import { aws_ec2, aws_iam, Resource } from 'aws-cdk-lib';
import { Construct } from 'constructs';
import { BastionInstanceProps } from './instance-props';
export interface WindowsBastionProps extends BastionInstanceProps {
    /**
     * If a keypair should be created and saved into Secrets Manager.
     *
     * This can be used to get Administrator user access
     *
     * @default - false
     * @stability stable
     */
    readonly createKeyPair?: boolean;
    /**
     * List of packages to be installed as part of the userdata using winget.
     *
     * @default - no association
     * @stability experimental
     */
    readonly windowsPackages?: string[];
}
export declare class WindowsBastion extends Resource implements aws_ec2.IInstance {
    readonly securityGroup: aws_ec2.ISecurityGroup;
    readonly instanceId: string;
    readonly instanceAvailabilityZone: string;
    readonly instancePrivateDnsName: string;
    readonly instancePrivateIp: string;
    readonly instancePublicDnsName: string;
    readonly instancePublicIp: string;
    readonly connections: aws_ec2.Connections;
    readonly grantPrincipal: aws_iam.IPrincipal;
    readonly role: aws_iam.IRole;
    constructor(scope: Construct, id: string, props: WindowsBastionProps);
}
//# sourceMappingURL=windows-bastion.d.ts.map