import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [backup-gateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupgateway.html).
 *
 * @experimental
 */
export declare class BackupGateway extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to AssociateGatewayToServer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_AssociateGatewayToServer.html
     *
     * @experimental
     */
    toAssociateGatewayToServer(): this;
    /**
     * (experimental) Grants permission to Backup.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_Backup.html
     *
     * @experimental
     */
    toBackup(): this;
    /**
     * (experimental) Grants permission to to CreateGateway.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_CreateGateway.html
     *
     * @experimental
     */
    toCreateGateway(): this;
    /**
     * (experimental) Grants permission to DeleteGateway.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteGateway.html
     *
     * @experimental
     */
    toDeleteGateway(): this;
    /**
     * (experimental) Grants permission to DeleteHypervisor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DeleteHypervisor.html
     *
     * @experimental
     */
    toDeleteHypervisor(): this;
    /**
     * (experimental) Grants permission to DisassociateGatewayFromServer.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_DisassociateGatewayFromServer.html
     *
     * @experimental
     */
    toDisassociateGatewayFromServer(): this;
    /**
     * (experimental) Grants permission to ImportHypervisorConfiguration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ImportHypervisorConfiguration.html
     *
     * @experimental
     */
    toImportHypervisorConfiguration(): this;
    /**
     * (experimental) Grants permission to ListGateways.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListGateways.html
     *
     * @experimental
     */
    toListGateways(): this;
    /**
     * (experimental) Grants permission to ListHypervisors.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListHypervisors.html
     *
     * @experimental
     */
    toListHypervisors(): this;
    /**
     * (experimental) Grants permission to ListTagsForResource.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to ListVirtualMachines.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_ListVirtualMachines.html
     *
     * @experimental
     */
    toListVirtualMachines(): this;
    /**
     * (experimental) Grants permission to PutMaintenanceStartTime.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutMaintenanceStartTime.html
     *
     * @experimental
     */
    toPutMaintenanceStartTime(): this;
    /**
     * (experimental) Grants permission to Restore.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_Restore.html
     *
     * @experimental
     */
    toRestore(): this;
    /**
     * (experimental) Grants permission to TagResource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to TestHypervisorConfiguration.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_TestHypervisorConfiguration.html
     *
     * @experimental
     */
    toTestHypervisorConfiguration(): this;
    /**
     * (experimental) Grants permission to UntagResource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to UpdateGatewayInformation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateGatewayInformation.html
     *
     * @experimental
     */
    toUpdateGatewayInformation(): this;
    /**
     * (experimental) Grants permission to UpdateHypervisor.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_UpdateHypervisor.html
     *
     * @experimental
     */
    toUpdateHypervisor(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type gateway to the statement.
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGateway(gatewayId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type hypervisor to the statement.
     *
     * @param hypervisorId - Identifier for the hypervisorId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onHypervisor(hypervisorId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type virtualmachine to the statement.
     *
     * @param virtualmachineId - Identifier for the virtualmachineId.
     * @param account - Account of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onVirtualmachine(virtualmachineId: string, account?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [backup-gateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupgateway.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
