import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [detective](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondetective.html).
 *
 * @experimental
 */
export declare class Detective extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to accept an invitation to become a member of a behavior graph.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_AcceptInvitation.html
     *
     * @experimental
     */
    toAcceptInvitation(): this;
    /**
     * (experimental) Grants permission to create a behavior graph and begin to aggregate security information.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_CreateGraph.html
     *
     * @experimental
     */
    toCreateGraph(): this;
    /**
     * (experimental) Grants permission to request the membership of one or more accounts in a behavior graph managed by this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_CreateMembers.html
     *
     * @experimental
     */
    toCreateMembers(): this;
    /**
     * (experimental) Grants permission to delete a behavior graph and stop aggregating security information.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_DeleteGraph.html
     *
     * @experimental
     */
    toDeleteGraph(): this;
    /**
     * (experimental) Grants permission to remove member accounts from a behavior graph managed by this account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_DeleteMembers.html
     *
     * @experimental
     */
    toDeleteMembers(): this;
    /**
     * (experimental) Grants permission to remove the association of this account with a behavior graph.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_DisassociateMembership.html
     *
     * @experimental
     */
    toDisassociateMembership(): this;
    /**
     * (experimental) Grants permission to retrieve a behavior graph's eligibility for a free trial period.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetFreeTrialEligibility(): this;
    /**
     * (experimental) Grants permission to retrieve the data ingestion state of a behavior graph.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetGraphIngestState(): this;
    /**
     * (experimental) Grants permission to retrieve details on specified members of a behavior graph.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_GetMembers.html
     *
     * @experimental
     */
    toGetMembers(): this;
    /**
     * (experimental) Grants permission to retrieve information about Amazon Detective's pricing.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetPricingInformation(): this;
    /**
     * (experimental) Grants permission to list usage information of a behavior graph.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toGetUsageInformation(): this;
    /**
     * (experimental) Grants permission to list behavior graphs managed by this account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_ListGraphs.html
     *
     * @experimental
     */
    toListGraphs(): this;
    /**
     * (experimental) Grants permission to retrieve details on the behavior graphs to which this account has been invited to join.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_ListInvitations.html
     *
     * @experimental
     */
    toListInvitations(): this;
    /**
     * (experimental) Grants permission to retrieve details on all members of a behavior graph.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_ListMembers.html
     *
     * @experimental
     */
    toListMembers(): this;
    /**
     * (experimental) Grants permission to list the tag values that are assigned to a behavior graph.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to reject an invitation to become a member of a behavior graph.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_RejectInvitation.html
     *
     * @experimental
     */
    toRejectInvitation(): this;
    /**
     * (experimental) Grants permission to search the data stored in a behavior graph.
     *
     * Access Level: Read
     *
     * @experimental
     */
    toSearchGraph(): this;
    /**
     * (experimental) Grants permission to start data ingest for a member account that has a status of ACCEPTED_BUT_DISABLED.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_StartMonitoringMember.html
     *
     * @experimental
     */
    toStartMonitoringMember(): this;
    /**
     * (experimental) Grants permission to assign tag values to a behavior graph.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove tag values from a behavior graph.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/detective/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type Graph to the statement.
     *
     * https://docs.aws.amazon.com/detective/latest/adminguide/security_iam_service-with-iam.html#security_iam_service-with-iam-id-based-policies-resources
     *
     * @param resourceId - Identifier for the resourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onGraph(resourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [detective](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazondetective.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
