import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [kendra](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkendra.html).
 *
 * @experimental
 */
export declare class Kendra extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to batch delete document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_BatchDeleteDocument.html
     *
     * @experimental
     */
    toBatchDeleteDocument(): this;
    /**
     * (experimental) Grants permission to do batch get document status.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_BatchGetDocumentStatus.html
     *
     * @experimental
     */
    toBatchGetDocumentStatus(): this;
    /**
     * (experimental) Grants permission to batch put document.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_BatchPutDocument.html
     *
     * @experimental
     */
    toBatchPutDocument(): this;
    /**
     * (experimental) Grants permission to clear out the suggestions for a given index, generated so far.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ClearQuerySuggestions.html
     *
     * @experimental
     */
    toClearQuerySuggestions(): this;
    /**
     * (experimental) Grants permission to create a data source.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateDataSource.html
     *
     * @experimental
     */
    toCreateDataSource(): this;
    /**
     * (experimental) Grants permission to create an Faq.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateFaq.html
     *
     * @experimental
     */
    toCreateFaq(): this;
    /**
     * (experimental) Grants permission to create an Index.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateIndex.html
     *
     * @experimental
     */
    toCreateIndex(): this;
    /**
     * (experimental) Grants permission to create a QuerySuggestions BlockList.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateQuerySuggestionsBlockList.html
     *
     * @experimental
     */
    toCreateQuerySuggestionsBlockList(): this;
    /**
     * (experimental) Grants permission to create a Thesaurus.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_CreateThesaurus.html
     *
     * @experimental
     */
    toCreateThesaurus(): this;
    /**
     * (experimental) Grants permission to delete a data source.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteDataSource.html
     *
     * @experimental
     */
    toDeleteDataSource(): this;
    /**
     * (experimental) Grants permission to delete an Faq.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteFaq.html
     *
     * @experimental
     */
    toDeleteFaq(): this;
    /**
     * (experimental) Grants permission to delete an Index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteIndex.html
     *
     * @experimental
     */
    toDeleteIndex(): this;
    /**
     * (experimental) Grants permission to delete principal mapping from index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeletePrincipalMapping.html
     *
     * @experimental
     */
    toDeletePrincipalMapping(): this;
    /**
     * (experimental) Grants permission to delete a QuerySuggestions BlockList.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteQuerySuggestionsBlockList.html
     *
     * @experimental
     */
    toDeleteQuerySuggestionsBlockList(): this;
    /**
     * (experimental) Grants permission to delete a Thesaurus.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DeleteThesaurus.html
     *
     * @experimental
     */
    toDeleteThesaurus(): this;
    /**
     * (experimental) Grants permission to describe a data source.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeDataSource.html
     *
     * @experimental
     */
    toDescribeDataSource(): this;
    /**
     * (experimental) Grants permission to describe an Faq.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeFaq.html
     *
     * @experimental
     */
    toDescribeFaq(): this;
    /**
     * (experimental) Grants permission to describe an Index.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeIndex.html
     *
     * @experimental
     */
    toDescribeIndex(): this;
    /**
     * (experimental) Grants permission to describe principal mapping from index.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribePrincipalMapping.html
     *
     * @experimental
     */
    toDescribePrincipalMapping(): this;
    /**
     * (experimental) Grants permission to describe a QuerySuggestions BlockList.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeQuerySuggestionsBlockList.html
     *
     * @experimental
     */
    toDescribeQuerySuggestionsBlockList(): this;
    /**
     * (experimental) Grants permission to describe the query suggestions configuration for an index.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeQuerySuggestionsConfig.html
     *
     * @experimental
     */
    toDescribeQuerySuggestionsConfig(): this;
    /**
     * (experimental) Grants permission to describe a Thesaurus.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_DescribeThesaurus.html
     *
     * @experimental
     */
    toDescribeThesaurus(): this;
    /**
     * (experimental) Grants permission to get suggestions for a query prefix.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_GetQuerySuggestions.html
     *
     * @experimental
     */
    toGetQuerySuggestions(): this;
    /**
     * (experimental) Grants permission to get Data Source sync job history.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListDataSourceSyncJobs.html
     *
     * @experimental
     */
    toListDataSourceSyncJobs(): this;
    /**
     * (experimental) Grants permission to list the data sources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListDataSources.html
     *
     * @experimental
     */
    toListDataSources(): this;
    /**
     * (experimental) Grants permission to list the Faqs.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListFaqs.html
     *
     * @experimental
     */
    toListFaqs(): this;
    /**
     * (experimental) Grants permission to list groups that are older than an ordering id.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListGroupsOlderThanOrderingId.html
     *
     * @experimental
     */
    toListGroupsOlderThanOrderingId(): this;
    /**
     * (experimental) Grants permission to list the indexes.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListIndices.html
     *
     * @experimental
     */
    toListIndices(): this;
    /**
     * (experimental) Grants permission to list the QuerySuggestions BlockLists.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListQuerySuggestionsBlockLists.html
     *
     * @experimental
     */
    toListQuerySuggestionsBlockLists(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list the Thesauri.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_ListThesauri.html
     *
     * @experimental
     */
    toListThesauri(): this;
    /**
     * (experimental) Grants permission to put principal mapping in index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_PutPrincipalMapping.html
     *
     * @experimental
     */
    toPutPrincipalMapping(): this;
    /**
     * (experimental) Grants permission to query documents and faqs.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_Query.html
     *
     * @experimental
     */
    toQuery(): this;
    /**
     * (experimental) Grants permission to start Data Source sync job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_StartDataSourceSyncJob.html
     *
     * @experimental
     */
    toStartDataSourceSyncJob(): this;
    /**
     * (experimental) Grants permission to stop Data Source sync job.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_StopDataSourceSyncJob.html
     *
     * @experimental
     */
    toStopDataSourceSyncJob(): this;
    /**
     * (experimental) Grants permission to send feedback about a query results.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_SubmitFeedback.html
     *
     * @experimental
     */
    toSubmitFeedback(): this;
    /**
     * (experimental) Grants permission to tag a resource with given key value pairs.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove the tag with the given key from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update a data source.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateDataSource.html
     *
     * @experimental
     */
    toUpdateDataSource(): this;
    /**
     * (experimental) Grants permission to update an Index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateIndex.html
     *
     * @experimental
     */
    toUpdateIndex(): this;
    /**
     * (experimental) Grants permission to update a QuerySuggestions BlockList.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsBlockList.html
     *
     * @experimental
     */
    toUpdateQuerySuggestionsBlockList(): this;
    /**
     * (experimental) Grants permission to update the query suggestions configuration for an index.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateQuerySuggestionsConfig.html
     *
     * @experimental
     */
    toUpdateQuerySuggestionsConfig(): this;
    /**
     * (experimental) Grants permission to update a thesaurus.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/API_UpdateThesaurus.html
     *
     * @experimental
     */
    toUpdateThesaurus(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type index to the statement.
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/index.html
     *
     * @param indexId - Identifier for the indexId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onIndex(indexId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type data-source to the statement.
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/data-source.html
     *
     * @param indexId - Identifier for the indexId.
     * @param dataSourceId - Identifier for the dataSourceId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDataSource(indexId: string, dataSourceId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type faq to the statement.
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/faq.html
     *
     * @param indexId - Identifier for the indexId.
     * @param faqId - Identifier for the faqId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onFaq(indexId: string, faqId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type thesaurus to the statement.
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/thesaurus.html
     *
     * @param indexId - Identifier for the indexId.
     * @param thesaurusId - Identifier for the thesaurusId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onThesaurus(indexId: string, thesaurusId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type query-suggestions-block-list to the statement.
     *
     * https://docs.aws.amazon.com/kendra/latest/dg/query-suggestions-block-list.html
     *
     * @param indexId - Identifier for the indexId.
     * @param querySuggestionsBlockListId - Identifier for the querySuggestionsBlockListId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onQuerySuggestionsBlockList(indexId: string, querySuggestionsBlockListId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [kendra](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonkendra.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
