import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [ses-pinpoint](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpointemailservice.html).
 *
 * @experimental
 */
export declare class SesPinpoint extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to create a configuration set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_CreateConfigurationSet.html
     *
     * @experimental
     */
    toCreateConfigurationSet(): this;
    /**
     * (experimental) Grants permission to create a configuration set event destination.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_CreateConfigurationSetEventDestination.html
     *
     * @experimental
     */
    toCreateConfigurationSetEventDestination(): this;
    /**
     * (experimental) Grants permission to create a new pool of dedicated IP addresses.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_CreateDedicatedIpPool.html
     *
     * @experimental
     */
    toCreateDedicatedIpPool(): this;
    /**
     * (experimental) Grants permission to create a new predictive inbox placement test.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_CreateDeliverabilityTestReport.html
     *
     * @experimental
     */
    toCreateDeliverabilityTestReport(): this;
    /**
     * (experimental) Grants permission to start the process of verifying an email identity.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_CreateEmailIdentity.html
     *
     * @experimental
     */
    toCreateEmailIdentity(): this;
    /**
     * (experimental) Grants permission to delete an existing configuration set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_DeleteConfigurationSet.html
     *
     * @experimental
     */
    toDeleteConfigurationSet(): this;
    /**
     * (experimental) Grants permission to delete an event destination.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_DeleteConfigurationSetEventDestination.html
     *
     * @experimental
     */
    toDeleteConfigurationSetEventDestination(): this;
    /**
     * (experimental) Grants permission to delete a dedicated IP pool.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_DeleteDedicatedIpPool.html
     *
     * @experimental
     */
    toDeleteDedicatedIpPool(): this;
    /**
     * (experimental) Grants permission to delete an email identity that you previously verified.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_DeleteEmailIdentity.html
     *
     * @experimental
     */
    toDeleteEmailIdentity(): this;
    /**
     * (experimental) Grants permission to get information about the email-sending status and capabilities.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetAccount.html
     *
     * @experimental
     */
    toGetAccount(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the deny lists on which your dedicated IP addresses appear.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetBlacklistReports.html
     *
     * @experimental
     */
    toGetBlacklistReports(): this;
    /**
     * (experimental) Grants permission to get information about an existing configuration set.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetConfigurationSet.html
     *
     * @experimental
     */
    toGetConfigurationSet(): this;
    /**
     * (experimental) Grants permission to retrieve a list of event destinations that are associated with a configuration set.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetConfigurationSetEventDestinations.html
     *
     * @experimental
     */
    toGetConfigurationSetEventDestinations(): this;
    /**
     * (experimental) Grants permission to get information about a dedicated IP address.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetDedicatedIp.html
     *
     * @experimental
     */
    toGetDedicatedIp(): this;
    /**
     * (experimental) Grants permission to list the dedicated IP addresses that are associated with your account.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetDedicatedIps.html
     *
     * @experimental
     */
    toGetDedicatedIps(): this;
    /**
     * (experimental) Grants permission to get the status of the Deliverability dashboard.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetDeliverabilityDashboardOptions.html
     *
     * @experimental
     */
    toGetDeliverabilityDashboardOptions(): this;
    /**
     * (experimental) Grants permission to retrieve the results of a predictive inbox placement test.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetDeliverabilityTestReport.html
     *
     * @experimental
     */
    toGetDeliverabilityTestReport(): this;
    /**
     * (experimental) Grants permission to retrieve all the deliverability data for a specific campaign.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetDomainDeliverabilityCampaign.html
     *
     * @experimental
     */
    toGetDomainDeliverabilityCampaign(): this;
    /**
     * (experimental) Grants permission to retrieve inbox placement and engagement rates for the domains that you use to send email.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetDomainStatisticsReport.html
     *
     * @experimental
     */
    toGetDomainStatisticsReport(): this;
    /**
     * (experimental) Grants permission to get information about a specific identity associated with your account.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_GetEmailIdentity.html
     *
     * @experimental
     */
    toGetEmailIdentity(): this;
    /**
     * (experimental) Grants permission to list all of the configuration sets associated with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_ListConfigurationSets.html
     *
     * @experimental
     */
    toListConfigurationSets(): this;
    /**
     * (experimental) Grants permission to list all of the dedicated IP pools that exist in your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_ListDedicatedIpPools.html
     *
     * @experimental
     */
    toListDedicatedIpPools(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the predictive inbox placement tests that you've performed, regardless of their statuses.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_ListDeliverabilityTestReports.html
     *
     * @experimental
     */
    toListDeliverabilityTestReports(): this;
    /**
     * (experimental) Grants permission to retrieve deliverability data for all the campaigns that used a specific domain to send email during a specified time range.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_ListDomainDeliverabilityCampaigns.html
     *
     * @experimental
     */
    toListDomainDeliverabilityCampaigns(): this;
    /**
     * (experimental) Grants permission to list all of the email identities that are associated with your account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_ListEmailIdentities.html
     *
     * @experimental
     */
    toListEmailIdentities(): this;
    /**
     * (experimental) Grants permission to retrieve a list of the tags (keys and values) that are associated with a specific resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to enable or disable the automatic warm-up feature for dedicated IP addresses.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutAccountDedicatedIpWarmupAttributes.html
     *
     * @experimental
     */
    toPutAccountDedicatedIpWarmupAttributes(): this;
    /**
     * (experimental) Grants permission to enable or disable the ability of your account to send email.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutAccountSendingAttributes.html
     *
     * @experimental
     */
    toPutAccountSendingAttributes(): this;
    /**
     * (experimental) Grants permission to associate a configuration set with a dedicated IP pool.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutConfigurationSetDeliveryOptions.html
     *
     * @experimental
     */
    toPutConfigurationSetDeliveryOptions(): this;
    /**
     * (experimental) Grants permission to enable or disable collection of reputation metrics for emails that you send using a particular configuration set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutConfigurationSetReputationOptions.html
     *
     * @experimental
     */
    toPutConfigurationSetReputationOptions(): this;
    /**
     * (experimental) Grants permission to enable or disable email sending for messages that use a particular configuration set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutConfigurationSetSendingOptions.html
     *
     * @experimental
     */
    toPutConfigurationSetSendingOptions(): this;
    /**
     * (experimental) Grants permission to specify a custom domain to use for open and click tracking elements in email that you send using a particular configuration set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutConfigurationSetTrackingOptions.html
     *
     * @experimental
     */
    toPutConfigurationSetTrackingOptions(): this;
    /**
     * (experimental) Grants permission to move a dedicated IP address to an existing dedicated IP pool.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutDedicatedIpInPool.html
     *
     * @experimental
     */
    toPutDedicatedIpInPool(): this;
    /**
     * (experimental) Grants permission to enable dedicated IP warm up attributes.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutDedicatedIpWarmupAttributes.html
     *
     * @experimental
     */
    toPutDedicatedIpWarmupAttributes(): this;
    /**
     * (experimental) Grants permission to enable or disable the Deliverability dashboard.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutDeliverabilityDashboardOption.html
     *
     * @experimental
     */
    toPutDeliverabilityDashboardOption(): this;
    /**
     * (experimental) Grants permission to enable or disable DKIM authentication for an email identity.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutEmailIdentityDkimAttributes.html
     *
     * @experimental
     */
    toPutEmailIdentityDkimAttributes(): this;
    /**
     * (experimental) Grants permission to enable or disable feedback forwarding for an identity.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutEmailIdentityFeedbackAttributes.html
     *
     * @experimental
     */
    toPutEmailIdentityFeedbackAttributes(): this;
    /**
     * (experimental) Grants permission to enable or disable the custom MAIL FROM domain configuration for an email identity.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_PutEmailIdentityMailFromAttributes.html
     *
     * @experimental
     */
    toPutEmailIdentityMailFromAttributes(): this;
    /**
     * (experimental) Grants permission to send an email message.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifFeedbackAddress()
     * - .ifFromAddress()
     * - .ifFromDisplayName()
     * - .ifRecipients()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_SendEmail.html
     *
     * @experimental
     */
    toSendEmail(): this;
    /**
     * (experimental) Grants permission to add one or more tags (keys and values) to a specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     * - .ifAwsRequestTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags (keys and values) from a specified resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update the configuration of an event destination for a configuration set.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_UpdateConfigurationSetEventDestination.html
     *
     * @experimental
     */
    toUpdateConfigurationSetEventDestination(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type configuration-set to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_CreateConfigurationSet.html
     *
     * @param configurationSetName - Identifier for the configurationSetName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onConfigurationSet(configurationSetName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type dedicated-ip-pool to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_DedicatedIp.html
     *
     * @param dedicatedIPPool - Identifier for the dedicatedIPPool.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDedicatedIpPool(dedicatedIPPool: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type deliverability-test-report to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_DeliverabilityTestReport.html
     *
     * @param reportId - Identifier for the reportId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onDeliverabilityTestReport(reportId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type identity to the statement.
     *
     * https://docs.aws.amazon.com/pinpoint-email/latest/APIReference/API_IdentityInfo.html
     *
     * @param identityName - Identifier for the identityName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onIdentity(identityName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters actions based on the "Return-Path" address, which specifies where bounces and complaints are sent by email feedback forwarding.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonses.html#amazonses-policy-keys
     *
     * Applies to actions:
     * - .toSendEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFeedbackAddress(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the "From" address of a message.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonses.html#amazonses-policy-keys
     *
     * Applies to actions:
     * - .toSendEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFromAddress(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the "From" address that is used as the display name of a message.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonses.html#amazonses-policy-keys
     *
     * Applies to actions:
     * - .toSendEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifFromDisplayName(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters actions based on the recipient addresses of a message, which include the "To", "CC", and "BCC" addresses.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonses.html#amazonses-policy-keys
     *
     * Applies to actions:
     * - .toSendEmail()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifRecipients(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [ses-pinpoint](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonpinpointemailservice.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
