import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [qldb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqldb.html).
 *
 * @experimental
 */
export declare class Qldb extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to cancel a journal kinesis stream.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_CancelJournalKinesisStream.html
     *
     * @experimental
     */
    toCancelJournalKinesisStream(): this;
    /**
     * (experimental) Grants permission to create a ledger.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_CreateLedger.html
     *
     * @experimental
     */
    toCreateLedger(): this;
    /**
     * (experimental) Grants permission to delete a ledger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_DeleteLedger.html
     *
     * @experimental
     */
    toDeleteLedger(): this;
    /**
     * (experimental) Grants permission to describe information about a journal kinesis stream.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeJournalKinesisStream.html
     *
     * @experimental
     */
    toDescribeJournalKinesisStream(): this;
    /**
     * (experimental) Grants permission to describe information about a journal export job.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeJournalS3Export.html
     *
     * @experimental
     */
    toDescribeJournalS3Export(): this;
    /**
     * (experimental) Grants permission to describe a ledger.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_DescribeLedger.html
     *
     * @experimental
     */
    toDescribeLedger(): this;
    /**
     * (experimental) Grants permission to send commands to a ledger via the console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html
     *
     * @experimental
     */
    toExecuteStatement(): this;
    /**
     * (experimental) Grants permission to export journal contents to an Amazon S3 bucket.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_ExportJournalToS3.html
     *
     * @experimental
     */
    toExportJournalToS3(): this;
    /**
     * (experimental) Grants permission to retrieve a block from a ledger for a given BlockAddress.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetBlock.html
     *
     * @experimental
     */
    toGetBlock(): this;
    /**
     * (experimental) Grants permission to retrieve a digest from a ledger for a given BlockAddress.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetDigest.html
     *
     * @experimental
     */
    toGetDigest(): this;
    /**
     * (experimental) Grants permission to retrieve a revision for a given document ID and a given BlockAddress.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_GetRevision.html
     *
     * @experimental
     */
    toGetRevision(): this;
    /**
     * (experimental) Grants permission to insert sample application data via the console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html
     *
     * @experimental
     */
    toInsertSampleData(): this;
    /**
     * (experimental) Grants permission to list journal kinesis streams for a specified ledger.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalKinesisStreamsForLedger.html
     *
     * @experimental
     */
    toListJournalKinesisStreamsForLedger(): this;
    /**
     * (experimental) Grants permission to list journal export jobs for all ledgers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalS3Exports.html
     *
     * @experimental
     */
    toListJournalS3Exports(): this;
    /**
     * (experimental) Grants permission to list journal export jobs for a specified ledger.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListJournalS3ExportsForLedger.html
     *
     * @experimental
     */
    toListJournalS3ExportsForLedger(): this;
    /**
     * (experimental) Grants permission to list existing ledgers.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListLedgers.html
     *
     * @experimental
     */
    toListLedgers(): this;
    /**
     * (experimental) Grants permission to list tags for a resource.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to create an index on a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.create-index.html
     *
     * @experimental
     */
    toPartiQLCreateIndex(): this;
    /**
     * (experimental) Grants permission to create a table.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.create-table.html
     *
     * @experimental
     */
    toPartiQLCreateTable(): this;
    /**
     * (experimental) Grants permission to delete documents from a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.delete.html
     *
     * @experimental
     */
    toPartiQLDelete(): this;
    /**
     * (experimental) Grants permission to drop an index from a table.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPurge()
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.drop-index.html
     *
     * @experimental
     */
    toPartiQLDropIndex(): this;
    /**
     * (experimental) Grants permission to drop a table.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifPurge()
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.drop-table.html
     *
     * @experimental
     */
    toPartiQLDropTable(): this;
    /**
     * (experimental) Grants permission to use the history function on a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/working.history.html
     *
     * @experimental
     */
    toPartiQLHistoryFunction(): this;
    /**
     * (experimental) Grants permission to insert documents into a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.insert.html
     *
     * @experimental
     */
    toPartiQLInsert(): this;
    /**
     * (experimental) Grants permission to select documents from a table.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.select.html
     *
     * @experimental
     */
    toPartiQLSelect(): this;
    /**
     * (experimental) Grants permission to undrop a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.undrop-table.html
     *
     * @experimental
     */
    toPartiQLUndropTable(): this;
    /**
     * (experimental) Grants permission to update existing documents in a table.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ql-reference.update.html
     *
     * @experimental
     */
    toPartiQLUpdate(): this;
    /**
     * (experimental) Grants permission to send commands to a ledger.
     *
     * Access Level: Write
     *
     * @experimental
     */
    toSendCommand(): this;
    /**
     * (experimental) Grants permission to view a ledger's catalog via the console.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/console_QLDB.html
     *
     * @experimental
     */
    toShowCatalog(): this;
    /**
     * (experimental) Grants permission to stream journal contents to a Kinesis Data Stream.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_StreamJournalToKinesis.html
     *
     * @experimental
     */
    toStreamJournalToKinesis(): this;
    /**
     * (experimental) Grants permission to add one or more tags to a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_TagResource.html
     *
     * @experimental
     */
    toTagResource(): this;
    /**
     * (experimental) Grants permission to remove one or more tags from a resource.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_UntagResource.html
     *
     * @experimental
     */
    toUntagResource(): this;
    /**
     * (experimental) Grants permission to update properties on a ledger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_UpdateLedger.html
     *
     * @experimental
     */
    toUpdateLedger(): this;
    /**
     * (experimental) Grants permission to update the permissions mode on a ledger.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/API_UpdateLedgerPermissionsMode.html
     *
     * @experimental
     */
    toUpdateLedgerPermissionsMode(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type ledger to the statement.
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-structure.html
     *
     * @param ledgerName - Identifier for the ledgerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onLedger(ledgerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type stream to the statement.
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/streams.html
     *
     * @param ledgerName - Identifier for the ledgerName.
     * @param streamId - Identifier for the streamId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onStream(ledgerName: string, streamId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type table to the statement.
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/working.manage-tables.html
     *
     * @param ledgerName - Identifier for the ledgerName.
     * @param tableId - Identifier for the tableId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onTable(ledgerName: string, tableId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type catalog to the statement.
     *
     * https://docs.aws.amazon.com/qldb/latest/developerguide/working.catalog.html
     *
     * @param ledgerName - Identifier for the ledgerName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     * @experimental
     */
    onCatalog(ledgerName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the value of purge that is specified in a PartiQL DROP statement.
     *
     * https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_condition-keys.html#condition-keys-purge
     *
     * Applies to actions:
     * - .toPartiQLDropIndex()
     * - .toPartiQLDropTable()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifPurge(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [qldb](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonqldb.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
