import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [route53](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html).
 *
 * @experimental
 */
export declare class Route53 extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to activate a key-signing key so that it can be used for signing by DNSSEC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ActivateKeySigningKey.html
     *
     * @experimental
     */
    toActivateKeySigningKey(): this;
    /**
     * (experimental) Grants permission to associate an additional Amazon VPC with a private hosted zone.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_AssociateVPCWithHostedZone.html
     *
     * @experimental
     */
    toAssociateVPCWithHostedZone(): this;
    /**
     * (experimental) Grants permission to create, update, or delete a record, which contains authoritative DNS information for a specified domain or subdomain name.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeResourceRecordSets.html
     *
     * @experimental
     */
    toChangeResourceRecordSets(): this;
    /**
     * (experimental) Grants permission to add, edit, or delete tags for a health check or a hosted zone.
     *
     * Access Level: Tagging
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ChangeTagsForResource.html
     *
     * @experimental
     */
    toChangeTagsForResource(): this;
    /**
     * (experimental) Grants permission to create a new health check, which monitors the health and performance of your web applications, web servers, and other resources.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHealthCheck.html
     *
     * @experimental
     */
    toCreateHealthCheck(): this;
    /**
     * (experimental) Grants permission to create a public hosted zone, which you use to specify how the Domain Name System (DNS) routes traffic on the Internet for a domain, such as example.com, and its subdomains.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateHostedZone.html
     *
     * @experimental
     */
    toCreateHostedZone(): this;
    /**
     * (experimental) Grants permission to create a new key-signing key associated with a hosted zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateKeySigningKey.html
     *
     * @experimental
     */
    toCreateKeySigningKey(): this;
    /**
     * (experimental) Grants permission to create a configuration for DNS query logging.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateQueryLoggingConfig.html
     *
     * @experimental
     */
    toCreateQueryLoggingConfig(): this;
    /**
     * (experimental) Grants permission to create a delegation set (a group of four name servers) that can be reused by multiple hosted zones.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateReusableDelegationSet.html
     *
     * @experimental
     */
    toCreateReusableDelegationSet(): this;
    /**
     * (experimental) Grants permission to create a traffic policy, which you use to create multiple DNS records for one domain name (such as example.com) or one subdomain name (such as www.example.com).
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicy.html
     *
     * @experimental
     */
    toCreateTrafficPolicy(): this;
    /**
     * (experimental) Grants permission to create records in a specified hosted zone based on the settings in a specified traffic policy version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicyInstance.html
     *
     * @experimental
     */
    toCreateTrafficPolicyInstance(): this;
    /**
     * (experimental) Grants permission to create a new version of an existing traffic policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateTrafficPolicyVersion.html
     *
     * @experimental
     */
    toCreateTrafficPolicyVersion(): this;
    /**
     * (experimental) Grants permission to authorize the AWS account that created a specified VPC to submit an AssociateVPCWithHostedZone request, which associates the VPC with a specified hosted zone that was created by a different account.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_CreateVPCAssociationAuthorization.html
     *
     * @experimental
     */
    toCreateVPCAssociationAuthorization(): this;
    /**
     * (experimental) Grants permission to deactivate a key-signing key so that it will not be used for signing by DNSSEC.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeactivateKeySigningKey.html
     *
     * @experimental
     */
    toDeactivateKeySigningKey(): this;
    /**
     * (experimental) Grants permission to delete a health check.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteHealthCheck.html
     *
     * @experimental
     */
    toDeleteHealthCheck(): this;
    /**
     * (experimental) Grants permission to delete a hosted zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteHostedZone.html
     *
     * @experimental
     */
    toDeleteHostedZone(): this;
    /**
     * (experimental) Grants permission to delete a key-signing key.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteKeySigningKey.html
     *
     * @experimental
     */
    toDeleteKeySigningKey(): this;
    /**
     * (experimental) Grants permission to delete a configuration for DNS query logging.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteQueryLoggingConfig.html
     *
     * @experimental
     */
    toDeleteQueryLoggingConfig(): this;
    /**
     * (experimental) Grants permission to delete a reusable delegation set.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteReusableDelegationSet.html
     *
     * @experimental
     */
    toDeleteReusableDelegationSet(): this;
    /**
     * (experimental) Grants permission to delete a traffic policy.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicy.html
     *
     * @experimental
     */
    toDeleteTrafficPolicy(): this;
    /**
     * (experimental) Grants permission to delete a traffic policy instance and all the records that Route 53 created when you created the instance.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteTrafficPolicyInstance.html
     *
     * @experimental
     */
    toDeleteTrafficPolicyInstance(): this;
    /**
     * (experimental) Grants permission to remove authorization for associating an Amazon Virtual Private Cloud with a Route 53 private hosted zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DeleteVPCAssociationAuthorization.html
     *
     * @experimental
     */
    toDeleteVPCAssociationAuthorization(): this;
    /**
     * (experimental) Grants permission to disable DNSSEC signing in a specific hosted zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DisableHostedZoneDNSSEC.html
     *
     * @experimental
     */
    toDisableHostedZoneDNSSEC(): this;
    /**
     * (experimental) Grants permission to disassociate an Amazon Virtual Private Cloud from a Route 53 private hosted zone.
     *
     * Access Level: Write
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_DisassociateVPCFromHostedZone.html
     *
     * @experimental
     */
    toDisassociateVPCFromHostedZone(): this;
    /**
     * (experimental) Grants permission to enable DNSSEC signing in a specific hosted zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_EnableHostedZoneDNSSEC.html
     *
     * @experimental
     */
    toEnableHostedZoneDNSSEC(): this;
    /**
     * (experimental) Grants permission to get the specified limit for the current account, for example, the maximum number of health checks that you can create using the account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetAccountLimit.html
     *
     * @experimental
     */
    toGetAccountLimit(): this;
    /**
     * (experimental) Grants permission to get the current status of a request to create, update, or delete one or more records.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetChange.html
     *
     * @experimental
     */
    toGetChange(): this;
    /**
     * (experimental) Grants permission to get a list of the IP ranges that are used by Route 53 health checkers to check the health of your resources.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetCheckerIpRanges.html
     *
     * @experimental
     */
    toGetCheckerIpRanges(): this;
    /**
     * (experimental) Grants permission to get information about DNSSEC for a specific hosted zone, including the key-signing keys in the hosted zone.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetDNSSEC.html
     *
     * @experimental
     */
    toGetDNSSEC(): this;
    /**
     * (experimental) Grants permission to get information about whether a specified geographic location is supported for Route 53 geolocation records.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetGeoLocation.html
     *
     * @experimental
     */
    toGetGeoLocation(): this;
    /**
     * (experimental) Grants permission to get information about a specified health check.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheck.html
     *
     * @experimental
     */
    toGetHealthCheck(): this;
    /**
     * (experimental) Grants permission to get the number of health checks that are associated with the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckCount.html
     *
     * @experimental
     */
    toGetHealthCheckCount(): this;
    /**
     * (experimental) Grants permission to get the reason that a specified health check failed most recently.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckLastFailureReason.html
     *
     * @experimental
     */
    toGetHealthCheckLastFailureReason(): this;
    /**
     * (experimental) Grants permission to get the status of a specified health check.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHealthCheckStatus.html
     *
     * @experimental
     */
    toGetHealthCheckStatus(): this;
    /**
     * (experimental) Grants permission to get information about a specified hosted zone including the four name servers that Route 53 assigned to the hosted zone.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZone.html
     *
     * @experimental
     */
    toGetHostedZone(): this;
    /**
     * (experimental) Grants permission to get the number of hosted zones that are associated with the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneCount.html
     *
     * @experimental
     */
    toGetHostedZoneCount(): this;
    /**
     * (experimental) Grants permission to get the specified limit for a specified hosted zone.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetHostedZoneLimit.html
     *
     * @experimental
     */
    toGetHostedZoneLimit(): this;
    /**
     * (experimental) Grants permission to get information about a specified configuration for DNS query logging.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetQueryLoggingConfig.html
     *
     * @experimental
     */
    toGetQueryLoggingConfig(): this;
    /**
     * (experimental) Grants permission to get information about a specified reusable delegation set, including the four name servers that are assigned to the delegation set.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSet.html
     *
     * @experimental
     */
    toGetReusableDelegationSet(): this;
    /**
     * (experimental) Grants permission to get the maximum number of hosted zones that you can associate with the specified reusable delegation set.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetReusableDelegationSetLimit.html
     *
     * @experimental
     */
    toGetReusableDelegationSetLimit(): this;
    /**
     * (experimental) Grants permission to get information about a specified traffic policy version.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicy.html
     *
     * @experimental
     */
    toGetTrafficPolicy(): this;
    /**
     * (experimental) Grants permission to get information about a specified traffic policy instance.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicyInstance.html
     *
     * @experimental
     */
    toGetTrafficPolicyInstance(): this;
    /**
     * (experimental) Grants permission to get the number of traffic policy instances that are associated with the current AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_GetTrafficPolicyInstanceCount.html
     *
     * @experimental
     */
    toGetTrafficPolicyInstanceCount(): this;
    /**
     * (experimental) Grants permission to get a list of geographic locations that Route 53 supports for geolocation.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListGeoLocations.html
     *
     * @experimental
     */
    toListGeoLocations(): this;
    /**
     * (experimental) Grants permission to get a list of the health checks that are associated with the current AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHealthChecks.html
     *
     * @experimental
     */
    toListHealthChecks(): this;
    /**
     * (experimental) Grants permission to get a list of the public and private hosted zones that are associated with the current AWS account.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZones.html
     *
     * @experimental
     */
    toListHostedZones(): this;
    /**
     * (experimental) Grants permission to get a list of your hosted zones in lexicographic order.
     *
     * Hosted zones are sorted by name with the labels reversed, for example, com.example.www.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByName.html
     *
     * @experimental
     */
    toListHostedZonesByName(): this;
    /**
     * (experimental) Grants permission to get a list of all the private hosted zones that a specified VPC is associated with.
     *
     * Access Level: List
     *
     * Dependent actions:
     * - ec2:DescribeVpcs
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListHostedZonesByVPC.html
     *
     * @experimental
     */
    toListHostedZonesByVPC(): this;
    /**
     * (experimental) Grants permission to list the configurations for DNS query logging that are associated with the current AWS account or the configuration that is associated with a specified hosted zone.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html
     *
     * @experimental
     */
    toListQueryLoggingConfigs(): this;
    /**
     * (experimental) Grants permission to list the records in a specified hosted zone.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListResourceRecordSets.html
     *
     * @experimental
     */
    toListResourceRecordSets(): this;
    /**
     * (experimental) Grants permission to list the reusable delegation sets that are associated with the current AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListReusableDelegationSets.html
     *
     * @experimental
     */
    toListReusableDelegationSets(): this;
    /**
     * (experimental) Grants permission to list tags for one health check or hosted zone.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTagsForResource.html
     *
     * @experimental
     */
    toListTagsForResource(): this;
    /**
     * (experimental) Grants permission to list tags for up to 10 health checks or hosted zones.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTagsForResources.html
     *
     * @experimental
     */
    toListTagsForResources(): this;
    /**
     * (experimental) Grants permission to get information about the latest version for every traffic policy that is associated with the current AWS account.
     *
     * Policies are listed in the order in which they were created.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicies.html
     *
     * @experimental
     */
    toListTrafficPolicies(): this;
    /**
     * (experimental) Grants permission to get information about the traffic policy instances that you created by using the current AWS account.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstances.html
     *
     * @experimental
     */
    toListTrafficPolicyInstances(): this;
    /**
     * (experimental) Grants permission to get information about the traffic policy instances that you created in a specified hosted zone.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstancesByHostedZone.html
     *
     * @experimental
     */
    toListTrafficPolicyInstancesByHostedZone(): this;
    /**
     * (experimental) Grants permission to get information about the traffic policy instances that you created using a specified traffic policy version.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyInstancesByPolicy.html
     *
     * @experimental
     */
    toListTrafficPolicyInstancesByPolicy(): this;
    /**
     * (experimental) Grants permission to get information about all the versions for a specified traffic policy.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListTrafficPolicyVersions.html
     *
     * @experimental
     */
    toListTrafficPolicyVersions(): this;
    /**
     * (experimental) Grants permission to get a list of the VPCs that were created by other accounts and that can be associated with a specified hosted zone.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListVPCAssociationAuthorizations.html
     *
     * @experimental
     */
    toListVPCAssociationAuthorizations(): this;
    /**
     * (experimental) Grants permission to get the value that Route 53 returns in response to a DNS query for a specified record name and type.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_TestDNSAnswer.html
     *
     * @experimental
     */
    toTestDNSAnswer(): this;
    /**
     * (experimental) Grants permission to update an existing health check.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html
     *
     * @experimental
     */
    toUpdateHealthCheck(): this;
    /**
     * (experimental) Grants permission to update the comment for a specified hosted zone.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHostedZoneComment.html
     *
     * @experimental
     */
    toUpdateHostedZoneComment(): this;
    /**
     * (experimental) Grants permission to update the comment for a specified traffic policy version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateTrafficPolicyComment.html
     *
     * @experimental
     */
    toUpdateTrafficPolicyComment(): this;
    /**
     * (experimental) Grants permission to update the records in a specified hosted zone that were created based on the settings in a specified traffic policy version.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateTrafficPolicyInstance.html
     *
     * @experimental
     */
    toUpdateTrafficPolicyInstance(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type change to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/APIReference/API_Change.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onChange(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type delegationset to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-reusable-delegation-set
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onDelegationset(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type healthcheck to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-health-check
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onHealthcheck(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type hostedzone to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/route-53-concepts.html#route-53-concepts-hosted-zone
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onHostedzone(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type trafficpolicy to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-policies.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTrafficpolicy(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type trafficpolicyinstance to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/traffic-policy-records.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onTrafficpolicyinstance(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type queryloggingconfig to the statement.
     *
     * https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/query-logs.html
     *
     * @param id - Identifier for the id.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onQueryloggingconfig(id: string, partition?: string): this;
    /**
     * (experimental) Adds a resource of type vpc to the statement.
     *
     * https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html
     *
     * @param vpcId - Identifier for the vpcId.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onVpc(vpcId: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Statement provider for service [route53](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazonroute53.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
