import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement, Operator } from '../shared';
import { aws_iam as iam } from "aws-cdk-lib";
/**
 * (experimental) Statement provider for service [s3-object-lambda](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3objectlambda.html).
 *
 * @experimental
 */
export declare class S3ObjectLambda extends PolicyStatement {
    /**
     * (experimental) Holds the prefix of the service actions, e.g. `ec2`.
     *
     * @experimental
     */
    servicePrefix: string;
    /**
     * (experimental) Grants permission to abort a multipart upload.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_AbortMultipartUpload.html
     *
     * @experimental
     */
    toAbortMultipartUpload(): this;
    /**
     * (experimental) Grants permission to remove the null version of an object and insert a delete marker, which becomes the current version of the object.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
     *
     * @experimental
     */
    toDeleteObject(): this;
    /**
     * (experimental) Grants permission to use the tagging subresource to remove the entire tag set from the specified object.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html
     *
     * @experimental
     */
    toDeleteObjectTagging(): this;
    /**
     * (experimental) Grants permission to remove a specific version of an object.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObject.html
     *
     * @experimental
     */
    toDeleteObjectVersion(): this;
    /**
     * (experimental) Grants permission to remove the entire tag set for a specific version of the object.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteObjectTagging.html
     *
     * @experimental
     */
    toDeleteObjectVersionTagging(): this;
    /**
     * (experimental) Grants permission to retrieve objects from Amazon S3.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
     *
     * @experimental
     */
    toGetObject(): this;
    /**
     * (experimental) Grants permission to return the access control list (ACL) of an object.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html
     *
     * @experimental
     */
    toGetObjectAcl(): this;
    /**
     * (experimental) Grants permission to get an object's current Legal Hold status.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectLegalHold.html
     *
     * @experimental
     */
    toGetObjectLegalHold(): this;
    /**
     * (experimental) Grants permission to retrieve the retention settings for an object.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectRetention.html
     *
     * @experimental
     */
    toGetObjectRetention(): this;
    /**
     * (experimental) Grants permission to return the tag set of an object.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectTagging.html
     *
     * @experimental
     */
    toGetObjectTagging(): this;
    /**
     * (experimental) Grants permission to retrieve a specific version of an object.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObject.html
     *
     * @experimental
     */
    toGetObjectVersion(): this;
    /**
     * (experimental) Grants permission to return the access control list (ACL) of a specific object version.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_GetObjectAcl.html
     *
     * @experimental
     */
    toGetObjectVersionAcl(): this;
    /**
     * (experimental) Grants permission to return the tag set for a specific version of the object.
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/setting-repl-config-perm-overview.html
     *
     * @experimental
     */
    toGetObjectVersionTagging(): this;
    /**
     * (experimental) Grants permission to list some or all of the objects in an Amazon S3 bucket (up to 1000).
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectsV2.html
     *
     * @experimental
     */
    toListBucket(): this;
    /**
     * (experimental) Grants permission to list in-progress multipart uploads.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListMultipartUploads.html
     *
     * @experimental
     */
    toListBucketMultipartUploads(): this;
    /**
     * (experimental) Grants permission to list metadata about all the versions of objects in an Amazon S3 bucket.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListObjectVersions.html
     *
     * @experimental
     */
    toListBucketVersions(): this;
    /**
     * (experimental) Grants permission to list the parts that have been uploaded for a specific multipart upload.
     *
     * Access Level: List
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_ListParts.html
     *
     * @experimental
     */
    toListMultipartUploadParts(): this;
    /**
     * (experimental) Grants permission to add an object to a bucket.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObject.html
     *
     * @experimental
     */
    toPutObject(): this;
    /**
     * (experimental) Grants permission to set the access control list (ACL) permissions for new or existing objects in an S3 bucket.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html
     *
     * @experimental
     */
    toPutObjectAcl(): this;
    /**
     * (experimental) Grants permission to apply a Legal Hold configuration to the specified object.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectLegalHold.html
     *
     * @experimental
     */
    toPutObjectLegalHold(): this;
    /**
     * (experimental) Grants permission to place an Object Retention configuration on an object.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectRetention.html
     *
     * @experimental
     */
    toPutObjectRetention(): this;
    /**
     * (experimental) Grants permission to set the supplied tag-set to an object that already exists in a bucket.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html
     *
     * @experimental
     */
    toPutObjectTagging(): this;
    /**
     * (experimental) Grants permission to use the acl subresource to set the access control list (ACL) permissions for an object that already exists in a bucket.
     *
     * Access Level: Permissions management
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectAcl.html
     *
     * @experimental
     */
    toPutObjectVersionAcl(): this;
    /**
     * (experimental) Grants permission to set the supplied tag-set for a specific version of an object.
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     * - .ifVersionid()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutObjectTagging.html
     *
     * @experimental
     */
    toPutObjectVersionTagging(): this;
    /**
     * (experimental) Grants permission to restore an archived copy of an object back into Amazon S3.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_RestoreObject.html
     *
     * @experimental
     */
    toRestoreObject(): this;
    /**
     * (experimental) Grants permission to provide data for GetObject requests send to S3 Object Lambda.
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAuthType()
     * - .ifSignatureAge()
     * - .ifTlsVersion()
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/API_WriteGetObjectResponse.html
     *
     * @experimental
     */
    toWriteGetObjectResponse(): this;
    /**
     * @experimental
     */
    protected accessLevelList: AccessLevelList;
    /**
     * (experimental) Adds a resource of type objectlambdaaccesspoint to the statement.
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/transforming-objects.html
     *
     * @param accessPointName - Identifier for the accessPointName.
     * @param account - Account of the resource;
     * @param region - Region of the resource;
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov];
     * @experimental
     */
    onObjectlambdaaccesspoint(accessPointName: string, account?: string, region?: string, partition?: string): this;
    /**
     * (experimental) Filters access by the TLS version used by the client.
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html
     *
     * Applies to actions:
     * - .toAbortMultipartUpload()
     * - .toDeleteObject()
     * - .toDeleteObjectTagging()
     * - .toDeleteObjectVersion()
     * - .toDeleteObjectVersionTagging()
     * - .toGetObject()
     * - .toGetObjectAcl()
     * - .toGetObjectLegalHold()
     * - .toGetObjectRetention()
     * - .toGetObjectTagging()
     * - .toGetObjectVersion()
     * - .toGetObjectVersionAcl()
     * - .toGetObjectVersionTagging()
     * - .toListBucket()
     * - .toListBucketMultipartUploads()
     * - .toListBucketVersions()
     * - .toListMultipartUploadParts()
     * - .toPutObject()
     * - .toPutObjectAcl()
     * - .toPutObjectLegalHold()
     * - .toPutObjectRetention()
     * - .toPutObjectTagging()
     * - .toPutObjectVersionAcl()
     * - .toPutObjectVersionTagging()
     * - .toRestoreObject()
     * - .toWriteGetObjectResponse()
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifTlsVersion(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by authentication method.
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html
     *
     * Applies to actions:
     * - .toAbortMultipartUpload()
     * - .toDeleteObject()
     * - .toDeleteObjectTagging()
     * - .toDeleteObjectVersion()
     * - .toDeleteObjectVersionTagging()
     * - .toGetObject()
     * - .toGetObjectAcl()
     * - .toGetObjectLegalHold()
     * - .toGetObjectRetention()
     * - .toGetObjectTagging()
     * - .toGetObjectVersion()
     * - .toGetObjectVersionAcl()
     * - .toGetObjectVersionTagging()
     * - .toListBucket()
     * - .toListBucketMultipartUploads()
     * - .toListBucketVersions()
     * - .toListMultipartUploadParts()
     * - .toPutObject()
     * - .toPutObjectAcl()
     * - .toPutObjectLegalHold()
     * - .toPutObjectRetention()
     * - .toPutObjectTagging()
     * - .toPutObjectVersionAcl()
     * - .toPutObjectVersionTagging()
     * - .toRestoreObject()
     * - .toWriteGetObjectResponse()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifAuthType(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by the age in milliseconds of the request signature.
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/API/bucket-policy-s3-sigv4-conditions.html
     *
     * Applies to actions:
     * - .toAbortMultipartUpload()
     * - .toDeleteObject()
     * - .toDeleteObjectTagging()
     * - .toDeleteObjectVersion()
     * - .toDeleteObjectVersionTagging()
     * - .toGetObject()
     * - .toGetObjectAcl()
     * - .toGetObjectLegalHold()
     * - .toGetObjectRetention()
     * - .toGetObjectTagging()
     * - .toGetObjectVersion()
     * - .toGetObjectVersionAcl()
     * - .toGetObjectVersionTagging()
     * - .toListBucket()
     * - .toListBucketMultipartUploads()
     * - .toListBucketVersions()
     * - .toListMultipartUploadParts()
     * - .toPutObject()
     * - .toPutObjectAcl()
     * - .toPutObjectLegalHold()
     * - .toPutObjectRetention()
     * - .toPutObjectTagging()
     * - .toPutObjectVersionAcl()
     * - .toPutObjectVersionTagging()
     * - .toRestoreObject()
     * - .toWriteGetObjectResponse()
     *
     * @param value The value(s) to check.
     * @param operator Works with [numeric operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_Numeric). **Default:** `NumericEquals`.
     * @experimental
     */
    ifSignatureAge(value: number | number[], operator?: Operator | string): this;
    /**
     * (experimental) Filters access by a specific object version.
     *
     * https://docs.aws.amazon.com/AmazonS3/latest/dev/amazon-s3-policy-keys.html/#getobjectversion-limit-access-to-specific-version-3
     *
     * Applies to actions:
     * - .toDeleteObjectVersion()
     * - .toDeleteObjectVersionTagging()
     * - .toGetObjectVersion()
     * - .toGetObjectVersionAcl()
     * - .toGetObjectVersionTagging()
     * - .toPutObjectVersionAcl()
     * - .toPutObjectVersionTagging()
     *
     * @param value The value(s) to check.
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`.
     * @experimental
     */
    ifVersionid(value: string | string[], operator?: Operator | string): this;
    /**
     * (experimental) Statement provider for service [s3-object-lambda](https://docs.aws.amazon.com/service-authorization/latest/reference/list_amazons3objectlambda.html).
     *
     * @experimental
     */
    constructor(props?: iam.PolicyStatementProps);
}
