import { Stack, StackSynthesizer, FileAssetSource, FileAssetLocation, DockerImageAssetLocation, DockerImageAssetSource, ISynthesisSession } from 'aws-cdk-lib';
import { Construct } from 'constructs';
/**
 * Deployment environment for an AWS StackSet stack.
 *
 * Interoperates with the StackSynthesizer of the parent stack.
 */
export declare class StackSetStackSynthesizer extends StackSynthesizer {
    addFileAsset(_asset: FileAssetSource): FileAssetLocation;
    addDockerImageAsset(_asset: DockerImageAssetSource): DockerImageAssetLocation;
    synthesize(session: ISynthesisSession): void;
}
/**
 * A StackSet stack, which is similar to a normal CloudFormation stack with
 * some differences.
 *
 * This stack will not be treated as an independent deployment
 * artifact (won't be listed in "cdk list" or deployable through "cdk deploy"),
 * but rather only synthesized as a template and uploaded as an asset to S3.
 */
export declare class StackSetStack extends Stack {
    readonly templateFile: string;
    private _templateUrl?;
    private _parentStack;
    constructor(scope: Construct, id: string);
    /**
     * Fetch the template URL.
     *
     * @internal
     */
    _getTemplateUrl(): string;
    /**
     * Synthesize the product stack template, overrides the `super` class method.
     *
     * Defines an asset at the parent stack which represents the template of this
     * product stack.
     *
     * @internal
     */
    _synthesizeTemplate(session: ISynthesisSession): void;
}
