from enum import IntEnum
from typing import Any, Optional

from django.contrib.gis.gdal.base import GDALBase as GDALBase

class AxisOrder(IntEnum):
    TRADITIONAL: int = ...
    AUTHORITY: int = ...

class SpatialReference(GDALBase):
    destructor: Any = ...
    axis_order: Any = ...
    ptr: Any = ...
    def __init__(
        self, srs_input: str = ..., srs_type: str = ..., axis_order: Optional[Any] = ...
    ) -> None: ...
    def __getitem__(self, target: Any): ...
    def attr_value(self, target: Any, index: int = ...): ...
    def auth_name(self, target: Any): ...
    def auth_code(self, target: Any): ...
    def clone(self): ...
    def from_esri(self) -> None: ...
    def identify_epsg(self) -> None: ...
    def to_esri(self) -> None: ...
    def validate(self) -> None: ...
    @property
    def name(self): ...
    @property
    def srid(self): ...
    @property
    def linear_name(self): ...
    @property
    def linear_units(self): ...
    @property
    def angular_name(self): ...
    @property
    def angular_units(self): ...
    @property
    def units(self): ...
    @property
    def ellipsoid(self): ...
    @property
    def semi_major(self): ...
    @property
    def semi_minor(self): ...
    @property
    def inverse_flattening(self): ...
    @property
    def geographic(self): ...
    @property
    def local(self): ...
    @property
    def projected(self): ...
    def import_epsg(self, epsg: Any) -> None: ...
    def import_proj(self, proj: Any) -> None: ...
    def import_user_input(self, user_input: Any) -> None: ...
    def import_wkt(self, wkt: Any) -> None: ...
    def import_xml(self, xml: Any) -> None: ...
    @property
    def wkt(self): ...
    @property
    def proj(self): ...
    @property
    def proj4(self): ...

class CoordTransform(GDALBase):
    destructor: Any = ...
    ptr: Any = ...
    def __init__(self, source: Any, target: Any) -> None: ...
