#!/bin/sh

##
## This script will auto-generate the AUTHORS attribution file.
## If your name does not display correctly, then please
## update the .mailmap file in the root repo directory
##

git log --reverse --format='%aN <%aE>' | perl -we '

BEGIN {
  %seen = (), @authors = ();
}

while (<>) {
  next if $seen{$_};
  $seen{$_} = push @authors, $_;
}

END {
  print "# Authors ordered by first contribution.\n";
  print "# Generated by scripts/update-authors.sh\n";
  print "\n", @authors;
  print "\n*** Contributions are copyright their respective authors. Some contributor works are in the public domain in countries where this is recognized. See LICENSE.txt";

}

'

echo "\n\nSome commits are co-authored:\n"

git log | grep Co-Author
