# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['ddot']

package_data = \
{'': ['*']}

install_requires = \
['devinstaller-core>=0.9.1,<0.10.0', 'typer>=0.3.2,<0.4.0']

entry_points = \
{'console_scripts': ['ddot = ddot.__main__:main']}

setup_kwargs = {
    'name': 'ddot',
    'version': '0.4.0',
    'description': 'Dotfile manager using the Devinstaller framework',
    'long_description': '[![img](https://img.shields.io/badge/Made_in-VSCode-blue?style=for-the-badge)](https://code.visualstudio.com/download)\n[![img](https://img.shields.io/badge/follow_me-@alka1e-E4405F?style=for-the-badge&logo=instagram&labelColor=8f3c4c&logoColor=white)](https://www.instagram.com/alka1e)\n[![img](https://img.shields.io/badge/follow_me-@alka1e-1DA1F2?style=for-the-badge&logo=twitter&labelColor=27597a&logoColor=white)](https://twitter.com/alka1e)\n\n# Ddot\n\n_Your dev environment manager_\n\n[![img](https://img.shields.io/badge/work_in-progress-eb3434?style=for-the-badge&labelColor=7d1616)]()\n[![img](https://img.shields.io/badge/license-mit-blueviolet?style=for-the-badge)]()\n\n----\n\n[![forthebadge](https://forthebadge.com/images/badges/built-with-love.svg)](https://forthebadge.com)\n[![forthebadge](https://forthebadge.com/images/badges/uses-git.svg)](https://forthebadge.com)\n[![forthebadge](https://forthebadge.com/images/badges/built-by-hipsters.svg)](https://forthebadge.com)\n\n\n[[_TOC_]]\n\n# Introduction \n\nDdot is a devinstaller application created using the devinstaller framework.\n\n[For more info read below](#what-is-devinstaller)\n\n# Getting Started\n\n```sh\npipx run ddot run\n```\n\nThere needs to be a devfile in the current directory. Any one of these:\n\n- `devfile.toml`\n- `devfile.yaml` or `devfile.yml`\n- `devfile.json`\n\n# Installation\n\nThere are two method to use the application:\n1. Using Pipx to directly run the application \n2. Installing the application on your machine\n\nUsing [Pipx](https://github.com/pipxproject/pipx) method is recommended.\n\n## Method 1: Using Pipx\n\nWhy this method is recommended?\n\nYou can use Pipx to directly run the latest version of ddot without installing it in your machine. This way\nyour machine stays clean and you don\'t need to worry about updating ddot.\n\nYou can also install ddot in your machine using pipx if that\'s what you want.\n\n### Usage without installation\n\n1. Install pipx\n\n- On MacOS\n```sh\nbrew install pipx\npipx ensurepath\n```\n-  Other OS\n\n```sh\npython3 -m pip install --user pipx\npython3 -m pipx ensurepath\n```\n\nfor more information check out [Pipx](https://github.com/pipxproject/pipx).\n\n2. Using ddot\n\n```sh\npipx run ddot <command> # Example: pipx run ddot run --verbose\n```\n\nPlease note that the commands in the section below will need the `pipx run ` prefix with this method. Other method\ndoesn\'t require this prefix.\n\n### Usage with installation\n\n```sh\npipx install ddot\n```\n\n## Method 2: Machine installation\n\nYou can also install ddot without pipx. Although this is discouraged as ddot may disturb your system packages.\n\n```sh\npython -m pip install ddot\n```\n\n# Commands\n\n- Show the ddot version\n```sh\nddot --version\n```\n\n- Show the help menu\n```sh\nddot --help\n```\n\n- Show all the modules available in the devfile\n```sh\nddot show\n```\n\n- Execute the modules\n\n```sh\nddot run\n```\n\nThis command will open up a interactive prompt which you can use to navigate and select all the modules you want to execute.\n\nYou select modules using your SPACEBAR key and naviage using your ARROW keys.\n\n- You can also skip the interactive prompt by running\n\n```sh\nddot run -m <module name>\n```\n\nHere `<module name>` is the name of the module in the devfile at the current directory.\n\n- You can also specify the location to the devfile if it\'s not present in the current directory or if it\'s named differently\n\n```sh\nddot run --spec-file <spec file location>\n```\n\n- You can also set the verbose flag using\n\n```sh\nddot run --verbose\n```\n\nBy default the verbose mode is disabled, so you won\'t see any of the commands that are being executed but instead will see a \nprogress bar.\n\nBut if you need to see it just run using the verbose flag.\n\n# What is Devinstaller?\n\nDevinstaller is a framework to execute the devfiles.\n\n# What are devfiles?\n\nDevfiles is made up of 2 file:\n1. Spec file\n2. Prog file\n\n## Spec file?\n\nThe guiding principle behind the Spec file is to give a declarative and a platform agnostic way to specify a task which then can be handled by the \ndevinstaller application and make that happen.\n\nIn Devinstaller the basic building block for anything is called a "module".\n\nAnd you execute/install the module to do something.\n\n### Modules\n\nWe have modules for:\n1. file\n2. folder\n3. link\n4. app\n5. phony\n6. group\n\n    - `file`, `folder` and `link` modules\n        Say you want to create a file in a declarative way. For this you use the file module\n        and specify where and what the file is and the devinstaller will handle how to create/update/delete\n        the file.\n\n        This way your file module is declarative and the application handles everything required to make it happen, \n        including on how to do it on different OS.\n\n        This is how the `file`, `folder` and the `link` module works.\n\n    - `app` module\n        Then we have the `app` module. App module is for system applications. Here you need to write in some imperative instructions on how\n        a specific application is to be installed. But the beauty behind this you can add in instructions on how to do the same on different\n        platforms and the overall module becomes declarative for other users.\n\n        Example: You can write up the instructions to install ddot on different OS in a devfile, which an another user can import the devfile into\n        their devfile and it will give them a declarative way to install ddot on their machine and they don\'t have to worry about how it\'s going to\n        be done.\n\n    - `phony` and `group` module\n        But we understand that not everything can be put in a declarative way so for those cases we have the `group` and the\n        `phony` module. You can combine these modules in any fashion to translate your imperative instructions into a more\n        declarative way.\n\n### dGenerate\nFor writing up spec file you can use the web application [dGenerate](https://dgenerate.aziraz.com/) or you can write it in any text editor.\n\nUsing dGenerate will give you better user experience. \n\n- Features of dGenerate \n\n    1. Write and save in any file format.\n        Formats supported include:\n        - TOML\n        - YAML\n        - JSON\n\n    2. You can upload existing devfile and do some changes and download it.\n    3. You can share the link to your dGenerate devfile and send it to anyone. And they can go to the link make their changes and download it.\n    4. dGenerate is a completely offline application and it doesn\'t send any data to any servers.\n        So you can be assured of the safety of your data. Even for generating the share link for your devfile, we don\'t store any data on any server.\n        All the data required are in the link itself. You might have probably noticed that all the share links are unusually long and now\n        you know the reason for it.\n\n## Prog file?\n\nTODO\n\n# License\n\nMIT License\n\nCopyright (c) 2021 Justine Kizhakkinedath\n\n',
    'author': 'Justine Kizhakkinedath',
    'author_email': 'justine@kizhak.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://justine.kizhak.com/projects/ddot',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
