# AUTOGENERATED! DO NOT EDIT! File to edit: ../../notebooks/CLI.ipynb.

# %% auto 0
__all__ = ['logger', 'app']

# %% ../../notebooks/CLI.ipynb 3
import logging
from typing import *

# %% ../../notebooks/CLI.ipynb 4
import typer

from airt._cli import api_key, db, ds, model, pred, user
from airt._cli.token import token
from airt._cli.version import version
from airt._logger import get_logger, set_level

# %% ../../notebooks/CLI.ipynb 6
logger = get_logger(__name__)

set_level(logging.WARNING)

# %% ../../notebooks/CLI.ipynb 8
app = typer.Typer(help="airt CLI for accessing airt services.")

# %% ../../notebooks/CLI.ipynb 10
# token as root command
app.command()(token)

# %% ../../notebooks/CLI.ipynb 11
# Datasource root command

app.add_typer(
    ds.app,
    name="ds",
)

# %% ../../notebooks/CLI.ipynb 12
# Datablob root command

app.add_typer(
    db.app,
    name="db",
)

# %% ../../notebooks/CLI.ipynb 13
# Model root command

app.add_typer(
    model.app,
    name="model",
)

# %% ../../notebooks/CLI.ipynb 14
# Pred root command

app.add_typer(
    pred.app,
    name="pred",
)

# %% ../../notebooks/CLI.ipynb 15
# User root command

app.add_typer(
    user.app,
    name="user",
)

# %% ../../notebooks/CLI.ipynb 16
# API Keys root command

app.add_typer(
    api_key.app,
    name="api-key",
)

# %% ../../notebooks/CLI.ipynb 17
# version root command

app.command()(version)
