# AUTOGENERATED! DO NOT EDIT! File to edit: ../../notebooks/CLI_Model.ipynb.

# %% auto 0
__all__ = ['logger']

# %% ../../notebooks/CLI_Model.ipynb 3
from typing import *

# %% ../../notebooks/CLI_Model.ipynb 4
import os

import pandas as pd
import typer
from tabulate import tabulate
from typer import echo

from airt._cli import helper
from airt._logger import get_logger, set_level

# %% ../../notebooks/CLI_Model.ipynb 6
app = typer.Typer(
    help="A set of commands for querying the model training, evaluation, and prediction status."
)

# %% ../../notebooks/CLI_Model.ipynb 8
logger = get_logger(__name__)

# %% ../../notebooks/CLI_Model.ipynb 15
@app.command()
@helper.display_formated_table
@helper.requires_auth_token
def ls(
    offset: int = typer.Option(
        0,
        "--offset",
        "-o",
        help="The number of models to offset at the beginning. If None, then the default value **0** will be used.",
    ),
    limit: int = typer.Option(
        100,
        "--limit",
        "-l",
        help="The maximum number of models to return from the server. If None, "
        "then the default value **100** will be used.",
    ),
    disabled: bool = typer.Option(
        False,
        "--disabled",
        help="If set to **True**, then only the deleted models will be returned. Else, the default value "
        "**False** will be used to return only the list of active models.",
    ),
    completed: bool = typer.Option(
        False,
        "--completed",
        help="If set to **True**, then only the models that are successfully downloaded "
        "to the server will be returned. Else, the default value **False** will be used to "
        "return all the models.",
    ),
    format: Optional[str] = typer.Option(
        None,
        "--format",
        "-f",
        help="Format output and show only the given column(s) values.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output only uuids of model separated by space",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> Dict["str", Union[pd.DataFrame, str]]:
    """Return the list of models."""

    from airt.client import Model

    mx = Model.ls(offset=offset, limit=limit, disabled=disabled, completed=completed)

    df = Model.as_df(mx)

    df["created"] = helper.humanize_date(df["created"])

    return {"df": df, "quite_column_name": "model_uuid"}

# %% ../../notebooks/CLI_Model.ipynb 21
@app.command()
@helper.display_formated_table
@helper.requires_auth_token
def details(
    uuid: str = typer.Argument(
        ...,
        help="Model uuid",
    ),
    format: Optional[str] = typer.Option(
        None,
        "--format",
        "-f",
        help="Format output and show only the given column(s) values.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> Dict["str", Union[pd.DataFrame, str]]:
    """Return the details of a model."""

    from airt.client import Model

    model = Model(uuid=uuid)
    df = model.details()

    df["created"] = helper.humanize_date(df["created"])

    return {"df": df, "quite_column_name": "model_uuid"}

# %% ../../notebooks/CLI_Model.ipynb 25
@app.command()
@helper.display_formated_table
@helper.requires_auth_token
def rm(
    uuid: str = typer.Argument(
        ...,
        help="Model uuid",
    ),
    format: Optional[str] = typer.Option(
        None,
        "--format",
        "-f",
        help="Format output and show only the given column(s) values.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the deleted Model uuid only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> Dict["str", Union[pd.DataFrame, str]]:
    """Delete a model from the server."""

    from airt.client import Model

    model = Model(uuid=uuid)
    df = model.delete()

    df["created"] = helper.humanize_date(df["created"])

    return {"df": df, "quite_column_name": "model_uuid"}

# %% ../../notebooks/CLI_Model.ipynb 29
@app.command()
@helper.requires_auth_token
def predict(
    data_uuid: str = typer.Option(
        ...,
        "--data_uuid",
        help="DataSource uuid.",
    ),
    uuid: str = typer.Option(
        ...,
        "--uuid",
        help="Model uuid.",
    ),
    quiet: bool = typer.Option(
        False,
        "--quiet",
        "-q",
        help="Output the prediction id only.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Run predictions against the trained model."""

    from airt.client import Model

    model = Model(uuid=uuid)

    prediction = model.predict(data_uuid=data_uuid)

    if quiet:
        prediction.wait()

        typer.echo(f"{prediction.uuid}")
    else:
        typer.echo(f"Running predictions for prediction uuid: {prediction.uuid}")
        prediction.progress_bar()

# %% ../../notebooks/CLI_Model.ipynb 33
@app.command()
@helper.requires_auth_token
def evaluate(
    uuid: str = typer.Argument(
        ...,
        help="Model uuid.",
    ),
    debug: bool = typer.Option(
        False,
        "--debug",
        "-d",
        help="Set logger level to DEBUG and output everything.",
    ),
) -> None:
    """Return the evaluation metrics of the trained model.

    Currently, this command returns the model's accuracy, precision, and recall. In the future, more performance metrics will be added.
    """

    from airt.client import Model

    model = Model(uuid=uuid)

    df = model.evaluate()

    typer.echo(tabulate(df, headers="keys", tablefmt="plain"))  # type: ignore
