"""Setup tily."""

from pathlib import Path
from setuptools import find_packages, setup

HERE = Path(__file__).parent
README = HERE.joinpath("README.md")

with open(README) as f:
    readme = f.read()

setup(
    name="tily",
    version="0.0.4",
    python_requires=">=3.7.4, <=3.7.12",
    description="Tumor-infiltrating lymphocytes prediction based on Whole Slide Imaging.",
    long_description=readme,
    long_description_content_type="text/markdown",
    url="https://github.com/kandabarau/wsi-til",
    author="Sergey Kandabarau",
    author_email="kandabarau@gmail.com",
    license="BSD",
    classifiers=[
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
    ],
    packages=find_packages(include=["tily"], exclude=["tests*"]),
    install_requires=[
        "about-time==3.1.1",
        "absl-py==1.0.0",
        "alive-progress==2.1.0",
        "astor==0.8.1",
        "attrs==21.2.0",
        "certifi==2021.10.8",
        "charset-normalizer==2.0.9",
        "gast==0.2.2",
        "google-pasta==0.2.0",
        "grapheme==0.6.0",
        "grpcio==1.42.0",
        "h5py==2.10.0",
        "idna==3.3",
        "imagecodecs==2021.11.20",
        "importlib-metadata==4.8.2",
        "iniconfig==1.1.1",
        "keras-applications==1.0.8",
        "keras-preprocessing==1.1.2",
        "markdown==3.3.6",
        "numpy==1.17.3",
        "opt-einsum==3.3.0",
        "packaging==21.3",
        "pillow==8.4.0",
        "pluggy==1.0.0",
        "protobuf==3.19.1",
        "py==1.11.0",
        "pyparsing==3.0.6",
        "pytest==6.2.5",
        "requests==2.26.0",
        "six==1.16.0",
        "tensorboard==1.15.0",
        "tensorflow==1.15.5",
        "tensorflow-estimator==1.15.1",
        "termcolor==1.1.0",
        "tifffile==2021.11.2",
        "toml==0.10.2",
        "typing-extensions==4.0.1",
        "urllib3==1.26.7",
        "werkzeug==2.0.2",
        "wheel==0.37.0",
        "wrapt==1.13.3",
        "zipp==3.6.0",
        ],
    entry_points={
        "console_scripts": [
            "tily=tily.__main__:main",
        ]
    },
)
