# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src', 'validate': 'vendor/validate'}

packages = \
['kaskada',
 'kaskada.api',
 'kaskada.kaskada.v1alpha',
 'kaskada.kaskada.v2alpha',
 'validate']

package_data = \
{'': ['*']}

install_requires = \
['certifi>=2022.12.7,<2023.0.0',
 'domonic>=0.9.11,<0.10.0',
 'googleapis-common-protos>=1.58.0,<2.0.0',
 'grpcio-status>=1.51.1,<2.0.0',
 'grpcio>=1.51.1,<2.0.0',
 'html5lib>=1.1,<2.0',
 'ipython>=8.8.0,<9.0.0',
 'pandas>=1.5.2,<2.0.0',
 'pyarrow>=10.0.1,<11.0.0',
 'requests>=2.28.2,<3.0.0',
 'tqdm>=4.64.1,<5.0.0']

setup_kwargs = {
    'name': 'kaskada',
    'version': '0.1.0a1',
    'description': 'A client library for the Kaskada time travel machine learning service',
    'long_description': '# Kaskada SDK\n\n## Developer Instructions\nThe package uses Poetry to develop and build.\n\n1. Install Pyenv [Pyenv Documentation](https://github.com/pyenv/pyenv)\n1. Install Python 3.9.16: `$ pyenv install 3.9.16`\n1. Install Poetry [Poetry Documentation](https://python-poetry.org/docs/)\n1. Install dependences: `$ poetry install`\n\n### Run tasks\nThe package uses [`poethepoet`](https://github.com/nat-n/poethepoet) for running tasks\n\n#### Test Task\nTo run tests: `$ poetry run poe test` \n\n#### Check Style Task\nTo check the style: `$ poetry run poe style`\n\n#### Format Task\nTo auto-format (isort + black): `$ poetry run poe format`\n\n#### Check Static Type Task\nTo perform static type analysis (mypy): `$ poetry run poe types`\n\n#### Lint Task\nTo run the linter (pylint): `$ poetry run poe lint`\n',
    'author': 'Kaskada',
    'author_email': 'support@kaskada.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
