"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ec2messages = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ec2messages extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ec2messages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonmessagedeliveryservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ec2messages';
        this.accessLevelList = {
            "Write": [
                "AcknowledgeMessage",
                "DeleteMessage",
                "FailMessage",
                "SendReply"
            ],
            "Read": [
                "GetEndpoint",
                "GetMessages"
            ]
        };
    }
    /**
     * Acknowledges a message, ensuring it will not be delivered again
     *
     * Access Level: Write
     */
    toAcknowledgeMessage() {
        this.to('ec2messages:AcknowledgeMessage');
        return this;
    }
    /**
     * Deletes a message
     *
     * Access Level: Write
     */
    toDeleteMessage() {
        this.to('ec2messages:DeleteMessage');
        return this;
    }
    /**
     * Fails a message, signifying the message could not be processed successfully, ensuring it cannot be replied to or delivered again
     *
     * Access Level: Write
     */
    toFailMessage() {
        this.to('ec2messages:FailMessage');
        return this;
    }
    /**
     * Routes traffic to the correct endpoint based on the given destination for the messages
     *
     * Access Level: Read
     */
    toGetEndpoint() {
        this.to('ec2messages:GetEndpoint');
        return this;
    }
    /**
     * Delivers messages to clients/instances using long polling
     *
     * Access Level: Read
     */
    toGetMessages() {
        this.to('ec2messages:GetMessages');
        return this;
    }
    /**
     * Sends replies from clients/instances to upstream service
     *
     * Access Level: Write
     */
    toSendReply() {
        this.to('ec2messages:SendReply');
        return this;
    }
}
exports.Ec2messages = Ec2messages;
//# sourceMappingURL=data:application/json;base64,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