import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [redshift-data](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonredshiftdataapi.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class RedshiftData extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [redshift-data](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonredshiftdataapi.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to cancel a running query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_CancelStatement.html
     */
    toCancelStatement(): this;
    /**
     * Grants permission to retrieve detailed information about a statement execution
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeStatement.html
     */
    toDescribeStatement(): this;
    /**
     * Grants permission to retrieve metadata about a particular table
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_DescribeTable.html
     */
    toDescribeTable(): this;
    /**
     * Grants permission to execute a query
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ExecuteStatement.html
     */
    toExecuteStatement(): this;
    /**
     * Grants permission to fetch the result of a query
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_GetStatementResult.html
     */
    toGetStatementResult(): this;
    /**
     * Grants permission to list databases for a given cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListDatabases.html
     */
    toListDatabases(): this;
    /**
     * Grants permission to list schemas for a given cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListSchemas.html
     */
    toListSchemas(): this;
    /**
     * Grants permission to list queries for a given principal
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListStatements.html
     */
    toListStatements(): this;
    /**
     * Grants permission to list tables for a given cluster
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/redshift-data/latest/APIReference/API_ListTables.html
     */
    toListTables(): this;
    protected accessLevelList: AccessLevelList;
}
