"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Ssmmessages = void 0;
const shared_1 = require("../shared");
/**
 * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsessionmanagermessagegatewayservice.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
class Ssmmessages extends shared_1.PolicyStatement {
    /**
     * Statement provider for service [ssmmessages](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_amazonsessionmanagermessagegatewayservice.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid) {
        super(sid);
        this.servicePrefix = 'ssmmessages';
        this.accessLevelList = {
            "Write": [
                "CreateControlChannel",
                "CreateDataChannel",
                "OpenControlChannel",
                "OpenDataChannel"
            ]
        };
    }
    /**
     * Registers a control channel for an instance to send control messages to Systems Manager service.
     *
     * Access Level: Write
     */
    toCreateControlChannel() {
        this.to('ssmmessages:CreateControlChannel');
        return this;
    }
    /**
     * Registers a data channel for an instance to send data messages to Systems Manager service.
     *
     * Access Level: Write
     */
    toCreateDataChannel() {
        this.to('ssmmessages:CreateDataChannel');
        return this;
    }
    /**
     * Opens a websocket connection for a registered control channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     */
    toOpenControlChannel() {
        this.to('ssmmessages:OpenControlChannel');
        return this;
    }
    /**
     * Opens a websocket connection for a registered data channel stream from an instance to Systems Manager service.
     *
     * Access Level: Write
     */
    toOpenDataChannel() {
        this.to('ssmmessages:OpenDataChannel');
        return this;
    }
}
exports.Ssmmessages = Ssmmessages;
//# sourceMappingURL=data:application/json;base64,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