import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement, Operator } from "../shared";
/**
 * Statement provider for service [account](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsaccounts.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Account extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [account](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsaccounts.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to disable a region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     */
    toDisableRegion(): this;
    /**
     * Grants permission to enable a region
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifTargetRegion()
     */
    toEnableRegion(): this;
    /**
     * Grants permission to list regions
     *
     * Access Level: List
     */
    toListRegions(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Filters access by a list of regions
     *
     * Applies to actions:
     * - .toDisableRegion()
     * - .toEnableRegion()
     *
     * @param value The value(s) to check
     * @param operator Works with [string operators](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_condition_operators.html#Conditions_String). **Default:** `StringLike`
     */
    ifTargetRegion(value: string | string[], operator?: Operator | string): this;
}
