import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [cur](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscostandusagereport.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Cur extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [cur](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awscostandusagereport.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Delete Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/delete-report-definition.html
     */
    toDeleteReportDefinition(): this;
    /**
     * Get Cost and Usage Report Definitions
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/describe-report-definitions.html
     */
    toDescribeReportDefinitions(): this;
    /**
     * Modify Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/modify-report-definition.html
     */
    toModifyReportDefinition(): this;
    /**
     * Write Cost and Usage Report Definition
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/put-report-definition.html
     */
    toPutReportDefinition(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type cur to the statement
     *
     * https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/billing-reports.html#enhanced-reports
     *
     * @param reportName - Identifier for the reportName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onCur(reportName: string, account?: string, region?: string, partition?: string): this;
}
