import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [deeplens](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdeeplens.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Deeplens extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [deeplens](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awsdeeplens.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Associates the user's account with IAM roles controlling various permissions needed by AWS DeepLens for proper functionality.
     *
     * Access Level: Permissions management
     */
    toAssociateServiceRoleToAccount(): this;
    /**
     * Retrieves a list of AWS DeepLens devices.
     *
     * Access Level: Read
     */
    toBatchGetDevice(): this;
    /**
     * Retrieves a list of AWS DeepLens Models.
     *
     * Access Level: Read
     */
    toBatchGetModel(): this;
    /**
     * Retrieves a list of AWS DeepLens Projects.
     *
     * Access Level: Read
     */
    toBatchGetProject(): this;
    /**
     * Creates a certificate package that is used to successfully authenticate and Register an AWS DeepLens device.
     *
     * Access Level: Write
     */
    toCreateDeviceCertificates(): this;
    /**
     * Creates a new AWS DeepLens Model.
     *
     * Access Level: Write
     */
    toCreateModel(): this;
    /**
     * Creates a new AWS DeepLens Project.
     *
     * Access Level: Write
     */
    toCreateProject(): this;
    /**
     * Deletes an AWS DeepLens Model.
     *
     * Access Level: Write
     */
    toDeleteModel(): this;
    /**
     * Deletes an AWS DeepLens Project.
     *
     * Access Level: Write
     */
    toDeleteProject(): this;
    /**
     * Deploys an AWS DeepLens project to a registered AWS DeepLens device.
     *
     * Access Level: Write
     */
    toDeployProject(): this;
    /**
     * Begins a device de-registration workflow for a registered AWS DeepLens device.
     *
     * Access Level: Write
     */
    toDeregisterDevice(): this;
    /**
     * Retrieves the account level resources associated with the user's account.
     *
     * Access Level: Read
     */
    toGetAssociatedResources(): this;
    /**
     * Retrieves the the deployment status of a particular AWS DeepLens device, along with any associated metadata.
     *
     * Access Level: Read
     */
    toGetDeploymentStatus(): this;
    /**
     * Retrieves information about an AWS DeepLens device.
     *
     * Access Level: Read
     */
    toGetDevice(): this;
    /**
     * Retrieves an AWS DeepLens Model.
     *
     * Access Level: Read
     */
    toGetModel(): this;
    /**
     * Retrieves an AWS DeepLens Project.
     *
     * Access Level: Read
     */
    toGetProject(): this;
    /**
     * Creates a new AWS DeepLens project from a sample project template.
     *
     * Access Level: Write
     */
    toImportProjectFromTemplate(): this;
    /**
     * Retrieves a list of AWS DeepLens Deployment identifiers.
     *
     * Access Level: List
     */
    toListDeployments(): this;
    /**
     * Retrieves a list of AWS DeepLens device identifiers.
     *
     * Access Level: List
     */
    toListDevices(): this;
    /**
     * Retrieves a list of AWS DeepLens Model identifiers.
     *
     * Access Level: List
     */
    toListModels(): this;
    /**
     * Retrieves a list of AWS DeepLens Project identifiers.
     *
     * Access Level: List
     */
    toListProjects(): this;
    /**
     * Begins a device registration workflow for an AWS DeepLens device.
     *
     * Access Level: Write
     */
    toRegisterDevice(): this;
    /**
     * Removes a deployed AWS DeepLens project from an AWS DeepLens device.
     *
     * Access Level: Write
     */
    toRemoveProject(): this;
    /**
     * Updates an existing AWS DeepLens Project.
     *
     * Access Level: Write
     */
    toUpdateProject(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type device to the statement
     *
     * @param deviceName - Identifier for the deviceName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onDevice(deviceName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type project to the statement
     *
     * @param projectName - Identifier for the projectName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onProject(projectName: string, account?: string, region?: string, partition?: string): this;
    /**
     * Adds a resource of type model to the statement
     *
     * @param modelName - Identifier for the modelName.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param region - Region of the resource; defaults to empty string: all regions.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`.
     */
    onModel(modelName: string, account?: string, region?: string, partition?: string): this;
}
