import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [lakeformation](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslakeformation.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Lakeformation extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [lakeformation](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_awslakeformation.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants data lake permissions to one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toBatchGrantPermissions(): this;
    /**
     * Revokes data lake permissions from one or more principals in a batch.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toBatchRevokePermissions(): this;
    /**
     * Deregisters a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toDeregisterResource(): this;
    /**
     * Describes a registered location.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toDescribeResource(): this;
    /**
     * Grants virtual data lake access permissions.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGetDataAccess(): this;
    /**
     * Retrieves data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGetDataLakeSettings(): this;
    /**
     * Retrieves permissions attached to resources in the given path.
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGetEffectivePermissionsForPath(): this;
    /**
     * Grants data lake permissions to a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toGrantPermissions(): this;
    /**
     * Lists permissions filtered by principal or resource.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toListPermissions(): this;
    /**
     * Lists registered locations.
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toListResources(): this;
    /**
     * Overwrites data lake settings such as the list of data lake administrators and database and table default permissions.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toPutDataLakeSettings(): this;
    /**
     * Registers a new location to be managed by Lake Formation.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toRegisterResource(): this;
    /**
     * Revokes data lake permissions from a principal.
     *
     * Access Level: Permissions management
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toRevokePermissions(): this;
    /**
     * Updates a registered location.
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/lake-formation/latest/dg/aws-lake-formation-api.html
     */
    toUpdateResource(): this;
    protected accessLevelList: AccessLevelList;
}
