import { AccessLevelList } from "../shared/access-level";
import { PolicyStatement } from "../shared";
/**
 * Statement provider for service [applicationinsights](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_cloudwatchapplicationinsights.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class Applicationinsights extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [applicationinsights](https://docs.aws.amazon.com/IAM/latest/UserGuide/list_cloudwatchapplicationinsights.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Creates an application from a resource group
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateApplication.html
     */
    toCreateApplication(): this;
    /**
     * Creates a component from a group of resources
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_CreateComponent.html
     */
    toCreateComponent(): this;
    /**
     * Deletes an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteApplication.html
     */
    toDeleteApplication(): this;
    /**
     * Deletes a component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DeleteComponent.html
     */
    toDeleteComponent(): this;
    /**
     * Describes an application
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeApplication.html
     */
    toDescribeApplication(): this;
    /**
     * Describes a component
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponent.html
     */
    toDescribeComponent(): this;
    /**
     * Describes a component configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfiguration.html
     */
    toDescribeComponentConfiguration(): this;
    /**
     * Describe the recommended application component configuration
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeComponentConfigurationRecommendation.html
     */
    toDescribeComponentConfigurationRecommendation(): this;
    /**
     * Describes an observation
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeObservation.html
     */
    toDescribeObservation(): this;
    /**
     * Describes a problem
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblem.html
     */
    toDescribeProblem(): this;
    /**
     * Describes the observation in a problem
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_DescribeProblemObservations.html
     */
    toDescribeProblemObservations(): this;
    /**
     * Lists all applications
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListApplications.html
     */
    toListApplications(): this;
    /**
     * List an application's components
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListComponents.html
     */
    toListComponents(): this;
    /**
     * Lists the problems in an application
     *
     * Access Level: List
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_ListProblems.html
     */
    toListProblems(): this;
    /**
     * Updates an application
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateApplication.html
     */
    toUpdateApplication(): this;
    /**
     * Updates a component
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponent.html
     */
    toUpdateComponent(): this;
    /**
     * Updates a component configuration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/appinsights/latest/APIReference/API_UpdateComponentConfiguration.html
     */
    toUpdateComponentConfiguration(): this;
    protected accessLevelList: AccessLevelList;
}
