import { PolicyStatementWithResources } from './4-resources';
/**
 * Policy effects
 */
export declare enum Effect {
    ALLOW = "Allow",
    DENY = "Deny"
}
/**
 * Adds "effect" functionality to the Policy Statement
 */
export declare class PolicyStatementWithEffect extends PolicyStatementWithResources {
    effect: Effect;
    /** When `true`, an "Effect: Allow" will be put into the policy statement.
     * By default it will be omitted, since `Allow` is the default anyway.
     */
    protected explicitAllow: boolean;
    /**
     * Injects effect into the statement.
     *
     * Only relevant for the main package. In CDK mode this only calls super.
     */
    toJSON(): any;
    /**
     * Allow the actions in this statement
     *
     * The default `Effect` is `Allow`. Therefore by default the `Effect` key
     * will not be present in the statement. To enforce the `Effect` key, pass
     * `true` as argument.
     *
     * @param explicit Enforce the `Effect` key to be present in the statement
     */
    allow(explicit?: boolean): this;
    /**
     * Deny the actions in this statement
     */
    deny(): this;
}
