<div id="Name">
<h1> Mat Science Library </h1>
</div>

![Banner](https://user-images.githubusercontent.com/79379000/210588068-ed1f92a1-e787-4bed-b786-f227a1b9b14e.svg)




<br>

<p align="center">
  <a href="https://www.linkedin.com/in/muhammed-al-kohawaldeh-2a1295245/" alt="LinkedIn">
  <img src="https://img.shields.io/badge/LinkedIn-Mohammed%20Alkohawaldeh-purple?logo=linkedin&logoColor=blue&color=blue" />
  </a>
  <a href="https://discord.com/channels/1059139195127480420/1059139196075384956" alt="Chat on Discord">
   <img src="https://img.shields.io/discord/808045925556682782.svg?logo=discord&colorB=00d37d" target="blank" />
  </a>

  <a href="https://www.paypal.com/paypalme/MASTALAST" alt="Paypal">
  <img src="https://img.shields.io/liberapay/receives/TheAlgorithms.svg?logo=Paypal" target="blank" />
  </a>

  <a href="https://twitter.com/TWISTER92257313" alt="Twitter">
  <img src="https://img.shields.io/twitter/follow/The_Algorithms?label=Follow us&style=social" />
  </a>


  ![GitHub](https://img.shields.io/github/license/MASTAR-LAST/Science?color=grean) 

<br>

</p>

Installation
============
### Use the package manager `pip` to install **Science** package.

```bash
  pip install science
```


<h1> Who's us </h1>
  I'm a solo python programmer, living in jorden, owner of science package.

<h1> description </h1>
A comprehensive scientific library specialized in thermomechanics and atomic sciences, capable of establishing bonds between atoms to build chemical reactions between them and depicting them in the form of symbolic or verbal equations.
This library is a scientific library that contains a lot of functions 
that are able to help developers and some hobbyists to develop programs
related to conversion between temperatures or atomic activity 
in containing almost all the information of atoms,
which makes it powerful and able to create simple simulations of atomic activities.

## Operating system compatibility
-----
system type | compatibility 
------------ | ------------- 
Linux | *Not Sure yet* :interrobang:
Windows | *compatible* :heavy_check_mark:
Mac OS | *compatible* :heavy_check_mark:

## package capabilities
---
1. *convert between temperature scales*

2. *Draw charts of the expected change in temperature of objects or areas under given weather conditions*

3. *Contains thermomechanical equations*

4. *Building chemical bonds between atoms...etc.*
---
> **NOTE:** This package is supposed to be able to turn fantasy into reality, but the only truth seems to be that this is almost impossible if you remain in this state of poor performance and desperate need for help.
---
## Contributing

**Pull requests are welcome**. For major changes, please open an *issue* first
to discuss what you would like to change.

Please make sure to update tests as appropriate.

<h2> Sources </h2>
        <ul>
            <li>
                <a href="https://github.com/MASTAR-LAST/Science/tree/master/core"> Source Code </a>
                <li>
                <a href="https://github.com/MASTAR-LAST/Science/tree/master/core/atom"> Atomic Stuff </a>
                </li>
                <li>
                <a href="https://github.com/MASTAR-LAST/Science/tree/master/core/thermodynamics"> thermodynamics </a>
                </li>
            </li>
            <li>
                <a href="https://github.com/MASTAR-LAST/Science/tree/master/Source/Errors"> Errors </a>
            </li>
        </ul>

# Usage

## Simpel usage
Convert between temperature scales
```python 
    #                       Convert from Celsius to Kelvin
    # Importing the module as sc
    import science as sc

    # Convert the Temperature
    result = sc.Temperature.Kelvin(23, Key = 'c')

    # Printing the result
    print(result)
``` 

## For more details, please see the [documents]()

# License

* [MIT](https://choosealicense.com/licenses/mit/)