#!/usr/bin/env python3
"""A setuptools based setup module.

"""

from os.path import abspath, dirname, join
from setuptools import setup


here = abspath(dirname(__file__))
with open(join(here, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

setup(
    author='heiko huebscher',
    author_email='heiko.huebscher@gmail.com',
    name='snapshotbackup',
    description='backups with `rsync` and `btrfs` snapshots',
    keywords='backup cli commandline',
    license='MIT',
    long_description=long_description,
    long_description_content_type='text/markdown',
    use_scm_version=True,
    setup_requires=['setuptools_scm'],
    packages=('snapshotbackup',),
    url='https://github.com/hbschr/snapshotbackup',
    install_requires=[
        'argcomplete>=1.11.1',
        'dateparser>=0.7.0',
        'humanfriendly>=4.17',
        'psutil>=5.6.6',
        'python-dateutil>=2.7.2',
        'xdg>=4.0.0',
    ],
    extras_require={
        'dev': [
            'coverage>=4.5.2',
            'flake8>=3.6.0',
            'pytest>=4.0.1',
            'pytest-cov>=2.6.1',
            'pytest-mccabe>=0.1',
            'sphinx>=2.0.1',
            'tox>=3.5.3',
        ],
        'journald': ['systemd-python>=234'],
    },
    entry_points={
        'console_scripts': [
            'snapshotbackup=snapshotbackup:main',
        ],
    },
    classifiers=[
        'Development Status :: 3 - Alpha',
        'Environment :: Console',
        'Intended Audience :: Developers',
        'Topic :: System :: Archiving :: Backup',
        'License :: OSI Approved :: MIT License',
        'Programming Language :: Python :: 3.7',
        'Programming Language :: Python :: 3.8',
        'Programming Language :: Python :: 3.9',
        'Programming Language :: Python :: 3.10',
    ],
)
