# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 credential_type: pulumi.Input[str],
                 default_sts_ttl: Optional[pulumi.Input[int]] = None,
                 iam_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_sts_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_path: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[str] backend: The path the AWS secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[str] credential_type: Specifies the type of credential to be used when
               retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
               `federation_token`.
        :param pulumi.Input[int] default_sts_ttl: The default TTL in seconds for STS credentials.
               When a TTL is not specified when STS credentials are requested,
               and a default TTL is specified on the role,
               then this default TTL will be used. Valid only when `credential_type` is one of
               `assumed_role` or `federation_token`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_groups: A list of IAM group names. IAM users generated
               against this vault role will be added to these IAM Groups. For a credential
               type of `assumed_role` or `federation_token`, the policies sent to the
               corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
               policies from each group in `iam_groups` combined with the `policy_document`
               and `policy_arns` parameters.
        :param pulumi.Input[int] max_sts_ttl: The max allowed TTL in seconds for STS credentials
               (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
               one of `assumed_role` or `federation_token`.
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] permissions_boundary_arn: The ARN of the AWS Permissions 
               Boundary to attach to IAM users created in the role. Valid only when
               `credential_type` is `iam_user`. If not specified, then no permissions boundary
               policy will be attached.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: Specifies a list of AWS managed policy ARNs. The
               behavior depends on the credential type. With `iam_user`, the policies will be
               attached to IAM users when they are requested. With `assumed_role` and
               `federation_token`, the policy ARNs will act as a filter on what the credentials
               can do, similar to `policy_document`. When `credential_type` is `iam_user` or
               `federation_token`, at least one of `policy_document` or `policy_arns` must
               be specified.
        :param pulumi.Input[str] policy_document: The IAM policy document for the role. The
               behavior depends on the credential type. With `iam_user`, the policy document
               will be attached to the IAM user generated and augment the permissions the IAM
               user has. With `assumed_role` and `federation_token`, the policy document will
               act as a filter on what the credentials can do, similar to `policy_arns`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_arns: Specifies the ARNs of the AWS roles this Vault role
               is allowed to assume. Required when `credential_type` is `assumed_role` and
               prohibited otherwise.
        :param pulumi.Input[str] user_path: The path for the user name. Valid only when 
               `credential_type` is `iam_user`. Default is `/`.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "credential_type", credential_type)
        if default_sts_ttl is not None:
            pulumi.set(__self__, "default_sts_ttl", default_sts_ttl)
        if iam_groups is not None:
            pulumi.set(__self__, "iam_groups", iam_groups)
        if max_sts_ttl is not None:
            pulumi.set(__self__, "max_sts_ttl", max_sts_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if role_arns is not None:
            pulumi.set(__self__, "role_arns", role_arns)
        if user_path is not None:
            pulumi.set(__self__, "user_path", user_path)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path the AWS secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of credential to be used when
        retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
        `federation_token`.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="defaultStsTtl")
    def default_sts_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The default TTL in seconds for STS credentials.
        When a TTL is not specified when STS credentials are requested,
        and a default TTL is specified on the role,
        then this default TTL will be used. Valid only when `credential_type` is one of
        `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "default_sts_ttl")

    @default_sts_ttl.setter
    def default_sts_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_sts_ttl", value)

    @property
    @pulumi.getter(name="iamGroups")
    def iam_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IAM group names. IAM users generated
        against this vault role will be added to these IAM Groups. For a credential
        type of `assumed_role` or `federation_token`, the policies sent to the
        corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
        policies from each group in `iam_groups` combined with the `policy_document`
        and `policy_arns` parameters.
        """
        return pulumi.get(self, "iam_groups")

    @iam_groups.setter
    def iam_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "iam_groups", value)

    @property
    @pulumi.getter(name="maxStsTtl")
    def max_sts_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The max allowed TTL in seconds for STS credentials
        (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
        one of `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "max_sts_ttl")

    @max_sts_ttl.setter
    def max_sts_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_sts_ttl", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS Permissions 
        Boundary to attach to IAM users created in the role. Valid only when
        `credential_type` is `iam_user`. If not specified, then no permissions boundary
        policy will be attached.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies a list of AWS managed policy ARNs. The
        behavior depends on the credential type. With `iam_user`, the policies will be
        attached to IAM users when they are requested. With `assumed_role` and
        `federation_token`, the policy ARNs will act as a filter on what the credentials
        can do, similar to `policy_document`. When `credential_type` is `iam_user` or
        `federation_token`, at least one of `policy_document` or `policy_arns` must
        be specified.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM policy document for the role. The
        behavior depends on the credential type. With `iam_user`, the policy document
        will be attached to the IAM user generated and augment the permissions the IAM
        user has. With `assumed_role` and `federation_token`, the policy document will
        act as a filter on what the credentials can do, similar to `policy_arns`.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="roleArns")
    def role_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the ARNs of the AWS roles this Vault role
        is allowed to assume. Required when `credential_type` is `assumed_role` and
        prohibited otherwise.
        """
        return pulumi.get(self, "role_arns")

    @role_arns.setter
    def role_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_arns", value)

    @property
    @pulumi.getter(name="userPath")
    def user_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path for the user name. Valid only when 
        `credential_type` is `iam_user`. Default is `/`.
        """
        return pulumi.get(self, "user_path")

    @user_path.setter
    def user_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_path", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 backend: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 default_sts_ttl: Optional[pulumi.Input[int]] = None,
                 iam_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_sts_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_path: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[str] backend: The path the AWS secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[str] credential_type: Specifies the type of credential to be used when
               retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
               `federation_token`.
        :param pulumi.Input[int] default_sts_ttl: The default TTL in seconds for STS credentials.
               When a TTL is not specified when STS credentials are requested,
               and a default TTL is specified on the role,
               then this default TTL will be used. Valid only when `credential_type` is one of
               `assumed_role` or `federation_token`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_groups: A list of IAM group names. IAM users generated
               against this vault role will be added to these IAM Groups. For a credential
               type of `assumed_role` or `federation_token`, the policies sent to the
               corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
               policies from each group in `iam_groups` combined with the `policy_document`
               and `policy_arns` parameters.
        :param pulumi.Input[int] max_sts_ttl: The max allowed TTL in seconds for STS credentials
               (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
               one of `assumed_role` or `federation_token`.
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] permissions_boundary_arn: The ARN of the AWS Permissions 
               Boundary to attach to IAM users created in the role. Valid only when
               `credential_type` is `iam_user`. If not specified, then no permissions boundary
               policy will be attached.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: Specifies a list of AWS managed policy ARNs. The
               behavior depends on the credential type. With `iam_user`, the policies will be
               attached to IAM users when they are requested. With `assumed_role` and
               `federation_token`, the policy ARNs will act as a filter on what the credentials
               can do, similar to `policy_document`. When `credential_type` is `iam_user` or
               `federation_token`, at least one of `policy_document` or `policy_arns` must
               be specified.
        :param pulumi.Input[str] policy_document: The IAM policy document for the role. The
               behavior depends on the credential type. With `iam_user`, the policy document
               will be attached to the IAM user generated and augment the permissions the IAM
               user has. With `assumed_role` and `federation_token`, the policy document will
               act as a filter on what the credentials can do, similar to `policy_arns`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_arns: Specifies the ARNs of the AWS roles this Vault role
               is allowed to assume. Required when `credential_type` is `assumed_role` and
               prohibited otherwise.
        :param pulumi.Input[str] user_path: The path for the user name. Valid only when 
               `credential_type` is `iam_user`. Default is `/`.
        """
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if credential_type is not None:
            pulumi.set(__self__, "credential_type", credential_type)
        if default_sts_ttl is not None:
            pulumi.set(__self__, "default_sts_ttl", default_sts_ttl)
        if iam_groups is not None:
            pulumi.set(__self__, "iam_groups", iam_groups)
        if max_sts_ttl is not None:
            pulumi.set(__self__, "max_sts_ttl", max_sts_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if permissions_boundary_arn is not None:
            pulumi.set(__self__, "permissions_boundary_arn", permissions_boundary_arn)
        if policy_arns is not None:
            pulumi.set(__self__, "policy_arns", policy_arns)
        if policy_document is not None:
            pulumi.set(__self__, "policy_document", policy_document)
        if role_arns is not None:
            pulumi.set(__self__, "role_arns", role_arns)
        if user_path is not None:
            pulumi.set(__self__, "user_path", user_path)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path the AWS secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of credential to be used when
        retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
        `federation_token`.
        """
        return pulumi.get(self, "credential_type")

    @credential_type.setter
    def credential_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "credential_type", value)

    @property
    @pulumi.getter(name="defaultStsTtl")
    def default_sts_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The default TTL in seconds for STS credentials.
        When a TTL is not specified when STS credentials are requested,
        and a default TTL is specified on the role,
        then this default TTL will be used. Valid only when `credential_type` is one of
        `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "default_sts_ttl")

    @default_sts_ttl.setter
    def default_sts_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_sts_ttl", value)

    @property
    @pulumi.getter(name="iamGroups")
    def iam_groups(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of IAM group names. IAM users generated
        against this vault role will be added to these IAM Groups. For a credential
        type of `assumed_role` or `federation_token`, the policies sent to the
        corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
        policies from each group in `iam_groups` combined with the `policy_document`
        and `policy_arns` parameters.
        """
        return pulumi.get(self, "iam_groups")

    @iam_groups.setter
    def iam_groups(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "iam_groups", value)

    @property
    @pulumi.getter(name="maxStsTtl")
    def max_sts_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The max allowed TTL in seconds for STS credentials
        (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
        one of `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "max_sts_ttl")

    @max_sts_ttl.setter
    def max_sts_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_sts_ttl", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> Optional[pulumi.Input[str]]:
        """
        The ARN of the AWS Permissions 
        Boundary to attach to IAM users created in the role. Valid only when
        `credential_type` is `iam_user`. If not specified, then no permissions boundary
        policy will be attached.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @permissions_boundary_arn.setter
    def permissions_boundary_arn(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "permissions_boundary_arn", value)

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies a list of AWS managed policy ARNs. The
        behavior depends on the credential type. With `iam_user`, the policies will be
        attached to IAM users when they are requested. With `assumed_role` and
        `federation_token`, the policy ARNs will act as a filter on what the credentials
        can do, similar to `policy_document`. When `credential_type` is `iam_user` or
        `federation_token`, at least one of `policy_document` or `policy_arns` must
        be specified.
        """
        return pulumi.get(self, "policy_arns")

    @policy_arns.setter
    def policy_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "policy_arns", value)

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> Optional[pulumi.Input[str]]:
        """
        The IAM policy document for the role. The
        behavior depends on the credential type. With `iam_user`, the policy document
        will be attached to the IAM user generated and augment the permissions the IAM
        user has. With `assumed_role` and `federation_token`, the policy document will
        act as a filter on what the credentials can do, similar to `policy_arns`.
        """
        return pulumi.get(self, "policy_document")

    @policy_document.setter
    def policy_document(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy_document", value)

    @property
    @pulumi.getter(name="roleArns")
    def role_arns(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the ARNs of the AWS roles this Vault role
        is allowed to assume. Required when `credential_type` is `assumed_role` and
        prohibited otherwise.
        """
        return pulumi.get(self, "role_arns")

    @role_arns.setter
    def role_arns(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "role_arns", value)

    @property
    @pulumi.getter(name="userPath")
    def user_path(self) -> Optional[pulumi.Input[str]]:
        """
        The path for the user name. Valid only when 
        `credential_type` is `iam_user`. Default is `/`.
        """
        return pulumi.get(self, "user_path")

    @user_path.setter
    def user_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_path", value)


class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 default_sts_ttl: Optional[pulumi.Input[int]] = None,
                 iam_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_sts_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            access_key="AKIA.....",
            secret_key="AWS secret key")
        role = vault.aws.SecretBackendRole("role",
            backend=aws.path,
            credential_type="iam_user",
            policy_document=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Effect": "Allow",
              "Action": "iam:*",
              "Resource": "*"
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        AWS secret backend roles can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:aws/secretBackendRole:SecretBackendRole role aws/roles/deploy
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the AWS secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[str] credential_type: Specifies the type of credential to be used when
               retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
               `federation_token`.
        :param pulumi.Input[int] default_sts_ttl: The default TTL in seconds for STS credentials.
               When a TTL is not specified when STS credentials are requested,
               and a default TTL is specified on the role,
               then this default TTL will be used. Valid only when `credential_type` is one of
               `assumed_role` or `federation_token`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_groups: A list of IAM group names. IAM users generated
               against this vault role will be added to these IAM Groups. For a credential
               type of `assumed_role` or `federation_token`, the policies sent to the
               corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
               policies from each group in `iam_groups` combined with the `policy_document`
               and `policy_arns` parameters.
        :param pulumi.Input[int] max_sts_ttl: The max allowed TTL in seconds for STS credentials
               (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
               one of `assumed_role` or `federation_token`.
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] permissions_boundary_arn: The ARN of the AWS Permissions 
               Boundary to attach to IAM users created in the role. Valid only when
               `credential_type` is `iam_user`. If not specified, then no permissions boundary
               policy will be attached.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: Specifies a list of AWS managed policy ARNs. The
               behavior depends on the credential type. With `iam_user`, the policies will be
               attached to IAM users when they are requested. With `assumed_role` and
               `federation_token`, the policy ARNs will act as a filter on what the credentials
               can do, similar to `policy_document`. When `credential_type` is `iam_user` or
               `federation_token`, at least one of `policy_document` or `policy_arns` must
               be specified.
        :param pulumi.Input[str] policy_document: The IAM policy document for the role. The
               behavior depends on the credential type. With `iam_user`, the policy document
               will be attached to the IAM user generated and augment the permissions the IAM
               user has. With `assumed_role` and `federation_token`, the policy document will
               act as a filter on what the credentials can do, similar to `policy_arns`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_arns: Specifies the ARNs of the AWS roles this Vault role
               is allowed to assume. Required when `credential_type` is `assumed_role` and
               prohibited otherwise.
        :param pulumi.Input[str] user_path: The path for the user name. Valid only when 
               `credential_type` is `iam_user`. Default is `/`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        aws = vault.aws.SecretBackend("aws",
            access_key="AKIA.....",
            secret_key="AWS secret key")
        role = vault.aws.SecretBackendRole("role",
            backend=aws.path,
            credential_type="iam_user",
            policy_document=\"\"\"{
          "Version": "2012-10-17",
          "Statement": [
            {
              "Effect": "Allow",
              "Action": "iam:*",
              "Resource": "*"
            }
          ]
        }
        \"\"\")
        ```

        ## Import

        AWS secret backend roles can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:aws/secretBackendRole:SecretBackendRole role aws/roles/deploy
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 credential_type: Optional[pulumi.Input[str]] = None,
                 default_sts_ttl: Optional[pulumi.Input[int]] = None,
                 iam_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 max_sts_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
                 policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 policy_document: Optional[pulumi.Input[str]] = None,
                 role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_path: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if credential_type is None and not opts.urn:
                raise TypeError("Missing required property 'credential_type'")
            __props__.__dict__["credential_type"] = credential_type
            __props__.__dict__["default_sts_ttl"] = default_sts_ttl
            __props__.__dict__["iam_groups"] = iam_groups
            __props__.__dict__["max_sts_ttl"] = max_sts_ttl
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["permissions_boundary_arn"] = permissions_boundary_arn
            __props__.__dict__["policy_arns"] = policy_arns
            __props__.__dict__["policy_document"] = policy_document
            __props__.__dict__["role_arns"] = role_arns
            __props__.__dict__["user_path"] = user_path
        super(SecretBackendRole, __self__).__init__(
            'vault:aws/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            credential_type: Optional[pulumi.Input[str]] = None,
            default_sts_ttl: Optional[pulumi.Input[int]] = None,
            iam_groups: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            max_sts_ttl: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            permissions_boundary_arn: Optional[pulumi.Input[str]] = None,
            policy_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            policy_document: Optional[pulumi.Input[str]] = None,
            role_arns: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            user_path: Optional[pulumi.Input[str]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The path the AWS secret backend is mounted at,
               with no leading or trailing `/`s.
        :param pulumi.Input[str] credential_type: Specifies the type of credential to be used when
               retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
               `federation_token`.
        :param pulumi.Input[int] default_sts_ttl: The default TTL in seconds for STS credentials.
               When a TTL is not specified when STS credentials are requested,
               and a default TTL is specified on the role,
               then this default TTL will be used. Valid only when `credential_type` is one of
               `assumed_role` or `federation_token`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] iam_groups: A list of IAM group names. IAM users generated
               against this vault role will be added to these IAM Groups. For a credential
               type of `assumed_role` or `federation_token`, the policies sent to the
               corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
               policies from each group in `iam_groups` combined with the `policy_document`
               and `policy_arns` parameters.
        :param pulumi.Input[int] max_sts_ttl: The max allowed TTL in seconds for STS credentials
               (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
               one of `assumed_role` or `federation_token`.
        :param pulumi.Input[str] name: The name to identify this role within the backend.
               Must be unique within the backend.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] permissions_boundary_arn: The ARN of the AWS Permissions 
               Boundary to attach to IAM users created in the role. Valid only when
               `credential_type` is `iam_user`. If not specified, then no permissions boundary
               policy will be attached.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] policy_arns: Specifies a list of AWS managed policy ARNs. The
               behavior depends on the credential type. With `iam_user`, the policies will be
               attached to IAM users when they are requested. With `assumed_role` and
               `federation_token`, the policy ARNs will act as a filter on what the credentials
               can do, similar to `policy_document`. When `credential_type` is `iam_user` or
               `federation_token`, at least one of `policy_document` or `policy_arns` must
               be specified.
        :param pulumi.Input[str] policy_document: The IAM policy document for the role. The
               behavior depends on the credential type. With `iam_user`, the policy document
               will be attached to the IAM user generated and augment the permissions the IAM
               user has. With `assumed_role` and `federation_token`, the policy document will
               act as a filter on what the credentials can do, similar to `policy_arns`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] role_arns: Specifies the ARNs of the AWS roles this Vault role
               is allowed to assume. Required when `credential_type` is `assumed_role` and
               prohibited otherwise.
        :param pulumi.Input[str] user_path: The path for the user name. Valid only when 
               `credential_type` is `iam_user`. Default is `/`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["backend"] = backend
        __props__.__dict__["credential_type"] = credential_type
        __props__.__dict__["default_sts_ttl"] = default_sts_ttl
        __props__.__dict__["iam_groups"] = iam_groups
        __props__.__dict__["max_sts_ttl"] = max_sts_ttl
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["permissions_boundary_arn"] = permissions_boundary_arn
        __props__.__dict__["policy_arns"] = policy_arns
        __props__.__dict__["policy_document"] = policy_document
        __props__.__dict__["role_arns"] = role_arns
        __props__.__dict__["user_path"] = user_path
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path the AWS secret backend is mounted at,
        with no leading or trailing `/`s.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="credentialType")
    def credential_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of credential to be used when
        retrieving credentials from the role. Must be one of `iam_user`, `assumed_role`, or
        `federation_token`.
        """
        return pulumi.get(self, "credential_type")

    @property
    @pulumi.getter(name="defaultStsTtl")
    def default_sts_ttl(self) -> pulumi.Output[int]:
        """
        The default TTL in seconds for STS credentials.
        When a TTL is not specified when STS credentials are requested,
        and a default TTL is specified on the role,
        then this default TTL will be used. Valid only when `credential_type` is one of
        `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "default_sts_ttl")

    @property
    @pulumi.getter(name="iamGroups")
    def iam_groups(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of IAM group names. IAM users generated
        against this vault role will be added to these IAM Groups. For a credential
        type of `assumed_role` or `federation_token`, the policies sent to the
        corresponding AWS call (sts:AssumeRole or sts:GetFederation) will be the
        policies from each group in `iam_groups` combined with the `policy_document`
        and `policy_arns` parameters.
        """
        return pulumi.get(self, "iam_groups")

    @property
    @pulumi.getter(name="maxStsTtl")
    def max_sts_ttl(self) -> pulumi.Output[int]:
        """
        The max allowed TTL in seconds for STS credentials
        (credentials TTL are capped to `max_sts_ttl`). Valid only when `credential_type` is
        one of `assumed_role` or `federation_token`.
        """
        return pulumi.get(self, "max_sts_ttl")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name to identify this role within the backend.
        Must be unique within the backend.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="permissionsBoundaryArn")
    def permissions_boundary_arn(self) -> pulumi.Output[Optional[str]]:
        """
        The ARN of the AWS Permissions 
        Boundary to attach to IAM users created in the role. Valid only when
        `credential_type` is `iam_user`. If not specified, then no permissions boundary
        policy will be attached.
        """
        return pulumi.get(self, "permissions_boundary_arn")

    @property
    @pulumi.getter(name="policyArns")
    def policy_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies a list of AWS managed policy ARNs. The
        behavior depends on the credential type. With `iam_user`, the policies will be
        attached to IAM users when they are requested. With `assumed_role` and
        `federation_token`, the policy ARNs will act as a filter on what the credentials
        can do, similar to `policy_document`. When `credential_type` is `iam_user` or
        `federation_token`, at least one of `policy_document` or `policy_arns` must
        be specified.
        """
        return pulumi.get(self, "policy_arns")

    @property
    @pulumi.getter(name="policyDocument")
    def policy_document(self) -> pulumi.Output[Optional[str]]:
        """
        The IAM policy document for the role. The
        behavior depends on the credential type. With `iam_user`, the policy document
        will be attached to the IAM user generated and augment the permissions the IAM
        user has. With `assumed_role` and `federation_token`, the policy document will
        act as a filter on what the credentials can do, similar to `policy_arns`.
        """
        return pulumi.get(self, "policy_document")

    @property
    @pulumi.getter(name="roleArns")
    def role_arns(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Specifies the ARNs of the AWS roles this Vault role
        is allowed to assume. Required when `credential_type` is `assumed_role` and
        prohibited otherwise.
        """
        return pulumi.get(self, "role_arns")

    @property
    @pulumi.getter(name="userPath")
    def user_path(self) -> pulumi.Output[Optional[str]]:
        """
        The path for the user name. Valid only when 
        `credential_type` is `iam_user`. Default is `/`.
        """
        return pulumi.get(self, "user_path")

