# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretsMountArgs', 'SecretsMount']

@pulumi.input_type
class SecretsMountArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]] = None,
                 external_entropy_access: Optional[pulumi.Input[bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]] = None,
                 seal_wrap: Optional[pulumi.Input[bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]] = None):
        """
        The set of arguments for constructing a SecretsMount resource.
        :param pulumi.Input[str] path: Where the secret backend will be mounted
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, Any]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        pulumi.set(__self__, "path", path)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if cassandras is not None:
            pulumi.set(__self__, "cassandras", cassandras)
        if couchbases is not None:
            pulumi.set(__self__, "couchbases", couchbases)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearches is not None:
            pulumi.set(__self__, "elasticsearches", elasticsearches)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if hanas is not None:
            pulumi.set(__self__, "hanas", hanas)
        if influxdbs is not None:
            pulumi.set(__self__, "influxdbs", influxdbs)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if mongodbatlas is not None:
            pulumi.set(__self__, "mongodbatlas", mongodbatlas)
        if mongodbs is not None:
            pulumi.set(__self__, "mongodbs", mongodbs)
        if mssqls is not None:
            pulumi.set(__self__, "mssqls", mssqls)
        if mysql_auroras is not None:
            pulumi.set(__self__, "mysql_auroras", mysql_auroras)
        if mysql_legacies is not None:
            pulumi.set(__self__, "mysql_legacies", mysql_legacies)
        if mysql_rds is not None:
            pulumi.set(__self__, "mysql_rds", mysql_rds)
        if mysqls is not None:
            pulumi.set(__self__, "mysqls", mysqls)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if oracles is not None:
            pulumi.set(__self__, "oracles", oracles)
        if postgresqls is not None:
            pulumi.set(__self__, "postgresqls", postgresqls)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_elasticaches is not None:
            pulumi.set(__self__, "redis_elasticaches", redis_elasticaches)
        if redshifts is not None:
            pulumi.set(__self__, "redshifts", redshifts)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if snowflakes is not None:
            pulumi.set(__self__, "snowflakes", snowflakes)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @property
    @pulumi.getter
    def cassandras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]:
        """
        A nested block containing configuration options for Cassandra connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "cassandras")

    @cassandras.setter
    def cassandras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]):
        pulumi.set(self, "cassandras", value)

    @property
    @pulumi.getter
    def couchbases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]:
        """
        A nested block containing configuration options for Couchbase connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "couchbases")

    @couchbases.setter
    def couchbases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]):
        pulumi.set(self, "couchbases", value)

    @property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def elasticsearches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]:
        """
        A nested block containing configuration options for Elasticsearch connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "elasticsearches")

    @elasticsearches.setter
    def elasticsearches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearches", value)

    @property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @property
    @pulumi.getter
    def hanas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]:
        """
        A nested block containing configuration options for SAP HanaDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "hanas")

    @hanas.setter
    def hanas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]):
        pulumi.set(self, "hanas", value)

    @property
    @pulumi.getter
    def influxdbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]:
        """
        A nested block containing configuration options for InfluxDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "influxdbs")

    @influxdbs.setter
    def influxdbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]):
        pulumi.set(self, "influxdbs", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @property
    @pulumi.getter
    def mongodbatlas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbatlas")

    @mongodbatlas.setter
    def mongodbatlas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]):
        pulumi.set(self, "mongodbatlas", value)

    @property
    @pulumi.getter
    def mongodbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]:
        """
        A nested block containing configuration options for MongoDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbs")

    @mongodbs.setter
    def mongodbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]):
        pulumi.set(self, "mongodbs", value)

    @property
    @pulumi.getter
    def mssqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]:
        """
        A nested block containing configuration options for MSSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mssqls")

    @mssqls.setter
    def mssqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]):
        pulumi.set(self, "mssqls", value)

    @property
    @pulumi.getter(name="mysqlAuroras")
    def mysql_auroras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]:
        """
        A nested block containing configuration options for Aurora MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_auroras")

    @mysql_auroras.setter
    def mysql_auroras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]):
        pulumi.set(self, "mysql_auroras", value)

    @property
    @pulumi.getter(name="mysqlLegacies")
    def mysql_legacies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]:
        """
        A nested block containing configuration options for legacy MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_legacies")

    @mysql_legacies.setter
    def mysql_legacies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]):
        pulumi.set(self, "mysql_legacies", value)

    @property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]:
        """
        A nested block containing configuration options for RDS MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_rds")

    @mysql_rds.setter
    def mysql_rds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]):
        pulumi.set(self, "mysql_rds", value)

    @property
    @pulumi.getter
    def mysqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]:
        """
        A nested block containing configuration options for MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysqls")

    @mysqls.setter
    def mysqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]):
        pulumi.set(self, "mysqls", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def oracles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]:
        """
        A nested block containing configuration options for Oracle connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "oracles")

    @oracles.setter
    def oracles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]):
        pulumi.set(self, "oracles", value)

    @property
    @pulumi.getter
    def postgresqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]:
        """
        A nested block containing configuration options for PostgreSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "postgresqls")

    @postgresqls.setter
    def postgresqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]):
        pulumi.set(self, "postgresqls", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]:
        """
        A nested block containing configuration options for Redis connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisElasticaches")
    def redis_elasticaches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis_elasticaches")

    @redis_elasticaches.setter
    def redis_elasticaches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]):
        pulumi.set(self, "redis_elasticaches", value)

    @property
    @pulumi.getter
    def redshifts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]:
        """
        A nested block containing configuration options for AWS Redshift connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redshifts")

    @redshifts.setter
    def redshifts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]):
        pulumi.set(self, "redshifts", value)

    @property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "seal_wrap", value)

    @property
    @pulumi.getter
    def snowflakes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]:
        """
        A nested block containing configuration options for Snowflake connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "snowflakes")

    @snowflakes.setter
    def snowflakes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]):
        pulumi.set(self, "snowflakes", value)


@pulumi.input_type
class _SecretsMountState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[str]] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]] = None,
                 engine_count: Optional[pulumi.Input[int]] = None,
                 external_entropy_access: Optional[pulumi.Input[bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]] = None,
                 seal_wrap: Optional[pulumi.Input[bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]] = None):
        """
        Input properties used for looking up and filtering SecretsMount resources.
        :param pulumi.Input[str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[int] engine_count: The total number of database secrets engines configured.
        :param pulumi.Input[bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, Any]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] path: Where the secret backend will be mounted
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if allowed_managed_keys is not None:
            pulumi.set(__self__, "allowed_managed_keys", allowed_managed_keys)
        if audit_non_hmac_request_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_request_keys", audit_non_hmac_request_keys)
        if audit_non_hmac_response_keys is not None:
            pulumi.set(__self__, "audit_non_hmac_response_keys", audit_non_hmac_response_keys)
        if cassandras is not None:
            pulumi.set(__self__, "cassandras", cassandras)
        if couchbases is not None:
            pulumi.set(__self__, "couchbases", couchbases)
        if default_lease_ttl_seconds is not None:
            pulumi.set(__self__, "default_lease_ttl_seconds", default_lease_ttl_seconds)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if elasticsearches is not None:
            pulumi.set(__self__, "elasticsearches", elasticsearches)
        if engine_count is not None:
            pulumi.set(__self__, "engine_count", engine_count)
        if external_entropy_access is not None:
            pulumi.set(__self__, "external_entropy_access", external_entropy_access)
        if hanas is not None:
            pulumi.set(__self__, "hanas", hanas)
        if influxdbs is not None:
            pulumi.set(__self__, "influxdbs", influxdbs)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if max_lease_ttl_seconds is not None:
            pulumi.set(__self__, "max_lease_ttl_seconds", max_lease_ttl_seconds)
        if mongodbatlas is not None:
            pulumi.set(__self__, "mongodbatlas", mongodbatlas)
        if mongodbs is not None:
            pulumi.set(__self__, "mongodbs", mongodbs)
        if mssqls is not None:
            pulumi.set(__self__, "mssqls", mssqls)
        if mysql_auroras is not None:
            pulumi.set(__self__, "mysql_auroras", mysql_auroras)
        if mysql_legacies is not None:
            pulumi.set(__self__, "mysql_legacies", mysql_legacies)
        if mysql_rds is not None:
            pulumi.set(__self__, "mysql_rds", mysql_rds)
        if mysqls is not None:
            pulumi.set(__self__, "mysqls", mysqls)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if oracles is not None:
            pulumi.set(__self__, "oracles", oracles)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if postgresqls is not None:
            pulumi.set(__self__, "postgresqls", postgresqls)
        if redis is not None:
            pulumi.set(__self__, "redis", redis)
        if redis_elasticaches is not None:
            pulumi.set(__self__, "redis_elasticaches", redis_elasticaches)
        if redshifts is not None:
            pulumi.set(__self__, "redshifts", redshifts)
        if seal_wrap is not None:
            pulumi.set(__self__, "seal_wrap", seal_wrap)
        if snowflakes is not None:
            pulumi.set(__self__, "snowflakes", snowflakes)

    @property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[str]]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessor", value)

    @property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Set of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @allowed_managed_keys.setter
    def allowed_managed_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allowed_managed_keys", value)

    @property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @audit_non_hmac_request_keys.setter
    def audit_non_hmac_request_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audit_non_hmac_request_keys", value)

    @property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @audit_non_hmac_response_keys.setter
    def audit_non_hmac_response_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "audit_non_hmac_response_keys", value)

    @property
    @pulumi.getter
    def cassandras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]:
        """
        A nested block containing configuration options for Cassandra connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "cassandras")

    @cassandras.setter
    def cassandras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCassandraArgs']]]]):
        pulumi.set(self, "cassandras", value)

    @property
    @pulumi.getter
    def couchbases(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]:
        """
        A nested block containing configuration options for Couchbase connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "couchbases")

    @couchbases.setter
    def couchbases(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountCouchbaseArgs']]]]):
        pulumi.set(self, "couchbases", value)

    @property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @default_lease_ttl_seconds.setter
    def default_lease_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "default_lease_ttl_seconds", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def elasticsearches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]:
        """
        A nested block containing configuration options for Elasticsearch connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "elasticsearches")

    @elasticsearches.setter
    def elasticsearches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountElasticsearchArgs']]]]):
        pulumi.set(self, "elasticsearches", value)

    @property
    @pulumi.getter(name="engineCount")
    def engine_count(self) -> Optional[pulumi.Input[int]]:
        """
        The total number of database secrets engines configured.
        """
        return pulumi.get(self, "engine_count")

    @engine_count.setter
    def engine_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "engine_count", value)

    @property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @external_entropy_access.setter
    def external_entropy_access(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_entropy_access", value)

    @property
    @pulumi.getter
    def hanas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]:
        """
        A nested block containing configuration options for SAP HanaDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "hanas")

    @hanas.setter
    def hanas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountHanaArgs']]]]):
        pulumi.set(self, "hanas", value)

    @property
    @pulumi.getter
    def influxdbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]:
        """
        A nested block containing configuration options for InfluxDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "influxdbs")

    @influxdbs.setter
    def influxdbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountInfluxdbArgs']]]]):
        pulumi.set(self, "influxdbs", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> Optional[pulumi.Input[int]]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @max_lease_ttl_seconds.setter
    def max_lease_ttl_seconds(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "max_lease_ttl_seconds", value)

    @property
    @pulumi.getter
    def mongodbatlas(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbatlas")

    @mongodbatlas.setter
    def mongodbatlas(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbatlaArgs']]]]):
        pulumi.set(self, "mongodbatlas", value)

    @property
    @pulumi.getter
    def mongodbs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]:
        """
        A nested block containing configuration options for MongoDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbs")

    @mongodbs.setter
    def mongodbs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMongodbArgs']]]]):
        pulumi.set(self, "mongodbs", value)

    @property
    @pulumi.getter
    def mssqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]:
        """
        A nested block containing configuration options for MSSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mssqls")

    @mssqls.setter
    def mssqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMssqlArgs']]]]):
        pulumi.set(self, "mssqls", value)

    @property
    @pulumi.getter(name="mysqlAuroras")
    def mysql_auroras(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]:
        """
        A nested block containing configuration options for Aurora MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_auroras")

    @mysql_auroras.setter
    def mysql_auroras(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlAuroraArgs']]]]):
        pulumi.set(self, "mysql_auroras", value)

    @property
    @pulumi.getter(name="mysqlLegacies")
    def mysql_legacies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]:
        """
        A nested block containing configuration options for legacy MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_legacies")

    @mysql_legacies.setter
    def mysql_legacies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlLegacyArgs']]]]):
        pulumi.set(self, "mysql_legacies", value)

    @property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]:
        """
        A nested block containing configuration options for RDS MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_rds")

    @mysql_rds.setter
    def mysql_rds(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlRdArgs']]]]):
        pulumi.set(self, "mysql_rds", value)

    @property
    @pulumi.getter
    def mysqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]:
        """
        A nested block containing configuration options for MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysqls")

    @mysqls.setter
    def mysqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountMysqlArgs']]]]):
        pulumi.set(self, "mysqls", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter
    def oracles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]:
        """
        A nested block containing configuration options for Oracle connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "oracles")

    @oracles.setter
    def oracles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountOracleArgs']]]]):
        pulumi.set(self, "oracles", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def postgresqls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]:
        """
        A nested block containing configuration options for PostgreSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "postgresqls")

    @postgresqls.setter
    def postgresqls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountPostgresqlArgs']]]]):
        pulumi.set(self, "postgresqls", value)

    @property
    @pulumi.getter
    def redis(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]:
        """
        A nested block containing configuration options for Redis connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis")

    @redis.setter
    def redis(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRediArgs']]]]):
        pulumi.set(self, "redis", value)

    @property
    @pulumi.getter(name="redisElasticaches")
    def redis_elasticaches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis_elasticaches")

    @redis_elasticaches.setter
    def redis_elasticaches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedisElasticachArgs']]]]):
        pulumi.set(self, "redis_elasticaches", value)

    @property
    @pulumi.getter
    def redshifts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]:
        """
        A nested block containing configuration options for AWS Redshift connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redshifts")

    @redshifts.setter
    def redshifts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountRedshiftArgs']]]]):
        pulumi.set(self, "redshifts", value)

    @property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @seal_wrap.setter
    def seal_wrap(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "seal_wrap", value)

    @property
    @pulumi.getter
    def snowflakes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]:
        """
        A nested block containing configuration options for Snowflake connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "snowflakes")

    @snowflakes.setter
    def snowflakes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretsMountSnowflakeArgs']]]]):
        pulumi.set(self, "snowflakes", value)


class SecretsMount(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCassandraArgs']]]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCouchbaseArgs']]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountElasticsearchArgs']]]]] = None,
                 external_entropy_access: Optional[pulumi.Input[bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountHanaArgs']]]]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountInfluxdbArgs']]]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbatlaArgs']]]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbArgs']]]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMssqlArgs']]]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlAuroraArgs']]]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlLegacyArgs']]]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlRdArgs']]]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlArgs']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountOracleArgs']]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountPostgresqlArgs']]]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRediArgs']]]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedisElasticachArgs']]]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedshiftArgs']]]]] = None,
                 seal_wrap: Optional[pulumi.Input[bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountSnowflakeArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.database.SecretsMount("db",
            path="db",
            mssqls=[vault.database.SecretsMountMssqlArgs(
                name="db1",
                username="sa",
                password="super_secret_1",
                connection_url="sqlserver://{{username}}:{{password}}@127.0.0.1:1433",
                allowed_roles=["dev1"],
            )],
            postgresqls=[vault.database.SecretsMountPostgresqlArgs(
                name="db2",
                username="postgres",
                password="super_secret_2",
                connection_url="postgresql://{{username}}:{{password}}@127.0.0.1:5432/postgres",
                verify_connection=True,
                allowed_roles=["dev2"],
            )])
        dev1 = vault.database.SecretBackendRole("dev1",
            backend=db.path,
            db_name=db.mssqls[0].name,
            creation_statements=[
                "CREATE LOGIN [{{name}}] WITH PASSWORD = '{{password}}';",
                "CREATE USER [{{name}}] FOR LOGIN [{{name}}];",
                "GRANT SELECT ON SCHEMA::dbo TO [{{name}}];",
            ])
        dev2 = vault.database.SecretBackendRole("dev2",
            backend=db.path,
            db_name=db.postgresqls[0].name,
            creation_statements=[
                "CREATE ROLE \\"{{name}}\\" WITH LOGIN PASSWORD '{{password}}' VALID UNTIL '{{expiration}}';",
                "GRANT SELECT ON ALL TABLES IN SCHEMA public TO \\"{{name}}\\";",
            ])
        ```

        ## Import

        Database secret backend connections can be imported using the `path` e.g.

        ```sh
         $ pulumi import vault:database/secretsMount:SecretsMount db db
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCassandraArgs']]]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCouchbaseArgs']]]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountElasticsearchArgs']]]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountHanaArgs']]]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountInfluxdbArgs']]]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbatlaArgs']]]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbArgs']]]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMssqlArgs']]]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlAuroraArgs']]]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlLegacyArgs']]]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlRdArgs']]]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlArgs']]]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, Any]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountOracleArgs']]]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] path: Where the secret backend will be mounted
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountPostgresqlArgs']]]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRediArgs']]]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedisElasticachArgs']]]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedshiftArgs']]]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountSnowflakeArgs']]]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretsMountArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        db = vault.database.SecretsMount("db",
            path="db",
            mssqls=[vault.database.SecretsMountMssqlArgs(
                name="db1",
                username="sa",
                password="super_secret_1",
                connection_url="sqlserver://{{username}}:{{password}}@127.0.0.1:1433",
                allowed_roles=["dev1"],
            )],
            postgresqls=[vault.database.SecretsMountPostgresqlArgs(
                name="db2",
                username="postgres",
                password="super_secret_2",
                connection_url="postgresql://{{username}}:{{password}}@127.0.0.1:5432/postgres",
                verify_connection=True,
                allowed_roles=["dev2"],
            )])
        dev1 = vault.database.SecretBackendRole("dev1",
            backend=db.path,
            db_name=db.mssqls[0].name,
            creation_statements=[
                "CREATE LOGIN [{{name}}] WITH PASSWORD = '{{password}}';",
                "CREATE USER [{{name}}] FOR LOGIN [{{name}}];",
                "GRANT SELECT ON SCHEMA::dbo TO [{{name}}];",
            ])
        dev2 = vault.database.SecretBackendRole("dev2",
            backend=db.path,
            db_name=db.postgresqls[0].name,
            creation_statements=[
                "CREATE ROLE \\"{{name}}\\" WITH LOGIN PASSWORD '{{password}}' VALID UNTIL '{{expiration}}';",
                "GRANT SELECT ON ALL TABLES IN SCHEMA public TO \\"{{name}}\\";",
            ])
        ```

        ## Import

        Database secret backend connections can be imported using the `path` e.g.

        ```sh
         $ pulumi import vault:database/secretsMount:SecretsMount db db
        ```

        :param str resource_name: The name of the resource.
        :param SecretsMountArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretsMountArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCassandraArgs']]]]] = None,
                 couchbases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCouchbaseArgs']]]]] = None,
                 default_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountElasticsearchArgs']]]]] = None,
                 external_entropy_access: Optional[pulumi.Input[bool]] = None,
                 hanas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountHanaArgs']]]]] = None,
                 influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountInfluxdbArgs']]]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
                 mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbatlaArgs']]]]] = None,
                 mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbArgs']]]]] = None,
                 mssqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMssqlArgs']]]]] = None,
                 mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlAuroraArgs']]]]] = None,
                 mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlLegacyArgs']]]]] = None,
                 mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlRdArgs']]]]] = None,
                 mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlArgs']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 oracles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountOracleArgs']]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountPostgresqlArgs']]]]] = None,
                 redis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRediArgs']]]]] = None,
                 redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedisElasticachArgs']]]]] = None,
                 redshifts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedshiftArgs']]]]] = None,
                 seal_wrap: Optional[pulumi.Input[bool]] = None,
                 snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountSnowflakeArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretsMountArgs.__new__(SecretsMountArgs)

            __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
            __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
            __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
            __props__.__dict__["cassandras"] = cassandras
            __props__.__dict__["couchbases"] = couchbases
            __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
            __props__.__dict__["description"] = description
            __props__.__dict__["elasticsearches"] = elasticsearches
            __props__.__dict__["external_entropy_access"] = external_entropy_access
            __props__.__dict__["hanas"] = hanas
            __props__.__dict__["influxdbs"] = influxdbs
            __props__.__dict__["local"] = local
            __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
            __props__.__dict__["mongodbatlas"] = mongodbatlas
            __props__.__dict__["mongodbs"] = mongodbs
            __props__.__dict__["mssqls"] = mssqls
            __props__.__dict__["mysql_auroras"] = mysql_auroras
            __props__.__dict__["mysql_legacies"] = mysql_legacies
            __props__.__dict__["mysql_rds"] = mysql_rds
            __props__.__dict__["mysqls"] = mysqls
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["options"] = options
            __props__.__dict__["oracles"] = oracles
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            __props__.__dict__["postgresqls"] = postgresqls
            __props__.__dict__["redis"] = redis
            __props__.__dict__["redis_elasticaches"] = redis_elasticaches
            __props__.__dict__["redshifts"] = redshifts
            __props__.__dict__["seal_wrap"] = seal_wrap
            __props__.__dict__["snowflakes"] = snowflakes
            __props__.__dict__["accessor"] = None
            __props__.__dict__["engine_count"] = None
        super(SecretsMount, __self__).__init__(
            'vault:database/secretsMount:SecretsMount',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[str]] = None,
            allowed_managed_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            audit_non_hmac_request_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            audit_non_hmac_response_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cassandras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCassandraArgs']]]]] = None,
            couchbases: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCouchbaseArgs']]]]] = None,
            default_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
            description: Optional[pulumi.Input[str]] = None,
            elasticsearches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountElasticsearchArgs']]]]] = None,
            engine_count: Optional[pulumi.Input[int]] = None,
            external_entropy_access: Optional[pulumi.Input[bool]] = None,
            hanas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountHanaArgs']]]]] = None,
            influxdbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountInfluxdbArgs']]]]] = None,
            local: Optional[pulumi.Input[bool]] = None,
            max_lease_ttl_seconds: Optional[pulumi.Input[int]] = None,
            mongodbatlas: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbatlaArgs']]]]] = None,
            mongodbs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbArgs']]]]] = None,
            mssqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMssqlArgs']]]]] = None,
            mysql_auroras: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlAuroraArgs']]]]] = None,
            mysql_legacies: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlLegacyArgs']]]]] = None,
            mysql_rds: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlRdArgs']]]]] = None,
            mysqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlArgs']]]]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            oracles: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountOracleArgs']]]]] = None,
            path: Optional[pulumi.Input[str]] = None,
            postgresqls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountPostgresqlArgs']]]]] = None,
            redis: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRediArgs']]]]] = None,
            redis_elasticaches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedisElasticachArgs']]]]] = None,
            redshifts: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedshiftArgs']]]]] = None,
            seal_wrap: Optional[pulumi.Input[bool]] = None,
            snowflakes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountSnowflakeArgs']]]]] = None) -> 'SecretsMount':
        """
        Get an existing SecretsMount resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor: Accessor of the mount
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allowed_managed_keys: Set of managed key registry entry names that the mount in question is allowed to access
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_request_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] audit_non_hmac_response_keys: Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCassandraArgs']]]] cassandras: A nested block containing configuration options for Cassandra connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountCouchbaseArgs']]]] couchbases: A nested block containing configuration options for Couchbase connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[int] default_lease_ttl_seconds: Default lease duration for tokens and secrets in seconds
        :param pulumi.Input[str] description: Human-friendly description of the mount
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountElasticsearchArgs']]]] elasticsearches: A nested block containing configuration options for Elasticsearch connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[int] engine_count: The total number of database secrets engines configured.
        :param pulumi.Input[bool] external_entropy_access: Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountHanaArgs']]]] hanas: A nested block containing configuration options for SAP HanaDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountInfluxdbArgs']]]] influxdbs: A nested block containing configuration options for InfluxDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] local: Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        :param pulumi.Input[int] max_lease_ttl_seconds: Maximum possible lease duration for tokens and secrets in seconds
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbatlaArgs']]]] mongodbatlas: A nested block containing configuration options for MongoDB Atlas connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMongodbArgs']]]] mongodbs: A nested block containing configuration options for MongoDB connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMssqlArgs']]]] mssqls: A nested block containing configuration options for MSSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlAuroraArgs']]]] mysql_auroras: A nested block containing configuration options for Aurora MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlLegacyArgs']]]] mysql_legacies: A nested block containing configuration options for legacy MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlRdArgs']]]] mysql_rds: A nested block containing configuration options for RDS MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountMysqlArgs']]]] mysqls: A nested block containing configuration options for MySQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] namespace: Target namespace. (requires Enterprise)
        :param pulumi.Input[Mapping[str, Any]] options: Specifies mount type specific options that are passed to the backend
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountOracleArgs']]]] oracles: A nested block containing configuration options for Oracle connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[str] path: Where the secret backend will be mounted
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountPostgresqlArgs']]]] postgresqls: A nested block containing configuration options for PostgreSQL connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRediArgs']]]] redis: A nested block containing configuration options for Redis connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedisElasticachArgs']]]] redis_elasticaches: A nested block containing configuration options for Redis ElastiCache connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountRedshiftArgs']]]] redshifts: A nested block containing configuration options for AWS Redshift connections.  
               *See Configuration Options for more info*
        :param pulumi.Input[bool] seal_wrap: Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretsMountSnowflakeArgs']]]] snowflakes: A nested block containing configuration options for Snowflake connections.  
               *See Configuration Options for more info*
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretsMountState.__new__(_SecretsMountState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["allowed_managed_keys"] = allowed_managed_keys
        __props__.__dict__["audit_non_hmac_request_keys"] = audit_non_hmac_request_keys
        __props__.__dict__["audit_non_hmac_response_keys"] = audit_non_hmac_response_keys
        __props__.__dict__["cassandras"] = cassandras
        __props__.__dict__["couchbases"] = couchbases
        __props__.__dict__["default_lease_ttl_seconds"] = default_lease_ttl_seconds
        __props__.__dict__["description"] = description
        __props__.__dict__["elasticsearches"] = elasticsearches
        __props__.__dict__["engine_count"] = engine_count
        __props__.__dict__["external_entropy_access"] = external_entropy_access
        __props__.__dict__["hanas"] = hanas
        __props__.__dict__["influxdbs"] = influxdbs
        __props__.__dict__["local"] = local
        __props__.__dict__["max_lease_ttl_seconds"] = max_lease_ttl_seconds
        __props__.__dict__["mongodbatlas"] = mongodbatlas
        __props__.__dict__["mongodbs"] = mongodbs
        __props__.__dict__["mssqls"] = mssqls
        __props__.__dict__["mysql_auroras"] = mysql_auroras
        __props__.__dict__["mysql_legacies"] = mysql_legacies
        __props__.__dict__["mysql_rds"] = mysql_rds
        __props__.__dict__["mysqls"] = mysqls
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["options"] = options
        __props__.__dict__["oracles"] = oracles
        __props__.__dict__["path"] = path
        __props__.__dict__["postgresqls"] = postgresqls
        __props__.__dict__["redis"] = redis
        __props__.__dict__["redis_elasticaches"] = redis_elasticaches
        __props__.__dict__["redshifts"] = redshifts
        __props__.__dict__["seal_wrap"] = seal_wrap
        __props__.__dict__["snowflakes"] = snowflakes
        return SecretsMount(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[str]:
        """
        Accessor of the mount
        """
        return pulumi.get(self, "accessor")

    @property
    @pulumi.getter(name="allowedManagedKeys")
    def allowed_managed_keys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Set of managed key registry entry names that the mount in question is allowed to access
        """
        return pulumi.get(self, "allowed_managed_keys")

    @property
    @pulumi.getter(name="auditNonHmacRequestKeys")
    def audit_non_hmac_request_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the request data object.
        """
        return pulumi.get(self, "audit_non_hmac_request_keys")

    @property
    @pulumi.getter(name="auditNonHmacResponseKeys")
    def audit_non_hmac_response_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        Specifies the list of keys that will not be HMAC'd by audit devices in the response data object.
        """
        return pulumi.get(self, "audit_non_hmac_response_keys")

    @property
    @pulumi.getter
    def cassandras(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountCassandra']]]:
        """
        A nested block containing configuration options for Cassandra connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "cassandras")

    @property
    @pulumi.getter
    def couchbases(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountCouchbase']]]:
        """
        A nested block containing configuration options for Couchbase connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "couchbases")

    @property
    @pulumi.getter(name="defaultLeaseTtlSeconds")
    def default_lease_ttl_seconds(self) -> pulumi.Output[int]:
        """
        Default lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "default_lease_ttl_seconds")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Human-friendly description of the mount
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def elasticsearches(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountElasticsearch']]]:
        """
        A nested block containing configuration options for Elasticsearch connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "elasticsearches")

    @property
    @pulumi.getter(name="engineCount")
    def engine_count(self) -> pulumi.Output[int]:
        """
        The total number of database secrets engines configured.
        """
        return pulumi.get(self, "engine_count")

    @property
    @pulumi.getter(name="externalEntropyAccess")
    def external_entropy_access(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean flag that can be explicitly set to true to enable the secrets engine to access Vault's external entropy source
        """
        return pulumi.get(self, "external_entropy_access")

    @property
    @pulumi.getter
    def hanas(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountHana']]]:
        """
        A nested block containing configuration options for SAP HanaDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "hanas")

    @property
    @pulumi.getter
    def influxdbs(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountInfluxdb']]]:
        """
        A nested block containing configuration options for InfluxDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "influxdbs")

    @property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[bool]]:
        """
        Boolean flag that can be explicitly set to true to enforce local mount in HA environment
        """
        return pulumi.get(self, "local")

    @property
    @pulumi.getter(name="maxLeaseTtlSeconds")
    def max_lease_ttl_seconds(self) -> pulumi.Output[int]:
        """
        Maximum possible lease duration for tokens and secrets in seconds
        """
        return pulumi.get(self, "max_lease_ttl_seconds")

    @property
    @pulumi.getter
    def mongodbatlas(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMongodbatla']]]:
        """
        A nested block containing configuration options for MongoDB Atlas connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbatlas")

    @property
    @pulumi.getter
    def mongodbs(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMongodb']]]:
        """
        A nested block containing configuration options for MongoDB connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mongodbs")

    @property
    @pulumi.getter
    def mssqls(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMssql']]]:
        """
        A nested block containing configuration options for MSSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mssqls")

    @property
    @pulumi.getter(name="mysqlAuroras")
    def mysql_auroras(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysqlAurora']]]:
        """
        A nested block containing configuration options for Aurora MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_auroras")

    @property
    @pulumi.getter(name="mysqlLegacies")
    def mysql_legacies(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysqlLegacy']]]:
        """
        A nested block containing configuration options for legacy MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_legacies")

    @property
    @pulumi.getter(name="mysqlRds")
    def mysql_rds(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysqlRd']]]:
        """
        A nested block containing configuration options for RDS MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysql_rds")

    @property
    @pulumi.getter
    def mysqls(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountMysql']]]:
        """
        A nested block containing configuration options for MySQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "mysqls")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        Target namespace. (requires Enterprise)
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def options(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Specifies mount type specific options that are passed to the backend
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def oracles(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountOracle']]]:
        """
        A nested block containing configuration options for Oracle connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "oracles")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        Where the secret backend will be mounted
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def postgresqls(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountPostgresql']]]:
        """
        A nested block containing configuration options for PostgreSQL connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "postgresqls")

    @property
    @pulumi.getter
    def redis(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountRedi']]]:
        """
        A nested block containing configuration options for Redis connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis")

    @property
    @pulumi.getter(name="redisElasticaches")
    def redis_elasticaches(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountRedisElasticach']]]:
        """
        A nested block containing configuration options for Redis ElastiCache connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redis_elasticaches")

    @property
    @pulumi.getter
    def redshifts(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountRedshift']]]:
        """
        A nested block containing configuration options for AWS Redshift connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "redshifts")

    @property
    @pulumi.getter(name="sealWrap")
    def seal_wrap(self) -> pulumi.Output[bool]:
        """
        Boolean flag that can be explicitly set to true to enable seal wrapping for the mount, causing values stored by the mount to be wrapped by the seal's encryption capability
        """
        return pulumi.get(self, "seal_wrap")

    @property
    @pulumi.getter
    def snowflakes(self) -> pulumi.Output[Optional[Sequence['outputs.SecretsMountSnowflake']]]:
        """
        A nested block containing configuration options for Snowflake connections.  
        *See Configuration Options for more info*
        """
        return pulumi.get(self, "snowflakes")

