# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetOidcPublicKeysResult',
    'AwaitableGetOidcPublicKeysResult',
    'get_oidc_public_keys',
    'get_oidc_public_keys_output',
]

@pulumi.output_type
class GetOidcPublicKeysResult:
    """
    A collection of values returned by getOidcPublicKeys.
    """
    def __init__(__self__, id=None, keys=None, name=None, namespace=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if keys and not isinstance(keys, list):
            raise TypeError("Expected argument 'keys' to be a list")
        pulumi.set(__self__, "keys", keys)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[Mapping[str, Any]]:
        """
        The public portion of keys for an OIDC provider. 
        Clients can use them to validate the authenticity of an identity token.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")


class AwaitableGetOidcPublicKeysResult(GetOidcPublicKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOidcPublicKeysResult(
            id=self.id,
            keys=self.keys,
            name=self.name,
            namespace=self.namespace)


def get_oidc_public_keys(name: Optional[str] = None,
                         namespace: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOidcPublicKeysResult:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    key = vault.identity.OidcKey("key",
        allowed_client_ids=["*"],
        rotation_period=3600,
        verification_ttl=3600)
    app = vault.identity.OidcClient("app",
        key=key.name,
        redirect_uris=[
            "http://127.0.0.1:9200/v1/auth-methods/oidc:authenticate:callback",
            "http://127.0.0.1:8251/callback",
            "http://127.0.0.1:8080/callback",
        ],
        id_token_ttl=2400,
        access_token_ttl=7200)
    provider = vault.identity.OidcProvider("provider", allowed_client_ids=[vault_identity_oidc_client["test"]["client_id"]])
    public_keys = vault.identity.get_oidc_public_keys_output(name=provider.name)
    ```


    :param str name: The name of the OIDC Provider in Vault.
    :param str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
           *Available only for Vault Enterprise*.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('vault:identity/getOidcPublicKeys:getOidcPublicKeys', __args__, opts=opts, typ=GetOidcPublicKeysResult).value

    return AwaitableGetOidcPublicKeysResult(
        id=__ret__.id,
        keys=__ret__.keys,
        name=__ret__.name,
        namespace=__ret__.namespace)


@_utilities.lift_output_func(get_oidc_public_keys)
def get_oidc_public_keys_output(name: Optional[pulumi.Input[str]] = None,
                                namespace: Optional[pulumi.Input[Optional[str]]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOidcPublicKeysResult]:
    """
    ## Example Usage

    ```python
    import pulumi
    import pulumi_vault as vault

    key = vault.identity.OidcKey("key",
        allowed_client_ids=["*"],
        rotation_period=3600,
        verification_ttl=3600)
    app = vault.identity.OidcClient("app",
        key=key.name,
        redirect_uris=[
            "http://127.0.0.1:9200/v1/auth-methods/oidc:authenticate:callback",
            "http://127.0.0.1:8251/callback",
            "http://127.0.0.1:8080/callback",
        ],
        id_token_ttl=2400,
        access_token_ttl=7200)
    provider = vault.identity.OidcProvider("provider", allowed_client_ids=[vault_identity_oidc_client["test"]["client_id"]])
    public_keys = vault.identity.get_oidc_public_keys_output(name=provider.name)
    ```


    :param str name: The name of the OIDC Provider in Vault.
    :param str namespace: The namespace of the target resource.
           The value should not contain leading or trailing forward slashes.
           The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
           *Available only for Vault Enterprise*.
    """
    ...
