# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AuthBackendArgs', 'AuthBackend']

@pulumi.input_type
class AuthBackendArgs:
    def __init__(__self__, *,
                 bound_issuer: Optional[pulumi.Input[str]] = None,
                 default_role: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_remount: Optional[pulumi.Input[bool]] = None,
                 jwks_ca_pem: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 jwt_supported_algs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jwt_validation_pubkeys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 namespace_in_state: Optional[pulumi.Input[bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[str]] = None,
                 oidc_client_secret: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_ca_pem: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_url: Optional[pulumi.Input[str]] = None,
                 oidc_response_mode: Optional[pulumi.Input[str]] = None,
                 oidc_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 provider_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthBackend resource.
        :param pulumi.Input[str] bound_issuer: The value against which to match the iss claim in a JWT
        :param pulumi.Input[str] default_role: The default role to use if none is provided during login
        :param pulumi.Input[str] description: The description of the auth backend
        :param pulumi.Input[bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[str] jwks_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        :param pulumi.Input[str] jwks_url: JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_supported_algs: A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_validation_pubkeys: A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        :param pulumi.Input[bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] namespace_in_state: Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        :param pulumi.Input[str] oidc_client_id: Client ID used for OIDC backends
        :param pulumi.Input[str] oidc_client_secret: Client Secret used for OIDC backends
        :param pulumi.Input[str] oidc_discovery_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        :param pulumi.Input[str] oidc_discovery_url: The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        :param pulumi.Input[str] oidc_response_mode: The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_response_types: List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        :param pulumi.Input[str] path: Path to mount the JWT/OIDC auth backend
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] provider_config: Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        :param pulumi.Input[str] type: Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        if bound_issuer is not None:
            pulumi.set(__self__, "bound_issuer", bound_issuer)
        if default_role is not None:
            pulumi.set(__self__, "default_role", default_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if jwks_ca_pem is not None:
            pulumi.set(__self__, "jwks_ca_pem", jwks_ca_pem)
        if jwks_url is not None:
            pulumi.set(__self__, "jwks_url", jwks_url)
        if jwt_supported_algs is not None:
            pulumi.set(__self__, "jwt_supported_algs", jwt_supported_algs)
        if jwt_validation_pubkeys is not None:
            pulumi.set(__self__, "jwt_validation_pubkeys", jwt_validation_pubkeys)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if namespace_in_state is not None:
            pulumi.set(__self__, "namespace_in_state", namespace_in_state)
        if oidc_client_id is not None:
            pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        if oidc_client_secret is not None:
            pulumi.set(__self__, "oidc_client_secret", oidc_client_secret)
        if oidc_discovery_ca_pem is not None:
            pulumi.set(__self__, "oidc_discovery_ca_pem", oidc_discovery_ca_pem)
        if oidc_discovery_url is not None:
            pulumi.set(__self__, "oidc_discovery_url", oidc_discovery_url)
        if oidc_response_mode is not None:
            pulumi.set(__self__, "oidc_response_mode", oidc_response_mode)
        if oidc_response_types is not None:
            pulumi.set(__self__, "oidc_response_types", oidc_response_types)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if provider_config is not None:
            pulumi.set(__self__, "provider_config", provider_config)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="boundIssuer")
    def bound_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The value against which to match the iss claim in a JWT
        """
        return pulumi.get(self, "bound_issuer")

    @bound_issuer.setter
    def bound_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bound_issuer", value)

    @property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> Optional[pulumi.Input[str]]:
        """
        The default role to use if none is provided during login
        """
        return pulumi.get(self, "default_role")

    @default_role.setter
    def default_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_role", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the auth backend
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_remount", value)

    @property
    @pulumi.getter(name="jwksCaPem")
    def jwks_ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        """
        return pulumi.get(self, "jwks_ca_pem")

    @jwks_ca_pem.setter
    def jwks_ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_ca_pem", value)

    @property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> Optional[pulumi.Input[str]]:
        """
        JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        """
        return pulumi.get(self, "jwks_url")

    @jwks_url.setter
    def jwks_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_url", value)

    @property
    @pulumi.getter(name="jwtSupportedAlgs")
    def jwt_supported_algs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        """
        return pulumi.get(self, "jwt_supported_algs")

    @jwt_supported_algs.setter
    def jwt_supported_algs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jwt_supported_algs", value)

    @property
    @pulumi.getter(name="jwtValidationPubkeys")
    def jwt_validation_pubkeys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        """
        return pulumi.get(self, "jwt_validation_pubkeys")

    @jwt_validation_pubkeys.setter
    def jwt_validation_pubkeys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jwt_validation_pubkeys", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="namespaceInState")
    def namespace_in_state(self) -> Optional[pulumi.Input[bool]]:
        """
        Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        """
        return pulumi.get(self, "namespace_in_state")

    @namespace_in_state.setter
    def namespace_in_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "namespace_in_state", value)

    @property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client ID used for OIDC backends
        """
        return pulumi.get(self, "oidc_client_id")

    @oidc_client_id.setter
    def oidc_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_client_id", value)

    @property
    @pulumi.getter(name="oidcClientSecret")
    def oidc_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret used for OIDC backends
        """
        return pulumi.get(self, "oidc_client_secret")

    @oidc_client_secret.setter
    def oidc_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_client_secret", value)

    @property
    @pulumi.getter(name="oidcDiscoveryCaPem")
    def oidc_discovery_ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        """
        return pulumi.get(self, "oidc_discovery_ca_pem")

    @oidc_discovery_ca_pem.setter
    def oidc_discovery_ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_discovery_ca_pem", value)

    @property
    @pulumi.getter(name="oidcDiscoveryUrl")
    def oidc_discovery_url(self) -> Optional[pulumi.Input[str]]:
        """
        The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        """
        return pulumi.get(self, "oidc_discovery_url")

    @oidc_discovery_url.setter
    def oidc_discovery_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_discovery_url", value)

    @property
    @pulumi.getter(name="oidcResponseMode")
    def oidc_response_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        """
        return pulumi.get(self, "oidc_response_mode")

    @oidc_response_mode.setter
    def oidc_response_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_response_mode", value)

    @property
    @pulumi.getter(name="oidcResponseTypes")
    def oidc_response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        """
        return pulumi.get(self, "oidc_response_types")

    @oidc_response_types.setter
    def oidc_response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oidc_response_types", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to mount the JWT/OIDC auth backend
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="providerConfig")
    def provider_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        """
        return pulumi.get(self, "provider_config")

    @provider_config.setter
    def provider_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "provider_config", value)

    @property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class _AuthBackendState:
    def __init__(__self__, *,
                 accessor: Optional[pulumi.Input[str]] = None,
                 bound_issuer: Optional[pulumi.Input[str]] = None,
                 default_role: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_remount: Optional[pulumi.Input[bool]] = None,
                 jwks_ca_pem: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 jwt_supported_algs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jwt_validation_pubkeys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 namespace_in_state: Optional[pulumi.Input[bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[str]] = None,
                 oidc_client_secret: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_ca_pem: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_url: Optional[pulumi.Input[str]] = None,
                 oidc_response_mode: Optional[pulumi.Input[str]] = None,
                 oidc_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 provider_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tune: Optional[pulumi.Input['AuthBackendTuneArgs']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthBackend resources.
        :param pulumi.Input[str] accessor: The accessor for this auth method
        :param pulumi.Input[str] bound_issuer: The value against which to match the iss claim in a JWT
        :param pulumi.Input[str] default_role: The default role to use if none is provided during login
        :param pulumi.Input[str] description: The description of the auth backend
        :param pulumi.Input[bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[str] jwks_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        :param pulumi.Input[str] jwks_url: JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_supported_algs: A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_validation_pubkeys: A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        :param pulumi.Input[bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] namespace_in_state: Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        :param pulumi.Input[str] oidc_client_id: Client ID used for OIDC backends
        :param pulumi.Input[str] oidc_client_secret: Client Secret used for OIDC backends
        :param pulumi.Input[str] oidc_discovery_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        :param pulumi.Input[str] oidc_discovery_url: The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        :param pulumi.Input[str] oidc_response_mode: The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_response_types: List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        :param pulumi.Input[str] path: Path to mount the JWT/OIDC auth backend
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] provider_config: Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        :param pulumi.Input[str] type: Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        if accessor is not None:
            pulumi.set(__self__, "accessor", accessor)
        if bound_issuer is not None:
            pulumi.set(__self__, "bound_issuer", bound_issuer)
        if default_role is not None:
            pulumi.set(__self__, "default_role", default_role)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if disable_remount is not None:
            pulumi.set(__self__, "disable_remount", disable_remount)
        if jwks_ca_pem is not None:
            pulumi.set(__self__, "jwks_ca_pem", jwks_ca_pem)
        if jwks_url is not None:
            pulumi.set(__self__, "jwks_url", jwks_url)
        if jwt_supported_algs is not None:
            pulumi.set(__self__, "jwt_supported_algs", jwt_supported_algs)
        if jwt_validation_pubkeys is not None:
            pulumi.set(__self__, "jwt_validation_pubkeys", jwt_validation_pubkeys)
        if local is not None:
            pulumi.set(__self__, "local", local)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if namespace_in_state is not None:
            pulumi.set(__self__, "namespace_in_state", namespace_in_state)
        if oidc_client_id is not None:
            pulumi.set(__self__, "oidc_client_id", oidc_client_id)
        if oidc_client_secret is not None:
            pulumi.set(__self__, "oidc_client_secret", oidc_client_secret)
        if oidc_discovery_ca_pem is not None:
            pulumi.set(__self__, "oidc_discovery_ca_pem", oidc_discovery_ca_pem)
        if oidc_discovery_url is not None:
            pulumi.set(__self__, "oidc_discovery_url", oidc_discovery_url)
        if oidc_response_mode is not None:
            pulumi.set(__self__, "oidc_response_mode", oidc_response_mode)
        if oidc_response_types is not None:
            pulumi.set(__self__, "oidc_response_types", oidc_response_types)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if provider_config is not None:
            pulumi.set(__self__, "provider_config", provider_config)
        if tune is not None:
            pulumi.set(__self__, "tune", tune)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def accessor(self) -> Optional[pulumi.Input[str]]:
        """
        The accessor for this auth method
        """
        return pulumi.get(self, "accessor")

    @accessor.setter
    def accessor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "accessor", value)

    @property
    @pulumi.getter(name="boundIssuer")
    def bound_issuer(self) -> Optional[pulumi.Input[str]]:
        """
        The value against which to match the iss claim in a JWT
        """
        return pulumi.get(self, "bound_issuer")

    @bound_issuer.setter
    def bound_issuer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bound_issuer", value)

    @property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> Optional[pulumi.Input[str]]:
        """
        The default role to use if none is provided during login
        """
        return pulumi.get(self, "default_role")

    @default_role.setter
    def default_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_role", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the auth backend
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @disable_remount.setter
    def disable_remount(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "disable_remount", value)

    @property
    @pulumi.getter(name="jwksCaPem")
    def jwks_ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        """
        return pulumi.get(self, "jwks_ca_pem")

    @jwks_ca_pem.setter
    def jwks_ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_ca_pem", value)

    @property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> Optional[pulumi.Input[str]]:
        """
        JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        """
        return pulumi.get(self, "jwks_url")

    @jwks_url.setter
    def jwks_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "jwks_url", value)

    @property
    @pulumi.getter(name="jwtSupportedAlgs")
    def jwt_supported_algs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        """
        return pulumi.get(self, "jwt_supported_algs")

    @jwt_supported_algs.setter
    def jwt_supported_algs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jwt_supported_algs", value)

    @property
    @pulumi.getter(name="jwtValidationPubkeys")
    def jwt_validation_pubkeys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        """
        return pulumi.get(self, "jwt_validation_pubkeys")

    @jwt_validation_pubkeys.setter
    def jwt_validation_pubkeys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "jwt_validation_pubkeys", value)

    @property
    @pulumi.getter
    def local(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @local.setter
    def local(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "local", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="namespaceInState")
    def namespace_in_state(self) -> Optional[pulumi.Input[bool]]:
        """
        Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        """
        return pulumi.get(self, "namespace_in_state")

    @namespace_in_state.setter
    def namespace_in_state(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "namespace_in_state", value)

    @property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> Optional[pulumi.Input[str]]:
        """
        Client ID used for OIDC backends
        """
        return pulumi.get(self, "oidc_client_id")

    @oidc_client_id.setter
    def oidc_client_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_client_id", value)

    @property
    @pulumi.getter(name="oidcClientSecret")
    def oidc_client_secret(self) -> Optional[pulumi.Input[str]]:
        """
        Client Secret used for OIDC backends
        """
        return pulumi.get(self, "oidc_client_secret")

    @oidc_client_secret.setter
    def oidc_client_secret(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_client_secret", value)

    @property
    @pulumi.getter(name="oidcDiscoveryCaPem")
    def oidc_discovery_ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        """
        return pulumi.get(self, "oidc_discovery_ca_pem")

    @oidc_discovery_ca_pem.setter
    def oidc_discovery_ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_discovery_ca_pem", value)

    @property
    @pulumi.getter(name="oidcDiscoveryUrl")
    def oidc_discovery_url(self) -> Optional[pulumi.Input[str]]:
        """
        The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        """
        return pulumi.get(self, "oidc_discovery_url")

    @oidc_discovery_url.setter
    def oidc_discovery_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_discovery_url", value)

    @property
    @pulumi.getter(name="oidcResponseMode")
    def oidc_response_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        """
        return pulumi.get(self, "oidc_response_mode")

    @oidc_response_mode.setter
    def oidc_response_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oidc_response_mode", value)

    @property
    @pulumi.getter(name="oidcResponseTypes")
    def oidc_response_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        """
        return pulumi.get(self, "oidc_response_types")

    @oidc_response_types.setter
    def oidc_response_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "oidc_response_types", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        Path to mount the JWT/OIDC auth backend
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter(name="providerConfig")
    def provider_config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        """
        return pulumi.get(self, "provider_config")

    @provider_config.setter
    def provider_config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "provider_config", value)

    @property
    @pulumi.getter
    def tune(self) -> Optional[pulumi.Input['AuthBackendTuneArgs']]:
        return pulumi.get(self, "tune")

    @tune.setter
    def tune(self, value: Optional[pulumi.Input['AuthBackendTuneArgs']]):
        pulumi.set(self, "tune", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


class AuthBackend(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bound_issuer: Optional[pulumi.Input[str]] = None,
                 default_role: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_remount: Optional[pulumi.Input[bool]] = None,
                 jwks_ca_pem: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 jwt_supported_algs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jwt_validation_pubkeys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 namespace_in_state: Optional[pulumi.Input[bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[str]] = None,
                 oidc_client_secret: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_ca_pem: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_url: Optional[pulumi.Input[str]] = None,
                 oidc_response_mode: Optional[pulumi.Input[str]] = None,
                 oidc_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 provider_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tune: Optional[pulumi.Input[pulumi.InputType['AuthBackendTuneArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource for managing an
        [JWT auth backend within Vault](https://www.vaultproject.io/docs/auth/jwt.html).

        ## Example Usage

        Manage JWT auth backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.jwt.AuthBackend("example",
            bound_issuer="https://myco.auth0.com/",
            description="Demonstration of the Terraform JWT auth backend",
            oidc_discovery_url="https://myco.auth0.com/",
            path="jwt")
        ```

        Manage OIDC auth backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.jwt.AuthBackend("example",
            bound_issuer="https://myco.auth0.com/",
            description="Demonstration of the Terraform JWT auth backend",
            oidc_client_id="1234567890",
            oidc_client_secret="secret123456",
            oidc_discovery_url="https://myco.auth0.com/",
            path="oidc",
            tune=vault.jwt.AuthBackendTuneArgs(
                listing_visibility="unauth",
            ),
            type="oidc")
        ```

        Configuring the auth backend with a `provider_config:

        ```python
        import pulumi
        import pulumi_vault as vault

        gsuite = vault.jwt.AuthBackend("gsuite",
            description="OIDC backend",
            oidc_discovery_url="https://accounts.google.com",
            path="oidc",
            provider_config={
                "fetch_groups": "true",
                "fetch_user_info": "true",
                "groups_recurse_max_depth": "1",
                "provider": "gsuite",
            },
            type="oidc")
        ```

        ## Import

        JWT auth backend can be imported using the `type`, e.g.

        ```sh
         $ pulumi import vault:jwt/authBackend:AuthBackend oidc oidc
        ```

         or

        ```sh
         $ pulumi import vault:jwt/authBackend:AuthBackend jwt jwt
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bound_issuer: The value against which to match the iss claim in a JWT
        :param pulumi.Input[str] default_role: The default role to use if none is provided during login
        :param pulumi.Input[str] description: The description of the auth backend
        :param pulumi.Input[bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[str] jwks_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        :param pulumi.Input[str] jwks_url: JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_supported_algs: A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_validation_pubkeys: A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        :param pulumi.Input[bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] namespace_in_state: Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        :param pulumi.Input[str] oidc_client_id: Client ID used for OIDC backends
        :param pulumi.Input[str] oidc_client_secret: Client Secret used for OIDC backends
        :param pulumi.Input[str] oidc_discovery_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        :param pulumi.Input[str] oidc_discovery_url: The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        :param pulumi.Input[str] oidc_response_mode: The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_response_types: List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        :param pulumi.Input[str] path: Path to mount the JWT/OIDC auth backend
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] provider_config: Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        :param pulumi.Input[str] type: Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AuthBackendArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource for managing an
        [JWT auth backend within Vault](https://www.vaultproject.io/docs/auth/jwt.html).

        ## Example Usage

        Manage JWT auth backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.jwt.AuthBackend("example",
            bound_issuer="https://myco.auth0.com/",
            description="Demonstration of the Terraform JWT auth backend",
            oidc_discovery_url="https://myco.auth0.com/",
            path="jwt")
        ```

        Manage OIDC auth backend:

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.jwt.AuthBackend("example",
            bound_issuer="https://myco.auth0.com/",
            description="Demonstration of the Terraform JWT auth backend",
            oidc_client_id="1234567890",
            oidc_client_secret="secret123456",
            oidc_discovery_url="https://myco.auth0.com/",
            path="oidc",
            tune=vault.jwt.AuthBackendTuneArgs(
                listing_visibility="unauth",
            ),
            type="oidc")
        ```

        Configuring the auth backend with a `provider_config:

        ```python
        import pulumi
        import pulumi_vault as vault

        gsuite = vault.jwt.AuthBackend("gsuite",
            description="OIDC backend",
            oidc_discovery_url="https://accounts.google.com",
            path="oidc",
            provider_config={
                "fetch_groups": "true",
                "fetch_user_info": "true",
                "groups_recurse_max_depth": "1",
                "provider": "gsuite",
            },
            type="oidc")
        ```

        ## Import

        JWT auth backend can be imported using the `type`, e.g.

        ```sh
         $ pulumi import vault:jwt/authBackend:AuthBackend oidc oidc
        ```

         or

        ```sh
         $ pulumi import vault:jwt/authBackend:AuthBackend jwt jwt
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bound_issuer: Optional[pulumi.Input[str]] = None,
                 default_role: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 disable_remount: Optional[pulumi.Input[bool]] = None,
                 jwks_ca_pem: Optional[pulumi.Input[str]] = None,
                 jwks_url: Optional[pulumi.Input[str]] = None,
                 jwt_supported_algs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 jwt_validation_pubkeys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 local: Optional[pulumi.Input[bool]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 namespace_in_state: Optional[pulumi.Input[bool]] = None,
                 oidc_client_id: Optional[pulumi.Input[str]] = None,
                 oidc_client_secret: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_ca_pem: Optional[pulumi.Input[str]] = None,
                 oidc_discovery_url: Optional[pulumi.Input[str]] = None,
                 oidc_response_mode: Optional[pulumi.Input[str]] = None,
                 oidc_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 provider_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 tune: Optional[pulumi.Input[pulumi.InputType['AuthBackendTuneArgs']]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendArgs.__new__(AuthBackendArgs)

            __props__.__dict__["bound_issuer"] = bound_issuer
            __props__.__dict__["default_role"] = default_role
            __props__.__dict__["description"] = description
            __props__.__dict__["disable_remount"] = disable_remount
            __props__.__dict__["jwks_ca_pem"] = jwks_ca_pem
            __props__.__dict__["jwks_url"] = jwks_url
            __props__.__dict__["jwt_supported_algs"] = jwt_supported_algs
            __props__.__dict__["jwt_validation_pubkeys"] = jwt_validation_pubkeys
            __props__.__dict__["local"] = local
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["namespace_in_state"] = namespace_in_state
            __props__.__dict__["oidc_client_id"] = oidc_client_id
            __props__.__dict__["oidc_client_secret"] = None if oidc_client_secret is None else pulumi.Output.secret(oidc_client_secret)
            __props__.__dict__["oidc_discovery_ca_pem"] = oidc_discovery_ca_pem
            __props__.__dict__["oidc_discovery_url"] = oidc_discovery_url
            __props__.__dict__["oidc_response_mode"] = oidc_response_mode
            __props__.__dict__["oidc_response_types"] = oidc_response_types
            __props__.__dict__["path"] = path
            __props__.__dict__["provider_config"] = provider_config
            __props__.__dict__["tune"] = tune
            __props__.__dict__["type"] = type
            __props__.__dict__["accessor"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["oidcClientSecret"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AuthBackend, __self__).__init__(
            'vault:jwt/authBackend:AuthBackend',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            accessor: Optional[pulumi.Input[str]] = None,
            bound_issuer: Optional[pulumi.Input[str]] = None,
            default_role: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            disable_remount: Optional[pulumi.Input[bool]] = None,
            jwks_ca_pem: Optional[pulumi.Input[str]] = None,
            jwks_url: Optional[pulumi.Input[str]] = None,
            jwt_supported_algs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            jwt_validation_pubkeys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            local: Optional[pulumi.Input[bool]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            namespace_in_state: Optional[pulumi.Input[bool]] = None,
            oidc_client_id: Optional[pulumi.Input[str]] = None,
            oidc_client_secret: Optional[pulumi.Input[str]] = None,
            oidc_discovery_ca_pem: Optional[pulumi.Input[str]] = None,
            oidc_discovery_url: Optional[pulumi.Input[str]] = None,
            oidc_response_mode: Optional[pulumi.Input[str]] = None,
            oidc_response_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            path: Optional[pulumi.Input[str]] = None,
            provider_config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            tune: Optional[pulumi.Input[pulumi.InputType['AuthBackendTuneArgs']]] = None,
            type: Optional[pulumi.Input[str]] = None) -> 'AuthBackend':
        """
        Get an existing AuthBackend resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] accessor: The accessor for this auth method
        :param pulumi.Input[str] bound_issuer: The value against which to match the iss claim in a JWT
        :param pulumi.Input[str] default_role: The default role to use if none is provided during login
        :param pulumi.Input[str] description: The description of the auth backend
        :param pulumi.Input[bool] disable_remount: If set, opts out of mount migration on path updates.
               See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        :param pulumi.Input[str] jwks_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        :param pulumi.Input[str] jwks_url: JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_supported_algs: A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        :param pulumi.Input[Sequence[pulumi.Input[str]]] jwt_validation_pubkeys: A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        :param pulumi.Input[bool] local: Specifies if the auth method is local only.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] namespace_in_state: Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        :param pulumi.Input[str] oidc_client_id: Client ID used for OIDC backends
        :param pulumi.Input[str] oidc_client_secret: Client Secret used for OIDC backends
        :param pulumi.Input[str] oidc_discovery_ca_pem: The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        :param pulumi.Input[str] oidc_discovery_url: The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        :param pulumi.Input[str] oidc_response_mode: The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] oidc_response_types: List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        :param pulumi.Input[str] path: Path to mount the JWT/OIDC auth backend
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] provider_config: Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        :param pulumi.Input[str] type: Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendState.__new__(_AuthBackendState)

        __props__.__dict__["accessor"] = accessor
        __props__.__dict__["bound_issuer"] = bound_issuer
        __props__.__dict__["default_role"] = default_role
        __props__.__dict__["description"] = description
        __props__.__dict__["disable_remount"] = disable_remount
        __props__.__dict__["jwks_ca_pem"] = jwks_ca_pem
        __props__.__dict__["jwks_url"] = jwks_url
        __props__.__dict__["jwt_supported_algs"] = jwt_supported_algs
        __props__.__dict__["jwt_validation_pubkeys"] = jwt_validation_pubkeys
        __props__.__dict__["local"] = local
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["namespace_in_state"] = namespace_in_state
        __props__.__dict__["oidc_client_id"] = oidc_client_id
        __props__.__dict__["oidc_client_secret"] = oidc_client_secret
        __props__.__dict__["oidc_discovery_ca_pem"] = oidc_discovery_ca_pem
        __props__.__dict__["oidc_discovery_url"] = oidc_discovery_url
        __props__.__dict__["oidc_response_mode"] = oidc_response_mode
        __props__.__dict__["oidc_response_types"] = oidc_response_types
        __props__.__dict__["path"] = path
        __props__.__dict__["provider_config"] = provider_config
        __props__.__dict__["tune"] = tune
        __props__.__dict__["type"] = type
        return AuthBackend(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def accessor(self) -> pulumi.Output[str]:
        """
        The accessor for this auth method
        """
        return pulumi.get(self, "accessor")

    @property
    @pulumi.getter(name="boundIssuer")
    def bound_issuer(self) -> pulumi.Output[Optional[str]]:
        """
        The value against which to match the iss claim in a JWT
        """
        return pulumi.get(self, "bound_issuer")

    @property
    @pulumi.getter(name="defaultRole")
    def default_role(self) -> pulumi.Output[Optional[str]]:
        """
        The default role to use if none is provided during login
        """
        return pulumi.get(self, "default_role")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the auth backend
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="disableRemount")
    def disable_remount(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, opts out of mount migration on path updates.
        See here for more info on [Mount Migration](https://www.vaultproject.io/docs/concepts/mount-migration)
        """
        return pulumi.get(self, "disable_remount")

    @property
    @pulumi.getter(name="jwksCaPem")
    def jwks_ca_pem(self) -> pulumi.Output[Optional[str]]:
        """
        The CA certificate or chain of certificates, in PEM format, to use to validate connections to the JWKS URL. If not set, system certificates are used.
        """
        return pulumi.get(self, "jwks_ca_pem")

    @property
    @pulumi.getter(name="jwksUrl")
    def jwks_url(self) -> pulumi.Output[Optional[str]]:
        """
        JWKS URL to use to authenticate signatures. Cannot be used with "oidc_discovery_url" or "jwt_validation_pubkeys".
        """
        return pulumi.get(self, "jwks_url")

    @property
    @pulumi.getter(name="jwtSupportedAlgs")
    def jwt_supported_algs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of supported signing algorithms. Vault 1.1.0 defaults to [RS256] but future or past versions of Vault may differ
        """
        return pulumi.get(self, "jwt_supported_algs")

    @property
    @pulumi.getter(name="jwtValidationPubkeys")
    def jwt_validation_pubkeys(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of PEM-encoded public keys to use to authenticate signatures locally. Cannot be used in combination with `oidc_discovery_url`
        """
        return pulumi.get(self, "jwt_validation_pubkeys")

    @property
    @pulumi.getter
    def local(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if the auth method is local only.
        """
        return pulumi.get(self, "local")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="namespaceInState")
    def namespace_in_state(self) -> pulumi.Output[Optional[bool]]:
        """
        Pass namespace in the OIDC state parameter instead of as a separate query parameter. With this setting, the allowed redirect URL(s) in Vault and on the provider side should not contain a namespace query parameter. This means only one redirect URL entry needs to be maintained on the OIDC provider side for all vault namespaces that will be authenticating against it. Defaults to true for new configs
        """
        return pulumi.get(self, "namespace_in_state")

    @property
    @pulumi.getter(name="oidcClientId")
    def oidc_client_id(self) -> pulumi.Output[Optional[str]]:
        """
        Client ID used for OIDC backends
        """
        return pulumi.get(self, "oidc_client_id")

    @property
    @pulumi.getter(name="oidcClientSecret")
    def oidc_client_secret(self) -> pulumi.Output[Optional[str]]:
        """
        Client Secret used for OIDC backends
        """
        return pulumi.get(self, "oidc_client_secret")

    @property
    @pulumi.getter(name="oidcDiscoveryCaPem")
    def oidc_discovery_ca_pem(self) -> pulumi.Output[Optional[str]]:
        """
        The CA certificate or chain of certificates, in PEM format, to use to validate connections to the OIDC Discovery URL. If not set, system certificates are used
        """
        return pulumi.get(self, "oidc_discovery_ca_pem")

    @property
    @pulumi.getter(name="oidcDiscoveryUrl")
    def oidc_discovery_url(self) -> pulumi.Output[Optional[str]]:
        """
        The OIDC Discovery URL, without any .well-known component (base path). Cannot be used in combination with `jwt_validation_pubkeys`
        """
        return pulumi.get(self, "oidc_discovery_url")

    @property
    @pulumi.getter(name="oidcResponseMode")
    def oidc_response_mode(self) -> pulumi.Output[Optional[str]]:
        """
        The response mode to be used in the OAuth2 request. Allowed values are `query` and `form_post`. Defaults to `query`. If using Vault namespaces, and `oidc_response_mode` is `form_post`, then `namespace_in_state` should be set to `false`.
        """
        return pulumi.get(self, "oidc_response_mode")

    @property
    @pulumi.getter(name="oidcResponseTypes")
    def oidc_response_types(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of response types to request. Allowed values are 'code' and 'id_token'. Defaults to `["code"]`. Note: `id_token` may only be used if `oidc_response_mode` is set to `form_post`.
        """
        return pulumi.get(self, "oidc_response_types")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[Optional[str]]:
        """
        Path to mount the JWT/OIDC auth backend
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter(name="providerConfig")
    def provider_config(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Provider specific handling configuration. All values may be strings, and the provider will convert to the appropriate type when configuring Vault.
        """
        return pulumi.get(self, "provider_config")

    @property
    @pulumi.getter
    def tune(self) -> pulumi.Output['outputs.AuthBackendTune']:
        return pulumi.get(self, "tune")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[Optional[str]]:
        """
        Type of auth backend. Should be one of `jwt` or `oidc`. Default - `jwt`
        """
        return pulumi.get(self, "type")

