# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretRoleArgs', 'SecretRole']

@pulumi.input_type
class SecretRoleArgs:
    def __init__(__self__, *,
                 path: pulumi.Input[str],
                 role: pulumi.Input[str],
                 scope: pulumi.Input[str],
                 namespace: Optional[pulumi.Input[str]] = None,
                 operation_activate: Optional[pulumi.Input[bool]] = None,
                 operation_add_attribute: Optional[pulumi.Input[bool]] = None,
                 operation_all: Optional[pulumi.Input[bool]] = None,
                 operation_create: Optional[pulumi.Input[bool]] = None,
                 operation_destroy: Optional[pulumi.Input[bool]] = None,
                 operation_discover_versions: Optional[pulumi.Input[bool]] = None,
                 operation_get: Optional[pulumi.Input[bool]] = None,
                 operation_get_attribute_list: Optional[pulumi.Input[bool]] = None,
                 operation_get_attributes: Optional[pulumi.Input[bool]] = None,
                 operation_locate: Optional[pulumi.Input[bool]] = None,
                 operation_none: Optional[pulumi.Input[bool]] = None,
                 operation_register: Optional[pulumi.Input[bool]] = None,
                 operation_rekey: Optional[pulumi.Input[bool]] = None,
                 operation_revoke: Optional[pulumi.Input[bool]] = None,
                 tls_client_key_bits: Optional[pulumi.Input[int]] = None,
                 tls_client_key_type: Optional[pulumi.Input[str]] = None,
                 tls_client_ttl: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a SecretRole resource.
        :param pulumi.Input[str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[str] role: Name of the role.
        :param pulumi.Input[str] scope: Name of the scope.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] operation_activate: Grant permission to use the KMIP Activate operation.
        :param pulumi.Input[bool] operation_add_attribute: Grant permission to use the KMIP Add Attribute operation.
        :param pulumi.Input[bool] operation_all: Grant all permissions to this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_create: Grant permission to use the KMIP Create operation.
        :param pulumi.Input[bool] operation_destroy: Grant permission to use the KMIP Destroy operation.
        :param pulumi.Input[bool] operation_discover_versions: Grant permission to use the KMIP Discover Version operation.
        :param pulumi.Input[bool] operation_get: Grant permission to use the KMIP Get operation.
        :param pulumi.Input[bool] operation_get_attribute_list: Grant permission to use the KMIP Get Atrribute List operation.
        :param pulumi.Input[bool] operation_get_attributes: Grant permission to use the KMIP Get Atrributes operation.
        :param pulumi.Input[bool] operation_locate: Grant permission to use the KMIP Get Locate operation.
        :param pulumi.Input[bool] operation_none: Remove all permissions from this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_register: Grant permission to use the KMIP Register operation.
        :param pulumi.Input[bool] operation_rekey: Grant permission to use the KMIP Rekey operation.
        :param pulumi.Input[bool] operation_revoke: Grant permission to use the KMIP Revoke operation.
        :param pulumi.Input[int] tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[str] tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[int] tls_client_ttl: Client certificate TTL in seconds.
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "role", role)
        pulumi.set(__self__, "scope", scope)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if operation_activate is not None:
            pulumi.set(__self__, "operation_activate", operation_activate)
        if operation_add_attribute is not None:
            pulumi.set(__self__, "operation_add_attribute", operation_add_attribute)
        if operation_all is not None:
            pulumi.set(__self__, "operation_all", operation_all)
        if operation_create is not None:
            pulumi.set(__self__, "operation_create", operation_create)
        if operation_destroy is not None:
            pulumi.set(__self__, "operation_destroy", operation_destroy)
        if operation_discover_versions is not None:
            pulumi.set(__self__, "operation_discover_versions", operation_discover_versions)
        if operation_get is not None:
            pulumi.set(__self__, "operation_get", operation_get)
        if operation_get_attribute_list is not None:
            pulumi.set(__self__, "operation_get_attribute_list", operation_get_attribute_list)
        if operation_get_attributes is not None:
            pulumi.set(__self__, "operation_get_attributes", operation_get_attributes)
        if operation_locate is not None:
            pulumi.set(__self__, "operation_locate", operation_locate)
        if operation_none is not None:
            pulumi.set(__self__, "operation_none", operation_none)
        if operation_register is not None:
            pulumi.set(__self__, "operation_register", operation_register)
        if operation_rekey is not None:
            pulumi.set(__self__, "operation_rekey", operation_rekey)
        if operation_revoke is not None:
            pulumi.set(__self__, "operation_revoke", operation_revoke)
        if tls_client_key_bits is not None:
            pulumi.set(__self__, "tls_client_key_bits", tls_client_key_bits)
        if tls_client_key_type is not None:
            pulumi.set(__self__, "tls_client_key_type", tls_client_key_type)
        if tls_client_ttl is not None:
            pulumi.set(__self__, "tls_client_ttl", tls_client_ttl)

    @property
    @pulumi.getter
    def path(self) -> pulumi.Input[str]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `kmip`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: pulumi.Input[str]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def role(self) -> pulumi.Input[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: pulumi.Input[str]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        Name of the scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="operationActivate")
    def operation_activate(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Activate operation.
        """
        return pulumi.get(self, "operation_activate")

    @operation_activate.setter
    def operation_activate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_activate", value)

    @property
    @pulumi.getter(name="operationAddAttribute")
    def operation_add_attribute(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Add Attribute operation.
        """
        return pulumi.get(self, "operation_add_attribute")

    @operation_add_attribute.setter
    def operation_add_attribute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_add_attribute", value)

    @property
    @pulumi.getter(name="operationAll")
    def operation_all(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant all permissions to this role. May not be specified with any other `operation_*` params.
        """
        return pulumi.get(self, "operation_all")

    @operation_all.setter
    def operation_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_all", value)

    @property
    @pulumi.getter(name="operationCreate")
    def operation_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Create operation.
        """
        return pulumi.get(self, "operation_create")

    @operation_create.setter
    def operation_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_create", value)

    @property
    @pulumi.getter(name="operationDestroy")
    def operation_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Destroy operation.
        """
        return pulumi.get(self, "operation_destroy")

    @operation_destroy.setter
    def operation_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_destroy", value)

    @property
    @pulumi.getter(name="operationDiscoverVersions")
    def operation_discover_versions(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Discover Version operation.
        """
        return pulumi.get(self, "operation_discover_versions")

    @operation_discover_versions.setter
    def operation_discover_versions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_discover_versions", value)

    @property
    @pulumi.getter(name="operationGet")
    def operation_get(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get operation.
        """
        return pulumi.get(self, "operation_get")

    @operation_get.setter
    def operation_get(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_get", value)

    @property
    @pulumi.getter(name="operationGetAttributeList")
    def operation_get_attribute_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get Atrribute List operation.
        """
        return pulumi.get(self, "operation_get_attribute_list")

    @operation_get_attribute_list.setter
    def operation_get_attribute_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_get_attribute_list", value)

    @property
    @pulumi.getter(name="operationGetAttributes")
    def operation_get_attributes(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get Atrributes operation.
        """
        return pulumi.get(self, "operation_get_attributes")

    @operation_get_attributes.setter
    def operation_get_attributes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_get_attributes", value)

    @property
    @pulumi.getter(name="operationLocate")
    def operation_locate(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get Locate operation.
        """
        return pulumi.get(self, "operation_locate")

    @operation_locate.setter
    def operation_locate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_locate", value)

    @property
    @pulumi.getter(name="operationNone")
    def operation_none(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove all permissions from this role. May not be specified with any other `operation_*` params.
        """
        return pulumi.get(self, "operation_none")

    @operation_none.setter
    def operation_none(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_none", value)

    @property
    @pulumi.getter(name="operationRegister")
    def operation_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Register operation.
        """
        return pulumi.get(self, "operation_register")

    @operation_register.setter
    def operation_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_register", value)

    @property
    @pulumi.getter(name="operationRekey")
    def operation_rekey(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Rekey operation.
        """
        return pulumi.get(self, "operation_rekey")

    @operation_rekey.setter
    def operation_rekey(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_rekey", value)

    @property
    @pulumi.getter(name="operationRevoke")
    def operation_revoke(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Revoke operation.
        """
        return pulumi.get(self, "operation_revoke")

    @operation_revoke.setter
    def operation_revoke(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_revoke", value)

    @property
    @pulumi.getter(name="tlsClientKeyBits")
    def tls_client_key_bits(self) -> Optional[pulumi.Input[int]]:
        """
        Client certificate key bits, valid values depend on key type.
        """
        return pulumi.get(self, "tls_client_key_bits")

    @tls_client_key_bits.setter
    def tls_client_key_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tls_client_key_bits", value)

    @property
    @pulumi.getter(name="tlsClientKeyType")
    def tls_client_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        Client certificate key type, `rsa` or `ec`.
        """
        return pulumi.get(self, "tls_client_key_type")

    @tls_client_key_type.setter
    def tls_client_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key_type", value)

    @property
    @pulumi.getter(name="tlsClientTtl")
    def tls_client_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Client certificate TTL in seconds.
        """
        return pulumi.get(self, "tls_client_ttl")

    @tls_client_ttl.setter
    def tls_client_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tls_client_ttl", value)


@pulumi.input_type
class _SecretRoleState:
    def __init__(__self__, *,
                 namespace: Optional[pulumi.Input[str]] = None,
                 operation_activate: Optional[pulumi.Input[bool]] = None,
                 operation_add_attribute: Optional[pulumi.Input[bool]] = None,
                 operation_all: Optional[pulumi.Input[bool]] = None,
                 operation_create: Optional[pulumi.Input[bool]] = None,
                 operation_destroy: Optional[pulumi.Input[bool]] = None,
                 operation_discover_versions: Optional[pulumi.Input[bool]] = None,
                 operation_get: Optional[pulumi.Input[bool]] = None,
                 operation_get_attribute_list: Optional[pulumi.Input[bool]] = None,
                 operation_get_attributes: Optional[pulumi.Input[bool]] = None,
                 operation_locate: Optional[pulumi.Input[bool]] = None,
                 operation_none: Optional[pulumi.Input[bool]] = None,
                 operation_register: Optional[pulumi.Input[bool]] = None,
                 operation_rekey: Optional[pulumi.Input[bool]] = None,
                 operation_revoke: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tls_client_key_bits: Optional[pulumi.Input[int]] = None,
                 tls_client_key_type: Optional[pulumi.Input[str]] = None,
                 tls_client_ttl: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering SecretRole resources.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] operation_activate: Grant permission to use the KMIP Activate operation.
        :param pulumi.Input[bool] operation_add_attribute: Grant permission to use the KMIP Add Attribute operation.
        :param pulumi.Input[bool] operation_all: Grant all permissions to this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_create: Grant permission to use the KMIP Create operation.
        :param pulumi.Input[bool] operation_destroy: Grant permission to use the KMIP Destroy operation.
        :param pulumi.Input[bool] operation_discover_versions: Grant permission to use the KMIP Discover Version operation.
        :param pulumi.Input[bool] operation_get: Grant permission to use the KMIP Get operation.
        :param pulumi.Input[bool] operation_get_attribute_list: Grant permission to use the KMIP Get Atrribute List operation.
        :param pulumi.Input[bool] operation_get_attributes: Grant permission to use the KMIP Get Atrributes operation.
        :param pulumi.Input[bool] operation_locate: Grant permission to use the KMIP Get Locate operation.
        :param pulumi.Input[bool] operation_none: Remove all permissions from this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_register: Grant permission to use the KMIP Register operation.
        :param pulumi.Input[bool] operation_rekey: Grant permission to use the KMIP Rekey operation.
        :param pulumi.Input[bool] operation_revoke: Grant permission to use the KMIP Revoke operation.
        :param pulumi.Input[str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[str] role: Name of the role.
        :param pulumi.Input[str] scope: Name of the scope.
        :param pulumi.Input[int] tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[str] tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[int] tls_client_ttl: Client certificate TTL in seconds.
        """
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if operation_activate is not None:
            pulumi.set(__self__, "operation_activate", operation_activate)
        if operation_add_attribute is not None:
            pulumi.set(__self__, "operation_add_attribute", operation_add_attribute)
        if operation_all is not None:
            pulumi.set(__self__, "operation_all", operation_all)
        if operation_create is not None:
            pulumi.set(__self__, "operation_create", operation_create)
        if operation_destroy is not None:
            pulumi.set(__self__, "operation_destroy", operation_destroy)
        if operation_discover_versions is not None:
            pulumi.set(__self__, "operation_discover_versions", operation_discover_versions)
        if operation_get is not None:
            pulumi.set(__self__, "operation_get", operation_get)
        if operation_get_attribute_list is not None:
            pulumi.set(__self__, "operation_get_attribute_list", operation_get_attribute_list)
        if operation_get_attributes is not None:
            pulumi.set(__self__, "operation_get_attributes", operation_get_attributes)
        if operation_locate is not None:
            pulumi.set(__self__, "operation_locate", operation_locate)
        if operation_none is not None:
            pulumi.set(__self__, "operation_none", operation_none)
        if operation_register is not None:
            pulumi.set(__self__, "operation_register", operation_register)
        if operation_rekey is not None:
            pulumi.set(__self__, "operation_rekey", operation_rekey)
        if operation_revoke is not None:
            pulumi.set(__self__, "operation_revoke", operation_revoke)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if tls_client_key_bits is not None:
            pulumi.set(__self__, "tls_client_key_bits", tls_client_key_bits)
        if tls_client_key_type is not None:
            pulumi.set(__self__, "tls_client_key_type", tls_client_key_type)
        if tls_client_ttl is not None:
            pulumi.set(__self__, "tls_client_ttl", tls_client_ttl)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="operationActivate")
    def operation_activate(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Activate operation.
        """
        return pulumi.get(self, "operation_activate")

    @operation_activate.setter
    def operation_activate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_activate", value)

    @property
    @pulumi.getter(name="operationAddAttribute")
    def operation_add_attribute(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Add Attribute operation.
        """
        return pulumi.get(self, "operation_add_attribute")

    @operation_add_attribute.setter
    def operation_add_attribute(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_add_attribute", value)

    @property
    @pulumi.getter(name="operationAll")
    def operation_all(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant all permissions to this role. May not be specified with any other `operation_*` params.
        """
        return pulumi.get(self, "operation_all")

    @operation_all.setter
    def operation_all(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_all", value)

    @property
    @pulumi.getter(name="operationCreate")
    def operation_create(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Create operation.
        """
        return pulumi.get(self, "operation_create")

    @operation_create.setter
    def operation_create(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_create", value)

    @property
    @pulumi.getter(name="operationDestroy")
    def operation_destroy(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Destroy operation.
        """
        return pulumi.get(self, "operation_destroy")

    @operation_destroy.setter
    def operation_destroy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_destroy", value)

    @property
    @pulumi.getter(name="operationDiscoverVersions")
    def operation_discover_versions(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Discover Version operation.
        """
        return pulumi.get(self, "operation_discover_versions")

    @operation_discover_versions.setter
    def operation_discover_versions(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_discover_versions", value)

    @property
    @pulumi.getter(name="operationGet")
    def operation_get(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get operation.
        """
        return pulumi.get(self, "operation_get")

    @operation_get.setter
    def operation_get(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_get", value)

    @property
    @pulumi.getter(name="operationGetAttributeList")
    def operation_get_attribute_list(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get Atrribute List operation.
        """
        return pulumi.get(self, "operation_get_attribute_list")

    @operation_get_attribute_list.setter
    def operation_get_attribute_list(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_get_attribute_list", value)

    @property
    @pulumi.getter(name="operationGetAttributes")
    def operation_get_attributes(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get Atrributes operation.
        """
        return pulumi.get(self, "operation_get_attributes")

    @operation_get_attributes.setter
    def operation_get_attributes(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_get_attributes", value)

    @property
    @pulumi.getter(name="operationLocate")
    def operation_locate(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Get Locate operation.
        """
        return pulumi.get(self, "operation_locate")

    @operation_locate.setter
    def operation_locate(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_locate", value)

    @property
    @pulumi.getter(name="operationNone")
    def operation_none(self) -> Optional[pulumi.Input[bool]]:
        """
        Remove all permissions from this role. May not be specified with any other `operation_*` params.
        """
        return pulumi.get(self, "operation_none")

    @operation_none.setter
    def operation_none(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_none", value)

    @property
    @pulumi.getter(name="operationRegister")
    def operation_register(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Register operation.
        """
        return pulumi.get(self, "operation_register")

    @operation_register.setter
    def operation_register(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_register", value)

    @property
    @pulumi.getter(name="operationRekey")
    def operation_rekey(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Rekey operation.
        """
        return pulumi.get(self, "operation_rekey")

    @operation_rekey.setter
    def operation_rekey(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_rekey", value)

    @property
    @pulumi.getter(name="operationRevoke")
    def operation_revoke(self) -> Optional[pulumi.Input[bool]]:
        """
        Grant permission to use the KMIP Revoke operation.
        """
        return pulumi.get(self, "operation_revoke")

    @operation_revoke.setter
    def operation_revoke(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "operation_revoke", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `kmip`.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the scope.
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="tlsClientKeyBits")
    def tls_client_key_bits(self) -> Optional[pulumi.Input[int]]:
        """
        Client certificate key bits, valid values depend on key type.
        """
        return pulumi.get(self, "tls_client_key_bits")

    @tls_client_key_bits.setter
    def tls_client_key_bits(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tls_client_key_bits", value)

    @property
    @pulumi.getter(name="tlsClientKeyType")
    def tls_client_key_type(self) -> Optional[pulumi.Input[str]]:
        """
        Client certificate key type, `rsa` or `ec`.
        """
        return pulumi.get(self, "tls_client_key_type")

    @tls_client_key_type.setter
    def tls_client_key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "tls_client_key_type", value)

    @property
    @pulumi.getter(name="tlsClientTtl")
    def tls_client_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        Client certificate TTL in seconds.
        """
        return pulumi.get(self, "tls_client_ttl")

    @tls_client_ttl.setter
    def tls_client_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "tls_client_ttl", value)


class SecretRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 operation_activate: Optional[pulumi.Input[bool]] = None,
                 operation_add_attribute: Optional[pulumi.Input[bool]] = None,
                 operation_all: Optional[pulumi.Input[bool]] = None,
                 operation_create: Optional[pulumi.Input[bool]] = None,
                 operation_destroy: Optional[pulumi.Input[bool]] = None,
                 operation_discover_versions: Optional[pulumi.Input[bool]] = None,
                 operation_get: Optional[pulumi.Input[bool]] = None,
                 operation_get_attribute_list: Optional[pulumi.Input[bool]] = None,
                 operation_get_attributes: Optional[pulumi.Input[bool]] = None,
                 operation_locate: Optional[pulumi.Input[bool]] = None,
                 operation_none: Optional[pulumi.Input[bool]] = None,
                 operation_register: Optional[pulumi.Input[bool]] = None,
                 operation_rekey: Optional[pulumi.Input[bool]] = None,
                 operation_revoke: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tls_client_key_bits: Optional[pulumi.Input[int]] = None,
                 tls_client_key_type: Optional[pulumi.Input[str]] = None,
                 tls_client_ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Manages KMIP Secret roles in a Vault server. This feature requires
        Vault Enterprise. See the [Vault documentation](https://www.vaultproject.io/docs/secrets/kmip)
        for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        default = vault.kmip.SecretBackend("default",
            path="kmip",
            description="Vault KMIP backend")
        dev = vault.kmip.SecretScope("dev",
            path=default.path,
            scope="dev",
            force=True)
        admin = vault.kmip.SecretRole("admin",
            path=dev.path,
            scope=dev.scope,
            role="admin",
            tls_client_key_type="ec",
            tls_client_key_bits=256,
            operation_activate=True,
            operation_get=True,
            operation_get_attributes=True,
            operation_create=True,
            operation_destroy=True)
        ```

        ## Import

        KMIP Secret role can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:kmip/secretRole:SecretRole admin kmip
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] operation_activate: Grant permission to use the KMIP Activate operation.
        :param pulumi.Input[bool] operation_add_attribute: Grant permission to use the KMIP Add Attribute operation.
        :param pulumi.Input[bool] operation_all: Grant all permissions to this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_create: Grant permission to use the KMIP Create operation.
        :param pulumi.Input[bool] operation_destroy: Grant permission to use the KMIP Destroy operation.
        :param pulumi.Input[bool] operation_discover_versions: Grant permission to use the KMIP Discover Version operation.
        :param pulumi.Input[bool] operation_get: Grant permission to use the KMIP Get operation.
        :param pulumi.Input[bool] operation_get_attribute_list: Grant permission to use the KMIP Get Atrribute List operation.
        :param pulumi.Input[bool] operation_get_attributes: Grant permission to use the KMIP Get Atrributes operation.
        :param pulumi.Input[bool] operation_locate: Grant permission to use the KMIP Get Locate operation.
        :param pulumi.Input[bool] operation_none: Remove all permissions from this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_register: Grant permission to use the KMIP Register operation.
        :param pulumi.Input[bool] operation_rekey: Grant permission to use the KMIP Rekey operation.
        :param pulumi.Input[bool] operation_revoke: Grant permission to use the KMIP Revoke operation.
        :param pulumi.Input[str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[str] role: Name of the role.
        :param pulumi.Input[str] scope: Name of the scope.
        :param pulumi.Input[int] tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[str] tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[int] tls_client_ttl: Client certificate TTL in seconds.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages KMIP Secret roles in a Vault server. This feature requires
        Vault Enterprise. See the [Vault documentation](https://www.vaultproject.io/docs/secrets/kmip)
        for more information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        default = vault.kmip.SecretBackend("default",
            path="kmip",
            description="Vault KMIP backend")
        dev = vault.kmip.SecretScope("dev",
            path=default.path,
            scope="dev",
            force=True)
        admin = vault.kmip.SecretRole("admin",
            path=dev.path,
            scope=dev.scope,
            role="admin",
            tls_client_key_type="ec",
            tls_client_key_bits=256,
            operation_activate=True,
            operation_get=True,
            operation_get_attributes=True,
            operation_create=True,
            operation_destroy=True)
        ```

        ## Import

        KMIP Secret role can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:kmip/secretRole:SecretRole admin kmip
        ```

        :param str resource_name: The name of the resource.
        :param SecretRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 operation_activate: Optional[pulumi.Input[bool]] = None,
                 operation_add_attribute: Optional[pulumi.Input[bool]] = None,
                 operation_all: Optional[pulumi.Input[bool]] = None,
                 operation_create: Optional[pulumi.Input[bool]] = None,
                 operation_destroy: Optional[pulumi.Input[bool]] = None,
                 operation_discover_versions: Optional[pulumi.Input[bool]] = None,
                 operation_get: Optional[pulumi.Input[bool]] = None,
                 operation_get_attribute_list: Optional[pulumi.Input[bool]] = None,
                 operation_get_attributes: Optional[pulumi.Input[bool]] = None,
                 operation_locate: Optional[pulumi.Input[bool]] = None,
                 operation_none: Optional[pulumi.Input[bool]] = None,
                 operation_register: Optional[pulumi.Input[bool]] = None,
                 operation_rekey: Optional[pulumi.Input[bool]] = None,
                 operation_revoke: Optional[pulumi.Input[bool]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 scope: Optional[pulumi.Input[str]] = None,
                 tls_client_key_bits: Optional[pulumi.Input[int]] = None,
                 tls_client_key_type: Optional[pulumi.Input[str]] = None,
                 tls_client_ttl: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretRoleArgs.__new__(SecretRoleArgs)

            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["operation_activate"] = operation_activate
            __props__.__dict__["operation_add_attribute"] = operation_add_attribute
            __props__.__dict__["operation_all"] = operation_all
            __props__.__dict__["operation_create"] = operation_create
            __props__.__dict__["operation_destroy"] = operation_destroy
            __props__.__dict__["operation_discover_versions"] = operation_discover_versions
            __props__.__dict__["operation_get"] = operation_get
            __props__.__dict__["operation_get_attribute_list"] = operation_get_attribute_list
            __props__.__dict__["operation_get_attributes"] = operation_get_attributes
            __props__.__dict__["operation_locate"] = operation_locate
            __props__.__dict__["operation_none"] = operation_none
            __props__.__dict__["operation_register"] = operation_register
            __props__.__dict__["operation_rekey"] = operation_rekey
            __props__.__dict__["operation_revoke"] = operation_revoke
            if path is None and not opts.urn:
                raise TypeError("Missing required property 'path'")
            __props__.__dict__["path"] = path
            if role is None and not opts.urn:
                raise TypeError("Missing required property 'role'")
            __props__.__dict__["role"] = role
            if scope is None and not opts.urn:
                raise TypeError("Missing required property 'scope'")
            __props__.__dict__["scope"] = scope
            __props__.__dict__["tls_client_key_bits"] = tls_client_key_bits
            __props__.__dict__["tls_client_key_type"] = tls_client_key_type
            __props__.__dict__["tls_client_ttl"] = tls_client_ttl
        super(SecretRole, __self__).__init__(
            'vault:kmip/secretRole:SecretRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            operation_activate: Optional[pulumi.Input[bool]] = None,
            operation_add_attribute: Optional[pulumi.Input[bool]] = None,
            operation_all: Optional[pulumi.Input[bool]] = None,
            operation_create: Optional[pulumi.Input[bool]] = None,
            operation_destroy: Optional[pulumi.Input[bool]] = None,
            operation_discover_versions: Optional[pulumi.Input[bool]] = None,
            operation_get: Optional[pulumi.Input[bool]] = None,
            operation_get_attribute_list: Optional[pulumi.Input[bool]] = None,
            operation_get_attributes: Optional[pulumi.Input[bool]] = None,
            operation_locate: Optional[pulumi.Input[bool]] = None,
            operation_none: Optional[pulumi.Input[bool]] = None,
            operation_register: Optional[pulumi.Input[bool]] = None,
            operation_rekey: Optional[pulumi.Input[bool]] = None,
            operation_revoke: Optional[pulumi.Input[bool]] = None,
            path: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            scope: Optional[pulumi.Input[str]] = None,
            tls_client_key_bits: Optional[pulumi.Input[int]] = None,
            tls_client_key_type: Optional[pulumi.Input[str]] = None,
            tls_client_ttl: Optional[pulumi.Input[int]] = None) -> 'SecretRole':
        """
        Get an existing SecretRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[bool] operation_activate: Grant permission to use the KMIP Activate operation.
        :param pulumi.Input[bool] operation_add_attribute: Grant permission to use the KMIP Add Attribute operation.
        :param pulumi.Input[bool] operation_all: Grant all permissions to this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_create: Grant permission to use the KMIP Create operation.
        :param pulumi.Input[bool] operation_destroy: Grant permission to use the KMIP Destroy operation.
        :param pulumi.Input[bool] operation_discover_versions: Grant permission to use the KMIP Discover Version operation.
        :param pulumi.Input[bool] operation_get: Grant permission to use the KMIP Get operation.
        :param pulumi.Input[bool] operation_get_attribute_list: Grant permission to use the KMIP Get Atrribute List operation.
        :param pulumi.Input[bool] operation_get_attributes: Grant permission to use the KMIP Get Atrributes operation.
        :param pulumi.Input[bool] operation_locate: Grant permission to use the KMIP Get Locate operation.
        :param pulumi.Input[bool] operation_none: Remove all permissions from this role. May not be specified with any other `operation_*` params.
        :param pulumi.Input[bool] operation_register: Grant permission to use the KMIP Register operation.
        :param pulumi.Input[bool] operation_rekey: Grant permission to use the KMIP Rekey operation.
        :param pulumi.Input[bool] operation_revoke: Grant permission to use the KMIP Revoke operation.
        :param pulumi.Input[str] path: The unique path this backend should be mounted at. Must
               not begin or end with a `/`. Defaults to `kmip`.
        :param pulumi.Input[str] role: Name of the role.
        :param pulumi.Input[str] scope: Name of the scope.
        :param pulumi.Input[int] tls_client_key_bits: Client certificate key bits, valid values depend on key type.
        :param pulumi.Input[str] tls_client_key_type: Client certificate key type, `rsa` or `ec`.
        :param pulumi.Input[int] tls_client_ttl: Client certificate TTL in seconds.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretRoleState.__new__(_SecretRoleState)

        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["operation_activate"] = operation_activate
        __props__.__dict__["operation_add_attribute"] = operation_add_attribute
        __props__.__dict__["operation_all"] = operation_all
        __props__.__dict__["operation_create"] = operation_create
        __props__.__dict__["operation_destroy"] = operation_destroy
        __props__.__dict__["operation_discover_versions"] = operation_discover_versions
        __props__.__dict__["operation_get"] = operation_get
        __props__.__dict__["operation_get_attribute_list"] = operation_get_attribute_list
        __props__.__dict__["operation_get_attributes"] = operation_get_attributes
        __props__.__dict__["operation_locate"] = operation_locate
        __props__.__dict__["operation_none"] = operation_none
        __props__.__dict__["operation_register"] = operation_register
        __props__.__dict__["operation_rekey"] = operation_rekey
        __props__.__dict__["operation_revoke"] = operation_revoke
        __props__.__dict__["path"] = path
        __props__.__dict__["role"] = role
        __props__.__dict__["scope"] = scope
        __props__.__dict__["tls_client_key_bits"] = tls_client_key_bits
        __props__.__dict__["tls_client_key_type"] = tls_client_key_type
        __props__.__dict__["tls_client_ttl"] = tls_client_ttl
        return SecretRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="operationActivate")
    def operation_activate(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Activate operation.
        """
        return pulumi.get(self, "operation_activate")

    @property
    @pulumi.getter(name="operationAddAttribute")
    def operation_add_attribute(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Add Attribute operation.
        """
        return pulumi.get(self, "operation_add_attribute")

    @property
    @pulumi.getter(name="operationAll")
    def operation_all(self) -> pulumi.Output[bool]:
        """
        Grant all permissions to this role. May not be specified with any other `operation_*` params.
        """
        return pulumi.get(self, "operation_all")

    @property
    @pulumi.getter(name="operationCreate")
    def operation_create(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Create operation.
        """
        return pulumi.get(self, "operation_create")

    @property
    @pulumi.getter(name="operationDestroy")
    def operation_destroy(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Destroy operation.
        """
        return pulumi.get(self, "operation_destroy")

    @property
    @pulumi.getter(name="operationDiscoverVersions")
    def operation_discover_versions(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Discover Version operation.
        """
        return pulumi.get(self, "operation_discover_versions")

    @property
    @pulumi.getter(name="operationGet")
    def operation_get(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Get operation.
        """
        return pulumi.get(self, "operation_get")

    @property
    @pulumi.getter(name="operationGetAttributeList")
    def operation_get_attribute_list(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Get Atrribute List operation.
        """
        return pulumi.get(self, "operation_get_attribute_list")

    @property
    @pulumi.getter(name="operationGetAttributes")
    def operation_get_attributes(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Get Atrributes operation.
        """
        return pulumi.get(self, "operation_get_attributes")

    @property
    @pulumi.getter(name="operationLocate")
    def operation_locate(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Get Locate operation.
        """
        return pulumi.get(self, "operation_locate")

    @property
    @pulumi.getter(name="operationNone")
    def operation_none(self) -> pulumi.Output[bool]:
        """
        Remove all permissions from this role. May not be specified with any other `operation_*` params.
        """
        return pulumi.get(self, "operation_none")

    @property
    @pulumi.getter(name="operationRegister")
    def operation_register(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Register operation.
        """
        return pulumi.get(self, "operation_register")

    @property
    @pulumi.getter(name="operationRekey")
    def operation_rekey(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Rekey operation.
        """
        return pulumi.get(self, "operation_rekey")

    @property
    @pulumi.getter(name="operationRevoke")
    def operation_revoke(self) -> pulumi.Output[bool]:
        """
        Grant permission to use the KMIP Revoke operation.
        """
        return pulumi.get(self, "operation_revoke")

    @property
    @pulumi.getter
    def path(self) -> pulumi.Output[str]:
        """
        The unique path this backend should be mounted at. Must
        not begin or end with a `/`. Defaults to `kmip`.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Output[str]:
        """
        Name of the scope.
        """
        return pulumi.get(self, "scope")

    @property
    @pulumi.getter(name="tlsClientKeyBits")
    def tls_client_key_bits(self) -> pulumi.Output[Optional[int]]:
        """
        Client certificate key bits, valid values depend on key type.
        """
        return pulumi.get(self, "tls_client_key_bits")

    @property
    @pulumi.getter(name="tlsClientKeyType")
    def tls_client_key_type(self) -> pulumi.Output[Optional[str]]:
        """
        Client certificate key type, `rsa` or `ec`.
        """
        return pulumi.get(self, "tls_client_key_type")

    @property
    @pulumi.getter(name="tlsClientTtl")
    def tls_client_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        Client certificate TTL in seconds.
        """
        return pulumi.get(self, "tls_client_ttl")

