# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AuthBackendRoleArgs', 'AuthBackendRole']

@pulumi.input_type
class AuthBackendRoleArgs:
    def __init__(__self__, *,
                 bound_service_account_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 bound_service_account_namespaces: pulumi.Input[Sequence[pulumi.Input[str]]],
                 role_name: pulumi.Input[str],
                 alias_name_source: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AuthBackendRole resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_names: List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_namespaces: List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[str] alias_name_source: Configures how identity aliases are generated.
               Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        :param pulumi.Input[str] audience: Audience claim to verify in the JWT.
        :param pulumi.Input[str] backend: Unique name of the kubernetes backend to configure.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: List of CIDR blocks; if set, specifies blocks of IP
               addresses which can authenticate successfully, and ties the resulting token to these blocks
               as well.
        :param pulumi.Input[int] token_explicit_max_ttl: If set, will encode an
               [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
               onto the token in number of seconds. This is a hard cap even if `token_ttl` and
               `token_max_ttl` would otherwise allow a renewal.
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[bool] token_no_default_policy: If set, the default policy will not be set on
               generated tokens; otherwise it will be added to the policies set in token_policies.
        :param pulumi.Input[int] token_num_uses: The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
               of times a generated token may be used (within its lifetime); 0 means unlimited.
        :param pulumi.Input[int] token_period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: List of policies to encode onto generated tokens. Depending
               on the auth method, this list may be supplemented by user/group/other values.
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token that should be generated. Can be `service`,
               `batch`, or `default` to use the mount's tuned default (which unless changed will be
               `service` tokens). For token store roles, there are two additional possibilities:
               `default-service` and `default-batch` which specify the type to return unless the client
               requests a different type at generation time.
        """
        pulumi.set(__self__, "bound_service_account_names", bound_service_account_names)
        pulumi.set(__self__, "bound_service_account_namespaces", bound_service_account_namespaces)
        pulumi.set(__self__, "role_name", role_name)
        if alias_name_source is not None:
            pulumi.set(__self__, "alias_name_source", alias_name_source)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter(name="boundServiceAccountNames")
    def bound_service_account_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        """
        return pulumi.get(self, "bound_service_account_names")

    @bound_service_account_names.setter
    def bound_service_account_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "bound_service_account_names", value)

    @property
    @pulumi.getter(name="boundServiceAccountNamespaces")
    def bound_service_account_namespaces(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        """
        return pulumi.get(self, "bound_service_account_namespaces")

    @bound_service_account_namespaces.setter
    def bound_service_account_namespaces(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "bound_service_account_namespaces", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Input[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="aliasNameSource")
    def alias_name_source(self) -> Optional[pulumi.Input[str]]:
        """
        Configures how identity aliases are generated.
        Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        """
        return pulumi.get(self, "alias_name_source")

    @alias_name_source.setter
    def alias_name_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias_name_source", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Audience claim to verify in the JWT.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the kubernetes backend to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of CIDR blocks; if set, specifies blocks of IP
        addresses which can authenticate successfully, and ties the resulting token to these blocks
        as well.
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        If set, will encode an
        [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
        onto the token in number of seconds. This is a hard cap even if `token_ttl` and
        `token_max_ttl` would otherwise allow a renewal.
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum lifetime for generated tokens in number of seconds.
        Its current value will be referenced at renewal time.
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, the default policy will not be set on
        generated tokens; otherwise it will be added to the policies set in token_policies.
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[int]]:
        """
        The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
        of times a generated token may be used (within its lifetime); 0 means unlimited.
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_num_uses", value)

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[int]]:
        """
        If set, indicates that the
        token generated using this role should never expire. The token should be renewed within the
        duration specified by this value. At each renewal, the token's TTL will be set to the
        value of this field. Specified in seconds.
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_period", value)

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policies to encode onto generated tokens. Depending
        on the auth method, this list may be supplemented by user/group/other values.
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_policies", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_ttl", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of token that should be generated. Can be `service`,
        `batch`, or `default` to use the mount's tuned default (which unless changed will be
        `service` tokens). For token store roles, there are two additional possibilities:
        `default-service` and `default-batch` which specify the type to return unless the client
        requests a different type at generation time.
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_type", value)


@pulumi.input_type
class _AuthBackendRoleState:
    def __init__(__self__, *,
                 alias_name_source: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 bound_service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_service_account_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AuthBackendRole resources.
        :param pulumi.Input[str] alias_name_source: Configures how identity aliases are generated.
               Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        :param pulumi.Input[str] audience: Audience claim to verify in the JWT.
        :param pulumi.Input[str] backend: Unique name of the kubernetes backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_names: List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_namespaces: List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: List of CIDR blocks; if set, specifies blocks of IP
               addresses which can authenticate successfully, and ties the resulting token to these blocks
               as well.
        :param pulumi.Input[int] token_explicit_max_ttl: If set, will encode an
               [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
               onto the token in number of seconds. This is a hard cap even if `token_ttl` and
               `token_max_ttl` would otherwise allow a renewal.
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[bool] token_no_default_policy: If set, the default policy will not be set on
               generated tokens; otherwise it will be added to the policies set in token_policies.
        :param pulumi.Input[int] token_num_uses: The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
               of times a generated token may be used (within its lifetime); 0 means unlimited.
        :param pulumi.Input[int] token_period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: List of policies to encode onto generated tokens. Depending
               on the auth method, this list may be supplemented by user/group/other values.
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token that should be generated. Can be `service`,
               `batch`, or `default` to use the mount's tuned default (which unless changed will be
               `service` tokens). For token store roles, there are two additional possibilities:
               `default-service` and `default-batch` which specify the type to return unless the client
               requests a different type at generation time.
        """
        if alias_name_source is not None:
            pulumi.set(__self__, "alias_name_source", alias_name_source)
        if audience is not None:
            pulumi.set(__self__, "audience", audience)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if bound_service_account_names is not None:
            pulumi.set(__self__, "bound_service_account_names", bound_service_account_names)
        if bound_service_account_namespaces is not None:
            pulumi.set(__self__, "bound_service_account_namespaces", bound_service_account_namespaces)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if role_name is not None:
            pulumi.set(__self__, "role_name", role_name)
        if token_bound_cidrs is not None:
            pulumi.set(__self__, "token_bound_cidrs", token_bound_cidrs)
        if token_explicit_max_ttl is not None:
            pulumi.set(__self__, "token_explicit_max_ttl", token_explicit_max_ttl)
        if token_max_ttl is not None:
            pulumi.set(__self__, "token_max_ttl", token_max_ttl)
        if token_no_default_policy is not None:
            pulumi.set(__self__, "token_no_default_policy", token_no_default_policy)
        if token_num_uses is not None:
            pulumi.set(__self__, "token_num_uses", token_num_uses)
        if token_period is not None:
            pulumi.set(__self__, "token_period", token_period)
        if token_policies is not None:
            pulumi.set(__self__, "token_policies", token_policies)
        if token_ttl is not None:
            pulumi.set(__self__, "token_ttl", token_ttl)
        if token_type is not None:
            pulumi.set(__self__, "token_type", token_type)

    @property
    @pulumi.getter(name="aliasNameSource")
    def alias_name_source(self) -> Optional[pulumi.Input[str]]:
        """
        Configures how identity aliases are generated.
        Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        """
        return pulumi.get(self, "alias_name_source")

    @alias_name_source.setter
    def alias_name_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alias_name_source", value)

    @property
    @pulumi.getter
    def audience(self) -> Optional[pulumi.Input[str]]:
        """
        Audience claim to verify in the JWT.
        """
        return pulumi.get(self, "audience")

    @audience.setter
    def audience(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "audience", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the kubernetes backend to configure.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="boundServiceAccountNames")
    def bound_service_account_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        """
        return pulumi.get(self, "bound_service_account_names")

    @bound_service_account_names.setter
    def bound_service_account_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bound_service_account_names", value)

    @property
    @pulumi.getter(name="boundServiceAccountNamespaces")
    def bound_service_account_namespaces(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        """
        return pulumi.get(self, "bound_service_account_namespaces")

    @bound_service_account_namespaces.setter
    def bound_service_account_namespaces(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "bound_service_account_namespaces", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @role_name.setter
    def role_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role_name", value)

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of CIDR blocks; if set, specifies blocks of IP
        addresses which can authenticate successfully, and ties the resulting token to these blocks
        as well.
        """
        return pulumi.get(self, "token_bound_cidrs")

    @token_bound_cidrs.setter
    def token_bound_cidrs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_bound_cidrs", value)

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        If set, will encode an
        [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
        onto the token in number of seconds. This is a hard cap even if `token_ttl` and
        `token_max_ttl` would otherwise allow a renewal.
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @token_explicit_max_ttl.setter
    def token_explicit_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_explicit_max_ttl", value)

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum lifetime for generated tokens in number of seconds.
        Its current value will be referenced at renewal time.
        """
        return pulumi.get(self, "token_max_ttl")

    @token_max_ttl.setter
    def token_max_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_max_ttl", value)

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, the default policy will not be set on
        generated tokens; otherwise it will be added to the policies set in token_policies.
        """
        return pulumi.get(self, "token_no_default_policy")

    @token_no_default_policy.setter
    def token_no_default_policy(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "token_no_default_policy", value)

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> Optional[pulumi.Input[int]]:
        """
        The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
        of times a generated token may be used (within its lifetime); 0 means unlimited.
        """
        return pulumi.get(self, "token_num_uses")

    @token_num_uses.setter
    def token_num_uses(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_num_uses", value)

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> Optional[pulumi.Input[int]]:
        """
        If set, indicates that the
        token generated using this role should never expire. The token should be renewed within the
        duration specified by this value. At each renewal, the token's TTL will be set to the
        value of this field. Specified in seconds.
        """
        return pulumi.get(self, "token_period")

    @token_period.setter
    def token_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_period", value)

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of policies to encode onto generated tokens. Depending
        on the auth method, this list may be supplemented by user/group/other values.
        """
        return pulumi.get(self, "token_policies")

    @token_policies.setter
    def token_policies(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "token_policies", value)

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> Optional[pulumi.Input[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @token_ttl.setter
    def token_ttl(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "token_ttl", value)

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of token that should be generated. Can be `service`,
        `batch`, or `default` to use the mount's tuned default (which unless changed will be
        `service` tokens). For token store roles, there are two additional possibilities:
        `default-service` and `default-batch` which specify the type to return unless the client
        requests a different type at generation time.
        """
        return pulumi.get(self, "token_type")

    @token_type.setter
    def token_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token_type", value)


class AuthBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_name_source: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 bound_service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_service_account_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Manages an Kubernetes auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/kubernetes.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        kubernetes = vault.AuthBackend("kubernetes", type="kubernetes")
        example = vault.kubernetes.AuthBackendRole("example",
            backend=kubernetes.path,
            role_name="example-role",
            bound_service_account_names=["example"],
            bound_service_account_namespaces=["example"],
            token_ttl=3600,
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            audience="vault")
        ```

        ## Import

        Kubernetes auth backend role can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:kubernetes/authBackendRole:AuthBackendRole foo auth/kubernetes/role/foo
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias_name_source: Configures how identity aliases are generated.
               Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        :param pulumi.Input[str] audience: Audience claim to verify in the JWT.
        :param pulumi.Input[str] backend: Unique name of the kubernetes backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_names: List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_namespaces: List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: List of CIDR blocks; if set, specifies blocks of IP
               addresses which can authenticate successfully, and ties the resulting token to these blocks
               as well.
        :param pulumi.Input[int] token_explicit_max_ttl: If set, will encode an
               [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
               onto the token in number of seconds. This is a hard cap even if `token_ttl` and
               `token_max_ttl` would otherwise allow a renewal.
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[bool] token_no_default_policy: If set, the default policy will not be set on
               generated tokens; otherwise it will be added to the policies set in token_policies.
        :param pulumi.Input[int] token_num_uses: The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
               of times a generated token may be used (within its lifetime); 0 means unlimited.
        :param pulumi.Input[int] token_period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: List of policies to encode onto generated tokens. Depending
               on the auth method, this list may be supplemented by user/group/other values.
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token that should be generated. Can be `service`,
               `batch`, or `default` to use the mount's tuned default (which unless changed will be
               `service` tokens). For token store roles, there are two additional possibilities:
               `default-service` and `default-batch` which specify the type to return unless the client
               requests a different type at generation time.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AuthBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manages an Kubernetes auth backend role in a Vault server. See the [Vault
        documentation](https://www.vaultproject.io/docs/auth/kubernetes.html) for more
        information.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        kubernetes = vault.AuthBackend("kubernetes", type="kubernetes")
        example = vault.kubernetes.AuthBackendRole("example",
            backend=kubernetes.path,
            role_name="example-role",
            bound_service_account_names=["example"],
            bound_service_account_namespaces=["example"],
            token_ttl=3600,
            token_policies=[
                "default",
                "dev",
                "prod",
            ],
            audience="vault")
        ```

        ## Import

        Kubernetes auth backend role can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:kubernetes/authBackendRole:AuthBackendRole foo auth/kubernetes/role/foo
        ```

        :param str resource_name: The name of the resource.
        :param AuthBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AuthBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alias_name_source: Optional[pulumi.Input[str]] = None,
                 audience: Optional[pulumi.Input[str]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 bound_service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 bound_service_account_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 role_name: Optional[pulumi.Input[str]] = None,
                 token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_max_ttl: Optional[pulumi.Input[int]] = None,
                 token_no_default_policy: Optional[pulumi.Input[bool]] = None,
                 token_num_uses: Optional[pulumi.Input[int]] = None,
                 token_period: Optional[pulumi.Input[int]] = None,
                 token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 token_ttl: Optional[pulumi.Input[int]] = None,
                 token_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AuthBackendRoleArgs.__new__(AuthBackendRoleArgs)

            __props__.__dict__["alias_name_source"] = alias_name_source
            __props__.__dict__["audience"] = audience
            __props__.__dict__["backend"] = backend
            if bound_service_account_names is None and not opts.urn:
                raise TypeError("Missing required property 'bound_service_account_names'")
            __props__.__dict__["bound_service_account_names"] = bound_service_account_names
            if bound_service_account_namespaces is None and not opts.urn:
                raise TypeError("Missing required property 'bound_service_account_namespaces'")
            __props__.__dict__["bound_service_account_namespaces"] = bound_service_account_namespaces
            __props__.__dict__["namespace"] = namespace
            if role_name is None and not opts.urn:
                raise TypeError("Missing required property 'role_name'")
            __props__.__dict__["role_name"] = role_name
            __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
            __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
            __props__.__dict__["token_max_ttl"] = token_max_ttl
            __props__.__dict__["token_no_default_policy"] = token_no_default_policy
            __props__.__dict__["token_num_uses"] = token_num_uses
            __props__.__dict__["token_period"] = token_period
            __props__.__dict__["token_policies"] = token_policies
            __props__.__dict__["token_ttl"] = token_ttl
            __props__.__dict__["token_type"] = token_type
        super(AuthBackendRole, __self__).__init__(
            'vault:kubernetes/authBackendRole:AuthBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alias_name_source: Optional[pulumi.Input[str]] = None,
            audience: Optional[pulumi.Input[str]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            bound_service_account_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            bound_service_account_namespaces: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            role_name: Optional[pulumi.Input[str]] = None,
            token_bound_cidrs: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_explicit_max_ttl: Optional[pulumi.Input[int]] = None,
            token_max_ttl: Optional[pulumi.Input[int]] = None,
            token_no_default_policy: Optional[pulumi.Input[bool]] = None,
            token_num_uses: Optional[pulumi.Input[int]] = None,
            token_period: Optional[pulumi.Input[int]] = None,
            token_policies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            token_ttl: Optional[pulumi.Input[int]] = None,
            token_type: Optional[pulumi.Input[str]] = None) -> 'AuthBackendRole':
        """
        Get an existing AuthBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alias_name_source: Configures how identity aliases are generated.
               Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        :param pulumi.Input[str] audience: Audience claim to verify in the JWT.
        :param pulumi.Input[str] backend: Unique name of the kubernetes backend to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_names: List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] bound_service_account_namespaces: List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] role_name: Name of the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_bound_cidrs: List of CIDR blocks; if set, specifies blocks of IP
               addresses which can authenticate successfully, and ties the resulting token to these blocks
               as well.
        :param pulumi.Input[int] token_explicit_max_ttl: If set, will encode an
               [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
               onto the token in number of seconds. This is a hard cap even if `token_ttl` and
               `token_max_ttl` would otherwise allow a renewal.
        :param pulumi.Input[int] token_max_ttl: The maximum lifetime for generated tokens in number of seconds.
               Its current value will be referenced at renewal time.
        :param pulumi.Input[bool] token_no_default_policy: If set, the default policy will not be set on
               generated tokens; otherwise it will be added to the policies set in token_policies.
        :param pulumi.Input[int] token_num_uses: The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
               of times a generated token may be used (within its lifetime); 0 means unlimited.
        :param pulumi.Input[int] token_period: If set, indicates that the
               token generated using this role should never expire. The token should be renewed within the
               duration specified by this value. At each renewal, the token's TTL will be set to the
               value of this field. Specified in seconds.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] token_policies: List of policies to encode onto generated tokens. Depending
               on the auth method, this list may be supplemented by user/group/other values.
        :param pulumi.Input[int] token_ttl: The initial ttl of the token to generate in seconds
        :param pulumi.Input[str] token_type: The type of token that should be generated. Can be `service`,
               `batch`, or `default` to use the mount's tuned default (which unless changed will be
               `service` tokens). For token store roles, there are two additional possibilities:
               `default-service` and `default-batch` which specify the type to return unless the client
               requests a different type at generation time.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AuthBackendRoleState.__new__(_AuthBackendRoleState)

        __props__.__dict__["alias_name_source"] = alias_name_source
        __props__.__dict__["audience"] = audience
        __props__.__dict__["backend"] = backend
        __props__.__dict__["bound_service_account_names"] = bound_service_account_names
        __props__.__dict__["bound_service_account_namespaces"] = bound_service_account_namespaces
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["role_name"] = role_name
        __props__.__dict__["token_bound_cidrs"] = token_bound_cidrs
        __props__.__dict__["token_explicit_max_ttl"] = token_explicit_max_ttl
        __props__.__dict__["token_max_ttl"] = token_max_ttl
        __props__.__dict__["token_no_default_policy"] = token_no_default_policy
        __props__.__dict__["token_num_uses"] = token_num_uses
        __props__.__dict__["token_period"] = token_period
        __props__.__dict__["token_policies"] = token_policies
        __props__.__dict__["token_ttl"] = token_ttl
        __props__.__dict__["token_type"] = token_type
        return AuthBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="aliasNameSource")
    def alias_name_source(self) -> pulumi.Output[str]:
        """
        Configures how identity aliases are generated.
        Valid choices are: `serviceaccount_uid`, `serviceaccount_name`. (vault-1.9+)
        """
        return pulumi.get(self, "alias_name_source")

    @property
    @pulumi.getter
    def audience(self) -> pulumi.Output[Optional[str]]:
        """
        Audience claim to verify in the JWT.
        """
        return pulumi.get(self, "audience")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[Optional[str]]:
        """
        Unique name of the kubernetes backend to configure.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="boundServiceAccountNames")
    def bound_service_account_names(self) -> pulumi.Output[Sequence[str]]:
        """
        List of service account names able to access this role. If set to `["*"]` all names are allowed, both this and bound_service_account_namespaces can not be "*".
        """
        return pulumi.get(self, "bound_service_account_names")

    @property
    @pulumi.getter(name="boundServiceAccountNamespaces")
    def bound_service_account_namespaces(self) -> pulumi.Output[Sequence[str]]:
        """
        List of namespaces allowed to access this role. If set to `["*"]` all namespaces are allowed, both this and bound_service_account_names can not be set to "*".
        """
        return pulumi.get(self, "bound_service_account_namespaces")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="roleName")
    def role_name(self) -> pulumi.Output[str]:
        """
        Name of the role.
        """
        return pulumi.get(self, "role_name")

    @property
    @pulumi.getter(name="tokenBoundCidrs")
    def token_bound_cidrs(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of CIDR blocks; if set, specifies blocks of IP
        addresses which can authenticate successfully, and ties the resulting token to these blocks
        as well.
        """
        return pulumi.get(self, "token_bound_cidrs")

    @property
    @pulumi.getter(name="tokenExplicitMaxTtl")
    def token_explicit_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        If set, will encode an
        [explicit max TTL](https://www.vaultproject.io/docs/concepts/tokens.html#token-time-to-live-periodic-tokens-and-explicit-max-ttls)
        onto the token in number of seconds. This is a hard cap even if `token_ttl` and
        `token_max_ttl` would otherwise allow a renewal.
        """
        return pulumi.get(self, "token_explicit_max_ttl")

    @property
    @pulumi.getter(name="tokenMaxTtl")
    def token_max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum lifetime for generated tokens in number of seconds.
        Its current value will be referenced at renewal time.
        """
        return pulumi.get(self, "token_max_ttl")

    @property
    @pulumi.getter(name="tokenNoDefaultPolicy")
    def token_no_default_policy(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, the default policy will not be set on
        generated tokens; otherwise it will be added to the policies set in token_policies.
        """
        return pulumi.get(self, "token_no_default_policy")

    @property
    @pulumi.getter(name="tokenNumUses")
    def token_num_uses(self) -> pulumi.Output[Optional[int]]:
        """
        The [maximum number](https://www.vaultproject.io/api-docs/kubernetes#token_num_uses)
        of times a generated token may be used (within its lifetime); 0 means unlimited.
        """
        return pulumi.get(self, "token_num_uses")

    @property
    @pulumi.getter(name="tokenPeriod")
    def token_period(self) -> pulumi.Output[Optional[int]]:
        """
        If set, indicates that the
        token generated using this role should never expire. The token should be renewed within the
        duration specified by this value. At each renewal, the token's TTL will be set to the
        value of this field. Specified in seconds.
        """
        return pulumi.get(self, "token_period")

    @property
    @pulumi.getter(name="tokenPolicies")
    def token_policies(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of policies to encode onto generated tokens. Depending
        on the auth method, this list may be supplemented by user/group/other values.
        """
        return pulumi.get(self, "token_policies")

    @property
    @pulumi.getter(name="tokenTtl")
    def token_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The initial ttl of the token to generate in seconds
        """
        return pulumi.get(self, "token_ttl")

    @property
    @pulumi.getter(name="tokenType")
    def token_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of token that should be generated. Can be `service`,
        `batch`, or `default` to use the mount's tuned default (which unless changed will be
        `service` tokens). For token store roles, there are two additional possibilities:
        `default-service` and `default-batch` which specify the type to return unless the client
        requests a different type at generation time.
        """
        return pulumi.get(self, "token_type")

