# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['KeysArgs', 'Keys']

@pulumi.input_type
class KeysArgs:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 pkcs: Optional[pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]]] = None):
        """
        The set of arguments for constructing a Keys resource.
        :param pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]] aws: Configuration block for AWS Managed Keys
        :param pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]] azures: Configuration block for Azure Managed Keys
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]] pkcs: Configuration block for PKCS Managed Keys
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azures is not None:
            pulumi.set(__self__, "azures", azures)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if pkcs is not None:
            pulumi.set(__self__, "pkcs", pkcs)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]]]:
        """
        Configuration block for AWS Managed Keys
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]]]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]]]:
        """
        Configuration block for Azure Managed Keys
        """
        return pulumi.get(self, "azures")

    @azures.setter
    def azures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]]]):
        pulumi.set(self, "azures", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def pkcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]]]:
        """
        Configuration block for PKCS Managed Keys
        """
        return pulumi.get(self, "pkcs")

    @pkcs.setter
    def pkcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]]]):
        pulumi.set(self, "pkcs", value)


@pulumi.input_type
class _KeysState:
    def __init__(__self__, *,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 pkcs: Optional[pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]]] = None):
        """
        Input properties used for looking up and filtering Keys resources.
        :param pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]] aws: Configuration block for AWS Managed Keys
        :param pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]] azures: Configuration block for Azure Managed Keys
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]] pkcs: Configuration block for PKCS Managed Keys
        """
        if aws is not None:
            pulumi.set(__self__, "aws", aws)
        if azures is not None:
            pulumi.set(__self__, "azures", azures)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if pkcs is not None:
            pulumi.set(__self__, "pkcs", pkcs)

    @property
    @pulumi.getter
    def aws(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]]]:
        """
        Configuration block for AWS Managed Keys
        """
        return pulumi.get(self, "aws")

    @aws.setter
    def aws(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAwArgs']]]]):
        pulumi.set(self, "aws", value)

    @property
    @pulumi.getter
    def azures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]]]:
        """
        Configuration block for Azure Managed Keys
        """
        return pulumi.get(self, "azures")

    @azures.setter
    def azures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeysAzureArgs']]]]):
        pulumi.set(self, "azures", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def pkcs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]]]:
        """
        Configuration block for PKCS Managed Keys
        """
        return pulumi.get(self, "pkcs")

    @pkcs.setter
    def pkcs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['KeysPkcArgs']]]]):
        pulumi.set(self, "pkcs", value)


class Keys(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAwArgs']]]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAzureArgs']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 pkcs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysPkcArgs']]]]] = None,
                 __props__=None):
        """
        ## Import

        Mounts can be imported using the `id` of `default`, e.g.

        ```sh
         $ pulumi import vault:managed/keys:Keys keys default
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAwArgs']]]] aws: Configuration block for AWS Managed Keys
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAzureArgs']]]] azures: Configuration block for Azure Managed Keys
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysPkcArgs']]]] pkcs: Configuration block for PKCS Managed Keys
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[KeysArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        Mounts can be imported using the `id` of `default`, e.g.

        ```sh
         $ pulumi import vault:managed/keys:Keys keys default
        ```

        :param str resource_name: The name of the resource.
        :param KeysArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KeysArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 aws: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAwArgs']]]]] = None,
                 azures: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAzureArgs']]]]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 pkcs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysPkcArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KeysArgs.__new__(KeysArgs)

            __props__.__dict__["aws"] = aws
            __props__.__dict__["azures"] = azures
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["pkcs"] = pkcs
        super(Keys, __self__).__init__(
            'vault:managed/keys:Keys',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            aws: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAwArgs']]]]] = None,
            azures: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAzureArgs']]]]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            pkcs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysPkcArgs']]]]] = None) -> 'Keys':
        """
        Get an existing Keys resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAwArgs']]]] aws: Configuration block for AWS Managed Keys
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysAzureArgs']]]] azures: Configuration block for Azure Managed Keys
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured namespace.
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['KeysPkcArgs']]]] pkcs: Configuration block for PKCS Managed Keys
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KeysState.__new__(_KeysState)

        __props__.__dict__["aws"] = aws
        __props__.__dict__["azures"] = azures
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["pkcs"] = pkcs
        return Keys(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def aws(self) -> pulumi.Output[Optional[Sequence['outputs.KeysAw']]]:
        """
        Configuration block for AWS Managed Keys
        """
        return pulumi.get(self, "aws")

    @property
    @pulumi.getter
    def azures(self) -> pulumi.Output[Optional[Sequence['outputs.KeysAzure']]]:
        """
        Configuration block for Azure Managed Keys
        """
        return pulumi.get(self, "azures")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured namespace.
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def pkcs(self) -> pulumi.Output[Optional[Sequence['outputs.KeysPkc']]]:
        """
        Configuration block for PKCS Managed Keys
        """
        return pulumi.get(self, "pkcs")

