# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SecretBackendSignArgs', 'SecretBackendSign']

@pulumi.input_type
class SecretBackendSignArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 common_name: pulumi.Input[str],
                 csr: pulumi.Input[str],
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        The set of arguments for constructing a SecretBackendSign resource.
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of certificate to create
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[str] name: Name of the role to create the certificate against
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "common_name", common_name)
        pulumi.set(__self__, "csr", csr)
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if min_seconds_remaining is not None:
            pulumi.set(__self__, "min_seconds_remaining", min_seconds_remaining)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Input[str]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Input[str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: pulumi.Input[str]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alt_names", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_sans", value)

    @property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> Optional[pulumi.Input[int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @min_seconds_remaining.setter
    def min_seconds_remaining(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_seconds_remaining", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "other_sans", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uri_sans", value)


@pulumi.input_type
class _SecretBackendSignState:
    def __init__(__self__, *,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 ca_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 certificate: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 expiration: Optional[pulumi.Input[int]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 issuing_ca: Optional[pulumi.Input[str]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 renew_pending: Optional[pulumi.Input[bool]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 serial_number: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering SecretBackendSign resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_chains: The CA chain
        :param pulumi.Input[str] certificate: The certificate
        :param pulumi.Input[str] common_name: CN of certificate to create
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[int] expiration: The expiration date of the certificate in unix epoch format
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[str] issuing_ca: The issuing CA
        :param pulumi.Input[int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[str] name: Name of the role to create the certificate against
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[bool] renew_pending: `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        :param pulumi.Input[str] serial: The serial number.
        :param pulumi.Input[str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        if alt_names is not None:
            pulumi.set(__self__, "alt_names", alt_names)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if ca_chains is not None:
            pulumi.set(__self__, "ca_chains", ca_chains)
        if certificate is not None:
            pulumi.set(__self__, "certificate", certificate)
        if common_name is not None:
            pulumi.set(__self__, "common_name", common_name)
        if csr is not None:
            pulumi.set(__self__, "csr", csr)
        if exclude_cn_from_sans is not None:
            pulumi.set(__self__, "exclude_cn_from_sans", exclude_cn_from_sans)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if format is not None:
            pulumi.set(__self__, "format", format)
        if ip_sans is not None:
            pulumi.set(__self__, "ip_sans", ip_sans)
        if issuing_ca is not None:
            pulumi.set(__self__, "issuing_ca", issuing_ca)
        if min_seconds_remaining is not None:
            pulumi.set(__self__, "min_seconds_remaining", min_seconds_remaining)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if other_sans is not None:
            pulumi.set(__self__, "other_sans", other_sans)
        if renew_pending is not None:
            pulumi.set(__self__, "renew_pending", renew_pending)
        if serial is not None:
            warnings.warn("""Use serial_number instead""", DeprecationWarning)
            pulumi.log.warn("""serial is deprecated: Use serial_number instead""")
        if serial is not None:
            pulumi.set(__self__, "serial", serial)
        if serial_number is not None:
            pulumi.set(__self__, "serial_number", serial_number)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)
        if uri_sans is not None:
            pulumi.set(__self__, "uri_sans", uri_sans)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @alt_names.setter
    def alt_names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "alt_names", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The CA chain
        """
        return pulumi.get(self, "ca_chains")

    @ca_chains.setter
    def ca_chains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ca_chains", value)

    @property
    @pulumi.getter
    def certificate(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate
        """
        return pulumi.get(self, "certificate")

    @certificate.setter
    def certificate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "certificate", value)

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> Optional[pulumi.Input[str]]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @common_name.setter
    def common_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "common_name", value)

    @property
    @pulumi.getter
    def csr(self) -> Optional[pulumi.Input[str]]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @csr.setter
    def csr(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "csr", value)

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> Optional[pulumi.Input[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @exclude_cn_from_sans.setter
    def exclude_cn_from_sans(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "exclude_cn_from_sans", value)

    @property
    @pulumi.getter
    def expiration(self) -> Optional[pulumi.Input[int]]:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @expiration.setter
    def expiration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "expiration", value)

    @property
    @pulumi.getter
    def format(self) -> Optional[pulumi.Input[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @ip_sans.setter
    def ip_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ip_sans", value)

    @property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> Optional[pulumi.Input[str]]:
        """
        The issuing CA
        """
        return pulumi.get(self, "issuing_ca")

    @issuing_ca.setter
    def issuing_ca(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "issuing_ca", value)

    @property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> Optional[pulumi.Input[int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @min_seconds_remaining.setter
    def min_seconds_remaining(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "min_seconds_remaining", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @other_sans.setter
    def other_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "other_sans", value)

    @property
    @pulumi.getter(name="renewPending")
    def renew_pending(self) -> Optional[pulumi.Input[bool]]:
        """
        `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        """
        return pulumi.get(self, "renew_pending")

    @renew_pending.setter
    def renew_pending(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "renew_pending", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        The serial number.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> Optional[pulumi.Input[str]]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @serial_number.setter
    def serial_number(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial_number", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

    @uri_sans.setter
    def uri_sans(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "uri_sans", value)


class SecretBackendSign(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pki_secret.SecretBackendSign("test",
            backend=vault_mount["pki"]["path"],
            csr=\"\"\"-----BEGIN CERTIFICATE REQUEST-----
        MIIEqDCCApACAQAwYzELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUx
        ITAfBgNVBAoMGEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDEcMBoGA1UEAwwTY2Vy
        dC50ZXN0Lm15LmRvbWFpbjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIB
        AJupYCQ8UVCWII1Zof1c6YcSSaM9hEaDU78cfKP5RoSeH10BvrWRfT+mzCONVpNP
        CW9Iabtvk6hm0ot6ilnndEyVJbc0g7hdDLBX5BM25D+DGZGJRKUz1V+uBrWmXtIt
        Vonj7JTDTe7ViH0GDsB7CvqXFGXO2a2cDYBchLkL6vQiFPshxvUsLtwxuy/qdYgy
        X6ya+AUoZcoQGy1XxNjfH6cPtWSWQGEp1oPR6vL9hU3laTZb3C+VV4jZem+he8/0
        V+qV6fLG92WTXm2hmf8nrtUqqJ+C7mW/RJod+TviviBadIX0OHXW7k5HVsZood01
        te8vMRUNJNiZfa9EMIK5oncbQn0LcM3Wo9VrjpL7jREb/4HCS2gswYGv7hzk9cCS
        kVY4rDucchKbApuI3kfzmO7GFOF5eiSkYZpY/czNn7VVM3WCu6dpOX4+3rhgrZQw
        kY14L930DaLVRUgve/zKVP2D2GHdEOs+MbV7s96UgigT9pXly/yHPj+1sSYqmnaD
        5b7jSeJusmzO/nrwXVGLsnezR87VzHl9Ux9g5s6zh+R+PrZuVxYsLvoUpaasH47O
        gIcBzSb/6pSGZKAUizmYsHsR1k88dAvsQ+FsUDaNokdi9VndEB4QPmiFmjyLV+0I
        1TFoXop4sW11NPz1YCq+IxnYrEaIN3PyhY0GvBJDFY1/AgMBAAGgADANBgkqhkiG
        9w0BAQsFAAOCAgEActuqnqS8Y9UF7e08w7tR3FPzGecWreuvxILrlFEZJxiLPFqL
        It7uJvtypCVQvz6UQzKdBYO7tMpRaWViB8DrWzXNZjLMrg+QHcpveg8C0Ett4scG
        fnvLk6fTDFYrnGvwHTqiHos5i0y3bFLyS1BGwSpdLAykGtvC+VM8mRyw/Y7CPcKN
        77kebY/9xduW1g2uxWLr0x90RuQDv9psPojT+59tRLGSp5Kt0IeD3QtnAZEFE4aN
        vt+Pd69eg3BgZ8ZeDgoqAw3yppvOkpAFiE5pw2qPZaM4SRphl4d2Lek2zNIMyZqv
        do5zh356HOgXtDaSg0POnRGrN/Ua+LMCRTg6GEPUnx9uQb/zt8Zu0hIexDGyykp1
        OGqtWlv/Nc8UYuS38v0BeB6bMPeoqQUjkqs8nHlAEFn0KlgYdtDC+7SdQx6wS4te
        dBKRNDfC4lS3jYJgs55jHqonZgkpSi3bamlxpfpW0ukGBcmq91wRe4bOw/4uD/vf
        UwqMWOdCYcU3mdYNjTWy22ORW3SGFQxMBwpUEURCSoeqWr6aJeQ7KAYkx1PrB5T8
        OTEc13lWf+B0PU9UJuGTsmpIuImPDVd0EVDayr3mT5dDbqTVDbe8ppf2IswABmf0
        o3DybUeUmknYjl109rdSf+76nuREICHatxXgN3xCMFuBaN4WLO+ksd6Y1Ys=
        -----END CERTIFICATE REQUEST-----
        \"\"\",
            common_name="test.my.domain",
            opts=pulumi.ResourceOptions(depends_on=[vault_pki_secret_backend_role["admin"]]))
        ```
        ## Deprecations

        * `serial` - Use `serial_number` instead.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[str] common_name: CN of certificate to create
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[str] name: Name of the role to create the certificate against
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendSignArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        test = vault.pki_secret.SecretBackendSign("test",
            backend=vault_mount["pki"]["path"],
            csr=\"\"\"-----BEGIN CERTIFICATE REQUEST-----
        MIIEqDCCApACAQAwYzELMAkGA1UEBhMCQVUxEzARBgNVBAgMClNvbWUtU3RhdGUx
        ITAfBgNVBAoMGEludGVybmV0IFdpZGdpdHMgUHR5IEx0ZDEcMBoGA1UEAwwTY2Vy
        dC50ZXN0Lm15LmRvbWFpbjCCAiIwDQYJKoZIhvcNAQEBBQADggIPADCCAgoCggIB
        AJupYCQ8UVCWII1Zof1c6YcSSaM9hEaDU78cfKP5RoSeH10BvrWRfT+mzCONVpNP
        CW9Iabtvk6hm0ot6ilnndEyVJbc0g7hdDLBX5BM25D+DGZGJRKUz1V+uBrWmXtIt
        Vonj7JTDTe7ViH0GDsB7CvqXFGXO2a2cDYBchLkL6vQiFPshxvUsLtwxuy/qdYgy
        X6ya+AUoZcoQGy1XxNjfH6cPtWSWQGEp1oPR6vL9hU3laTZb3C+VV4jZem+he8/0
        V+qV6fLG92WTXm2hmf8nrtUqqJ+C7mW/RJod+TviviBadIX0OHXW7k5HVsZood01
        te8vMRUNJNiZfa9EMIK5oncbQn0LcM3Wo9VrjpL7jREb/4HCS2gswYGv7hzk9cCS
        kVY4rDucchKbApuI3kfzmO7GFOF5eiSkYZpY/czNn7VVM3WCu6dpOX4+3rhgrZQw
        kY14L930DaLVRUgve/zKVP2D2GHdEOs+MbV7s96UgigT9pXly/yHPj+1sSYqmnaD
        5b7jSeJusmzO/nrwXVGLsnezR87VzHl9Ux9g5s6zh+R+PrZuVxYsLvoUpaasH47O
        gIcBzSb/6pSGZKAUizmYsHsR1k88dAvsQ+FsUDaNokdi9VndEB4QPmiFmjyLV+0I
        1TFoXop4sW11NPz1YCq+IxnYrEaIN3PyhY0GvBJDFY1/AgMBAAGgADANBgkqhkiG
        9w0BAQsFAAOCAgEActuqnqS8Y9UF7e08w7tR3FPzGecWreuvxILrlFEZJxiLPFqL
        It7uJvtypCVQvz6UQzKdBYO7tMpRaWViB8DrWzXNZjLMrg+QHcpveg8C0Ett4scG
        fnvLk6fTDFYrnGvwHTqiHos5i0y3bFLyS1BGwSpdLAykGtvC+VM8mRyw/Y7CPcKN
        77kebY/9xduW1g2uxWLr0x90RuQDv9psPojT+59tRLGSp5Kt0IeD3QtnAZEFE4aN
        vt+Pd69eg3BgZ8ZeDgoqAw3yppvOkpAFiE5pw2qPZaM4SRphl4d2Lek2zNIMyZqv
        do5zh356HOgXtDaSg0POnRGrN/Ua+LMCRTg6GEPUnx9uQb/zt8Zu0hIexDGyykp1
        OGqtWlv/Nc8UYuS38v0BeB6bMPeoqQUjkqs8nHlAEFn0KlgYdtDC+7SdQx6wS4te
        dBKRNDfC4lS3jYJgs55jHqonZgkpSi3bamlxpfpW0ukGBcmq91wRe4bOw/4uD/vf
        UwqMWOdCYcU3mdYNjTWy22ORW3SGFQxMBwpUEURCSoeqWr6aJeQ7KAYkx1PrB5T8
        OTEc13lWf+B0PU9UJuGTsmpIuImPDVd0EVDayr3mT5dDbqTVDbe8ppf2IswABmf0
        o3DybUeUmknYjl109rdSf+76nuREICHatxXgN3xCMFuBaN4WLO+ksd6Y1Ys=
        -----END CERTIFICATE REQUEST-----
        \"\"\",
            common_name="test.my.domain",
            opts=pulumi.ResourceOptions(depends_on=[vault_pki_secret_backend_role["admin"]]))
        ```
        ## Deprecations

        * `serial` - Use `serial_number` instead.

        :param str resource_name: The name of the resource.
        :param SecretBackendSignArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendSignArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 common_name: Optional[pulumi.Input[str]] = None,
                 csr: Optional[pulumi.Input[str]] = None,
                 exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
                 format: Optional[pulumi.Input[str]] = None,
                 ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 min_seconds_remaining: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendSignArgs.__new__(SecretBackendSignArgs)

            __props__.__dict__["alt_names"] = alt_names
            __props__.__dict__["auto_renew"] = auto_renew
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            if common_name is None and not opts.urn:
                raise TypeError("Missing required property 'common_name'")
            __props__.__dict__["common_name"] = common_name
            if csr is None and not opts.urn:
                raise TypeError("Missing required property 'csr'")
            __props__.__dict__["csr"] = csr
            __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
            __props__.__dict__["format"] = format
            __props__.__dict__["ip_sans"] = ip_sans
            __props__.__dict__["min_seconds_remaining"] = min_seconds_remaining
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["other_sans"] = other_sans
            __props__.__dict__["ttl"] = ttl
            __props__.__dict__["uri_sans"] = uri_sans
            __props__.__dict__["ca_chains"] = None
            __props__.__dict__["certificate"] = None
            __props__.__dict__["expiration"] = None
            __props__.__dict__["issuing_ca"] = None
            __props__.__dict__["renew_pending"] = None
            __props__.__dict__["serial"] = None
            __props__.__dict__["serial_number"] = None
        super(SecretBackendSign, __self__).__init__(
            'vault:pkiSecret/secretBackendSign:SecretBackendSign',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alt_names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            ca_chains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            certificate: Optional[pulumi.Input[str]] = None,
            common_name: Optional[pulumi.Input[str]] = None,
            csr: Optional[pulumi.Input[str]] = None,
            exclude_cn_from_sans: Optional[pulumi.Input[bool]] = None,
            expiration: Optional[pulumi.Input[int]] = None,
            format: Optional[pulumi.Input[str]] = None,
            ip_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            issuing_ca: Optional[pulumi.Input[str]] = None,
            min_seconds_remaining: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            other_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            renew_pending: Optional[pulumi.Input[bool]] = None,
            serial: Optional[pulumi.Input[str]] = None,
            serial_number: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[str]] = None,
            uri_sans: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SecretBackendSign':
        """
        Get an existing SecretBackendSign resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] alt_names: List of alternative names
        :param pulumi.Input[bool] auto_renew: If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        :param pulumi.Input[str] backend: The PKI secret backend the resource belongs to.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ca_chains: The CA chain
        :param pulumi.Input[str] certificate: The certificate
        :param pulumi.Input[str] common_name: CN of certificate to create
        :param pulumi.Input[str] csr: The CSR
        :param pulumi.Input[bool] exclude_cn_from_sans: Flag to exclude CN from SANs
        :param pulumi.Input[int] expiration: The expiration date of the certificate in unix epoch format
        :param pulumi.Input[str] format: The format of data
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ip_sans: List of alternative IPs
        :param pulumi.Input[str] issuing_ca: The issuing CA
        :param pulumi.Input[int] min_seconds_remaining: Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        :param pulumi.Input[str] name: Name of the role to create the certificate against
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] other_sans: List of other SANs
        :param pulumi.Input[bool] renew_pending: `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        :param pulumi.Input[str] serial: The serial number.
        :param pulumi.Input[str] serial_number: The certificate's serial number, hex formatted.
        :param pulumi.Input[str] ttl: Time to live
        :param pulumi.Input[Sequence[pulumi.Input[str]]] uri_sans: List of alternative URIs
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendSignState.__new__(_SecretBackendSignState)

        __props__.__dict__["alt_names"] = alt_names
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["backend"] = backend
        __props__.__dict__["ca_chains"] = ca_chains
        __props__.__dict__["certificate"] = certificate
        __props__.__dict__["common_name"] = common_name
        __props__.__dict__["csr"] = csr
        __props__.__dict__["exclude_cn_from_sans"] = exclude_cn_from_sans
        __props__.__dict__["expiration"] = expiration
        __props__.__dict__["format"] = format
        __props__.__dict__["ip_sans"] = ip_sans
        __props__.__dict__["issuing_ca"] = issuing_ca
        __props__.__dict__["min_seconds_remaining"] = min_seconds_remaining
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["other_sans"] = other_sans
        __props__.__dict__["renew_pending"] = renew_pending
        __props__.__dict__["serial"] = serial
        __props__.__dict__["serial_number"] = serial_number
        __props__.__dict__["ttl"] = ttl
        __props__.__dict__["uri_sans"] = uri_sans
        return SecretBackendSign(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="altNames")
    def alt_names(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative names
        """
        return pulumi.get(self, "alt_names")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        If set to `true`, certs will be renewed if the expiration is within `min_seconds_remaining`. Default `false`
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The PKI secret backend the resource belongs to.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="caChains")
    def ca_chains(self) -> pulumi.Output[Sequence[str]]:
        """
        The CA chain
        """
        return pulumi.get(self, "ca_chains")

    @property
    @pulumi.getter
    def certificate(self) -> pulumi.Output[str]:
        """
        The certificate
        """
        return pulumi.get(self, "certificate")

    @property
    @pulumi.getter(name="commonName")
    def common_name(self) -> pulumi.Output[str]:
        """
        CN of certificate to create
        """
        return pulumi.get(self, "common_name")

    @property
    @pulumi.getter
    def csr(self) -> pulumi.Output[str]:
        """
        The CSR
        """
        return pulumi.get(self, "csr")

    @property
    @pulumi.getter(name="excludeCnFromSans")
    def exclude_cn_from_sans(self) -> pulumi.Output[Optional[bool]]:
        """
        Flag to exclude CN from SANs
        """
        return pulumi.get(self, "exclude_cn_from_sans")

    @property
    @pulumi.getter
    def expiration(self) -> pulumi.Output[int]:
        """
        The expiration date of the certificate in unix epoch format
        """
        return pulumi.get(self, "expiration")

    @property
    @pulumi.getter
    def format(self) -> pulumi.Output[Optional[str]]:
        """
        The format of data
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter(name="ipSans")
    def ip_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative IPs
        """
        return pulumi.get(self, "ip_sans")

    @property
    @pulumi.getter(name="issuingCa")
    def issuing_ca(self) -> pulumi.Output[str]:
        """
        The issuing CA
        """
        return pulumi.get(self, "issuing_ca")

    @property
    @pulumi.getter(name="minSecondsRemaining")
    def min_seconds_remaining(self) -> pulumi.Output[Optional[int]]:
        """
        Generate a new certificate when the expiration is within this number of seconds, default is 604800 (7 days)
        """
        return pulumi.get(self, "min_seconds_remaining")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the role to create the certificate against
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="otherSans")
    def other_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of other SANs
        """
        return pulumi.get(self, "other_sans")

    @property
    @pulumi.getter(name="renewPending")
    def renew_pending(self) -> pulumi.Output[bool]:
        """
        `true` if the current time (during refresh) is after the start of the early renewal window declared by `min_seconds_remaining`, and `false` otherwise; if `auto_renew` is set to `true` then the provider will plan to replace the certificate once renewal is pending.
        """
        return pulumi.get(self, "renew_pending")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        The serial number.
        """
        return pulumi.get(self, "serial")

    @property
    @pulumi.getter(name="serialNumber")
    def serial_number(self) -> pulumi.Output[str]:
        """
        The certificate's serial number, hex formatted.
        """
        return pulumi.get(self, "serial_number")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[Optional[str]]:
        """
        Time to live
        """
        return pulumi.get(self, "ttl")

    @property
    @pulumi.getter(name="uriSans")
    def uri_sans(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        List of alternative URIs
        """
        return pulumi.get(self, "uri_sans")

