# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SecretBackendRoleArgs', 'SecretBackendRole']

@pulumi.input_type
class SecretBackendRoleArgs:
    def __init__(__self__, *,
                 backend: pulumi.Input[str],
                 key_type: pulumi.Input[str],
                 algorithm_signer: Optional[pulumi.Input[str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[str]] = None,
                 allowed_domains: Optional[pulumi.Input[str]] = None,
                 allowed_extensions: Optional[pulumi.Input[str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]] = None,
                 allowed_user_key_lengths: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
                 allowed_users: Optional[pulumi.Input[str]] = None,
                 allowed_users_template: Optional[pulumi.Input[bool]] = None,
                 cidr_list: Optional[pulumi.Input[str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_user: Optional[pulumi.Input[str]] = None,
                 default_user_template: Optional[pulumi.Input[bool]] = None,
                 key_id_format: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a SecretBackendRole resource.
        :param pulumi.Input[str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] allowed_user_key_lengths: Specifies a map of ssh key types and their expected sizes which 
               are allowed to be signed by the CA type.
               *Deprecated: use* allowed_user_key_config *instead*
        :param pulumi.Input[str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, Any]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, Any]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[str] name: Specifies the name of the role to create.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ttl: Specifies the Time To Live value.
        """
        pulumi.set(__self__, "backend", backend)
        pulumi.set(__self__, "key_type", key_type)
        if algorithm_signer is not None:
            pulumi.set(__self__, "algorithm_signer", algorithm_signer)
        if allow_bare_domains is not None:
            pulumi.set(__self__, "allow_bare_domains", allow_bare_domains)
        if allow_host_certificates is not None:
            pulumi.set(__self__, "allow_host_certificates", allow_host_certificates)
        if allow_subdomains is not None:
            pulumi.set(__self__, "allow_subdomains", allow_subdomains)
        if allow_user_certificates is not None:
            pulumi.set(__self__, "allow_user_certificates", allow_user_certificates)
        if allow_user_key_ids is not None:
            pulumi.set(__self__, "allow_user_key_ids", allow_user_key_ids)
        if allowed_critical_options is not None:
            pulumi.set(__self__, "allowed_critical_options", allowed_critical_options)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_extensions is not None:
            pulumi.set(__self__, "allowed_extensions", allowed_extensions)
        if allowed_user_key_configs is not None:
            pulumi.set(__self__, "allowed_user_key_configs", allowed_user_key_configs)
        if allowed_user_key_lengths is not None:
            warnings.warn("""Set in allowed_user_key_config""", DeprecationWarning)
            pulumi.log.warn("""allowed_user_key_lengths is deprecated: Set in allowed_user_key_config""")
        if allowed_user_key_lengths is not None:
            pulumi.set(__self__, "allowed_user_key_lengths", allowed_user_key_lengths)
        if allowed_users is not None:
            pulumi.set(__self__, "allowed_users", allowed_users)
        if allowed_users_template is not None:
            pulumi.set(__self__, "allowed_users_template", allowed_users_template)
        if cidr_list is not None:
            pulumi.set(__self__, "cidr_list", cidr_list)
        if default_critical_options is not None:
            pulumi.set(__self__, "default_critical_options", default_critical_options)
        if default_extensions is not None:
            pulumi.set(__self__, "default_extensions", default_extensions)
        if default_user is not None:
            pulumi.set(__self__, "default_user", default_user)
        if default_user_template is not None:
            pulumi.set(__self__, "default_user_template", default_user_template)
        if key_id_format is not None:
            pulumi.set(__self__, "key_id_format", key_id_format)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Input[str]:
        """
        The path where the SSH secret backend is mounted.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: pulumi.Input[str]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Input[str]:
        """
        Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="algorithmSigner")
    def algorithm_signer(self) -> Optional[pulumi.Input[str]]:
        """
        When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        """
        return pulumi.get(self, "algorithm_signer")

    @algorithm_signer.setter
    def algorithm_signer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm_signer", value)

    @property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_bare_domains")

    @allow_bare_domains.setter
    def allow_bare_domains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_bare_domains", value)

    @property
    @pulumi.getter(name="allowHostCertificates")
    def allow_host_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'host'.
        """
        return pulumi.get(self, "allow_host_certificates")

    @allow_host_certificates.setter
    def allow_host_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_host_certificates", value)

    @property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_subdomains")

    @allow_subdomains.setter
    def allow_subdomains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_subdomains", value)

    @property
    @pulumi.getter(name="allowUserCertificates")
    def allow_user_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'user'.
        """
        return pulumi.get(self, "allow_user_certificates")

    @allow_user_certificates.setter
    def allow_user_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_certificates", value)

    @property
    @pulumi.getter(name="allowUserKeyIds")
    def allow_user_key_ids(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        """
        return pulumi.get(self, "allow_user_key_ids")

    @allow_user_key_ids.setter
    def allow_user_key_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_key_ids", value)

    @property
    @pulumi.getter(name="allowedCriticalOptions")
    def allowed_critical_options(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comma-separated list of critical options that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_critical_options")

    @allowed_critical_options.setter
    def allowed_critical_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_critical_options", value)

    @property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[str]]:
        """
        The list of domains for which a client can request a host certificate.
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_domains", value)

    @property
    @pulumi.getter(name="allowedExtensions")
    def allowed_extensions(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comma-separated list of extensions that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_extensions")

    @allowed_extensions.setter
    def allowed_extensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_extensions", value)

    @property
    @pulumi.getter(name="allowedUserKeyConfigs")
    def allowed_user_key_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]:
        """
        Set of configuration blocks to define allowed  
        user key configuration, like key type and their lengths. Can be specified multiple times.
        *See Configuration-Options for more info*
        """
        return pulumi.get(self, "allowed_user_key_configs")

    @allowed_user_key_configs.setter
    def allowed_user_key_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]):
        pulumi.set(self, "allowed_user_key_configs", value)

    @property
    @pulumi.getter(name="allowedUserKeyLengths")
    def allowed_user_key_lengths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        Specifies a map of ssh key types and their expected sizes which 
        are allowed to be signed by the CA type.
        *Deprecated: use* allowed_user_key_config *instead*
        """
        return pulumi.get(self, "allowed_user_key_lengths")

    @allowed_user_key_lengths.setter
    def allowed_user_key_lengths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_user_key_lengths", value)

    @property
    @pulumi.getter(name="allowedUsers")
    def allowed_users(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        """
        return pulumi.get(self, "allowed_users")

    @allowed_users.setter
    def allowed_users(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_users", value)

    @property
    @pulumi.getter(name="allowedUsersTemplate")
    def allowed_users_template(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        """
        return pulumi.get(self, "allowed_users_template")

    @allowed_users_template.setter
    def allowed_users_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allowed_users_template", value)

    @property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> Optional[pulumi.Input[str]]:
        """
        The comma-separated string of CIDR blocks for which this role is applicable.
        """
        return pulumi.get(self, "cidr_list")

    @cidr_list.setter
    def cidr_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_list", value)

    @property
    @pulumi.getter(name="defaultCriticalOptions")
    def default_critical_options(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specifies a map of critical options that certificates have when signed.
        """
        return pulumi.get(self, "default_critical_options")

    @default_critical_options.setter
    def default_critical_options(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "default_critical_options", value)

    @property
    @pulumi.getter(name="defaultExtensions")
    def default_extensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specifies a map of extensions that certificates have when signed.
        """
        return pulumi.get(self, "default_extensions")

    @default_extensions.setter
    def default_extensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "default_extensions", value)

    @property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default username for which a credential will be generated.
        """
        return pulumi.get(self, "default_user")

    @default_user.setter
    def default_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_user", value)

    @property
    @pulumi.getter(name="defaultUserTemplate")
    def default_user_template(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        """
        return pulumi.get(self, "default_user_template")

    @default_user_template.setter
    def default_user_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_user_template", value)

    @property
    @pulumi.getter(name="keyIdFormat")
    def key_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a custom format for the key id of a signed certificate.
        """
        return pulumi.get(self, "key_id_format")

    @key_id_format.setter
    def key_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id_format", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the maximum Time To Live value.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Time To Live value.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


@pulumi.input_type
class _SecretBackendRoleState:
    def __init__(__self__, *,
                 algorithm_signer: Optional[pulumi.Input[str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[str]] = None,
                 allowed_domains: Optional[pulumi.Input[str]] = None,
                 allowed_extensions: Optional[pulumi.Input[str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]] = None,
                 allowed_user_key_lengths: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
                 allowed_users: Optional[pulumi.Input[str]] = None,
                 allowed_users_template: Optional[pulumi.Input[bool]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cidr_list: Optional[pulumi.Input[str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_user: Optional[pulumi.Input[str]] = None,
                 default_user_template: Optional[pulumi.Input[bool]] = None,
                 key_id_format: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SecretBackendRole resources.
        :param pulumi.Input[str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] allowed_user_key_lengths: Specifies a map of ssh key types and their expected sizes which 
               are allowed to be signed by the CA type.
               *Deprecated: use* allowed_user_key_config *instead*
        :param pulumi.Input[str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, Any]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, Any]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[str] name: Specifies the name of the role to create.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ttl: Specifies the Time To Live value.
        """
        if algorithm_signer is not None:
            pulumi.set(__self__, "algorithm_signer", algorithm_signer)
        if allow_bare_domains is not None:
            pulumi.set(__self__, "allow_bare_domains", allow_bare_domains)
        if allow_host_certificates is not None:
            pulumi.set(__self__, "allow_host_certificates", allow_host_certificates)
        if allow_subdomains is not None:
            pulumi.set(__self__, "allow_subdomains", allow_subdomains)
        if allow_user_certificates is not None:
            pulumi.set(__self__, "allow_user_certificates", allow_user_certificates)
        if allow_user_key_ids is not None:
            pulumi.set(__self__, "allow_user_key_ids", allow_user_key_ids)
        if allowed_critical_options is not None:
            pulumi.set(__self__, "allowed_critical_options", allowed_critical_options)
        if allowed_domains is not None:
            pulumi.set(__self__, "allowed_domains", allowed_domains)
        if allowed_extensions is not None:
            pulumi.set(__self__, "allowed_extensions", allowed_extensions)
        if allowed_user_key_configs is not None:
            pulumi.set(__self__, "allowed_user_key_configs", allowed_user_key_configs)
        if allowed_user_key_lengths is not None:
            warnings.warn("""Set in allowed_user_key_config""", DeprecationWarning)
            pulumi.log.warn("""allowed_user_key_lengths is deprecated: Set in allowed_user_key_config""")
        if allowed_user_key_lengths is not None:
            pulumi.set(__self__, "allowed_user_key_lengths", allowed_user_key_lengths)
        if allowed_users is not None:
            pulumi.set(__self__, "allowed_users", allowed_users)
        if allowed_users_template is not None:
            pulumi.set(__self__, "allowed_users_template", allowed_users_template)
        if backend is not None:
            pulumi.set(__self__, "backend", backend)
        if cidr_list is not None:
            pulumi.set(__self__, "cidr_list", cidr_list)
        if default_critical_options is not None:
            pulumi.set(__self__, "default_critical_options", default_critical_options)
        if default_extensions is not None:
            pulumi.set(__self__, "default_extensions", default_extensions)
        if default_user is not None:
            pulumi.set(__self__, "default_user", default_user)
        if default_user_template is not None:
            pulumi.set(__self__, "default_user_template", default_user_template)
        if key_id_format is not None:
            pulumi.set(__self__, "key_id_format", key_id_format)
        if key_type is not None:
            pulumi.set(__self__, "key_type", key_type)
        if max_ttl is not None:
            pulumi.set(__self__, "max_ttl", max_ttl)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if ttl is not None:
            pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="algorithmSigner")
    def algorithm_signer(self) -> Optional[pulumi.Input[str]]:
        """
        When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        """
        return pulumi.get(self, "algorithm_signer")

    @algorithm_signer.setter
    def algorithm_signer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "algorithm_signer", value)

    @property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_bare_domains")

    @allow_bare_domains.setter
    def allow_bare_domains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_bare_domains", value)

    @property
    @pulumi.getter(name="allowHostCertificates")
    def allow_host_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'host'.
        """
        return pulumi.get(self, "allow_host_certificates")

    @allow_host_certificates.setter
    def allow_host_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_host_certificates", value)

    @property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_subdomains")

    @allow_subdomains.setter
    def allow_subdomains(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_subdomains", value)

    @property
    @pulumi.getter(name="allowUserCertificates")
    def allow_user_certificates(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'user'.
        """
        return pulumi.get(self, "allow_user_certificates")

    @allow_user_certificates.setter
    def allow_user_certificates(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_certificates", value)

    @property
    @pulumi.getter(name="allowUserKeyIds")
    def allow_user_key_ids(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        """
        return pulumi.get(self, "allow_user_key_ids")

    @allow_user_key_ids.setter
    def allow_user_key_ids(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_user_key_ids", value)

    @property
    @pulumi.getter(name="allowedCriticalOptions")
    def allowed_critical_options(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comma-separated list of critical options that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_critical_options")

    @allowed_critical_options.setter
    def allowed_critical_options(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_critical_options", value)

    @property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> Optional[pulumi.Input[str]]:
        """
        The list of domains for which a client can request a host certificate.
        """
        return pulumi.get(self, "allowed_domains")

    @allowed_domains.setter
    def allowed_domains(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_domains", value)

    @property
    @pulumi.getter(name="allowedExtensions")
    def allowed_extensions(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comma-separated list of extensions that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_extensions")

    @allowed_extensions.setter
    def allowed_extensions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_extensions", value)

    @property
    @pulumi.getter(name="allowedUserKeyConfigs")
    def allowed_user_key_configs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]:
        """
        Set of configuration blocks to define allowed  
        user key configuration, like key type and their lengths. Can be specified multiple times.
        *See Configuration-Options for more info*
        """
        return pulumi.get(self, "allowed_user_key_configs")

    @allowed_user_key_configs.setter
    def allowed_user_key_configs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SecretBackendRoleAllowedUserKeyConfigArgs']]]]):
        pulumi.set(self, "allowed_user_key_configs", value)

    @property
    @pulumi.getter(name="allowedUserKeyLengths")
    def allowed_user_key_lengths(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]:
        """
        Specifies a map of ssh key types and their expected sizes which 
        are allowed to be signed by the CA type.
        *Deprecated: use* allowed_user_key_config *instead*
        """
        return pulumi.get(self, "allowed_user_key_lengths")

    @allowed_user_key_lengths.setter
    def allowed_user_key_lengths(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]]):
        pulumi.set(self, "allowed_user_key_lengths", value)

    @property
    @pulumi.getter(name="allowedUsers")
    def allowed_users(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        """
        return pulumi.get(self, "allowed_users")

    @allowed_users.setter
    def allowed_users(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allowed_users", value)

    @property
    @pulumi.getter(name="allowedUsersTemplate")
    def allowed_users_template(self) -> Optional[pulumi.Input[bool]]:
        """
        Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        """
        return pulumi.get(self, "allowed_users_template")

    @allowed_users_template.setter
    def allowed_users_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allowed_users_template", value)

    @property
    @pulumi.getter
    def backend(self) -> Optional[pulumi.Input[str]]:
        """
        The path where the SSH secret backend is mounted.
        """
        return pulumi.get(self, "backend")

    @backend.setter
    def backend(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backend", value)

    @property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> Optional[pulumi.Input[str]]:
        """
        The comma-separated string of CIDR blocks for which this role is applicable.
        """
        return pulumi.get(self, "cidr_list")

    @cidr_list.setter
    def cidr_list(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cidr_list", value)

    @property
    @pulumi.getter(name="defaultCriticalOptions")
    def default_critical_options(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specifies a map of critical options that certificates have when signed.
        """
        return pulumi.get(self, "default_critical_options")

    @default_critical_options.setter
    def default_critical_options(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "default_critical_options", value)

    @property
    @pulumi.getter(name="defaultExtensions")
    def default_extensions(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Specifies a map of extensions that certificates have when signed.
        """
        return pulumi.get(self, "default_extensions")

    @default_extensions.setter
    def default_extensions(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "default_extensions", value)

    @property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the default username for which a credential will be generated.
        """
        return pulumi.get(self, "default_user")

    @default_user.setter
    def default_user(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_user", value)

    @property
    @pulumi.getter(name="defaultUserTemplate")
    def default_user_template(self) -> Optional[pulumi.Input[bool]]:
        """
        If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        """
        return pulumi.get(self, "default_user_template")

    @default_user_template.setter
    def default_user_template(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "default_user_template", value)

    @property
    @pulumi.getter(name="keyIdFormat")
    def key_id_format(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a custom format for the key id of a signed certificate.
        """
        return pulumi.get(self, "key_id_format")

    @key_id_format.setter
    def key_id_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_id_format", value)

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        """
        return pulumi.get(self, "key_type")

    @key_type.setter
    def key_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_type", value)

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the maximum Time To Live value.
        """
        return pulumi.get(self, "max_ttl")

    @max_ttl.setter
    def max_ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "max_ttl", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the name of the role to create.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def ttl(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the Time To Live value.
        """
        return pulumi.get(self, "ttl")

    @ttl.setter
    def ttl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ttl", value)


class SecretBackendRole(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm_signer: Optional[pulumi.Input[str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[str]] = None,
                 allowed_domains: Optional[pulumi.Input[str]] = None,
                 allowed_extensions: Optional[pulumi.Input[str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretBackendRoleAllowedUserKeyConfigArgs']]]]] = None,
                 allowed_user_key_lengths: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
                 allowed_users: Optional[pulumi.Input[str]] = None,
                 allowed_users_template: Optional[pulumi.Input[bool]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cidr_list: Optional[pulumi.Input[str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_user: Optional[pulumi.Input[str]] = None,
                 default_user_template: Optional[pulumi.Input[bool]] = None,
                 key_id_format: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage roles in an SSH secret backend
        [SSH secret backend within Vault](https://www.vaultproject.io/docs/secrets/ssh/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Mount("example", type="ssh")
        foo = vault.ssh.SecretBackendRole("foo",
            backend=example.path,
            key_type="ca",
            allow_user_certificates=True)
        bar = vault.ssh.SecretBackendRole("bar",
            backend=example.path,
            key_type="otp",
            default_user="default",
            allowed_users="default,baz",
            cidr_list="0.0.0.0/0")
        ```

        ## Import

        SSH secret backend roles can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:ssh/secretBackendRole:SecretBackendRole foo ssh/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretBackendRoleAllowedUserKeyConfigArgs']]]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] allowed_user_key_lengths: Specifies a map of ssh key types and their expected sizes which 
               are allowed to be signed by the CA type.
               *Deprecated: use* allowed_user_key_config *instead*
        :param pulumi.Input[str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, Any]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, Any]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[str] name: Specifies the name of the role to create.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ttl: Specifies the Time To Live value.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SecretBackendRoleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage roles in an SSH secret backend
        [SSH secret backend within Vault](https://www.vaultproject.io/docs/secrets/ssh/index.html).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_vault as vault

        example = vault.Mount("example", type="ssh")
        foo = vault.ssh.SecretBackendRole("foo",
            backend=example.path,
            key_type="ca",
            allow_user_certificates=True)
        bar = vault.ssh.SecretBackendRole("bar",
            backend=example.path,
            key_type="otp",
            default_user="default",
            allowed_users="default,baz",
            cidr_list="0.0.0.0/0")
        ```

        ## Import

        SSH secret backend roles can be imported using the `path`, e.g.

        ```sh
         $ pulumi import vault:ssh/secretBackendRole:SecretBackendRole foo ssh/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param SecretBackendRoleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SecretBackendRoleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 algorithm_signer: Optional[pulumi.Input[str]] = None,
                 allow_bare_domains: Optional[pulumi.Input[bool]] = None,
                 allow_host_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_subdomains: Optional[pulumi.Input[bool]] = None,
                 allow_user_certificates: Optional[pulumi.Input[bool]] = None,
                 allow_user_key_ids: Optional[pulumi.Input[bool]] = None,
                 allowed_critical_options: Optional[pulumi.Input[str]] = None,
                 allowed_domains: Optional[pulumi.Input[str]] = None,
                 allowed_extensions: Optional[pulumi.Input[str]] = None,
                 allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretBackendRoleAllowedUserKeyConfigArgs']]]]] = None,
                 allowed_user_key_lengths: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
                 allowed_users: Optional[pulumi.Input[str]] = None,
                 allowed_users_template: Optional[pulumi.Input[bool]] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 cidr_list: Optional[pulumi.Input[str]] = None,
                 default_critical_options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_extensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 default_user: Optional[pulumi.Input[str]] = None,
                 default_user_template: Optional[pulumi.Input[bool]] = None,
                 key_id_format: Optional[pulumi.Input[str]] = None,
                 key_type: Optional[pulumi.Input[str]] = None,
                 max_ttl: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 ttl: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SecretBackendRoleArgs.__new__(SecretBackendRoleArgs)

            __props__.__dict__["algorithm_signer"] = algorithm_signer
            __props__.__dict__["allow_bare_domains"] = allow_bare_domains
            __props__.__dict__["allow_host_certificates"] = allow_host_certificates
            __props__.__dict__["allow_subdomains"] = allow_subdomains
            __props__.__dict__["allow_user_certificates"] = allow_user_certificates
            __props__.__dict__["allow_user_key_ids"] = allow_user_key_ids
            __props__.__dict__["allowed_critical_options"] = allowed_critical_options
            __props__.__dict__["allowed_domains"] = allowed_domains
            __props__.__dict__["allowed_extensions"] = allowed_extensions
            __props__.__dict__["allowed_user_key_configs"] = allowed_user_key_configs
            if allowed_user_key_lengths is not None and not opts.urn:
                warnings.warn("""Set in allowed_user_key_config""", DeprecationWarning)
                pulumi.log.warn("""allowed_user_key_lengths is deprecated: Set in allowed_user_key_config""")
            __props__.__dict__["allowed_user_key_lengths"] = allowed_user_key_lengths
            __props__.__dict__["allowed_users"] = allowed_users
            __props__.__dict__["allowed_users_template"] = allowed_users_template
            if backend is None and not opts.urn:
                raise TypeError("Missing required property 'backend'")
            __props__.__dict__["backend"] = backend
            __props__.__dict__["cidr_list"] = cidr_list
            __props__.__dict__["default_critical_options"] = default_critical_options
            __props__.__dict__["default_extensions"] = default_extensions
            __props__.__dict__["default_user"] = default_user
            __props__.__dict__["default_user_template"] = default_user_template
            __props__.__dict__["key_id_format"] = key_id_format
            if key_type is None and not opts.urn:
                raise TypeError("Missing required property 'key_type'")
            __props__.__dict__["key_type"] = key_type
            __props__.__dict__["max_ttl"] = max_ttl
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["ttl"] = ttl
        super(SecretBackendRole, __self__).__init__(
            'vault:ssh/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            algorithm_signer: Optional[pulumi.Input[str]] = None,
            allow_bare_domains: Optional[pulumi.Input[bool]] = None,
            allow_host_certificates: Optional[pulumi.Input[bool]] = None,
            allow_subdomains: Optional[pulumi.Input[bool]] = None,
            allow_user_certificates: Optional[pulumi.Input[bool]] = None,
            allow_user_key_ids: Optional[pulumi.Input[bool]] = None,
            allowed_critical_options: Optional[pulumi.Input[str]] = None,
            allowed_domains: Optional[pulumi.Input[str]] = None,
            allowed_extensions: Optional[pulumi.Input[str]] = None,
            allowed_user_key_configs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretBackendRoleAllowedUserKeyConfigArgs']]]]] = None,
            allowed_user_key_lengths: Optional[pulumi.Input[Mapping[str, pulumi.Input[int]]]] = None,
            allowed_users: Optional[pulumi.Input[str]] = None,
            allowed_users_template: Optional[pulumi.Input[bool]] = None,
            backend: Optional[pulumi.Input[str]] = None,
            cidr_list: Optional[pulumi.Input[str]] = None,
            default_critical_options: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            default_extensions: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            default_user: Optional[pulumi.Input[str]] = None,
            default_user_template: Optional[pulumi.Input[bool]] = None,
            key_id_format: Optional[pulumi.Input[str]] = None,
            key_type: Optional[pulumi.Input[str]] = None,
            max_ttl: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            ttl: Optional[pulumi.Input[str]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] algorithm_signer: When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        :param pulumi.Input[bool] allow_bare_domains: Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_host_certificates: Specifies if certificates are allowed to be signed for use as a 'host'.
        :param pulumi.Input[bool] allow_subdomains: Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        :param pulumi.Input[bool] allow_user_certificates: Specifies if certificates are allowed to be signed for use as a 'user'.
        :param pulumi.Input[bool] allow_user_key_ids: Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        :param pulumi.Input[str] allowed_critical_options: Specifies a comma-separated list of critical options that certificates can have when signed.
        :param pulumi.Input[str] allowed_domains: The list of domains for which a client can request a host certificate.
        :param pulumi.Input[str] allowed_extensions: Specifies a comma-separated list of extensions that certificates can have when signed.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['SecretBackendRoleAllowedUserKeyConfigArgs']]]] allowed_user_key_configs: Set of configuration blocks to define allowed  
               user key configuration, like key type and their lengths. Can be specified multiple times.
               *See Configuration-Options for more info*
        :param pulumi.Input[Mapping[str, pulumi.Input[int]]] allowed_user_key_lengths: Specifies a map of ssh key types and their expected sizes which 
               are allowed to be signed by the CA type.
               *Deprecated: use* allowed_user_key_config *instead*
        :param pulumi.Input[str] allowed_users: Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        :param pulumi.Input[bool] allowed_users_template: Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        :param pulumi.Input[str] backend: The path where the SSH secret backend is mounted.
        :param pulumi.Input[str] cidr_list: The comma-separated string of CIDR blocks for which this role is applicable.
        :param pulumi.Input[Mapping[str, Any]] default_critical_options: Specifies a map of critical options that certificates have when signed.
        :param pulumi.Input[Mapping[str, Any]] default_extensions: Specifies a map of extensions that certificates have when signed.
        :param pulumi.Input[str] default_user: Specifies the default username for which a credential will be generated.
        :param pulumi.Input[bool] default_user_template: If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        :param pulumi.Input[str] key_id_format: Specifies a custom format for the key id of a signed certificate.
        :param pulumi.Input[str] key_type: Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        :param pulumi.Input[str] max_ttl: Specifies the maximum Time To Live value.
        :param pulumi.Input[str] name: Specifies the name of the role to create.
        :param pulumi.Input[str] namespace: The namespace to provision the resource in.
               The value should not contain leading or trailing forward slashes.
               The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
               *Available only for Vault Enterprise*.
        :param pulumi.Input[str] ttl: Specifies the Time To Live value.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SecretBackendRoleState.__new__(_SecretBackendRoleState)

        __props__.__dict__["algorithm_signer"] = algorithm_signer
        __props__.__dict__["allow_bare_domains"] = allow_bare_domains
        __props__.__dict__["allow_host_certificates"] = allow_host_certificates
        __props__.__dict__["allow_subdomains"] = allow_subdomains
        __props__.__dict__["allow_user_certificates"] = allow_user_certificates
        __props__.__dict__["allow_user_key_ids"] = allow_user_key_ids
        __props__.__dict__["allowed_critical_options"] = allowed_critical_options
        __props__.__dict__["allowed_domains"] = allowed_domains
        __props__.__dict__["allowed_extensions"] = allowed_extensions
        __props__.__dict__["allowed_user_key_configs"] = allowed_user_key_configs
        __props__.__dict__["allowed_user_key_lengths"] = allowed_user_key_lengths
        __props__.__dict__["allowed_users"] = allowed_users
        __props__.__dict__["allowed_users_template"] = allowed_users_template
        __props__.__dict__["backend"] = backend
        __props__.__dict__["cidr_list"] = cidr_list
        __props__.__dict__["default_critical_options"] = default_critical_options
        __props__.__dict__["default_extensions"] = default_extensions
        __props__.__dict__["default_user"] = default_user
        __props__.__dict__["default_user_template"] = default_user_template
        __props__.__dict__["key_id_format"] = key_id_format
        __props__.__dict__["key_type"] = key_type
        __props__.__dict__["max_ttl"] = max_ttl
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["ttl"] = ttl
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="algorithmSigner")
    def algorithm_signer(self) -> pulumi.Output[str]:
        """
        When supplied, this value specifies a signing algorithm for the key. Possible values: ssh-rsa, rsa-sha2-256, rsa-sha2-512.
        """
        return pulumi.get(self, "algorithm_signer")

    @property
    @pulumi.getter(name="allowBareDomains")
    def allow_bare_domains(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if host certificates that are requested are allowed to use the base domains listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_bare_domains")

    @property
    @pulumi.getter(name="allowHostCertificates")
    def allow_host_certificates(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'host'.
        """
        return pulumi.get(self, "allow_host_certificates")

    @property
    @pulumi.getter(name="allowSubdomains")
    def allow_subdomains(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if host certificates that are requested are allowed to be subdomains of those listed in `allowed_domains`.
        """
        return pulumi.get(self, "allow_subdomains")

    @property
    @pulumi.getter(name="allowUserCertificates")
    def allow_user_certificates(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if certificates are allowed to be signed for use as a 'user'.
        """
        return pulumi.get(self, "allow_user_certificates")

    @property
    @pulumi.getter(name="allowUserKeyIds")
    def allow_user_key_ids(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if users can override the key ID for a signed certificate with the `key_id` field.
        """
        return pulumi.get(self, "allow_user_key_ids")

    @property
    @pulumi.getter(name="allowedCriticalOptions")
    def allowed_critical_options(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comma-separated list of critical options that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_critical_options")

    @property
    @pulumi.getter(name="allowedDomains")
    def allowed_domains(self) -> pulumi.Output[Optional[str]]:
        """
        The list of domains for which a client can request a host certificate.
        """
        return pulumi.get(self, "allowed_domains")

    @property
    @pulumi.getter(name="allowedExtensions")
    def allowed_extensions(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comma-separated list of extensions that certificates can have when signed.
        """
        return pulumi.get(self, "allowed_extensions")

    @property
    @pulumi.getter(name="allowedUserKeyConfigs")
    def allowed_user_key_configs(self) -> pulumi.Output[Optional[Sequence['outputs.SecretBackendRoleAllowedUserKeyConfig']]]:
        """
        Set of configuration blocks to define allowed  
        user key configuration, like key type and their lengths. Can be specified multiple times.
        *See Configuration-Options for more info*
        """
        return pulumi.get(self, "allowed_user_key_configs")

    @property
    @pulumi.getter(name="allowedUserKeyLengths")
    def allowed_user_key_lengths(self) -> pulumi.Output[Optional[Mapping[str, int]]]:
        """
        Specifies a map of ssh key types and their expected sizes which 
        are allowed to be signed by the CA type.
        *Deprecated: use* allowed_user_key_config *instead*
        """
        return pulumi.get(self, "allowed_user_key_lengths")

    @property
    @pulumi.getter(name="allowedUsers")
    def allowed_users(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a comma-separated list of usernames that are to be allowed, only if certain usernames are to be allowed.
        """
        return pulumi.get(self, "allowed_users")

    @property
    @pulumi.getter(name="allowedUsersTemplate")
    def allowed_users_template(self) -> pulumi.Output[Optional[bool]]:
        """
        Specifies if `allowed_users` can be declared using identity template policies. Non-templated users are also permitted.
        """
        return pulumi.get(self, "allowed_users_template")

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The path where the SSH secret backend is mounted.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="cidrList")
    def cidr_list(self) -> pulumi.Output[Optional[str]]:
        """
        The comma-separated string of CIDR blocks for which this role is applicable.
        """
        return pulumi.get(self, "cidr_list")

    @property
    @pulumi.getter(name="defaultCriticalOptions")
    def default_critical_options(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Specifies a map of critical options that certificates have when signed.
        """
        return pulumi.get(self, "default_critical_options")

    @property
    @pulumi.getter(name="defaultExtensions")
    def default_extensions(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Specifies a map of extensions that certificates have when signed.
        """
        return pulumi.get(self, "default_extensions")

    @property
    @pulumi.getter(name="defaultUser")
    def default_user(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the default username for which a credential will be generated.
        """
        return pulumi.get(self, "default_user")

    @property
    @pulumi.getter(name="defaultUserTemplate")
    def default_user_template(self) -> pulumi.Output[Optional[bool]]:
        """
        If set, `default_users` can be specified using identity template values. A non-templated user is also permitted.
        """
        return pulumi.get(self, "default_user_template")

    @property
    @pulumi.getter(name="keyIdFormat")
    def key_id_format(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a custom format for the key id of a signed certificate.
        """
        return pulumi.get(self, "key_id_format")

    @property
    @pulumi.getter(name="keyType")
    def key_type(self) -> pulumi.Output[str]:
        """
        Specifies the type of credentials generated by this role. This can be either `otp`, `dynamic` or `ca`.
        """
        return pulumi.get(self, "key_type")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[str]:
        """
        Specifies the maximum Time To Live value.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies the name of the role to create.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        The namespace to provision the resource in.
        The value should not contain leading or trailing forward slashes.
        The `namespace` is always relative to the provider's configured [namespace](https://www.terraform.io/docs/providers/vault#namespace).
        *Available only for Vault Enterprise*.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def ttl(self) -> pulumi.Output[str]:
        """
        Specifies the Time To Live value.
        """
        return pulumi.get(self, "ttl")

