"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PhysicalName = void 0;
const physical_name_generator_1 = require("./private/physical-name-generator");
const token_1 = require("./token");
/**
 * Includes special markers for automatic generation of physical names.
 *
 * @stability stable
 */
class PhysicalName {
    constructor() { }
}
exports.PhysicalName = PhysicalName;
/**
 * Use this to automatically generate a physical name for an AWS resource only if the resource is referenced across environments (account/region).
 *
 * Otherwise, the name will be allocated during deployment by CloudFormation.
 *
 * If you are certain that a resource will be referenced across environments,
 * you may also specify an explicit physical name for it. This option is
 * mostly designed for reusable constructs which may or may not be referenced
 * acrossed environments.
 *
 * @stability stable
 */
PhysicalName.GENERATE_IF_NEEDED = token_1.Token.asString(new physical_name_generator_1.GeneratedWhenNeededMarker());
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGh5c2ljYWwtbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBoeXNpY2FsLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsK0VBQThFO0FBQzlFLG1DQUFnQzs7Ozs7O0FBS2hDLE1BQWEsWUFBWTtJQWF2QixnQkFBd0IsQ0FBQzs7QUFiM0Isb0NBY0M7Ozs7Ozs7Ozs7Ozs7QUFId0IsK0JBQWtCLEdBQUcsYUFBSyxDQUFDLFFBQVEsQ0FBQyxJQUFJLG1EQUF5QixFQUFFLENBQUMsQ0FBQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IEdlbmVyYXRlZFdoZW5OZWVkZWRNYXJrZXIgfSBmcm9tICcuL3ByaXZhdGUvcGh5c2ljYWwtbmFtZS1nZW5lcmF0b3InO1xuaW1wb3J0IHsgVG9rZW4gfSBmcm9tICcuL3Rva2VuJztcblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFBoeXNpY2FsTmFtZSB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcHVibGljIHN0YXRpYyByZWFkb25seSBHRU5FUkFURV9JRl9ORUVERUQgPSBUb2tlbi5hc1N0cmluZyhuZXcgR2VuZXJhdGVkV2hlbk5lZWRlZE1hcmtlcigpKTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkgeyB9XG59XG4iXX0=