# camundactl

a camunda cli that interacts with the camunda rest api. the cli design is heavily influenced by kubectl.

**features**

- multiple output formats: table, json, jsonpath, jinja2 template
- shell autocomplete (zsh, bash, fish)
- shell autocomplete for processInstanceId, incidentIds, aso.
- configuration for multipe camunda engines
- ...

**examples**

Load two active process instances and use only the columns id and suspended

```bash
$ cctl get processInstances --max-results 2 -o table -oH id,suspended
id                                    suspended
------------------------------------  -----------
0027da48-0a61-11ec-bd5f-0242ac120014  False
003248e7-0b05-11ec-990f-0242ac12000d  False
```

Load all active process instances and use the result in a jinja2 template.

```bash
$  cctl get processInstances -o template -oT '{{result|length}}'
1337
```

Load five active process instances and apply jsonpath formatting.

```bash
$ cctl get processInstances -o jsonpath -oJ '$.[*].id' --max-results 5
0027da48-0a61-11ec-bd5f-0242ac120014
003248e7-0b05-11ec-990f-0242ac12000d
005ec7db-0a6c-11ec-bd5f-0242ac120014
00957ceb-0b18-11ec-990f-0242ac12000d
00f522c0-0b10-11ec-990f-0242ac12000d
```

Load only one active process instance and ouput as json.

```bash
$ cctl get processInstances -o json --max-results 1
[
  {
    "links": [],
    "id": "0027da48-0a61-11ec-bd5f-0242ac120014",
    "definitionId": "f87b25ce-0577-11ec-8801-0242ac12000a",
    "businessKey": null,
    "caseInstanceId": null,
    "ended": false,
    "suspended": false,
    "tenantId": null
  }
]
```

Pipe commands together. Get all active process instances by process defintion and delete them:

```bash
$ cctl get processInstances --process-definition-id f87b25ce-0577-11ec-8801-0242ac12000a -o jsonpath -oJ "$.[*].id" | xargs -n 1 cctl delete processInstance
Ok
Ok
Ok
...
```

## config

Mac:
$HOME/Library/Application Support/Camudna/config.yml

```yaml
version: beta1
current_engine: localhost
engines:
  - name: localhost
    url: http://localhost:8080/engine-rest
    auth:
      user: camunda
      password: camunda
  - name: client-a
    url: http://localhost:8080/engine-rest
    auth:
      user: camunda
      password: camunda
  - name: client-c
    url: https://localhost:8080/engine-rest
    verify: false
    auth:
      user: camunda
      password: camunda
```

## usage

### root command

```bash

$ python -m camundactl --help

Usage: __main__.py [OPTIONS] COMMAND [ARGS]...

Options:
  -l, --log-level TEXT  activates the logger with the given level
  -e, --engine TEXT     define the engine name to be used
  --help                Show this message and exit.

Commands:
  delete
  describe
  get

```

### delete command

```bash

$ python -m camundactl delete --help

Usage: __main__.py delete [OPTIONS] COMMAND [ARGS]...

Options:
  --help  Show this message and exit.

Commands:
  attachment                      Removes an attachment from a task by...
  deployment                      Deletes a deployment by id.
  processDefinition               Deletes a running process instance by...
  processDefinitionsByKey         Deletes process definitions by a given...
  processDefinitionsByKeyAndTenantId
                                  Deletes process definitions by a given...
  processInstance                 Deletes a running process instance by...
  processInstanceVariable         Deletes a variable of a process...
  task                            Removes a task by id.
  taskLocalVariable               Removes a local variable from a task...
  taskVariable                    Removes a variable that is visible to...


```

### get command

```bash

$ python -m camundactl get --help

Usage: __main__.py get [OPTIONS] COMMAND [ARGS]...

Options:
  --help  Show this message and exit.

Commands:
  activityInstanceTree            Retrieves an Activity...
  activityStatistics              Retrieves runtime...
  activityStatisticsByProcessDefinitionKey
                                  Retrieves runtime...
  activityStatisticsByProcessDefinitionKeyAndTenantId
                                  Retrieves runtime...
  attachment                      Retrieves a task...
  attachmentData                  Retrieves the binary...
  attachments                     Gets the attachments...
  comment                         Retrieves a task...
  comments                        Gets the comments for...
  deployedForm                    Retrieves the...
  deployedStartForm               Retrieves the...
  deployedStartFormByKey          Retrieves the...
  deployedStartFormByKeyAndTenantId
                                  Retrieves the...
  deployment                      Retrieves a...
  deploymentResource              Retrieves a...
  deploymentResourceData          Retrieves the binary...
  deploymentResources             Retrieves all...
  deploymentsCount                Queries for the...
  eventSubscriptions              Queries for event...
  eventSubscriptionsCount         Queries for the...
  externalTask                    Retrieves an external...
  externalTaskErrorDetails        Retrieves the error...
  externalTasks                   Queries for the...
  externalTasksCount              Queries for the...
  form                            Retrieves the form...
  formVariables                   Retrieves the form...
  identityLinks                   Gets the identity...
  interval                        Retrieves a list of...
  latestProcessDefinitionByTenantId
                                  Retrieves the latest...
  metrics                         Retrieves the `sum`...
  processDefinition               Retrieves a process...
  processDefinitionBpmn20Xml      Retrieves the BPMN...
  processDefinitionBpmn20XmlByKey
                                  Retrieves latest...
  processDefinitionBpmn20XmlByKeyAndTenantId
                                  Retrieves latest...
  processDefinitionByKey          Retrieves the latest...
  processDefinitionDiagram        Retrieves the diagram...
  processDefinitionDiagramByKey   Retrieves the diagram...
  processDefinitionDiagramByKeyAndTenantId
                                  Retrieves the diagram...
  processDefinitionStatistics     Retrieves runtime...
  processDefinitions              Queries for process...
  processDefinitionsCount         Requests the number...
  processEngineNames              Retrieves the names...
  processInstance                 lists all active...
  processInstanceVariable         Retrieves a variable...
  processInstanceVariableBinary   Retrieves the content...
  processInstanceVariables        Retrieves all...
  processInstances                Queries for process...
  processInstancesCount           Queries for the...
  renderedForm                    Retrieves the...
  renderedStartForm               Retrieves the...
  renderedStartFormByKey          Retrieves the...
  renderedStartFormByKeyAndTenantId
                                  Retrieves the...
  restAPIVersion                  Retrieves the version...
  schemaLog                       Queries for schema...
  startForm                       Retrieves the key of...
  startFormByKey                  Retrieves the key of...
  startFormByKeyAndTenantId       Retrieves the key of...
  startFormVariables              Retrieves the start...
  startFormVariablesByKey         Retrieves the start...
  startFormVariablesByKeyAndTenantId
                                  Retrieves the start...
  task                            Retrieves a task by...
  taskLocalVariable               Retrieves a variable...
  taskLocalVariableBinary         Retrieves a binary...
  taskLocalVariables              Retrieves all...
  taskVariable                    Retrieves a variable...
  taskVariableBinary              Retrieves a binary...
  taskVariables                   Retrieves all...
  tasks                           Queries for tasks...
  tasksCount                      Retrieves the number...
  topicNames                      Queries for distinct...


```

## autocomplete

_CCTL_COMPLETE=zsh_source cctl


# TODO / Ideas

- output column length in options or parameter (currently hard 40)

- display

  - list of strings
  - list of objects
  - object with keys
  - object with one value

- use template loader to save and load templates somewhere and let use use them or save some for default
