# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['camundactl', 'camundactl.cmd', 'camundactl.cmd.openapi', 'camundactl.output']

package_data = \
{'': ['*']}

install_requires = \
['Jinja2>=3.0.1,<4.0.0',
 'PyYAML>=5.4.1,<6.0.0',
 'click>=8.0.1,<9.0.0',
 'jsonpath-ng>=1.5.3,<2.0.0',
 'jsonschema>=3.2.0,<4.0.0',
 'requests>=2.26.0,<3.0.0',
 'tabulate>=0.8.9,<0.9.0',
 'toolz>=0.11.1,<0.12.0',
 'types-requests>=2.25.6,<3.0.0']

entry_points = \
{'console_scripts': ['cctl = camundactl.cmd.base:root']}

setup_kwargs = {
    'name': 'camundactl',
    'version': '0.1.0a2',
    'description': 'A Camunda cli that interacts with the rest api',
    'long_description': '# camundactl\n\na camunda cli that interacts with the camunda rest api. the cli design is heavily influenced by kubectl.\n\n**features**\n\n- multiple output formats: table, json, jsonpath, jinja2 template\n- shell autocomplete (zsh, bash, fish)\n- shell autocomplete for processInstanceId, incidentIds, aso.\n- configuration for multipe camunda engines\n- ...\n\n**examples**\n\nLoad two active process instances and use only the columns id and suspended\n\n```bash\n$ cctl get processInstances --max-results 2 -o table -oH id,suspended\nid                                    suspended\n------------------------------------  -----------\n0027da48-0a61-11ec-bd5f-0242ac120014  False\n003248e7-0b05-11ec-990f-0242ac12000d  False\n```\n\nLoad all active process instances and use the result in a jinja2 template.\n\n```bash\n$  cctl get processInstances -o template -oT \'{{result|length}}\'\n1337\n```\n\nLoad five active process instances and apply jsonpath formatting.\n\n```bash\n$ cctl get processInstances -o jsonpath -oJ \'$.[*].id\' --max-results 5\n0027da48-0a61-11ec-bd5f-0242ac120014\n003248e7-0b05-11ec-990f-0242ac12000d\n005ec7db-0a6c-11ec-bd5f-0242ac120014\n00957ceb-0b18-11ec-990f-0242ac12000d\n00f522c0-0b10-11ec-990f-0242ac12000d\n```\n\nLoad only one active process instance and ouput as json.\n\n```bash\n$ cctl get processInstances -o json --max-results 1\n[\n  {\n    "links": [],\n    "id": "0027da48-0a61-11ec-bd5f-0242ac120014",\n    "definitionId": "f87b25ce-0577-11ec-8801-0242ac12000a",\n    "businessKey": null,\n    "caseInstanceId": null,\n    "ended": false,\n    "suspended": false,\n    "tenantId": null\n  }\n]\n```\n\nPipe commands together. Get all active process instances by process defintion and delete them:\n\n```bash\n$ cctl get processInstances --process-definition-id f87b25ce-0577-11ec-8801-0242ac12000a -o jsonpath -oJ "$.[*].id" | xargs -n 1 cctl delete processInstance\nOk\nOk\nOk\n...\n```\n\n## config\n\nMac:\n$HOME/Library/Application Support/Camudna/config.yml\n\n```yaml\nversion: beta1\ncurrent_engine: localhost\nengines:\n  - name: localhost\n    url: http://localhost:8080/engine-rest\n    auth:\n      user: camunda\n      password: camunda\n  - name: client-a\n    url: http://localhost:8080/engine-rest\n    auth:\n      user: camunda\n      password: camunda\n  - name: client-c\n    url: https://localhost:8080/engine-rest\n    verify: false\n    auth:\n      user: camunda\n      password: camunda\n```\n\n## usage\n\n### root command\n\n```bash\n\n$ python -m camundactl --help\n\nUsage: __main__.py [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  -l, --log-level TEXT  activates the logger with the given level\n  -e, --engine TEXT     define the engine name to be used\n  --help                Show this message and exit.\n\nCommands:\n  delete\n  describe\n  get\n\n```\n\n### delete command\n\n```bash\n\n$ python -m camundactl delete --help\n\nUsage: __main__.py delete [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  attachment                      Removes an attachment from a task by...\n  deployment                      Deletes a deployment by id.\n  processDefinition               Deletes a running process instance by...\n  processDefinitionsByKey         Deletes process definitions by a given...\n  processDefinitionsByKeyAndTenantId\n                                  Deletes process definitions by a given...\n  processInstance                 Deletes a running process instance by...\n  processInstanceVariable         Deletes a variable of a process...\n  task                            Removes a task by id.\n  taskLocalVariable               Removes a local variable from a task...\n  taskVariable                    Removes a variable that is visible to...\n\n\n```\n\n### get command\n\n```bash\n\n$ python -m camundactl get --help\n\nUsage: __main__.py get [OPTIONS] COMMAND [ARGS]...\n\nOptions:\n  --help  Show this message and exit.\n\nCommands:\n  activityInstanceTree            Retrieves an Activity...\n  activityStatistics              Retrieves runtime...\n  activityStatisticsByProcessDefinitionKey\n                                  Retrieves runtime...\n  activityStatisticsByProcessDefinitionKeyAndTenantId\n                                  Retrieves runtime...\n  attachment                      Retrieves a task...\n  attachmentData                  Retrieves the binary...\n  attachments                     Gets the attachments...\n  comment                         Retrieves a task...\n  comments                        Gets the comments for...\n  deployedForm                    Retrieves the...\n  deployedStartForm               Retrieves the...\n  deployedStartFormByKey          Retrieves the...\n  deployedStartFormByKeyAndTenantId\n                                  Retrieves the...\n  deployment                      Retrieves a...\n  deploymentResource              Retrieves a...\n  deploymentResourceData          Retrieves the binary...\n  deploymentResources             Retrieves all...\n  deploymentsCount                Queries for the...\n  eventSubscriptions              Queries for event...\n  eventSubscriptionsCount         Queries for the...\n  externalTask                    Retrieves an external...\n  externalTaskErrorDetails        Retrieves the error...\n  externalTasks                   Queries for the...\n  externalTasksCount              Queries for the...\n  form                            Retrieves the form...\n  formVariables                   Retrieves the form...\n  identityLinks                   Gets the identity...\n  interval                        Retrieves a list of...\n  latestProcessDefinitionByTenantId\n                                  Retrieves the latest...\n  metrics                         Retrieves the `sum`...\n  processDefinition               Retrieves a process...\n  processDefinitionBpmn20Xml      Retrieves the BPMN...\n  processDefinitionBpmn20XmlByKey\n                                  Retrieves latest...\n  processDefinitionBpmn20XmlByKeyAndTenantId\n                                  Retrieves latest...\n  processDefinitionByKey          Retrieves the latest...\n  processDefinitionDiagram        Retrieves the diagram...\n  processDefinitionDiagramByKey   Retrieves the diagram...\n  processDefinitionDiagramByKeyAndTenantId\n                                  Retrieves the diagram...\n  processDefinitionStatistics     Retrieves runtime...\n  processDefinitions              Queries for process...\n  processDefinitionsCount         Requests the number...\n  processEngineNames              Retrieves the names...\n  processInstance                 lists all active...\n  processInstanceVariable         Retrieves a variable...\n  processInstanceVariableBinary   Retrieves the content...\n  processInstanceVariables        Retrieves all...\n  processInstances                Queries for process...\n  processInstancesCount           Queries for the...\n  renderedForm                    Retrieves the...\n  renderedStartForm               Retrieves the...\n  renderedStartFormByKey          Retrieves the...\n  renderedStartFormByKeyAndTenantId\n                                  Retrieves the...\n  restAPIVersion                  Retrieves the version...\n  schemaLog                       Queries for schema...\n  startForm                       Retrieves the key of...\n  startFormByKey                  Retrieves the key of...\n  startFormByKeyAndTenantId       Retrieves the key of...\n  startFormVariables              Retrieves the start...\n  startFormVariablesByKey         Retrieves the start...\n  startFormVariablesByKeyAndTenantId\n                                  Retrieves the start...\n  task                            Retrieves a task by...\n  taskLocalVariable               Retrieves a variable...\n  taskLocalVariableBinary         Retrieves a binary...\n  taskLocalVariables              Retrieves all...\n  taskVariable                    Retrieves a variable...\n  taskVariableBinary              Retrieves a binary...\n  taskVariables                   Retrieves all...\n  tasks                           Queries for tasks...\n  tasksCount                      Retrieves the number...\n  topicNames                      Queries for distinct...\n\n\n```\n\n## autocomplete\n\n_CCTL_COMPLETE=zsh_source cctl\n\n\n# TODO / Ideas\n\n- output column length in options or parameter (currently hard 40)\n\n- display\n\n  - list of strings\n  - list of objects\n  - object with keys\n  - object with one value\n\n- use template loader to save and load templates somewhere and let use use them or save some for default\n',
    'author': 'Jens Blawatt',
    'author_email': 'jens.blawatt@codecentric.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': None,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
