# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: chatie-grpc.proto
# plugin: python-betterproto
from dataclasses import dataclass
from typing import AsyncIterator, List, Optional

import betterproto
import grpclib


class ContactGender(betterproto.Enum):
    CONTACT_GENDER_UNSPECIFIED = 0
    CONTACT_GENDER_MALE = 1
    CONTACT_GENDER_FEMALE = 2


class ContactType(betterproto.Enum):
    CONTACT_TYPE_UNSPECIFIED = 0
    CONTACT_TYPE_PERSONAL = 1
    CONTACT_TYPE_OFFICIAL = 2


class EventType(betterproto.Enum):
    EVENT_TYPE_UNSPECIFIED = 0
    EVENT_TYPE_HEARTBEAT = 1
    EVENT_TYPE_MESSAGE = 2
    EVENT_TYPE_DONG = 3
    EVENT_TYPE_ERROR = 16
    EVENT_TYPE_FRIENDSHIP = 17
    EVENT_TYPE_ROOM_INVITE = 18
    EVENT_TYPE_ROOM_JOIN = 19
    EVENT_TYPE_ROOM_LEAVE = 20
    EVENT_TYPE_ROOM_TOPIC = 21
    EVENT_TYPE_SCAN = 22
    EVENT_TYPE_READY = 23
    EVENT_TYPE_RESET = 24
    EVENT_TYPE_LOGIN = 25
    EVENT_TYPE_LOGOUT = 26


class FriendshipType(betterproto.Enum):
    FRIENDSHIP_TYPE_UNSPECIFIED = 0
    FRIENDSHIP_TYPE_CONFIRM = 1
    FRIENDSHIP_TYPE_RECEIVE = 2
    FRIENDSHIP_TYPE_VERIFY = 3


class FriendshipSceneType(betterproto.Enum):
    FRIENDSHIP_SCENE_TYPE_UNSPECIFIED = 0
    FRIENDSHIP_SCENE_TYPE_QQ = 1
    FRIENDSHIP_SCENE_TYPE_EMAIL = 2
    FRIENDSHIP_SCENE_TYPE_WEIXIN = 3
    FRIENDSHIP_SCENE_TYPE_QQTBD = 12
    FRIENDSHIP_SCENE_TYPE_ROOM = 14
    FRIENDSHIP_SCENE_TYPE_PHONE = 15
    FRIENDSHIP_SCENE_TYPE_CARD = 17
    FRIENDSHIP_SCENE_TYPE_LOCATION = 18
    FRIENDSHIP_SCENE_TYPE_BOTTLE = 25
    FRIENDSHIP_SCENE_TYPE_SHAKING = 29
    FRIENDSHIP_SCENE_TYPE_QRCODE = 30


class MessageType(betterproto.Enum):
    MESSAGE_TYPE_UNSPECIFIED = 0
    MESSAGE_TYPE_ATTACHMENT = 1
    MESSAGE_TYPE_AUDIO = 2
    MESSAGE_TYPE_CONTACT = 3
    MESSAGE_TYPE_EMOTICON = 4
    MESSAGE_TYPE_IMAGE = 5
    MESSAGE_TYPE_TEXT = 6
    MESSAGE_TYPE_VIDEO = 7
    MESSAGE_TYPE_CHAT_HISTORY = 8
    MESSAGE_TYPE_LOCATION = 9
    MESSAGE_TYPE_MINI_PROGRAM = 10
    MESSAGE_TYPE_TRANSFER = 11
    MESSAGE_TYPE_RED_ENVELOPE = 12
    MESSAGE_TYPE_RECALLED = 13
    MESSAGE_TYPE_URL = 14


class ImageType(betterproto.Enum):
    IMAGE_TYPE_UNSPECIFIED = 0
    IMAGE_TYPE_THUMBNAIL = 1
    IMAGE_TYPE_HD = 2
    IMAGE_TYPE_ARTWORK = 3


@dataclass
class StartRequest(betterproto.Message):
    pass


@dataclass
class StartResponse(betterproto.Message):
    pass


@dataclass
class StopRequest(betterproto.Message):
    pass


@dataclass
class StopResponse(betterproto.Message):
    pass


@dataclass
class VersionRequest(betterproto.Message):
    pass


@dataclass
class VersionResponse(betterproto.Message):
    version: str = betterproto.string_field(1)


@dataclass
class LogoutRequest(betterproto.Message):
    pass


@dataclass
class LogoutResponse(betterproto.Message):
    pass


@dataclass
class DingRequest(betterproto.Message):
    data: str = betterproto.string_field(1)


@dataclass
class DingResponse(betterproto.Message):
    pass


@dataclass
class ContactListRequest(betterproto.Message):
    pass


@dataclass
class ContactListResponse(betterproto.Message):
    ids: List[str] = betterproto.string_field(1)


@dataclass
class ContactPayloadRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class ContactPayloadResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    gender: "ContactGender" = betterproto.enum_field(2)
    type: "ContactType" = betterproto.enum_field(3)
    name: str = betterproto.string_field(4)
    avatar: str = betterproto.string_field(5)
    address: str = betterproto.string_field(6)
    alias: str = betterproto.string_field(7)
    city: str = betterproto.string_field(8)
    friend: bool = betterproto.bool_field(9)
    province: str = betterproto.string_field(10)
    signature: str = betterproto.string_field(11)
    star: bool = betterproto.bool_field(12)
    weixin: str = betterproto.string_field(13)


@dataclass
class ContactSelfQrCodeRequest(betterproto.Message):
    pass


@dataclass
class ContactSelfQrCodeResponse(betterproto.Message):
    qrcode: str = betterproto.string_field(1)


@dataclass
class ContactSelfNameRequest(betterproto.Message):
    name: str = betterproto.string_field(1)


@dataclass
class ContactSelfNameResponse(betterproto.Message):
    pass


@dataclass
class ContactSelfSignatureRequest(betterproto.Message):
    signature: str = betterproto.string_field(1)


@dataclass
class ContactSelfSignatureResponse(betterproto.Message):
    pass


@dataclass
class ContactAliasRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    # nullable
    alias: Optional[str] = betterproto.message_field(2, wraps=betterproto.TYPE_STRING)


@dataclass
class ContactAliasResponse(betterproto.Message):
    alias: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class ContactAvatarRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    # nullable
    filebox: Optional[str] = betterproto.message_field(2, wraps=betterproto.TYPE_STRING)


@dataclass
class ContactAvatarResponse(betterproto.Message):
    filebox: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class EventRequest(betterproto.Message):
    pass


@dataclass
class EventResponse(betterproto.Message):
    type: "EventType" = betterproto.enum_field(1)
    # TODO: Huan(202002) consider to use a PB Map?
    payload: str = betterproto.string_field(2)


@dataclass
class FriendshipPayloadRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    payload: Optional[str] = betterproto.message_field(2, wraps=betterproto.TYPE_STRING)


@dataclass
class FriendshipPayloadResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    contact_id: str = betterproto.string_field(2)
    hello: str = betterproto.string_field(3)
    type: "FriendshipType" = betterproto.enum_field(4)
    stranger: str = betterproto.string_field(5)
    ticket: str = betterproto.string_field(6)
    scene: "FriendshipSceneType" = betterproto.enum_field(7)


@dataclass
class FriendshipSearchPhoneRequest(betterproto.Message):
    phone: str = betterproto.string_field(1)


@dataclass
class FriendshipSearchPhoneResponse(betterproto.Message):
    # nullable
    contact_id: Optional[str] = betterproto.message_field(
        1, wraps=betterproto.TYPE_STRING
    )


@dataclass
class FriendshipSearchWeixinRequest(betterproto.Message):
    weixin: str = betterproto.string_field(1)


@dataclass
class FriendshipSearchWeixinResponse(betterproto.Message):
    # nullable
    contact_id: Optional[str] = betterproto.message_field(
        1, wraps=betterproto.TYPE_STRING
    )


@dataclass
class FriendshipAddRequest(betterproto.Message):
    contact_id: str = betterproto.string_field(1)
    hello: str = betterproto.string_field(2)


@dataclass
class FriendshipAddResponse(betterproto.Message):
    pass


@dataclass
class FriendshipAcceptRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class FriendshipAcceptResponse(betterproto.Message):
    pass


@dataclass
class MessagePayloadRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessagePayloadResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    filename: str = betterproto.string_field(2)
    text: str = betterproto.string_field(3)
    timestamp: int = betterproto.uint64_field(4)
    type: "MessageType" = betterproto.enum_field(5)
    from_id: str = betterproto.string_field(6)
    room_id: str = betterproto.string_field(7)
    to_id: str = betterproto.string_field(8)
    mention_ids: List[str] = betterproto.string_field(9)


@dataclass
class MessageImageRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    type: "ImageType" = betterproto.enum_field(2)


@dataclass
class MessageImageResponse(betterproto.Message):
    filebox: str = betterproto.string_field(1)


@dataclass
class MessageContactRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessageContactResponse(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessageFileRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessageFileResponse(betterproto.Message):
    filebox: str = betterproto.string_field(1)


@dataclass
class MessageMiniProgramRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessageMiniProgramResponse(betterproto.Message):
    mini_program: str = betterproto.string_field(1)


@dataclass
class MessageUrlRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessageUrlResponse(betterproto.Message):
    url_link: str = betterproto.string_field(1)


@dataclass
class MessageSendContactRequest(betterproto.Message):
    conversation_id: str = betterproto.string_field(1)
    contact_id: str = betterproto.string_field(2)


@dataclass
class MessageSendContactResponse(betterproto.Message):
    # nullable
    id: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class MessageSendFileRequest(betterproto.Message):
    conversation_id: str = betterproto.string_field(1)
    filebox: str = betterproto.string_field(2)


@dataclass
class MessageSendFileResponse(betterproto.Message):
    id: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class MessageSendTextRequest(betterproto.Message):
    conversation_id: str = betterproto.string_field(1)
    text: str = betterproto.string_field(2)
    mentonal_ids: List[str] = betterproto.string_field(3)


@dataclass
class MessageSendTextResponse(betterproto.Message):
    id: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class MessageSendMiniProgramRequest(betterproto.Message):
    conversation_id: str = betterproto.string_field(1)
    mini_program: str = betterproto.string_field(2)


@dataclass
class MessageSendMiniProgramResponse(betterproto.Message):
    id: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class MessageSendUrlRequest(betterproto.Message):
    conversation_id: str = betterproto.string_field(1)
    url_link: str = betterproto.string_field(2)


@dataclass
class MessageSendUrlResponse(betterproto.Message):
    id: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class MessageRecallRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class MessageRecallResponse(betterproto.Message):
    success: bool = betterproto.bool_field(1)


@dataclass
class RoomListRequest(betterproto.Message):
    pass


@dataclass
class RoomListResponse(betterproto.Message):
    ids: List[str] = betterproto.string_field(1)


@dataclass
class RoomPayloadRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomPayloadResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    topic: str = betterproto.string_field(2)
    avatar: str = betterproto.string_field(3)
    owner_id: str = betterproto.string_field(4)
    admin_ids: List[str] = betterproto.string_field(5)
    member_ids: List[str] = betterproto.string_field(6)


@dataclass
class RoomAddRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    contact_id: str = betterproto.string_field(2)


@dataclass
class RoomAddResponse(betterproto.Message):
    pass


@dataclass
class RoomAvatarRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomAvatarResponse(betterproto.Message):
    filebox: str = betterproto.string_field(1)


@dataclass
class RoomCreateRequest(betterproto.Message):
    contact_ids: List[str] = betterproto.string_field(1)
    topic: str = betterproto.string_field(2)


@dataclass
class RoomCreateResponse(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomDelRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    contact_id: str = betterproto.string_field(2)


@dataclass
class RoomDelResponse(betterproto.Message):
    pass


@dataclass
class RoomQuitRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomQuitResponse(betterproto.Message):
    pass


@dataclass
class RoomTopicRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    topic: Optional[str] = betterproto.message_field(2, wraps=betterproto.TYPE_STRING)


@dataclass
class RoomTopicResponse(betterproto.Message):
    topic: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class RoomQrCodeRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomQrCodeResponse(betterproto.Message):
    qrcode: str = betterproto.string_field(1)


@dataclass
class RoomAnnounceRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    text: Optional[str] = betterproto.message_field(2, wraps=betterproto.TYPE_STRING)


@dataclass
class RoomAnnounceResponse(betterproto.Message):
    text: Optional[str] = betterproto.message_field(1, wraps=betterproto.TYPE_STRING)


@dataclass
class RoomInvitationPayloadRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    payload: Optional[str] = betterproto.message_field(2, wraps=betterproto.TYPE_STRING)


@dataclass
class RoomInvitationPayloadResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    inviter_id: str = betterproto.string_field(2)
    topic: str = betterproto.string_field(3)
    member_count: int = betterproto.uint32_field(4)
    member_ids: List[str] = betterproto.string_field(5)
    timestamp: int = betterproto.uint64_field(6)
    avatar: str = betterproto.string_field(7)
    invitation: str = betterproto.string_field(8)
    receiver_id: str = betterproto.string_field(9)


@dataclass
class RoomInvitationAcceptRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomInvitationAcceptResponse(betterproto.Message):
    pass


@dataclass
class RoomMemberPayloadRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    member_id: str = betterproto.string_field(2)


@dataclass
class RoomMemberPayloadResponse(betterproto.Message):
    id: str = betterproto.string_field(1)
    room_alias: str = betterproto.string_field(2)
    inviter_id: str = betterproto.string_field(3)
    avatar: str = betterproto.string_field(4)
    name: str = betterproto.string_field(5)


@dataclass
class RoomMemberListRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class RoomMemberListResponse(betterproto.Message):
    member_ids: List[str] = betterproto.string_field(1)


@dataclass
class TagContactAddRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    contact_id: str = betterproto.string_field(2)


@dataclass
class TagContactAddResponse(betterproto.Message):
    pass


@dataclass
class TagContactRemoveRequest(betterproto.Message):
    id: str = betterproto.string_field(1)
    contact_id: str = betterproto.string_field(2)


@dataclass
class TagContactRemoveResponse(betterproto.Message):
    pass


@dataclass
class TagContactDeleteRequest(betterproto.Message):
    id: str = betterproto.string_field(1)


@dataclass
class TagContactDeleteResponse(betterproto.Message):
    pass


@dataclass
class TagContactListRequest(betterproto.Message):
    contact_id: Optional[str] = betterproto.message_field(
        1, wraps=betterproto.TYPE_STRING
    )


@dataclass
class TagContactListResponse(betterproto.Message):
    ids: List[str] = betterproto.string_field(1)


class PuppetStub(betterproto.ServiceStub):
    async def start(self) -> StartResponse:
        """* Base"""

        request = StartRequest()

        return await self._unary_unary("/wechaty.Puppet/Start", request, StartResponse)

    async def stop(self) -> StopResponse:
        request = StopRequest()

        return await self._unary_unary("/wechaty.Puppet/Stop", request, StopResponse)

    async def logout(self) -> LogoutResponse:
        request = LogoutRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/Logout", request, LogoutResponse
        )

    async def ding(self, *, data: str = "") -> DingResponse:
        request = DingRequest()
        request.data = data

        return await self._unary_unary("/wechaty.Puppet/Ding", request, DingResponse)

    async def version(self) -> VersionResponse:
        request = VersionRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/Version", request, VersionResponse
        )

    async def event(self) -> AsyncIterator[EventResponse]:
        """* Event - Server Stream"""

        request = EventRequest()

        async for response in self._unary_stream(
            "/wechaty.Puppet/Event", request, EventResponse,
        ):
            yield response

    async def contact_self_qr_code(self) -> ContactSelfQrCodeResponse:
        """* Contact Self"""

        request = ContactSelfQrCodeRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/ContactSelfQRCode", request, ContactSelfQrCodeResponse
        )

    async def contact_self_name(self, *, name: str = "") -> ContactSelfNameResponse:
        request = ContactSelfNameRequest()
        request.name = name

        return await self._unary_unary(
            "/wechaty.Puppet/ContactSelfName", request, ContactSelfNameResponse
        )

    async def contact_self_signature(
        self, *, signature: str = ""
    ) -> ContactSelfSignatureResponse:
        request = ContactSelfSignatureRequest()
        request.signature = signature

        return await self._unary_unary(
            "/wechaty.Puppet/ContactSelfSignature",
            request,
            ContactSelfSignatureResponse,
        )

    async def contact_payload(self, *, id: str = "") -> ContactPayloadResponse:
        """* Contact"""

        request = ContactPayloadRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/ContactPayload", request, ContactPayloadResponse
        )

    async def contact_alias(
        self, *, id: str = "", alias: Optional[str] = None
    ) -> ContactAliasResponse:
        request = ContactAliasRequest()
        request.id = id
        if alias is not None:
            request.alias = alias

        return await self._unary_unary(
            "/wechaty.Puppet/ContactAlias", request, ContactAliasResponse
        )

    async def contact_avatar(
        self, *, id: str = "", filebox: Optional[str] = None
    ) -> ContactAvatarResponse:
        request = ContactAvatarRequest()
        request.id = id
        if filebox is not None:
            request.filebox = filebox

        return await self._unary_unary(
            "/wechaty.Puppet/ContactAvatar", request, ContactAvatarResponse
        )

    async def contact_list(self) -> ContactListResponse:
        request = ContactListRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/ContactList", request, ContactListResponse
        )

    async def friendship_payload(
        self, *, id: str = "", payload: Optional[str] = None
    ) -> FriendshipPayloadResponse:
        """* Friendship"""

        request = FriendshipPayloadRequest()
        request.id = id
        if payload is not None:
            request.payload = payload

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipPayload", request, FriendshipPayloadResponse
        )

    async def friendship_search_phone(
        self, *, phone: str = ""
    ) -> FriendshipSearchPhoneResponse:
        request = FriendshipSearchPhoneRequest()
        request.phone = phone

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipSearchPhone",
            request,
            FriendshipSearchPhoneResponse,
        )

    async def friendship_search_weixin(
        self, *, weixin: str = ""
    ) -> FriendshipSearchWeixinResponse:
        request = FriendshipSearchWeixinRequest()
        request.weixin = weixin

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipSearchWeixin",
            request,
            FriendshipSearchWeixinResponse,
        )

    async def friendship_add(
        self, *, contact_id: str = "", hello: str = ""
    ) -> FriendshipAddResponse:
        request = FriendshipAddRequest()
        request.contact_id = contact_id
        request.hello = hello

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipAdd", request, FriendshipAddResponse
        )

    async def friendship_accept(self, *, id: str = "") -> FriendshipAcceptResponse:
        request = FriendshipAcceptRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/FriendshipAccept", request, FriendshipAcceptResponse
        )

    async def message_payload(self, *, id: str = "") -> MessagePayloadResponse:
        """* Message"""

        request = MessagePayloadRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessagePayload", request, MessagePayloadResponse
        )

    async def message_contact(self, *, id: str = "") -> MessageContactResponse:
        request = MessageContactRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageContact", request, MessageContactResponse
        )

    async def message_file(self, *, id: str = "") -> MessageFileResponse:
        request = MessageFileRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageFile", request, MessageFileResponse
        )

    async def message_image(
        self, *, id: str = "", type: "ImageType" = 0
    ) -> MessageImageResponse:
        request = MessageImageRequest()
        request.id = id
        request.type = type

        return await self._unary_unary(
            "/wechaty.Puppet/MessageImage", request, MessageImageResponse
        )

    async def message_mini_program(self, *, id: str = "") -> MessageMiniProgramResponse:
        request = MessageMiniProgramRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageMiniProgram", request, MessageMiniProgramResponse
        )

    async def message_url(self, *, id: str = "") -> MessageUrlResponse:
        request = MessageUrlRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageUrl", request, MessageUrlResponse
        )

    async def message_send_contact(
        self, *, conversation_id: str = "", contact_id: str = ""
    ) -> MessageSendContactResponse:
        request = MessageSendContactRequest()
        request.conversation_id = conversation_id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendContact", request, MessageSendContactResponse
        )

    async def message_send_file(
        self, *, conversation_id: str = "", filebox: str = ""
    ) -> MessageSendFileResponse:
        request = MessageSendFileRequest()
        request.conversation_id = conversation_id
        request.filebox = filebox

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendFile", request, MessageSendFileResponse
        )

    async def message_send_text(
        self, *, conversation_id: str = "", text: str = "", mentonal_ids: List[str] = []
    ) -> MessageSendTextResponse:
        request = MessageSendTextRequest()
        request.conversation_id = conversation_id
        request.text = text
        request.mentonal_ids = mentonal_ids

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendText", request, MessageSendTextResponse
        )

    async def message_send_mini_program(
        self, *, conversation_id: str = "", mini_program: str = ""
    ) -> MessageSendMiniProgramResponse:
        request = MessageSendMiniProgramRequest()
        request.conversation_id = conversation_id
        request.mini_program = mini_program

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendMiniProgram",
            request,
            MessageSendMiniProgramResponse,
        )

    async def message_send_url(
        self, *, conversation_id: str = "", url_link: str = ""
    ) -> MessageSendUrlResponse:
        request = MessageSendUrlRequest()
        request.conversation_id = conversation_id
        request.url_link = url_link

        return await self._unary_unary(
            "/wechaty.Puppet/MessageSendUrl", request, MessageSendUrlResponse
        )

    async def message_recall(self, *, id: str = "") -> MessageRecallResponse:
        request = MessageRecallRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/MessageRecall", request, MessageRecallResponse
        )

    async def room_payload(self, *, id: str = "") -> RoomPayloadResponse:
        """* Room"""

        request = RoomPayloadRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomPayload", request, RoomPayloadResponse
        )

    async def room_list(self) -> RoomListResponse:
        request = RoomListRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/RoomList", request, RoomListResponse
        )

    async def room_add(self, *, id: str = "", contact_id: str = "") -> RoomAddResponse:
        request = RoomAddRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomAdd", request, RoomAddResponse
        )

    async def room_avatar(self, *, id: str = "") -> RoomAvatarResponse:
        request = RoomAvatarRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomAvatar", request, RoomAvatarResponse
        )

    async def room_create(
        self, *, contact_ids: List[str] = [], topic: str = ""
    ) -> RoomCreateResponse:
        request = RoomCreateRequest()
        request.contact_ids = contact_ids
        request.topic = topic

        return await self._unary_unary(
            "/wechaty.Puppet/RoomCreate", request, RoomCreateResponse
        )

    async def room_del(self, *, id: str = "", contact_id: str = "") -> RoomDelResponse:
        request = RoomDelRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomDel", request, RoomDelResponse
        )

    async def room_quit(self, *, id: str = "") -> RoomQuitResponse:
        request = RoomQuitRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomQuit", request, RoomQuitResponse
        )

    async def room_topic(
        self, *, id: str = "", topic: Optional[str] = None
    ) -> RoomTopicResponse:
        request = RoomTopicRequest()
        request.id = id
        if topic is not None:
            request.topic = topic

        return await self._unary_unary(
            "/wechaty.Puppet/RoomTopic", request, RoomTopicResponse
        )

    async def room_qr_code(self) -> RoomQrCodeResponse:
        request = RoomQrCodeRequest()

        return await self._unary_unary(
            "/wechaty.Puppet/RoomQRCode", request, RoomQrCodeResponse
        )

    async def room_announce(
        self, *, id: str = "", text: Optional[str] = None
    ) -> RoomAnnounceResponse:
        request = RoomAnnounceRequest()
        request.id = id
        if text is not None:
            request.text = text

        return await self._unary_unary(
            "/wechaty.Puppet/RoomAnnounce", request, RoomAnnounceResponse
        )

    async def room_member_payload(
        self, *, id: str = "", member_id: str = ""
    ) -> RoomMemberPayloadResponse:
        """* Room Member"""

        request = RoomMemberPayloadRequest()
        request.id = id
        request.member_id = member_id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomMemberPayload", request, RoomMemberPayloadResponse
        )

    async def room_member_list(self, *, id: str = "") -> RoomMemberListResponse:
        request = RoomMemberListRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomMemberList", request, RoomMemberListResponse
        )

    async def room_invitation_payload(
        self, *, id: str = "", payload: Optional[str] = None
    ) -> RoomInvitationPayloadResponse:
        """* Room Invitation"""

        request = RoomInvitationPayloadRequest()
        request.id = id
        if payload is not None:
            request.payload = payload

        return await self._unary_unary(
            "/wechaty.Puppet/RoomInvitationPayload",
            request,
            RoomInvitationPayloadResponse,
        )

    async def room_invitation_accept(
        self, *, id: str = ""
    ) -> RoomInvitationAcceptResponse:
        request = RoomInvitationAcceptRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/RoomInvitationAccept",
            request,
            RoomInvitationAcceptResponse,
        )

    async def tag_contact_add(
        self, *, id: str = "", contact_id: str = ""
    ) -> TagContactAddResponse:
        """* Tag"""

        request = TagContactAddRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactAdd", request, TagContactAddResponse
        )

    async def tag_contact_remove(
        self, *, id: str = "", contact_id: str = ""
    ) -> TagContactRemoveResponse:
        request = TagContactRemoveRequest()
        request.id = id
        request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactRemove", request, TagContactRemoveResponse
        )

    async def tag_contact_delete(self, *, id: str = "") -> TagContactDeleteResponse:
        request = TagContactDeleteRequest()
        request.id = id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactDelete", request, TagContactDeleteResponse
        )

    async def tag_contact_list(
        self, *, contact_id: Optional[str] = None
    ) -> TagContactListResponse:
        request = TagContactListRequest()
        if contact_id is not None:
            request.contact_id = contact_id

        return await self._unary_unary(
            "/wechaty.Puppet/TagContactList", request, TagContactListResponse
        )
