# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['dsfr',
 'dsfr.management',
 'dsfr.management.commands',
 'dsfr.migrations',
 'dsfr.templatetags',
 'dsfr.test']

package_data = \
{'': ['*'],
 'dsfr': ['fixtures/*',
          'static/dsfr/dist/*',
          'static/dsfr/dist/artwork/*',
          'static/dsfr/dist/artwork/background/*',
          'static/dsfr/dist/component/*',
          'static/dsfr/dist/component/accordion/*',
          'static/dsfr/dist/component/alert/*',
          'static/dsfr/dist/component/badge/*',
          'static/dsfr/dist/component/breadcrumb/*',
          'static/dsfr/dist/component/button/*',
          'static/dsfr/dist/component/callout/*',
          'static/dsfr/dist/component/card/*',
          'static/dsfr/dist/component/checkbox/*',
          'static/dsfr/dist/component/connect/*',
          'static/dsfr/dist/component/consent/*',
          'static/dsfr/dist/component/content/*',
          'static/dsfr/dist/component/display/*',
          'static/dsfr/dist/component/download/*',
          'static/dsfr/dist/component/follow/*',
          'static/dsfr/dist/component/footer/*',
          'static/dsfr/dist/component/form/*',
          'static/dsfr/dist/component/header/*',
          'static/dsfr/dist/component/highlight/*',
          'static/dsfr/dist/component/input/*',
          'static/dsfr/dist/component/link/*',
          'static/dsfr/dist/component/logo/*',
          'static/dsfr/dist/component/modal/*',
          'static/dsfr/dist/component/navigation/*',
          'static/dsfr/dist/component/notice/*',
          'static/dsfr/dist/component/pagination/*',
          'static/dsfr/dist/component/quote/*',
          'static/dsfr/dist/component/radio/*',
          'static/dsfr/dist/component/search/*',
          'static/dsfr/dist/component/select/*',
          'static/dsfr/dist/component/share/*',
          'static/dsfr/dist/component/sidemenu/*',
          'static/dsfr/dist/component/skiplink/*',
          'static/dsfr/dist/component/stepper/*',
          'static/dsfr/dist/component/summary/*',
          'static/dsfr/dist/component/tab/*',
          'static/dsfr/dist/component/table/*',
          'static/dsfr/dist/component/tag/*',
          'static/dsfr/dist/component/tile/*',
          'static/dsfr/dist/component/toggle/*',
          'static/dsfr/dist/component/translate/*',
          'static/dsfr/dist/component/upload/*',
          'static/dsfr/dist/core/*',
          'static/dsfr/dist/dsfr/*',
          'static/dsfr/dist/favicon/*',
          'static/dsfr/dist/fonts/*',
          'static/dsfr/dist/icons/buildings/*',
          'static/dsfr/dist/icons/business/*',
          'static/dsfr/dist/icons/communication/*',
          'static/dsfr/dist/icons/design/*',
          'static/dsfr/dist/icons/development/*',
          'static/dsfr/dist/icons/device/*',
          'static/dsfr/dist/icons/document/*',
          'static/dsfr/dist/icons/editor/*',
          'static/dsfr/dist/icons/finance/*',
          'static/dsfr/dist/icons/health/*',
          'static/dsfr/dist/icons/logo/*',
          'static/dsfr/dist/icons/map/*',
          'static/dsfr/dist/icons/media/*',
          'static/dsfr/dist/icons/others/*',
          'static/dsfr/dist/icons/system/*',
          'static/dsfr/dist/icons/user/*',
          'static/dsfr/dist/icons/weather/*',
          'static/dsfr/dist/legacy/*',
          'static/dsfr/dist/page/*',
          'static/dsfr/dist/page/response/*',
          'static/dsfr/dist/page/response/not-found/*',
          'static/dsfr/dist/page/response/unavailable/*',
          'static/dsfr/dist/pattern/*',
          'static/dsfr/dist/scheme/*',
          'static/dsfr/dist/utility/*',
          'static/dsfr/dist/utility/colors/*',
          'static/dsfr/dist/utility/icons/*',
          'static/dsfr/dist/utility/icons/icons-buildings/*',
          'static/dsfr/dist/utility/icons/icons-business/*',
          'static/dsfr/dist/utility/icons/icons-communication/*',
          'static/dsfr/dist/utility/icons/icons-design/*',
          'static/dsfr/dist/utility/icons/icons-development/*',
          'static/dsfr/dist/utility/icons/icons-device/*',
          'static/dsfr/dist/utility/icons/icons-document/*',
          'static/dsfr/dist/utility/icons/icons-editor/*',
          'static/dsfr/dist/utility/icons/icons-finance/*',
          'static/dsfr/dist/utility/icons/icons-health/*',
          'static/dsfr/dist/utility/icons/icons-logo/*',
          'static/dsfr/dist/utility/icons/icons-map/*',
          'static/dsfr/dist/utility/icons/icons-media/*',
          'static/dsfr/dist/utility/icons/icons-others/*',
          'static/dsfr/dist/utility/icons/icons-system/*',
          'static/dsfr/dist/utility/icons/icons-user/*',
          'static/dsfr/dist/utility/icons/icons-weather/*',
          'templates/django/forms/widgets/*',
          'templates/dsfr/*',
          'templates/dsfr/form_field_snippets/*']}

install_requires = \
['Django>=3.2.5,<4.0.0',
 'django-widget-tweaks>=1.4.12,<2.0.0',
 'requests>=2.26.0,<3.0.0']

setup_kwargs = {
    'name': 'django-dsfr',
    'version': '0.11.0',
    'description': 'Integrate the French government Design System into a Django app',
    'long_description': '.. image:: https://badge.fury.io/py/django-dsfr.svg\n    :target: https://pypi.org/project/django-dsfr/\n\n.. image:: https://github.com/entrepreneur-interet-general/django-dsfr/actions/workflows/django.yml/badge.svg\n    :target: https://github.com/entrepreneur-interet-general/django-dsfr/actions/workflows/django.yml\n\n.. image:: https://github.com/entrepreneur-interet-general/django-dsfr/actions/workflows/codeql-analysis.yml/badge.svg\n    :target: https://github.com/entrepreneur-interet-general/django-dsfr/actions/workflows/codeql-analysis.yml\n\n\n===========\nDjango-DSFR\n===========\n\nDjango-DSFR is a Django app to integrate the `French government Design System ("Système de design de l’État français") <https://www.systeme-de-design.gouv.fr/>`_.\n\n\nThis app was created as a part of `Open Collectivités <https://github.com/entrepreneur-interet-general/opencollectivites>`_ and is very much a work in progress. See the `documentation (in French) <https://entrepreneur-interet-general.github.io/django-dsfr/>`_ for details.\n\nDjango-DSFR (partly) implements the `version 1.7.2 of the DSFR <https://www.systeme-de-design.gouv.fr/a-propos/versions-du-dsfr/version-courante>`_.\n\nRequirements\n------------\nTested with Python 3.7 to 3.10 and Django 3.2.5 to 3.2.13. Per `vermin <https://github.com/netromdk/vermin>`_, it should work with Python >= 3.0, and it should work with old versions of Django too.\n\nQuick start\n-----------\n\n1. Install with :code:`pip install django-dsfr`.\n\n2. Add "widget_tweaks" and "dsfr" to INSTALLED_APPS in your settings.py like this, before the app you want to use it with::\n\n    INSTALLED_APPS = [\n        ...\n        "widget_tweaks"\n        "dsfr",\n        <your_app>\n    ]\n\n3. Add the following info in the TEMPLATES section in your settings.py so that the choice forms work::\n\n    TEMPLATES = [\n        {        \n            [...]\n            "DIRS": [\n                os.path.join(BASE_DIR, "dsfr/templates"),\n                os.path.join(BASE_DIR, "templates"),\n            ],\n        },\n    ]\n\n4. Add the following FORM_RENDERER in settings.py so that the choice forms work::\n\n    FORM_RENDERER = "django.forms.renderers.TemplatesSetting"\n\n5. (Optional) Add the context processor to your settings.py and create an instance of "DsfrConfig" in the admin panel::\n\n    TEMPLATES = [\n        {\n            [...]\n            "OPTIONS": {\n                "context_processors": [\n                    [...]\n                    "dsfr.context_processors.site_config",\n                ],\n            },\n        },\n    ]\n\n6. Include the tags in your base.html file (see example file at https://github.com/entrepreneur-interet-general/django-dsfr/blob/main/example_app/templates/example_app/base.html)\n\n7. Start the development server and visit http://127.0.0.1:8000/',
    'author': 'Sylvain Boissel',
    'author_email': 'sylvain.boissel@beta.gouv.fr',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/entrepreneur-interet-general/django-dsfr',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
