# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/00_core.ipynb (unless otherwise specified).

__all__ = ['notnone', 'last', 'lmap', 'allequal', 'np_local_seed', 'to_np', 'requires_grad', 'model_device',
           'get_files', 'get_image_files', 'image_extensions']

# Cell
from .imports import *

# Cell
def notnone(v): return v is not None

# Cell
def last(x): return next(reversed(x))

# Cell
def lmap(f, vs): return list(map(f, vs))

# Cell
def allequal(l): return l.count(l[0]) == len(l) if l else True

# Cell
@contextmanager
def np_local_seed(seed):
    state = np.random.get_state()
    np.random.seed(seed)
    try: yield
    finally: np.random.set_state(state)

# Cell
def to_np(t): return t.detach().cpu().numpy()

# Cell
def requires_grad(model, layer): return list(model.parameters())[layer].requires_grad

# Cell
def model_device(model): return first(model.parameters()).device

# Cell
def _get_files(p, fs, extensions=None):
    'From fastai'
    p = Path(p)
    res = [p/f for f in fs if not f.startswith('.')
           and ((not extensions) or f'.{f.split(".")[-1].lower()}' in extensions)]
    return res

# Cell
def get_files(path, extensions=None, recurse=True, folders=None, followlinks=True):
    "Get all the files in `path` with optional `extensions`, optionally with `recurse`, only in `folders`, if specified. From fastai"
    path = Path(path)
    folders=L(folders)
    extensions = setify(extensions)
    extensions = {e.lower() for e in extensions}
    if recurse:
        res = []
        for i,(p,d,f) in enumerate(os.walk(path, followlinks=followlinks)): # returns (dirpath, dirnames, filenames)
            if len(folders) !=0 and i==0: d[:] = [o for o in d if o in folders]
            else:                         d[:] = [o for o in d if not o.startswith('.')]
            if len(folders) !=0 and i==0 and '.' not in folders: continue
            res += _get_files(p, f, extensions)
    else:
        f = [o.name for o in os.scandir(path) if o.is_file()]
        res = _get_files(path, f, extensions)
    return L(res)

# Cell
image_extensions = set(k for k,v in mimetypes.types_map.items() if v.startswith('image/'))
def get_image_files(path, recurse=True, folders=None):
    "Get image files in `path` recursively, only in `folders`, if specified. From fastai"
    return get_files(path, extensions=image_extensions, recurse=recurse, folders=folders)