# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/02_data.core.ipynb (unless otherwise specified).

__all__ = ['open_img', 'show_img', 'grid', 'grid2', 'Category', 'CategoryMap']

# Cell
from ..imports import *
from ..core import *

# Cell
def open_img(fn, gray=False):
    if not os.path.exists(fn): raise ValueError(f'File {fn} does not exists')
    color = cv2.COLOR_BGR2GRAY if gray else cv2.COLOR_BGR2RGB
    return cv2.cvtColor(cv2.imread(str(fn)), color)

# Cell
def show_img(im, ax=None, **kwargs):
    if ax is None: fig,ax = plt.subplots(**kwargs)
    im = im.squeeze().copy()
    cmap = 'gray' if len(im.shape)==2 else None
    ax.imshow(im, cmap=cmap)
    ax.set_axis_off()
    return ax

# Cell
# TODO: Deprecate and update all usages to grid2
def grid(f, ims, figsize=None, **kwargs):
    figsize = figsize or [7*len(ims)]*2
    fig,axs = plt.subplots(nrows=len(ims), figsize=figsize, **kwargs)
    for fn,ax in zip(ims,axs): f(fn, ax=ax)
    plt.tight_layout()

# Cell
def grid2(fs, figsize=None, **kwargs):
    figsize = figsize or [7*len(fs)]*2
    fig,axs = plt.subplots(nrows=len(fs), figsize=figsize, **kwargs)
    for f,ax in zip(fs,axs): f(ax=ax)
    plt.tight_layout()

# Cell
@dataclass(frozen=True)
class Category:
    id: int=None
    name: str=None

# Cell
class CategoryMap:
    def __init__(self, cats, background=None):
        self.cats = cats.copy()
        if notnone(background): self.cats.pop(background)
        self.cats.insert(0, background or Category(name='background'))
        self.i2o = {i:o for i,o in enumerate(self.cats)}
        self.o2i = {o:i for i,o in enumerate(self.cats)}
        self.id2i = {o.id:i for i,o in enumerate(self.cats) if notnone(o.id)}
        self.id2o = {o.id:o for o in self.cats if notnone(o.id)}

    def __len__(self): return len(self.cats)
    def __repr__(self): return f'<{self.__class__.__name__} with {len(self)} categories>'