# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/07_data.load.ipynb (unless otherwise specified).

__all__ = ['Dataset', 'zip_collate', 'RCNNDataloader']

# Cell
from ..imports import *
from ..transforms import EmptyTransformer

# Cell
class Dataset:
    def __init__(self, records, tfms=None): self.records,self.tfms = records,tfms or EmptyTransformer()
    def __len__(self): return len(self.records)
    def __getitem__(self, i):
        im,rec = self.tfms(self.records[i])
        return im2tensor(im), rec.to_rcnn_target()

# Cell
def zip_collate(t): return tuple(zip(*t))

# Cell
RCNNDataloader = partial(DataLoader, collate_fn=zip_collate)