# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/08_models.ipynb (unless otherwise specified).

__all__ = ['RCNNModel', 'MaskRCNNModel', 'FastRCNNModel', 'show_pred', 'show_preds']

# Cell
from .imports import *
from .core import *
from .data.all import *

# Cell
# TODO: How to properly inject coco_evaluator? A callback/metric?
class RCNNModel(LightningModule):
    # TODO: coco_eval_fn temporary
    def __init__(self, n_class, metrics=None):
        super().__init__()
        self.m = self.create_model(n_class)
        self.metrics = metrics or []
        for metric in self.metrics: metric.register_model(self)

    def create_model(self, n_class, h=256): raise NotImplementedError

    def forward(self, x): return self.m(x)

    def training_step(self, b, b_idx):
        xb,yb = b
        losses = self.m(xb,list(yb))
        loss = sum(losses.values())
        return {'loss': loss, 'log': {'avg_loss': loss, **losses}}

    def validation_step(self, b, b_idx):
        xb,yb = b
        with torch.no_grad(): preds = self(xb)
        res = {}
        for metric in self.metrics:
            o = metric.step(xb, yb, preds)
            if notnone(o): res.update(o)
        return res

    def validation_epoch_end(self, outs):
        res = {}
        for metric in self.metrics:
            o = metric.end(outs)
            if notnone(o): res.update(o)
        return res

    def configure_optimizers(self):
        params = [p for p in self.parameters() if p.requires_grad]
        opt = torch.optim.SGD(params, 5e-3, momentum=0.9, weight_decay=0.0005)
        step_lr = torch.optim.lr_scheduler.StepLR(opt, step_size=3, gamma=0.1)
        return [opt], [step_lr]

# Cell
class MaskRCNNModel(RCNNModel):
    def create_model(self, n_class, h=256):
        model = torchvision.models.detection.maskrcnn_resnet50_fpn(pretrained=True)
        in_features = model.roi_heads.box_predictor.cls_score.in_features
        model.roi_heads.box_predictor = FastRCNNPredictor(in_features, n_class)
        in_features_mask = model.roi_heads.mask_predictor.conv5_mask.in_channels
        model.roi_heads.mask_predictor = MaskRCNNPredictor(in_features_mask, h, n_class)
        return model

# Cell
class FastRCNNModel(RCNNModel):
    def create_model(self, n_class, h=256):
        model = torchvision.models.detection.fasterrcnn_resnet50_fpn(pretrained=True)
        in_features = model.roi_heads.box_predictor.cls_score.in_features
        model.roi_heads.box_predictor = FastRCNNPredictor(in_features, n_class)
        return model

# Cell
@patch
def predict(self:RCNNModel, ims=None, rs=None):
    if bool(ims)==bool(rs): raise ValueError('You should either pass ims or rs')
    if notnone(rs): ims = [open_img(o.iinfo.fp) for o in rs]
    xs = [im2tensor(o).to(model_device(self)) for o in ims]
    self.eval()
    return ims, self(xs)

# Cell
def show_pred(im, pred, mask_thresh=.5, ax=None):
    # TODO: Implement mask and keypoint
    bboxes,masks,kpts = None,None,None
    if 'boxes' in pred: bboxes = [BBox.from_xyxy(*o) for o in pred['boxes']]
    if 'masks' in pred: masks = Mask(to_np((pred['masks']>.5).long()[:,0,:,:]))
    return show_annot(im, bboxes=bboxes, masks=masks, ax=ax)

# Cell
def show_preds(ims, preds, mask_thresh=.5):
    return grid2([partial(show_pred,im=im,pred=pred,mask_thresh=mask_thresh)
                  for im,pred in zip(ims,preds)])