# AUTOGENERATED! DO NOT EDIT! File to edit: nbs/06_transforms.ipynb (unless otherwise specified).

__all__ = ['Transformer', 'EmptyTransformer', 'AlbumentationTransformer']

# Cell
from .imports import *
from .core import *
from .data.all import *

# Cell
class Transformer:
    def __init__(self, tfms): self.tfms=tfms
    def __call__(self, record): return self.apply(record)

# Cell
class EmptyTransformer(Transformer):
    def __init__(self, tfms=None): super().__init__(tfms=tfms)
    def apply(self, record):
        im = open_img(record.iinfo.fp)
        return im, record

# Cell
class AlbumentationTransformer(Transformer):
    def __init__(self, tfms):
        self.bbox_params=A.BboxParams(format='pascal_voc', label_fields=['oids'])
        super().__init__(tfms=A.Compose(tfms, bbox_params=self.bbox_params))

    def apply(self, r):
        d = self.tfms(
            image=open_img(r.iinfo.fp),
            oids=r.annot.oids,
            bboxes=[o.xyxy for o in r.annot.bboxes] if notnone(r.annot.bboxes) else None,
            masks=Mask.from_segs(r.annot.segs,r.iinfo.h,r.iinfo.w).data if notnone(r.annot.segs) else None,
            keypoints=r.annot.kpts if notnone(r.annot.kpts) else None,
        )
        # TODO: Don't use dicts
        h,w,_ = d['image'].shape
        iinfo = dict(h=h, w=w)
        annot = dict(
            oids=d['oids'],
            bboxes=[BBox.from_xyxy(*o) for o in d['bboxes']] if notnone(d['bboxes']) else None,
            segs=Mask(np.stack(d['masks'])) if notnone(d['masks']) else None,
        #     kpts=res['keypoints'] # TODO
        )
        return d['image'], r.new(iinfo=iinfo, annot=annot)