from collections import namedtuple

TimeSeries = namedtuple('TimeSeries', 'name, output_var, where, repoption, restrictoption, operation')
ReportedMap = namedtuple('ReportedMap', 'name, output_var, unit, end, steps, all, restrictoption, monthly, yearly')

default_options = {'EnKF': False,
                   'InitLisflood': True,
                   'InitLisfloodwithoutSplit': False,
                   'MonteCarlo': False,
                   'SplitRouting': False,
                   'TemperatureInKelvin': False,
                   'TransLoss': False,
                   'TransientLandUseChange': False,
                   'TransientWaterDemandChange': False,
                   'drainedIrrigation': False,
                   'dynamicWave': False,
                   'gridSizeUserDefined': False,
                   'groundwaterSmooth': False,
                   'indicator': False,
                   'inflow': False,
                   'nonInit': False,
                   'openwaterevapo': True,
                   'readNetcdfStack': False,
                   'repAverageDis': False,
                   'repBal1': False,
                   'repChanCrossSectionMaps': False,
                   'repCumInterCeptionMaps': False,
                   'repDSLRMaps': False,
                   'repDischargeMaps': False,
                   'repDischargeTs': True,
                   'repE2O1': False,
                   'repE2O2': False,
                   'repESActMaps': False,
                   'repESRefMaps': False,
                   'repETRefMaps': False,
                   'repEWIntMaps': False,
                   'repEWRefMaps': False,
                   'repEndMaps': True,
                   'repFastRunoffMaps': False,
                   'repFrostIndexMaps': False,
                   'repGwLossMaps': False,
                   'repGwPercUZLZMaps': False,
                   'repInfiltrationMaps': False,
                   'repInterceptionMaps': False,
                   'repInternalCom': False,
                   'repLZAvInflowMap': False,
                   'repLZAvInflowSites': False,
                   'repLZAvInflowUpsGauges': False,
                   'repLZMaps': False,
                   'repLZOutflowMaps': False,
                   'repLeafDrainageMaps': False,
                   'repMBTs': False,
                   'repMeteoUpsGauges': False,
                   'repPFForestMaps': False,
                   'repPFMaps': False,
                   'repPFSites': False,
                   'repPFUpsGauges': False,
                   'repPercolationMaps': False,
                   'repRWS': False,
                   'repPrefFlowMaps': False,
                   'repRainMaps': False,
                   'repRateSites': False,
                   'repRateUpsGauges': False,
                   'repSeepSubToGWMaps': False,
                   'repSnowCoverMaps': False,
                   'repSnowMaps': False,
                   'repSnowMeltMaps': False,
                   'repStateMaps': True,
                   'repStateSites': False,
                   'repStateUpsGauges': False,
                   'repStressDays': False,
                   'repSurfaceRunoffMaps': False,
                   'repTaMaps': False,
                   'repTavgMaps': False,
                   'repThetaForestMaps': False,
                   'repThetaIrrigationMaps': False,
                   'repThetaMaps': False,
                   'repTotalAbs': False,
                   'repTotalRunoffMaps': False,
                   'repTotalWUse': False,
                   'repUZMaps': False,
                   'repUZOutflowMaps': False,
                   'repWIndex': False,
                   'repWaterDepthMaps': False,
                   'repWaterLevelMaps': False,
                   'repWaterLevelTs': False,
                   'reportedmaps': {'AreaTotalAbstractionFromGroundwaterM3': ReportedMap(
                       name='AreaTotalAbstractionFromGroundwaterM3',
                       output_var='AreaTotalAbstractionFromGroundwaterM3', unit='m3', end=[],
                       steps=['repTotalAbs'], all=[], restrictoption=['nonInit', 'wateruse'], monthly=False,
                       yearly=False),
                       'AreaTotalAbstractionFromSurfaceWaterM3': ReportedMap(
                           name='AreaTotalAbstractionFromSurfaceWaterM3',
                           output_var='AreaTotalAbstractionFromSurfaceWaterM3', unit='m3', end=[],
                           steps=['repTotalAbs'], all=[], restrictoption=['nonInit', 'wateruse'],
                           monthly=False, yearly=False),
                       'AreatotalIrrigationUseM3': ReportedMap(name='AreatotalIrrigationUseM3',
                                                               output_var='AreatotalIrrigationUseM3',
                                                               unit='m3', end=[],
                                                               steps=['repTotalAbs'], all=[],
                                                               restrictoption=['nonInit', 'wateruse'],
                                                               monthly=False, yearly=False),
                       'AreatotalWaterAbstractedfromLakesReservoirsM3': ReportedMap(
                           name='AreatotalWaterAbstractedfromLakesReservoirsM3',
                           output_var='AreatotalWaterAbstractedfromLakesReservoirsM3', unit='m3',
                           end=[], steps=['repTotalAbs'], all=[],
                           restrictoption=['nonInit', 'wateruse'], monthly=False, yearly=False),
                       'AvgDis': ReportedMap(name='AvgDis', output_var='avgdis', unit='m3/s',
                                             end=['InitLisflood'], steps=[], all=[],
                                             restrictoption=['SplitRouting'], monthly=False,
                                             yearly=False),
                       'ChSideEnd': ReportedMap(name='ChSideEnd', output_var='Sideflow1Chan', unit='m',
                                                end=['repEndMaps'], steps=[], all=[],
                                                restrictoption=['nonInit', 'SplitRouting'],
                                                monthly=False, yearly=False),
                       'ChSideState': ReportedMap(name='ChSideState', output_var='Sideflow1Chan',
                                                  unit='m', end=[], steps=['repStateMaps'],
                                                  all=[], restrictoption=['nonInit', 'SplitRouting'],
                                                  monthly=False, yearly=False),
                       'ChanCrossSectionEnd': ReportedMap(name='ChanCrossSectionEnd',
                                                          output_var='TotalCrossSectionArea', unit='m2',
                                                          end=['repEndMaps'], steps=[], all=[],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'ChanCrossSectionMaps': ReportedMap(name='ChanCrossSectionMaps',
                                                           output_var='TotalCrossSectionArea',
                                                           unit='m2', end=[], steps=[],
                                                           all=['repChanCrossSectionMaps'],
                                                           restrictoption=['nonInit'], monthly=False,
                                                           yearly=False),
                       'ChanCrossSectionState': ReportedMap(name='ChanCrossSectionState',
                                                            output_var='TotalCrossSectionArea',
                                                            unit='m2', end=[],
                                                            steps=['repStateMaps'], all=[],
                                                            restrictoption=['nonInit'], monthly=False,
                                                            yearly=False),
                       'ChanQEnd': ReportedMap(name='ChanQEnd', output_var='ChanQ', unit='m3/s',
                                               end=['repEndMaps'], steps=[], all=[],
                                               restrictoption=['nonInit'], monthly=False, yearly=False),
                       'ChanQState': ReportedMap(name='ChanQState', output_var='ChanQ', unit='m3/s',
                                                 end=[], steps=['repStateMaps'], all=[],
                                                 restrictoption=['nonInit'], monthly=False,
                                                 yearly=False),
                       'CrossSection2End': ReportedMap(name='CrossSection2End',
                                                       output_var='CrossSection2Area', unit='m',
                                                       end=['repEndMaps'], steps=[], all=[],
                                                       restrictoption=['nonInit', 'SplitRouting'],
                                                       monthly=False, yearly=False),
                       'CrossSection2State': ReportedMap(name='CrossSection2State',
                                                         output_var='CrossSection2Area', unit='m',
                                                         end=[], steps=['repStateMaps'], all=[],
                                                         restrictoption=['nonInit', 'SplitRouting'],
                                                         monthly=False, yearly=False),
                       'CumIntSealedEnd': ReportedMap(name='CumIntSealedEnd',
                                                      output_var='CumInterSealed', unit='mm',
                                                      end=['repEndMaps'], steps=[], all=[],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'CumIntSealedState': ReportedMap(name='CumIntSealedState',
                                                        output_var='CumInterSealed', unit='mm',
                                                        end=[], steps=['repStateMaps'], all=[],
                                                        restrictoption=['nonInit'], monthly=False,
                                                        yearly=False),
                       'CumInterceptionEnd': ReportedMap(name='CumInterceptionEnd',
                                                         output_var='CumInterception[0]', unit='mm',
                                                         end=['repEndMaps'], steps=[], all=[],
                                                         restrictoption=['nonInit'], monthly=False,
                                                         yearly=False),
                       'CumInterceptionForestEnd': ReportedMap(name='CumInterceptionForestEnd',
                                                               output_var='CumInterception[1]',
                                                               unit='mm', end=['repEndMaps'],
                                                               steps=[], all=[],
                                                               restrictoption=['nonInit'], monthly=False,
                                                               yearly=False),
                       'CumInterceptionForestMaps': ReportedMap(name='CumInterceptionForestMaps',
                                                                output_var='CumInterception[1]',
                                                                unit='m', end=[], steps=[],
                                                                all=['repCumInterCeptionMaps'],
                                                                restrictoption=['nonInit'],
                                                                monthly=False, yearly=False),
                       'CumInterceptionForestState': ReportedMap(name='CumInterceptionForestState',
                                                                 output_var='CumInterception[1]',
                                                                 unit='mm', end=[],
                                                                 steps=['repStateMaps'], all=[],
                                                                 restrictoption=['nonInit'],
                                                                 monthly=False, yearly=False),
                       'CumInterceptionIrrigationEnd': ReportedMap(name='CumInterceptionIrrigationEnd',
                                                                   output_var='CumInterception[2]',
                                                                   unit='mm', end=['repEndMaps'],
                                                                   steps=[], all=[],
                                                                   restrictoption=['nonInit'],
                                                                   monthly=False, yearly=False),
                       'CumInterceptionIrrigationState': ReportedMap(
                           name='CumInterceptionIrrigationState', output_var='CumInterception[2]',
                           unit='mm', end=[], steps=['repStateMaps'], all=[],
                           restrictoption=['nonInit'], monthly=False, yearly=False),
                       'CumInterceptionMaps': ReportedMap(name='CumInterceptionMaps',
                                                          output_var='CumInterception[0]', unit='m',
                                                          end=[], steps=[],
                                                          all=['repCumInterCeptionMaps'],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'CumInterceptionState': ReportedMap(name='CumInterceptionState',
                                                           output_var='CumInterception[0]', unit='mm',
                                                           end=[], steps=['repStateMaps'], all=[],
                                                           restrictoption=['nonInit'], monthly=False,
                                                           yearly=False),
                       'DSLREnd': ReportedMap(name='DSLREnd', output_var='DSLR[0]', unit='-',
                                              end=['repEndMaps'], steps=[], all=[],
                                              restrictoption=['nonInit'], monthly=False, yearly=False),
                       'DSLRForestEnd': ReportedMap(name='DSLRForestEnd', output_var='DSLR[1]',
                                                    unit='-', end=['repEndMaps'], steps=[],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'DSLRForestMaps': ReportedMap(name='DSLRForestMaps', output_var='DSLR[1]',
                                                     unit='', end=[], steps=[],
                                                     all=['repDSLRMaps'], restrictoption=['nonInit'],
                                                     monthly=False, yearly=False),
                       'DSLRForestState': ReportedMap(name='DSLRForestState', output_var='DSLR[1]',
                                                      unit='-', end=[], steps=['repStateMaps'],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'DSLRIrrigationEnd': ReportedMap(name='DSLRIrrigationEnd', output_var='DSLR[2]',
                                                        unit='-', end=['repEndMaps'], steps=[],
                                                        all=[], restrictoption=['nonInit'],
                                                        monthly=False, yearly=False),
                       'DSLRIrrigationState': ReportedMap(name='DSLRIrrigationState',
                                                          output_var='DSLR[2]', unit='-', end=[],
                                                          steps=['repStateMaps'], all=[],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'DSLRMaps': ReportedMap(name='DSLRMaps', output_var='DSLR[0]', unit='',
                                               end=[], steps=[], all=['repDSLRMaps'],
                                               restrictoption=['nonInit'], monthly=False, yearly=False),
                       'DSLRState': ReportedMap(name='DSLRState', output_var='DSLR[0]', unit='-',
                                                end=[], steps=['repStateMaps'], all=[],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'DirectRunoffMaps': ReportedMap(name='DirectRunoffMaps',
                                                       output_var='DirectRunoff', unit='mm', end=[],
                                                       steps=[], all=['repSurfaceRunoffMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'DischargeEnd': ReportedMap(name='DischargeEnd', output_var='ChanQAvg',
                                                   unit='m3/s', end=['repEndMaps'], steps=[],
                                                   all=[], restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'DischargeMaps': ReportedMap(name='DischargeMaps', output_var='ChanQAvg',
                                                    unit='m3/s', end=[], steps=[],
                                                    all=['repDischargeMaps'], restrictoption=[],
                                                    monthly=False, yearly=False),
                       'DomesticConsumptiveUse': ReportedMap(name='DomesticConsumptiveUse',
                                                             output_var='DomesticConsumptiveUseMM',
                                                             unit='mm', end=[],
                                                             steps=['repTotalAbs'], all=[],
                                                             restrictoption=['nonInit', 'wateruse'],
                                                             monthly=False, yearly=False),
                       'EFlowIndicator': ReportedMap(name='EFlowIndicator', output_var='EFlowIndicator',
                                                     unit='-', end=[], steps=['repTotalAbs'],
                                                     all=[], restrictoption=['nonInit', 'wateruse',
                                                                             'indicator'],
                                                     monthly=False, yearly=False),
                       'ESActForestMaps': ReportedMap(name='ESActForestMaps', output_var='ESAct[1]',
                                                      unit='mm', end=[], steps=[],
                                                      all=['repESActMaps'], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'ESActMaps': ReportedMap(name='ESActMaps', output_var='ESActPixel', unit='mm',
                                                end=[], steps=[], all=['repE2O1'],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'ESRefMapsOut': ReportedMap(name='ESRefMapsOut', output_var='ESRef', unit='mm',
                                                   end=[], steps=[], all=['repESRefMaps'],
                                                   restrictoption=[], monthly=False, yearly=False),
                       'ETActMaps': ReportedMap(name='ETActMaps',
                                                output_var='ESActPixel+self.var.TaPixel+self.var.TaInterceptionAll+self.var.EvaAddM3*self.var.M3toMM',
                                                unit='mm', end=[], steps=[], all=['repE2O1'],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'ETRefMapsOut': ReportedMap(name='ETRefMapsOut', output_var='ETRef', unit='mm',
                                                   end=[], steps=[], all=['repETRefMaps'],
                                                   restrictoption=[], monthly=False, yearly=False),
                       'EWIntForestMaps': ReportedMap(name='EWIntForestMaps',
                                                      output_var='TaInterception[1]', unit='mm',
                                                      end=[], steps=[], all=['repEWIntMaps'],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'EWIntMaps': ReportedMap(name='EWIntMaps', output_var='TaInterceptionAll',
                                                unit='mm', end=[], steps=[], all=['repE2O1'],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'EWRefMapsOut': ReportedMap(name='EWRefMapsOut', output_var='EWRef', unit='mm',
                                                   end=[], steps=[], all=['repEWRefMaps'],
                                                   restrictoption=[], monthly=False, yearly=False),
                       'EWater': ReportedMap(name='EWater', output_var='EvaAddM3*self.var.M3toMM',
                                             unit='mm', end=[], steps=[], all=['repE2O1'],
                                             restrictoption=['nonInit'], monthly=False, yearly=False),
                       'EnergyConsumptiveUse': ReportedMap(name='EnergyConsumptiveUse',
                                                           output_var='EnergyConsumptiveUseMM',
                                                           unit='mm', end=[], steps=['repTotalAbs'],
                                                           all=[],
                                                           restrictoption=['nonInit', 'wateruse'],
                                                           monthly=False, yearly=False),
                       'FalkenmarkM3Capita1': ReportedMap(name='FalkenmarkM3Capita1',
                                                          output_var='FalkenmarkM3Capita1',
                                                          unit='M3Capita', end=[],
                                                          steps=['repWIndex'], all=[],
                                                          restrictoption=['nonInit', 'wateruse',
                                                                          'indicator'], monthly=False,
                                                          yearly=False),
                       'FalkenmarkM3Capita2': ReportedMap(name='FalkenmarkM3Capita2',
                                                          output_var='FalkenmarkM3Capita2',
                                                          unit='M3Capita', end=[],
                                                          steps=['repWIndex'], all=[],
                                                          restrictoption=['nonInit', 'wateruse',
                                                                          'indicator'], monthly=False,
                                                          yearly=False),
                       'FalkenmarkM3Capita3': ReportedMap(name='FalkenmarkM3Capita3',
                                                          output_var='FalkenmarkM3Capita3',
                                                          unit='M3Capita', end=[],
                                                          steps=['repWIndex'], all=[],
                                                          restrictoption=['nonInit', 'wateruse',
                                                                          'indicator'], monthly=False,
                                                          yearly=False),
                       'FastRunoffMaps': ReportedMap(name='FastRunoffMaps',
                                                     output_var='SurfaceRunoff+self.var.UZOutflowPixel',
                                                     unit='mm', end=[], steps=[], all=['repE2O1'],
                                                     restrictoption=['nonInit'], monthly=False,
                                                     yearly=False),
                       'FractionAbstractedFromChannels': ReportedMap(
                           name='FractionAbstractedFromChannels',
                           output_var='FractionAbstractedFromChannels', unit='-', end=[],
                           steps=['repTotalAbs'], all=[], restrictoption=['nonInit', 'wateruse'],
                           monthly=False, yearly=False),
                       'FrostIndexEnd': ReportedMap(name='FrostIndexEnd', output_var='FrostIndex',
                                                    unit='-', end=['repEndMaps'], steps=[],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'FrostIndexMaps': ReportedMap(name='FrostIndexMaps', output_var='FrostIndex',
                                                     unit='-', end=[], steps=[],
                                                     all=['repFrostIndexMaps'],
                                                     restrictoption=['nonInit'], monthly=False,
                                                     yearly=False),
                       'FrostIndexState': ReportedMap(name='FrostIndexState', output_var='FrostIndex',
                                                      unit='-', end=[], steps=['repStateMaps'],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'GwLossMaps': ReportedMap(name='GwLossMaps', output_var='GwLossPixel',
                                                 unit='mm', end=[], steps=[], all=['repE2O2'],
                                                 restrictoption=['nonInit'], monthly=False,
                                                 yearly=False),
                       'GwPercUZLZForestMaps': ReportedMap(name='GwPercUZLZForestMaps',
                                                           output_var='GwPercUZLZ[1]', unit='mm',
                                                           end=[], steps=[],
                                                           all=['repGwPercUZLZMaps'],
                                                           restrictoption=['nonInit'], monthly=False,
                                                           yearly=False),
                       'GwPercUZLZMaps': ReportedMap(name='GwPercUZLZMaps',
                                                     output_var='GwPercUZLZPixel', unit='mm', end=[],
                                                     steps=[], all=['repE2O2'],
                                                     restrictoption=['nonInit'], monthly=False,
                                                     yearly=False),
                       'IndustrialConsumptiveUse': ReportedMap(name='IndustrialConsumptiveUse',
                                                               output_var='IndustrialConsumptiveUseMM',
                                                               unit='mm', end=[],
                                                               steps=['repTotalAbs'], all=[],
                                                               restrictoption=['nonInit', 'wateruse'],
                                                               monthly=False, yearly=False),
                       'InfiltrationForestMaps': ReportedMap(name='InfiltrationForestMaps',
                                                             output_var='Infiltration[1]', unit='mm',
                                                             end=[], steps=[],
                                                             all=['repInfiltrationMaps'],
                                                             restrictoption=['nonInit'], monthly=False,
                                                             yearly=False),
                       'InfiltrationMaps': ReportedMap(name='InfiltrationMaps',
                                                       output_var='Infiltration[0]', unit='mm',
                                                       end=[], steps=[],
                                                       all=['repInfiltrationMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'InterceptionForestMaps': ReportedMap(name='InterceptionForestMaps',
                                                             output_var='Interception[1]', unit='mm',
                                                             end=[], steps=[],
                                                             all=['repInterceptionMaps'],
                                                             restrictoption=['nonInit'], monthly=False,
                                                             yearly=False),
                       'InterceptionMaps': ReportedMap(name='InterceptionMaps',
                                                       output_var='Interception[0]', unit='mm',
                                                       end=[], steps=[],
                                                       all=['repInterceptionMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'IrrigationWaterAbstraction': ReportedMap(name='IrrigationWaterAbstraction',
                                                                 output_var='IrrigationWaterAbstractionM3*self.var.M3toMM + self.var.PaddyRiceWaterAbstractionFromSurfaceWaterM3*self.var.M3toMM',
                                                                 unit='mm', end=[],
                                                                 steps=['repTotalAbs'], all=[],
                                                                 restrictoption=['nonInit', 'wateruse'],
                                                                 monthly=False, yearly=False),
                       'LZAvInflowMap': ReportedMap(name='LZAvInflowMap', output_var='LZAvInflow',
                                                    unit='mm',
                                                    end=['InitLisflood', 'repLZAvInflowMap'],
                                                    steps=[], all=[], restrictoption=[],
                                                    monthly=False, yearly=False),
                       'LZEnd': ReportedMap(name='LZEnd', output_var='LZ', unit='mm',
                                            end=['repEndMaps'], steps=[], all=[],
                                            restrictoption=['nonInit'], monthly=False, yearly=False),
                       'LZMaps': ReportedMap(name='LZMaps', output_var='LZ', unit='mm', end=[],
                                             steps=[], all=['repE2O2'], restrictoption=['nonInit'],
                                             monthly=False, yearly=False),
                       'LZOutflowMaps': ReportedMap(name='LZOutflowMaps',
                                                    output_var='LZOutflowToChannelPixel', unit='mm',
                                                    end=[], steps=[], all=['repE2O1'],
                                                    restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'LZState': ReportedMap(name='LZState', output_var='LZ', unit='mm', end=[],
                                              steps=['repStateMaps'], all=[],
                                              restrictoption=['nonInit', 'repLZMaps'], monthly=False, yearly=False),
                       'LakeAbstractionM3': ReportedMap(name='LakeAbstractionM3',
                                                        output_var='LakeAbstractionM3', unit='m3',
                                                        end=[], steps=['repTotalAbs'], all=[],
                                                        restrictoption=['nonInit', 'wateruse',
                                                                        'simulateLakes'], monthly=False,
                                                        yearly=False),
                       'LakeLevelEnd': ReportedMap(name='LakeLevelEnd', output_var='LakeLevel',
                                                   unit='m', end=['repEndMaps'], steps=[], all=[],
                                                   restrictoption=['nonInit', 'simulateLakes'],
                                                   monthly=False, yearly=False),
                       'LakeLevelState': ReportedMap(name='LakeLevelState', output_var='LakeLevel',
                                                     unit='m', end=[], steps=['repStateMaps'],
                                                     all=[],
                                                     restrictoption=['nonInit', 'simulateLakes'],
                                                     monthly=False, yearly=False),
                       'LakeStorageM3': ReportedMap(name='LakeStorageM3', output_var='LakeStorageM3',
                                                    unit='m3', end=[], steps=['repTotalAbs'],
                                                    all=[], restrictoption=['nonInit', 'wateruse',
                                                                            'simulateLakes'],
                                                    monthly=False, yearly=False),
                       'LeafDrainageForestMaps': ReportedMap(name='LeafDrainageForestMaps',
                                                             output_var='LeafDrainage[1]', unit='mm',
                                                             end=[], steps=[],
                                                             all=['repLeafDrainageMaps'],
                                                             restrictoption=['nonInit'], monthly=False,
                                                             yearly=False),
                       'LeafDrainageMaps': ReportedMap(name='LeafDrainageMaps',
                                                       output_var='LeafDrainage[0]', unit='mm',
                                                       end=[], steps=[],
                                                       all=['repLeafDrainageMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'LivestockConsumptiveUse': ReportedMap(name='LivestockConsumptiveUse',
                                                              output_var='LivestockConsumptiveUseMM',
                                                              unit='mm', end=[],
                                                              steps=['repTotalAbs'], all=[],
                                                              restrictoption=['nonInit', 'wateruse'],
                                                              monthly=False, yearly=False),
                       'MonthETactMM': ReportedMap(name='MonthETactMM', output_var='MonthETactMM',
                                                   unit='mm', end=[], steps=['repWIndex'], all=[],
                                                   restrictoption=['nonInit', 'wateruse', 'indicator'],
                                                   monthly=False, yearly=False),
                       'MonthETdifMM': ReportedMap(name='MonthETdifMM', output_var='MonthETdifMM',
                                                   unit='mm', end=[], steps=['repWIndex'], all=[],
                                                   restrictoption=['nonInit', 'wateruse', 'indicator'],
                                                   monthly=False, yearly=False),
                       'MonthETpotMM': ReportedMap(name='MonthETpotMM', output_var='MonthETpotMM',
                                                   unit='mm', end=[], steps=['repWIndex'], all=[],
                                                   restrictoption=['nonInit', 'wateruse', 'indicator'], monthly=False,
                                                   yearly=False),
                       'OFDirectEnd': ReportedMap(name='OFDirectEnd', output_var='OFM3Direct',
                                                  unit='m3', end=['repEndMaps'], steps=[], all=[],
                                                  restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'OFDirectMaps': ReportedMap(name='OFDirectMaps', output_var='OFM3Direct',
                                                   unit='m3', end=[], steps=[],
                                                   all=['repWaterDepthMaps'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'OFDirectState': ReportedMap(name='OFDirectState', output_var='OFM3Direct',
                                                    unit='m3', end=[], steps=['repStateMaps'],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'OFForestEnd': ReportedMap(name='OFForestEnd', output_var='OFM3Forest',
                                                  unit='m3', end=['repEndMaps'], steps=[], all=[],
                                                  restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'OFForestMaps': ReportedMap(name='OFForestMaps', output_var='OFM3Forest',
                                                   unit='m3', end=[], steps=[],
                                                   all=['repWaterDepthMaps'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'OFForestState': ReportedMap(name='OFForestState', output_var='OFM3Forest',
                                                    unit='m3', end=[], steps=['repStateMaps'],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'OFOtherEnd': ReportedMap(name='OFOtherEnd', output_var='OFM3Other', unit='m3',
                                                 end=['repEndMaps'], steps=[], all=[],
                                                 restrictoption=['nonInit'], monthly=False,
                                                 yearly=False),
                       'OFOtherMaps': ReportedMap(name='OFOtherMaps', output_var='OFM3Other',
                                                  unit='m3', end=[], steps=[],
                                                  all=['repWaterDepthMaps'], restrictoption=['nonInit'],
                                                  monthly=False, yearly=False),
                       'OFOtherState': ReportedMap(name='OFOtherState', output_var='OFM3Other',
                                                   unit='m3', end=[], steps=['repStateMaps'],
                                                   all=[], restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'PF1ForestMaps': ReportedMap(name='PF1ForestMaps', output_var='pF0[1]',
                                                    unit='mm', end=[], steps=[],
                                                    all=['repPFForestMaps'],
                                                    restrictoption=['nonInit', 'simulatePF'],
                                                    monthly=False, yearly=False),
                       'PF1Maps': ReportedMap(name='PF1Maps', output_var='pF0[0]', unit='mm',
                                              end=[], steps=[], all=['repPFMaps'],
                                              restrictoption=['nonInit', 'simulatePF'], monthly=False,
                                              yearly=False),
                       'PF2ForestMaps': ReportedMap(name='PF2ForestMaps', output_var='pF1[1]',
                                                    unit='mm', end=[], steps=[],
                                                    all=['repPFForestMaps'],
                                                    restrictoption=['nonInit', 'simulatePF'],
                                                    monthly=False, yearly=False),
                       'PF2Maps': ReportedMap(name='PF2Maps', output_var='pF1[0]', unit='mm',
                                              end=[], steps=[], all=['repPFMaps'],
                                              restrictoption=['nonInit', 'simulatePF'], monthly=False,
                                              yearly=False),
                       'PF3Maps': ReportedMap(name='PF3Maps', output_var='pF2[0]', unit='mm',
                                              end=[], steps=[], all=['repPFMaps'],
                                              restrictoption=['nonInit', 'simulatePF'], monthly=False,
                                              yearly=False),
                       'PercolationForestMaps': ReportedMap(name='PercolationForestMaps',
                                                            output_var='SeepTopToSub[1]', unit='mm',
                                                            end=[], steps=[],
                                                            all=['repPercolationMaps'],
                                                            restrictoption=['nonInit'], monthly=False,
                                                            yearly=False),
                       'PercolationMaps': ReportedMap(name='PercolationMaps',
                                                      output_var='SeepTopToSub[0]', unit='mm',
                                                      end=[], steps=[], all=['repPercolationMaps'],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'PolderLevelEnd': ReportedMap(name='PolderLevelEnd', output_var='PolderLevel',
                                                     unit='m', end=['repEndMaps'], steps=[],
                                                     all=[],
                                                     restrictoption=['nonInit', 'simulatePolders'],
                                                     monthly=False, yearly=False),
                       'PolderLevelState': ReportedMap(name='PolderLevelState',
                                                       output_var='PolderLevel', unit='m', end=[],
                                                       steps=['repStateMaps'], all=[],
                                                       restrictoption=['nonInit', 'simulatePolders'],
                                                       monthly=False, yearly=False),
                       'PotentialSurfaceWaterAvailabilityForIrrigationM3': ReportedMap(
                           name='PotentialSurfaceWaterAvailabilityForIrrigationM3',
                           output_var='PotentialSurfaceWaterAvailabilityForIrrigationM3', unit='m3',
                           end=[], steps=['repTotalAbs'], all=[],
                           restrictoption=['nonInit', 'wateruse'], monthly=False, yearly=False),
                       'PrecipitationMapsOut': ReportedMap(name='PrecipitationMapsOut',
                                                           output_var='Precipitation',
                                                           unit='mm/timestep', end=[], steps=[],
                                                           all=['repPrecipitationMaps'],
                                                           restrictoption=[], monthly=False,
                                                           yearly=False),
                       'PrefFlowForestMaps': ReportedMap(name='PrefFlowForestMaps',
                                                         output_var='PrefFlow[1]', unit='mm', end=[],
                                                         steps=[], all=['repPrefFlowMaps'],
                                                         restrictoption=['nonInit'], monthly=False,
                                                         yearly=False),
                       'PrefFlowMaps': ReportedMap(name='PrefFlowMaps', output_var='PrefFlowPixel',
                                                   unit='mm', end=[], steps=[], all=['repE2O2'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'RainMaps': ReportedMap(name='RainMaps', output_var='Rain', unit='mm',
                                               end=[], steps=[], all=['repE2O1'],
                                               restrictoption=['nonInit'], monthly=False, yearly=False),
                       'RegionMonthExternalInflowM3': ReportedMap(name='RegionMonthExternalInflowM3',
                                                                  output_var='RegionMonthExternalInflowM3',
                                                                  unit='M3', end=[],
                                                                  steps=['repWIndex'], all=[],
                                                                  restrictoption=['nonInit', 'wateruse',
                                                                                  'wateruseRegion',
                                                                                  'indicator'],
                                                                  monthly=False, yearly=False),
                       'RegionMonthInternalFlowM3': ReportedMap(name='RegionMonthInternalFlowM3',
                                                                output_var='RegionMonthInternalFlowM3',
                                                                unit='M3', end=[],
                                                                steps=['repWIndex'], all=[],
                                                                restrictoption=['nonInit', 'wateruse',
                                                                                'wateruseRegion',
                                                                                'indicator'],
                                                                monthly=False, yearly=False),
                       'RegionMonthIrrigationShortageM3': ReportedMap(
                           name='RegionMonthIrrigationShortageM3',
                           output_var='RegionMonthIrrigationShortageM3', unit='M3', end=[],
                           steps=['repWIndex'], all=[],
                           restrictoption=['nonInit', 'wateruse', 'wateruseRegion', 'indicator'],
                           monthly=False, yearly=False),
                       'RegionMonthReservoirAndLakeStorageM3': ReportedMap(
                           name='RegionMonthReservoirAndLakeStorageM3',
                           output_var='RegionMonthReservoirAndLakeStorageM3', unit='M3', end=[],
                           steps=['repWIndex'], all=[],
                           restrictoption=['nonInit', 'wateruse', 'wateruseRegion', 'indicator'],
                           monthly=False, yearly=False),
                       'RegionMonthWAbstractionM3': ReportedMap(name='RegionMonthWAbstractionM3',
                                                                output_var='RegionMonthWAbstractionM3',
                                                                unit='M3', end=[],
                                                                steps=['repWIndex'], all=[],
                                                                restrictoption=['nonInit', 'wateruse',
                                                                                'wateruseRegion',
                                                                                'indicator'],
                                                                monthly=False, yearly=False),
                       'RegionMonthWConsumptionM3': ReportedMap(name='RegionMonthWConsumptionM3',
                                                                output_var='RegionMonthWConsumptionM3',
                                                                unit='M3', end=[],
                                                                steps=['repWIndex'], all=[],
                                                                restrictoption=['nonInit', 'wateruse',
                                                                                'wateruseRegion',
                                                                                'indicator'],
                                                                monthly=False, yearly=False),
                       'RegionMonthWDemandM3': ReportedMap(name='RegionMonthWDemandM3',
                                                           output_var='RegionMonthWDemandM3', unit='M3',
                                                           end=[], steps=['repWIndex'], all=[],
                                                           restrictoption=['nonInit', 'wateruse',
                                                                           'wateruseRegion',
                                                                           'indicator'], monthly=False,
                                                           yearly=False),
                       'RegionMonthWaterAbstractedfromLakesReservoirsM3': ReportedMap(
                           name='RegionMonthWaterAbstractedfromLakesReservoirsM3',
                           output_var='RegionMonthWaterAbstractedfromLakesReservoirsM3', unit='M3',
                           end=[], steps=['repWIndex'], all=[],
                           restrictoption=['nonInit', 'wateruse', 'wateruseRegion', 'indicator'],
                           monthly=False, yearly=False),
                       'ReservoirAbstractionM3': ReportedMap(name='ReservoirAbstractionM3',
                                                             output_var='ReservoirAbstractionM3',
                                                             unit='m3', end=[],
                                                             steps=['repTotalAbs'], all=[],
                                                             restrictoption=['nonInit', 'wateruse',
                                                                             'simulateReservoirs'],
                                                             monthly=False, yearly=False),
                       'ReservoirFillEnd': ReportedMap(name='ReservoirFillEnd',
                                                       output_var='ReservoirFill', unit='m',
                                                       end=['repEndMaps'], steps=[], all=[],
                                                       restrictoption=['nonInit', 'simulateReservoirs'],
                                                       monthly=False, yearly=False),
                       'ReservoirFillState': ReportedMap(name='ReservoirFillState',
                                                         output_var='ReservoirFill', unit='m',
                                                         end=[], steps=['repStateMaps'], all=[],
                                                         restrictoption=['nonInit',
                                                                         'simulateReservoirs'],
                                                         monthly=False, yearly=False),
                       'ReservoirStorageM3': ReportedMap(name='ReservoirStorageM3',
                                                         output_var='ReservoirStorageM3', unit='m3',
                                                         end=[], steps=['repTotalAbs'], all=[],
                                                         restrictoption=['nonInit', 'wateruse',
                                                                         'simulateReservoirs'],
                                                         monthly=False, yearly=False),
                       'SMStressForestMap': ReportedMap(name='SMStressForestMap',
                                                        output_var='SoilMoistureStressDays[1]',
                                                        unit='days', end=[], steps=[],
                                                        all=['repStressDays'],
                                                        restrictoption=['nonInit'], monthly=False,
                                                        yearly=False),
                       'SMStressMap': ReportedMap(name='SMStressMap',
                                                  output_var='SoilMoistureStressDays[0]', unit='days',
                                                  end=[], steps=[], all=['repStressDays'],
                                                  restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'SeepSubToGWForestMaps': ReportedMap(name='SeepSubToGWForestMaps',
                                                            output_var='SeepSubToGW[1]', unit='mm',
                                                            end=[], steps=[],
                                                            all=['repSeepSubToGWMaps'],
                                                            restrictoption=['nonInit'], monthly=False,
                                                            yearly=False),
                       'SeepSubToGWMaps': ReportedMap(name='SeepSubToGWMaps',
                                                      output_var='SeepSubToGWPixel', unit='mm',
                                                      end=[], steps=[], all=['repE2O2'],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'SnowCoverAEnd': ReportedMap(name='SnowCoverAEnd', output_var='SnowCoverS[0]',
                                                    unit='mm', end=['repEndMaps'], steps=[],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'SnowCoverAState': ReportedMap(name='SnowCoverAState',
                                                      output_var='SnowCoverS[0]', unit='mm', end=[],
                                                      steps=['repStateMaps'], all=[],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'SnowCoverBEnd': ReportedMap(name='SnowCoverBEnd', output_var='SnowCoverS[1]',
                                                    unit='mm', end=['repEndMaps'], steps=[],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'SnowCoverBState': ReportedMap(name='SnowCoverBState',
                                                      output_var='SnowCoverS[1]', unit='mm', end=[],
                                                      steps=['repStateMaps'], all=[],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'SnowCoverCEnd': ReportedMap(name='SnowCoverCEnd', output_var='SnowCoverS[2]',
                                                    unit='mm', end=['repEndMaps'], steps=[],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'SnowCoverCState': ReportedMap(name='SnowCoverCState',
                                                      output_var='SnowCoverS[2]', unit='mm', end=[],
                                                      steps=['repStateMaps'], all=[],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'SnowCoverMaps': ReportedMap(name='SnowCoverMaps', output_var='SnowCover',
                                                    unit='mm', end=[], steps=[], all=['repE2O1'],
                                                    restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'SnowMaps': ReportedMap(name='SnowMaps', output_var='Snow', unit='mm',
                                               end=[], steps=[], all=['repSnowMaps'],
                                               restrictoption=['nonInit'], monthly=False, yearly=False),
                       'SnowMeltMaps': ReportedMap(name='SnowMeltMaps', output_var='SnowMelt',
                                                   unit='mm', end=[], steps=[], all=['repE2O1'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'SurfaceRunoffMaps': ReportedMap(name='SurfaceRunoffMaps',
                                                        output_var='SurfaceRunoff', unit='mm',
                                                        end=[], steps=[],
                                                        all=['repSurfaceRunoffMaps'],
                                                        restrictoption=['nonInit'], monthly=False,
                                                        yearly=False),
                       'TaForestMaps': ReportedMap(name='TaForestMaps', output_var='Ta[1]', unit='mm',
                                                   end=[], steps=[], all=['repTaMaps'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'TaMaps': ReportedMap(name='TaMaps', output_var='TaPixel', unit='mm', end=[],
                                             steps=[], all=['repE2O1'], restrictoption=['nonInit'],
                                             monthly=False, yearly=False),
                       'TavgMapsOut': ReportedMap(name='TavgMapsOut', output_var='Tavg', unit='degree',
                                                  end=[], steps=[], all=['repTavgMaps'],
                                                  restrictoption=[], monthly=False, yearly=False),
                       'Theta1End': ReportedMap(name='Theta1End', output_var='Theta1a[0]', unit='mm',
                                                end=['repEndMaps'], steps=[], all=[],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'Theta1ForestEnd': ReportedMap(name='Theta1ForestEnd', output_var='Theta1a[1]',
                                                      unit='mm', end=['repEndMaps'], steps=[],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'Theta1ForestMaps': ReportedMap(name='Theta1ForestMaps', output_var='Theta1a[1]',
                                                       unit='mm', end=[], steps=[],
                                                       all=['repThetaForestMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'Theta1ForestState': ReportedMap(name='Theta1ForestState',
                                                        output_var='Theta1a[1]', unit='mm', end=[],
                                                        steps=['repStateMaps'], all=[],
                                                        restrictoption=['nonInit'], monthly=False,
                                                        yearly=False),
                       'Theta1IrrigationEnd': ReportedMap(name='Theta1IrrigationEnd',
                                                          output_var='Theta1a[2]', unit='mm',
                                                          end=['repEndMaps'], steps=[], all=[],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'Theta1IrrigationMaps': ReportedMap(name='Theta1IrrigationMaps',
                                                           output_var='Theta1a[2]', unit='mm',
                                                           end=[], steps=[],
                                                           all=['repThetaIrrigationMaps'],
                                                           restrictoption=['nonInit'], monthly=False,
                                                           yearly=False),
                       'Theta1IrrigationState': ReportedMap(name='Theta1IrrigationState',
                                                            output_var='Theta1a[2]', unit='mm',
                                                            end=[], steps=['repStateMaps'], all=[],
                                                            restrictoption=['nonInit'], monthly=False,
                                                            yearly=False),
                       'Theta1Maps': ReportedMap(name='Theta1Maps', output_var='Theta1a[0]', unit='mm',
                                                 end=[], steps=[], all=['repE2O2'],
                                                 restrictoption=['nonInit'], monthly=False,
                                                 yearly=False),
                       'Theta1State': ReportedMap(name='Theta1State', output_var='Theta1a[0]',
                                                  unit='mm', end=[], steps=['repStateMaps'],
                                                  all=[], restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'Theta2End': ReportedMap(name='Theta2End', output_var='Theta1b[0]', unit='mm',
                                                end=['repEndMaps'], steps=[], all=[],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'Theta2ForestEnd': ReportedMap(name='Theta2ForestEnd', output_var='Theta1b[1]',
                                                      unit='mm', end=['repEndMaps'], steps=[],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'Theta2ForestMaps': ReportedMap(name='Theta2ForestMaps', output_var='Theta1b[1]',
                                                       unit='mm', end=[], steps=[],
                                                       all=['repThetaForestMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'Theta2ForestState': ReportedMap(name='Theta2ForestState',
                                                        output_var='Theta1b[1]', unit='mm', end=[],
                                                        steps=['repStateMaps'], all=[],
                                                        restrictoption=['nonInit'], monthly=False,
                                                        yearly=False),
                       'Theta2IrrigationEnd': ReportedMap(name='Theta2IrrigationEnd',
                                                          output_var='Theta1b[2]', unit='mm',
                                                          end=['repEndMaps'], steps=[], all=[],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'Theta2IrrigationMaps': ReportedMap(name='Theta2IrrigationMaps',
                                                           output_var='Theta1b[2]', unit='mm',
                                                           end=[], steps=[],
                                                           all=['repThetaIrrigationMaps'],
                                                           restrictoption=['nonInit'], monthly=False,
                                                           yearly=False),
                       'Theta2IrrigationState': ReportedMap(name='Theta2IrrigationState',
                                                            output_var='Theta1b[2]', unit='mm',
                                                            end=[], steps=['repStateMaps'], all=[],
                                                            restrictoption=['nonInit'], monthly=False,
                                                            yearly=False),
                       'Theta2Maps': ReportedMap(name='Theta2Maps', output_var='Theta1b[0]', unit='mm',
                                                 end=[], steps=[], all=['repE2O2'],
                                                 restrictoption=['nonInit'], monthly=False,
                                                 yearly=False),
                       'Theta2State': ReportedMap(name='Theta2State', output_var='Theta1b[0]',
                                                  unit='mm', end=[], steps=['repStateMaps'],
                                                  all=[], restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'Theta3End': ReportedMap(name='Theta3End', output_var='Theta2[0]', unit='mm',
                                                end=['repEndMaps'], steps=[], all=[],
                                                restrictoption=['nonInit'], monthly=False, yearly=False),
                       'Theta3ForestEnd': ReportedMap(name='Theta3ForestEnd', output_var='Theta2[1]',
                                                      unit='mm', end=['repEndMaps'], steps=[],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'Theta3ForestMaps': ReportedMap(name='Theta3ForestMaps', output_var='Theta2[1]',
                                                       unit='mm', end=[], steps=[],
                                                       all=['repThetaForestMaps'],
                                                       restrictoption=['nonInit'], monthly=False,
                                                       yearly=False),
                       'Theta3ForestState': ReportedMap(name='Theta3ForestState',
                                                        output_var='Theta2[1]', unit='mm', end=[],
                                                        steps=['repStateMaps'], all=[],
                                                        restrictoption=['nonInit'], monthly=False,
                                                        yearly=False),
                       'Theta3IrrigationEnd': ReportedMap(name='Theta3IrrigationEnd',
                                                          output_var='Theta2[2]', unit='mm',
                                                          end=['repEndMaps'], steps=[], all=[],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'Theta3IrrigationMaps': ReportedMap(name='Theta3IrrigationMaps',
                                                           output_var='Theta2[2]', unit='mm', end=[],
                                                           steps=[], all=['repThetaIrrigationMaps'],
                                                           restrictoption=['nonInit'], monthly=False,
                                                           yearly=False),
                       'Theta3IrrigationState': ReportedMap(name='Theta3IrrigationState',
                                                            output_var='Theta2[2]', unit='mm',
                                                            end=[], steps=['repStateMaps'], all=[],
                                                            restrictoption=['nonInit'], monthly=False,
                                                            yearly=False),
                       'Theta3Maps': ReportedMap(name='Theta3Maps', output_var='Theta2[0]', unit='mm',
                                                 end=[], steps=[], all=['repE2O2'],
                                                 restrictoption=['nonInit'], monthly=False,
                                                 yearly=False),
                       'Theta3State': ReportedMap(name='Theta3State', output_var='Theta2[0]',
                                                  unit='mm', end=[], steps=['repStateMaps'],
                                                  all=[], restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'TotalAbsGroundwater': ReportedMap(name='TotalAbsGroundwater',
                                                          output_var='TotalAbstractionFromGroundwaterM3*self.var.M3toMM',
                                                          unit='mm', end=[], steps=['repTotalAbs'],
                                                          all=[],
                                                          restrictoption=['nonInit', 'wateruse'],
                                                          monthly=False, yearly=False),
                       'TotalAbsGroundwaterRegion': ReportedMap(name='TotalAbsGroundwaterRegion',
                                                                output_var='AreaTotalAbstractionFromGroundwaterM3*self.var.M3toMM',
                                                                unit='mm', end=[],
                                                                steps=['repTotalAbs'], all=[],
                                                                restrictoption=['nonInit', 'wateruse',
                                                                                'wateruseRegion'],
                                                                monthly=False, yearly=False),
                       'TotalAbsSurface': ReportedMap(name='TotalAbsSurface',
                                                      output_var='TotalAbstractionFromSurfaceWaterM3*self.var.M3toMM',
                                                      unit='mm', end=[], steps=['repTotalAbs'],
                                                      all=[], restrictoption=['nonInit', 'wateruse'],
                                                      monthly=False, yearly=False),
                       'TotalAbsSurfaceRegion': ReportedMap(name='TotalAbsSurfaceRegion',
                                                            output_var='AreaTotalAbstractionFromSurfaceWaterM3*self.var.M3toMM',
                                                            unit='mm', end=[], steps=['repTotalAbs'],
                                                            all=[],
                                                            restrictoption=['nonInit', 'wateruse',
                                                                            'wateruseRegion'],
                                                            monthly=False, yearly=False),
                       'TotalAbstractionFromGroundwaterM3': ReportedMap(
                           name='TotalAbstractionFromGroundwaterM3',
                           output_var='TotalAbstractionFromGroundwaterM3', unit='m3', end=[],
                           steps=['repTotalAbs'], all=[], restrictoption=['nonInit', 'wateruse'],
                           monthly=False, yearly=False),
                       'TotalAbstractionFromSurfaceWaterM3': ReportedMap(
                           name='TotalAbstractionFromSurfaceWaterM3',
                           output_var='TotalAbstractionFromSurfaceWaterM3', unit='m3', end=[],
                           steps=['repTotalAbs'], all=[], restrictoption=['nonInit', 'wateruse'],
                           monthly=False, yearly=False),
                       'TotalDemandM3': ReportedMap(name='TotalDemandM3', output_var='TotalDemandM3',
                                                    unit='m3', end=[], steps=['repTotalAbs'],
                                                    all=[], restrictoption=['nonInit', 'wateruse'],
                                                    monthly=False, yearly=False),
                       'TotalIrrigationAbstractionM3': ReportedMap(name='TotalIrrigationAbstractionM3',
                                                                   output_var='TotalIrrigationAbstractionM3',
                                                                   unit='m3', end=[],
                                                                   steps=['repTotalAbs'], all=[],
                                                                   restrictoption=['nonInit',
                                                                                   'wateruse'],
                                                                   monthly=False, yearly=False),
                       'TotalLivestockAbstractionM3': ReportedMap(name='TotalLivestockAbstractionM3',
                                                                  output_var='TotalLivestockAbstractionM3',
                                                                  unit='m3', end=[],
                                                                  steps=['repTotalAbs'], all=[],
                                                                  restrictoption=['nonInit',
                                                                                  'wateruse'],
                                                                  monthly=False, yearly=False),
                       'TotalPaddyRiceIrrigationAbstractionM3': ReportedMap(
                           name='TotalPaddyRiceIrrigationAbstractionM3',
                           output_var='TotalPaddyRiceIrrigationAbstractionM3', unit='m3', end=[],
                           steps=['repTotalAbs'], all=[], restrictoption=['nonInit', 'wateruse'],
                           monthly=False, yearly=False),
                       'TotalRunoffMaps': ReportedMap(name='TotalRunoffMaps',
                                                      output_var='ToChanM3Runoff*self.var.M3toMM',
                                                      unit='mm', end=[], steps=[],
                                                      all=['repE2O1'], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'TotalToChanMaps': ReportedMap(name='TotalToChanMaps',
                                                      output_var='ToChanM3Runoff*self.var.M3toMM',
                                                      unit='mm', end=[], steps=[],
                                                      all=['repSurfaceRunoffMaps'],
                                                      restrictoption=['nonInit'], monthly=False,
                                                      yearly=False),
                       'TotalWUse': ReportedMap(name='TotalWUse',
                                                output_var='WUseAddM3*self.var.M3toMM', unit='mm',
                                                end=[], steps=['repTotalWUse'], all=[],
                                                restrictoption=['nonInit', 'wateruse'], monthly=False,
                                                yearly=False),
                       'TotalWUseRegion': ReportedMap(name='TotalWUseRegion',
                                                      output_var='totalAddM3*self.var.M3toMM',
                                                      unit='mm', end=[], steps=['repTotalWUse'],
                                                      all=[], restrictoption=['nonInit', 'wateruse',
                                                                              'wateruseRegion'],
                                                      monthly=False, yearly=False),
                       'UZEnd': ReportedMap(name='UZEnd', output_var='UZ[0]', unit='mm',
                                            end=['repEndMaps'], steps=[], all=[],
                                            restrictoption=['nonInit'], monthly=False, yearly=False),
                       'UZForestEnd': ReportedMap(name='UZForestEnd', output_var='UZ[1]', unit='mm',
                                                  end=['repEndMaps'], steps=[], all=[],
                                                  restrictoption=['nonInit'], monthly=False,
                                                  yearly=False),
                       'UZForestMaps': ReportedMap(name='UZForestMaps', output_var='UZ[1]', unit='m',
                                                   end=[], steps=[], all=['repUZMaps'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'UZForestState': ReportedMap(name='UZForestState', output_var='UZ[1]',
                                                    unit='mm', end=[], steps=['repStateMaps'],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'UZIrrigationEnd': ReportedMap(name='UZIrrigationEnd', output_var='UZ[2]',
                                                      unit='mm', end=['repEndMaps'], steps=[],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'UZIrrigationState': ReportedMap(name='UZIrrigationState', output_var='UZ[2]',
                                                        unit='mm', end=[], steps=['repStateMaps'],
                                                        all=[], restrictoption=['nonInit'],
                                                        monthly=False, yearly=False),
                       'UZMaps': ReportedMap(name='UZMaps', output_var='UZ[0]', unit='m', end=[],
                                             steps=[], all=['repUZMaps'], restrictoption=['nonInit'],
                                             monthly=False, yearly=False),
                       'UZOutflowForestMaps': ReportedMap(name='UZOutflowForestMaps',
                                                          output_var='UZOutflowPixel', unit='mm',
                                                          end=[], steps=[],
                                                          all=['repUZOutflowMaps'],
                                                          restrictoption=['nonInit'], monthly=False,
                                                          yearly=False),
                       'UZOutflowMaps': ReportedMap(name='UZOutflowMaps', output_var='UZOutflowPixel',
                                                    unit='mm', end=[], steps=[],
                                                    all=['repUZOutflowMaps'],
                                                    restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'UZState': ReportedMap(name='UZState', output_var='UZ[0]', unit='mm', end=[],
                                              steps=['repStateMaps'], all=[],
                                              restrictoption=['nonInit'], monthly=False, yearly=False),
                       'WEI_Abs': ReportedMap(name='WEI_Abs', output_var='WEI_Abs', unit='-',
                                              end=[], steps=['repWIndex'], all=[],
                                              restrictoption=['nonInit', 'wateruse', 'indicator'],
                                              monthly=False, yearly=False),
                       'WEI_Cns': ReportedMap(name='WEI_Cns', output_var='WEI_Cns', unit='-',
                                              end=[], steps=['repWIndex'], all=[],
                                              restrictoption=['nonInit', 'wateruse', 'indicator'],
                                              monthly=False, yearly=False),
                       'WEI_Dem': ReportedMap(name='WEI_Dem', output_var='WEI_Dem', unit='-',
                                              end=[], steps=['repWIndex'], all=[],
                                              restrictoption=['nonInit', 'wateruse', 'indicator'],
                                              monthly=False, yearly=False),
                       'WUseAddM3': ReportedMap(name='WUseAddM3', output_var='WUseAddM3', unit='m3',
                                                end=[], steps=['repTotalAbs'], all=[],
                                                restrictoption=['nonInit', 'wateruse'], monthly=False,
                                                yearly=False),
                       'WaterDependencyIndex': ReportedMap(name='WaterDependencyIndex',
                                                           output_var='WaterDependencyIndex', unit='-',
                                                           end=[], steps=['repWIndex'], all=[],
                                                           restrictoption=['nonInit', 'wateruse',
                                                                           'indicator'], monthly=False,
                                                           yearly=False),
                       'WaterDepthEnd': ReportedMap(name='WaterDepthEnd', output_var='WaterDepth',
                                                    unit='m', end=['repEndMaps'], steps=[],
                                                    all=[], restrictoption=['nonInit'], monthly=False,
                                                    yearly=False),
                       'WaterDepthMaps': ReportedMap(name='WaterDepthMaps', output_var='WaterDepth',
                                                     unit='m', end=[], steps=[],
                                                     all=['repWaterDepthMaps'],
                                                     restrictoption=['nonInit'], monthly=False,
                                                     yearly=False),
                       'WaterDepthState': ReportedMap(name='WaterDepthState', output_var='WaterDepth',
                                                      unit='m', end=[], steps=['repStateMaps'],
                                                      all=[], restrictoption=['nonInit'],
                                                      monthly=False, yearly=False),
                       'WaterSecurityIndex': ReportedMap(name='WaterSecurityIndex',
                                                         output_var='WaterSecurityIndex', unit='-',
                                                         end=[], steps=['repWIndex'], all=[],
                                                         restrictoption=['nonInit', 'wateruse',
                                                                         'indicator'], monthly=False,
                                                         yearly=False),
                       'WaterSustainabilityIndex': ReportedMap(name='WaterSustainabilityIndex',
                                                               output_var='WaterSustainabilityIndex',
                                                               unit='-', end=[], steps=['repWIndex'],
                                                               all=[],
                                                               restrictoption=['nonInit', 'wateruse',
                                                                               'indicator'],
                                                               monthly=False, yearly=False),
                       'WaterUseMaps': ReportedMap(name='WaterUseMaps',
                                                   output_var='WUseAddM3*self.var.M3toMM', unit='mm',
                                                   end=[], steps=[], all=['repE2O2'],
                                                   restrictoption=['nonInit'], monthly=False,
                                                   yearly=False),
                       'totalAddM3': ReportedMap(name='totalAddM3', output_var='totalAddM3', unit='m3',
                                                 end=[], steps=['repTotalAbs'], all=[],
                                                 restrictoption=['nonInit', 'wateruse'], monthly=False,
                                                 yearly=False)},
                   'repsimulateLakes': False,
                   'repsimulatePolders': False,
                   'repsimulateReservoirs': False,
                   'repwateruseGauges': False,
                   'repwateruseSites': False,
                   'riceIrrigation': False,
                   'simulateLakes': False,
                   'simulatePF': False,
                   'simulatePolders': False,
                   'simulateReservoirs': False,
                   'simulateWaterLevels': False,
                   'timeseries': {
                       'DSLRAvUpsTS': TimeSeries(name='DSLRAvUpsTS', output_var='DSLR[0]', where='Gauges',
                                                 repoption=['repStateUpsGauges'], restrictoption=['nonInit'],
                                                 operation=['total']),
                       'DSLRTS': TimeSeries(name='DSLRTS', output_var='DSLR[0]', where='Sites',
                                            repoption=['repStateSites'], restrictoption=['nonInit'], operation=['']),
                       'DisTS': TimeSeries(name='DisTS', output_var='ChanQAvg', where='Gauges',
                                           repoption=['repDischargeTs'], restrictoption=[], operation=['']),
                       'ESActAvUpsTS': TimeSeries(name='ESActAvUpsTS', output_var='ESActPixel', where='Gauges',
                                                  repoption=['repBal1'], restrictoption=['nonInit'],
                                                  operation=['total']),
                       'ESActTS': TimeSeries(name='ESActTS', output_var='ESActPixel', where='Sites',
                                             repoption=['repRateSites'], restrictoption=['nonInit'], operation=['']),
                       'ETRefAvUpsTS': TimeSeries(name='ETRefAvUpsTS', output_var='ETRef', where='Gauges',
                                                  repoption=['repMeteoUpsGauges'], restrictoption=['nonInit'],
                                                  operation=['total']),
                       'EWIntAvUpsTS': TimeSeries(name='EWIntAvUpsTS', output_var='TaInterceptionAll',
                                                  where='Gauges', repoption=['repBal1'], restrictoption=['nonInit'],
                                                  operation=['total']),
                       'EWIntTS': TimeSeries(name='EWIntTS', output_var='TaInterceptionAll', where='Sites',
                                             repoption=['repRateSites'], restrictoption=['nonInit'], operation=['']),
                       'EWRefAvUpsTS': TimeSeries(name='EWRefAvUpsTS', output_var='EWRef', where='Gauges',
                                                  repoption=['repMeteoUpsGauges'], restrictoption=['nonInit'],
                                                  operation=['total']),
                       'EvaOpenWaterAvUpsTS': TimeSeries(name='EvaOpenWaterAvUpsTS',
                                                         output_var='EvaAddM3*self.var.M3toMM', where='Gauges',
                                                         repoption=['repBal1'], restrictoption=['nonInit'],
                                                         operation=['total']),
                       'FrostIndexAvUpsTS': TimeSeries(name='FrostIndexAvUpsTS', output_var='FrostIndex',
                                                       where='Gauges', repoption=['repStateUpsGauges'],
                                                       restrictoption=['nonInit'], operation=['total']),
                       'FrostIndexTS': TimeSeries(name='FrostIndexTS', output_var='FrostIndex', where='Sites',
                                                  repoption=['repStateSites'], restrictoption=['nonInit'],
                                                  operation=['']),
                       'GwLossAvUpsTS': TimeSeries(name='GwLossAvUpsTS', output_var='GwLossPixel', where='Gauges',
                                                   repoption=['repBal1'], restrictoption=[], operation=['total']),
                       'GwLossTS': TimeSeries(name='GwLossTS', output_var='GwLossPixel', where='Sites',
                                              repoption=['repRateSites'], restrictoption=['nonInit'],
                                              operation=['']),
                       'GwPercUZLZAvUpsTS': TimeSeries(name='GwPercUZLZAvUpsTS', output_var='GwPercUZLZPixel',
                                                       where='Gauges', repoption=['repRateUpsGauges'],
                                                       restrictoption=['nonInit'], operation=['total']),
                       'GwPercUZLZTS': TimeSeries(name='GwPercUZLZTS', output_var='GwPercUZLZPixel', where='Sites',
                                                  repoption=['repRateSites'], restrictoption=['nonInit'],
                                                  operation=['']),
                       'InfiltrationAvUpsTS': TimeSeries(name='InfiltrationAvUpsTS', output_var='InfiltrationPixel',
                                                         where='Gauges', repoption=['repRateUpsGauges'],
                                                         restrictoption=['nonInit'], operation=['total']),
                       'InfiltrationTS': TimeSeries(name='InfiltrationTS', output_var='InfiltrationPixel',
                                                    where='Sites', repoption=['repRateSites'],
                                                    restrictoption=['nonInit'], operation=['']),
                       'LZAvInflowAvUps': TimeSeries(name='LZAvInflowAvUps', output_var='LZAvInflow',
                                                     where='Gauges', repoption=['repLZAvInflowUpsGauges'],
                                                     restrictoption=[], operation=['total']),
                       'LZAvInflowTS': TimeSeries(name='LZAvInflowTS', output_var='LZAvInflow', where='Sites',
                                                  repoption=['repLZAvInflowSites'], restrictoption=[],
                                                  operation=['']),
                       'LZAvUpsTS': TimeSeries(name='LZAvUpsTS', output_var='LZ', where='Gauges',
                                               repoption=['repStateUpsGauges'], restrictoption=['nonInit'],
                                               operation=['total']),
                       'LZOutflowAvUpsTS': TimeSeries(name='LZOutflowAvUpsTS', output_var='LZOutflowToChannelPixel',
                                                      where='Gauges', repoption=['repRateUpsGauges'],
                                                      restrictoption=['nonInit'], operation=['total']),
                       'LZOutflowTS': TimeSeries(name='LZOutflowTS', output_var='LZOutflowToChannelPixel',
                                                 where='Sites', repoption=['repRateSites'],
                                                 restrictoption=['nonInit'], operation=['']),
                       'LZTS': TimeSeries(name='LZTS', output_var='LZ', where='Sites', repoption=['repStateSites'],
                                          restrictoption=['nonInit'], operation=['']),
                       'LakeInflowTS': TimeSeries(name='LakeInflowTS', output_var='LakeInflowM3S',
                                                  where='LakeSites', repoption=['repsimulateLakes'],
                                                  restrictoption=['nonInit', 'simulateLakes'], operation=['']),
                       'LakeLevelTS': TimeSeries(name='LakeLevelTS', output_var='LakeLevel', where='LakeSites',
                                                 repoption=['repsimulateLakes'],
                                                 restrictoption=['nonInit', 'simulateLakes'], operation=['']),
                       'LakeOutflowTS': TimeSeries(name='LakeOutflowTS', output_var='LakeOutflowM3S',
                                                   where='LakeSites', repoption=['repsimulateLakes'],
                                                   restrictoption=['nonInit', 'simulateLakes'], operation=['']),
                       'MassBalanceMMTSS': TimeSeries(name='MassBalanceMMTSS', output_var='MBErrorMM',
                                                      where='Catchments', repoption=['repMBTs'],
                                                      restrictoption=['nonInit'], operation=['']),
                       'PF1AvUpsTS': TimeSeries(name='PF1AvUpsTS', output_var='pF1[0]', where='Gauges',
                                                repoption=['repPFUpsGauges'],
                                                restrictoption=['nonInit', 'simulatePF'], operation=['total']),
                       'PF1ForestAvUpsTS': TimeSeries(name='PF1ForestAvUpsTS', output_var='pF1[1]', where='Gauges',
                                                      repoption=['repPFUpsGauges'],
                                                      restrictoption=['nonInit', 'simulatePF'],
                                                      operation=['total']),
                       'PF1ForestTS': TimeSeries(name='PF1ForestTS', output_var='pF1[1]', where='Sites',
                                                 repoption=['repPFSites'], restrictoption=['nonInit', 'simulatePF'],
                                                 operation=['']),
                       'PF1TS': TimeSeries(name='PF1TS', output_var='pF1[0]', where='Sites',
                                           repoption=['repPFSites'], restrictoption=['nonInit', 'simulatePF'],
                                           operation=['']),
                       'PF2AvUpsTS': TimeSeries(name='PF2AvUpsTS', output_var='pF2[0]', where='Gauges',
                                                repoption=['repPFUpsGauges'],
                                                restrictoption=['nonInit', 'simulatePF'], operation=['total']),
                       'PF2ForestAvUpsTS': TimeSeries(name='PF2ForestAvUpsTS', output_var='pF2[1]', where='Gauges',
                                                      repoption=['repPFUpsGauges'],
                                                      restrictoption=['nonInit', 'simulatePF'],
                                                      operation=['total']),
                       'PF2ForestTS': TimeSeries(name='PF2ForestTS', output_var='pF2[1]', where='Sites',
                                                 repoption=['repPFSites'], restrictoption=['nonInit', 'simulatePF'],
                                                 operation=['']),
                       'PF2TS': TimeSeries(name='PF2TS', output_var='pF2[0]', where='Sites',
                                           repoption=['repPFSites'], restrictoption=['nonInit', 'simulatePF'],
                                           operation=['']),
                       'PercolationAvUpsTS': TimeSeries(name='PercolationAvUpsTS', output_var='SeepTopToSubPixelB',
                                                        where='Gauges', repoption=['repRateUpsGauges'],
                                                        restrictoption=['nonInit'], operation=['total']),
                       'PercolationTS': TimeSeries(name='PercolationTS', output_var='SeepTopToSubPixelB',
                                                   where='Sites', repoption=['repRateSites'],
                                                   restrictoption=['nonInit'], operation=['']),
                       'PolderFluxTS': TimeSeries(name='PolderFluxTS', output_var='PolderFlux', where='PolderSites',
                                                  repoption=['repsimulatePolders'],
                                                  restrictoption=['nonInit', 'simulatePolders'], operation=['']),
                       'PolderLevelTS': TimeSeries(name='PolderLevelTS', output_var='PolderLevel',
                                                   where='PolderSites', repoption=['repsimulatePolders'],
                                                   restrictoption=['nonInit', 'simulatePolders'], operation=['']),
                       'PrecipitationAvUpsTS': TimeSeries(name='PrecipitationAvUpsTS', output_var='Precipitation',
                                                          where='Gauges', repoption=['repBal1'],
                                                          restrictoption=[], operation=['total']),
                       'PrefFlowAvUpsTS': TimeSeries(name='PrefFlowAvUpsTS', output_var='PrefFlowPixel',
                                                     where='Gauges', repoption=['repRateUpsGauges'],
                                                     restrictoption=['nonInit'], operation=['total']),
                       'PrefFlowTS': TimeSeries(name='PrefFlowTS', output_var='PrefFlowPixel', where='Sites',
                                                repoption=['repRateSites'], restrictoption=['nonInit'],
                                                operation=['']),
                       'RainAvUpsTS': TimeSeries(name='RainAvUpsTS', output_var='Rain', where='Gauges',
                                                 repoption=['repRateUpsGauges'], restrictoption=['nonInit'],
                                                 operation=['total']),
                       'RainTS': TimeSeries(name='RainTS', output_var='Rain', where='Sites',
                                            repoption=['repRateSites'], restrictoption=['nonInit'], operation=['']),
                       'ReservoirFillTS': TimeSeries(name='ReservoirFillTS', output_var='ReservoirFill',
                                                     where='ReservoirSites', repoption=['repsimulateReservoirs'],
                                                     restrictoption=['nonInit', 'simulateReservoirs'],
                                                     operation=['']),
                       'ReservoirInflowTS': TimeSeries(name='ReservoirInflowTS', output_var='ReservoirInflowM3S',
                                                       where='ReservoirSites', repoption=['repsimulateReservoirs'],
                                                       restrictoption=['nonInit', 'simulateReservoirs'],
                                                       operation=['']),
                       'ReservoirOutflowTS': TimeSeries(name='ReservoirOutflowTS', output_var='ReservoirOutflowM3S',
                                                        where='ReservoirSites', repoption=['repsimulateReservoirs'],
                                                        restrictoption=['nonInit', 'simulateReservoirs'],
                                                        operation=['']),
                       'RunLossUpsTS': TimeSeries(name='RunLossUpsTS', output_var='TotalRunoff+self.var.GwLossPixel',
                                                  where='Gauges', repoption=['repBal1'], restrictoption=['nonInit'],
                                                  operation=['total']),
                       'SeepSubToGWAvUpsTS': TimeSeries(name='SeepSubToGWAvUpsTS', output_var='SeepSubToGWPixel',
                                                        where='Gauges', repoption=['repRateUpsGauges'],
                                                        restrictoption=['nonInit'], operation=['total']),
                       'SeepSubToGWTS': TimeSeries(name='SeepSubToGWTS', output_var='SeepSubToGWPixel',
                                                   where='Sites', repoption=['repRateSites'],
                                                   restrictoption=['nonInit'], operation=['']),
                       'SnowAvUpsTS': TimeSeries(name='SnowAvUpsTS', output_var='Snow', where='Gauges',
                                                 repoption=['repRateUpsGauges'], restrictoption=['nonInit'],
                                                 operation=['total']),
                       'SnowCoverAvUpsTS': TimeSeries(name='SnowCoverAvUpsTS', output_var='SnowCover',
                                                      where='Gauges', repoption=['repStateUpsGauges'],
                                                      restrictoption=[], operation=['total']),
                       'SnowCoverTS': TimeSeries(name='SnowCoverTS', output_var='SnowCover', where='Sites',
                                                 repoption=['repStateSites'], restrictoption=['nonInit'],
                                                 operation=['']),
                       'SnowTS': TimeSeries(name='SnowTS', output_var='Snow', where='Sites',
                                            repoption=['repRateSites'], restrictoption=['nonInit'], operation=['']),
                       'SnowmeltAvUpsTS': TimeSeries(name='SnowmeltAvUpsTS', output_var='SnowMelt', where='Gauges',
                                                     repoption=['repRateUpsGauges'], restrictoption=['nonInit'],
                                                     operation=['total']),
                       'SnowmeltTS': TimeSeries(name='SnowmeltTS', output_var='SnowMelt', where='Sites',
                                                repoption=['repRateSites'], restrictoption=['nonInit'],
                                                operation=['']),
                       'StepsSoilTS': TimeSeries(name='StepsSoilTS', output_var='NoSubSteps', where='1',
                                                 repoption=['repInternalCom'], restrictoption=[],
                                                 operation=['mapmaximum']),
                       'StepsWaterUseTS': TimeSeries(name='StepsWaterUseTS', output_var='NoWaterUseExe', where='1',
                                                     repoption=['repInternalCom'],
                                                     restrictoption=['nonInit', 'wateruse'], operation=['']),
                       'SurfaceRunoffAvUpsTS': TimeSeries(name='SurfaceRunoffAvUpsTS', output_var='SurfaceRunoff',
                                                          where='Gauges', repoption=['repRateUpsGauges'],
                                                          restrictoption=[], operation=['total']),
                       'SurfaceRunoffTS': TimeSeries(name='SurfaceRunoffTS', output_var='SurfaceRunoff',
                                                     where='Sites', repoption=['repRateSites'],
                                                     restrictoption=['nonInit'], operation=['']),
                       'TaAvUpsTS': TimeSeries(name='TaAvUpsTS', output_var='TaPixel', where='Gauges',
                                               repoption=['repBal1'], restrictoption=['nonInit'],
                                               operation=['total']),
                       'TaTS': TimeSeries(name='TaTS', output_var='TaPixel', where='Sites',
                                          repoption=['repRateSites'], restrictoption=['nonInit'], operation=['']),
                       'TavgAvUpsTS': TimeSeries(name='TavgAvUpsTS', output_var='Tavg', where='Gauges',
                                                 repoption=['repMeteoUpsGauges'], restrictoption=['nonInit'],
                                                 operation=['total']),
                       'TotalRunoffAvUpsTS': TimeSeries(name='TotalRunoffAvUpsTS', output_var='TotalRunoff',
                                                        where='Gauges', repoption=['repBal1'], restrictoption=[],
                                                        operation=['total']),
                       'TotalRunoffTS': TimeSeries(name='TotalRunoffTS', output_var='TotalRunoff', where='Sites',
                                                   repoption=['repRateSites'], restrictoption=['nonInit'],
                                                   operation=['']),
                       'UZOutflowAvUpsTS': TimeSeries(name='UZOutflowAvUpsTS', output_var='UZOutflowPixel',
                                                      where='Gauges', repoption=['repRateUpsGauges'],
                                                      restrictoption=['nonInit'], operation=['total']),
                       'UZOutflowTS': TimeSeries(name='UZOutflowTS', output_var='UZOutflowPixel', where='Sites',
                                                 repoption=['repRateSites'], restrictoption=['nonInit'],
                                                 operation=['']),
                       'WaterDepthAvUpsTS': TimeSeries(name='WaterDepthAvUpsTS', output_var='WaterDepth',
                                                       where='Gauges', repoption=['repStateUpsGauges'],
                                                       restrictoption=['nonInit'], operation=['total']),
                       'WaterDepthTS': TimeSeries(name='WaterDepthTS', output_var='WaterDepth', where='Sites',
                                                  repoption=['repStateSites'], restrictoption=['nonInit'],
                                                  operation=['']),
                       'WaterLevelTS': TimeSeries(name='WaterLevelTS', output_var='WaterLevel', where='Gauges',
                                                  repoption=['repWaterLevelTs'],
                                                  restrictoption=['nonInit', 'simulateWaterLevels'], operation=['']),
                       'WaterMassBalanceTSS': TimeSeries(name='WaterMassBalanceTSS', output_var='MBError',
                                                         where='Catchments', repoption=['repMBTs'],
                                                         restrictoption=['nonInit'], operation=['']),
                       'WaterUseSitesTS': TimeSeries(name='WaterUseSitesTS', output_var='WUseSumM3', where='Sites',
                                                     repoption=['repwateruseSites'],
                                                     restrictoption=['nonInit', 'wateruse'], operation=['']),
                       'WaterUseTS': TimeSeries(name='WaterUseTS', output_var='WUseSumM3', where='Gauges',
                                                repoption=['repwateruseGauges'],
                                                restrictoption=['nonInit', 'wateruse'], operation=['']),
                       'actETPUpsTS': TimeSeries(name='actETPUpsTS',
                                                 output_var='ESActPixel+self.var.TaPixel+self.var.TaInterceptionAll+self.var.EvaAddM3*self.var.M3toMM',
                                                 where='Gauges', repoption=['repBal1'], restrictoption=['nonInit'],
                                                 operation=['total'])},
                   'useWaterDemandAveYear': False,
                   'varfractionwater': False,
                   'wateruse': False,
                   'wateruseRegion': False,
                   'writeNetcdf': False,
                   'writeNetcdfStack': False}
