"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DBCluster = exports.DBClusterProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const clickhouse_generated_1 = require("./clickhouse.generated");
Object.defineProperty(exports, "DBClusterProperty", { enumerable: true, get: function () { return clickhouse_generated_1.RosDBCluster; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::ClickHouse::DBCluster`, which is used to query the information about an ApsaraDB for ClickHouse cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDBCluster`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-clickhouse-dbcluster
 */
class DBCluster extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDBCluster = new clickhouse_generated_1.RosDBCluster(this, id, {
            dbClusterId: props.dbClusterId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDBCluster;
        this.attrAliUid = rosDBCluster.attrAliUid;
        this.attrBid = rosDBCluster.attrBid;
        this.attrCategory = rosDBCluster.attrCategory;
        this.attrCommodityCode = rosDBCluster.attrCommodityCode;
        this.attrConnectionString = rosDBCluster.attrConnectionString;
        this.attrCreateTime = rosDBCluster.attrCreateTime;
        this.attrDbClusterIpArrayName = rosDBCluster.attrDbClusterIpArrayName;
        this.attrDbClusterId = rosDBCluster.attrDbClusterId;
        this.attrDbClusterName = rosDBCluster.attrDbClusterName;
        this.attrDbClusterType = rosDBCluster.attrDbClusterType;
        this.attrDbClusterNetworkType = rosDBCluster.attrDbClusterNetworkType;
        this.attrDbNodeClass = rosDBCluster.attrDbNodeClass;
        this.attrDbNodeCount = rosDBCluster.attrDbNodeCount;
        this.attrDbNodeStorage = rosDBCluster.attrDbNodeStorage;
        this.attrEncryptionKey = rosDBCluster.attrEncryptionKey;
        this.attrEncryptionType = rosDBCluster.attrEncryptionType;
        this.attrEngine = rosDBCluster.attrEngine;
        this.attrEngineVersion = rosDBCluster.attrEngineVersion;
        this.attrExpireTime = rosDBCluster.attrExpireTime;
        this.attrIsExpired = rosDBCluster.attrIsExpired;
        this.attrLockMode = rosDBCluster.attrLockMode;
        this.attrLockReason = rosDBCluster.attrLockReason;
        this.attrMaintainTime = rosDBCluster.attrMaintainTime;
        this.attrPaymentType = rosDBCluster.attrPaymentType;
        this.attrPort = rosDBCluster.attrPort;
        this.attrPublicConnectionString = rosDBCluster.attrPublicConnectionString;
        this.attrPublicIpAddr = rosDBCluster.attrPublicIpAddr;
        this.attrPublicPort = rosDBCluster.attrPublicPort;
        this.attrResourceGroupId = rosDBCluster.attrResourceGroupId;
        this.attrScaleOutStatus = rosDBCluster.attrScaleOutStatus;
        this.attrSecurityIps = rosDBCluster.attrSecurityIps;
        this.attrStorageType = rosDBCluster.attrStorageType;
        this.attrSupportBackup = rosDBCluster.attrSupportBackup;
        this.attrSupportHttpsPort = rosDBCluster.attrSupportHttpsPort;
        this.attrSupportMysqlPort = rosDBCluster.attrSupportMysqlPort;
        this.attrSupportOss = rosDBCluster.attrSupportOss;
        this.attrVSwitchId = rosDBCluster.attrVSwitchId;
        this.attrVpcCloudInstanceId = rosDBCluster.attrVpcCloudInstanceId;
        this.attrVpcId = rosDBCluster.attrVpcId;
        this.attrVpcIpAddr = rosDBCluster.attrVpcIpAddr;
        this.attrZoneId = rosDBCluster.attrZoneId;
    }
}
exports.DBCluster = DBCluster;
//# sourceMappingURL=data:application/json;base64,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