"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynDb = exports.SynDbProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const clickhouse_generated_1 = require("./clickhouse.generated");
Object.defineProperty(exports, "SynDbProperty", { enumerable: true, get: function () { return clickhouse_generated_1.RosSynDb; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::ClickHouse::SynDb`, which is used to create a synchronization task for an ApsaraDB for ClickHouse Community-compatible Edition cluster.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosSynDb`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-clickhouse-syndb
 */
class SynDb extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosSynDb = new clickhouse_generated_1.RosSynDb(this, id, {
            rdsVpcUrl: props.rdsVpcUrl,
            limitUpper: props.limitUpper,
            skipUnsupported: props.skipUnsupported,
            rdsId: props.rdsId,
            rdsPassword: props.rdsPassword,
            rdsUserName: props.rdsUserName,
            ckPassword: props.ckPassword,
            ckUserName: props.ckUserName,
            clickhousePort: props.clickhousePort,
            synDbTables: props.synDbTables,
            dbClusterId: props.dbClusterId,
            rdsPort: props.rdsPort,
            rdsVpcId: props.rdsVpcId,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosSynDb;
        this.attrDbClusterId = rosSynDb.attrDbClusterId;
        this.attrRdsId = rosSynDb.attrRdsId;
        this.attrSynDbs = rosSynDb.attrSynDbs;
    }
}
exports.SynDb = SynDb;
//# sourceMappingURL=data:application/json;base64,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