import { AccessLevelList } from '../shared/access-level';
import { PolicyStatement } from '../shared';
/**
 * Statement provider for service [backup-gateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupgateway.html).
 *
 * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
 */
export declare class BackupGateway extends PolicyStatement {
    servicePrefix: string;
    /**
     * Statement provider for service [backup-gateway](https://docs.aws.amazon.com/service-authorization/latest/reference/list_awsbackupgateway.html).
     *
     * @param sid [SID](https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies_elements_sid.html) of the statement
     */
    constructor(sid?: string);
    /**
     * Grants permission to AssociateGatewayToServer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_AssociateGatewayToServer.html
     */
    toAssociateGatewayToServer(): this;
    /**
     * Grants permission to Backup
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartBackupJob.html
     */
    toBackup(): this;
    /**
     * Grants permission to to CreateGateway
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_CreateGateway.html
     */
    toCreateGateway(): this;
    /**
     * Grants permission to DeleteGateway
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_DeleteGateway.html
     */
    toDeleteGateway(): this;
    /**
     * Grants permission to DeleteHypervisor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_DeleteHypervisor.html
     */
    toDeleteHypervisor(): this;
    /**
     * Grants permission to DisassociateGatewayFromServer
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_DisassociateGatewayFromServer.html
     */
    toDisassociateGatewayFromServer(): this;
    /**
     * Grants permission to GetGateway
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_GetGateway.html
     */
    toGetGateway(): this;
    /**
     * Grants permission to GetVirtualMachine
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_GetVirtualMachine.html
     */
    toGetVirtualMachine(): this;
    /**
     * Grants permission to ImportHypervisorConfiguration
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ImportHypervisorConfiguration.html
     */
    toImportHypervisorConfiguration(): this;
    /**
     * Grants permission to ListGateways
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html
     */
    toListGateways(): this;
    /**
     * Grants permission to ListHypervisors
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListHypervisors.html
     */
    toListHypervisors(): this;
    /**
     * Grants permission to ListTagsForResource
     *
     * Access Level: Read
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListTagsForResource.html
     */
    toListTagsForResource(): this;
    /**
     * Grants permission to ListVirtualMachines
     *
     * Access Level: Read
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListVirtualMachines.html
     */
    toListVirtualMachines(): this;
    /**
     * Grants permission to PutMaintenanceStartTime
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_PutMaintenanceStartTime.html
     */
    toPutMaintenanceStartTime(): this;
    /**
     * Grants permission to Restore
     *
     * Access Level: Write
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_StartRestoreJob.html
     */
    toRestore(): this;
    /**
     * Grants permission to TagResource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_TagResource.html
     */
    toTagResource(): this;
    /**
     * Grants permission to TestHypervisorConfiguration
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_TestHypervisorConfiguration.html
     */
    toTestHypervisorConfiguration(): this;
    /**
     * Grants permission to UntagResource
     *
     * Access Level: Tagging
     *
     * Possible conditions:
     * - .ifAwsRequestTag()
     * - .ifAwsTagKeys()
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_UntagResource.html
     */
    toUntagResource(): this;
    /**
     * Grants permission to UpdateGatewayInformation
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_UpdateGatewayInformation.html
     */
    toUpdateGatewayInformation(): this;
    /**
     * Grants permission to UpdateGatewaySoftwareNow
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_UpdateGatewaySoftwareNow.html
     */
    toUpdateGatewaySoftwareNow(): this;
    /**
     * Grants permission to UpdateHypervisor
     *
     * Access Level: Write
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_UpdateHypervisor.html
     */
    toUpdateHypervisor(): this;
    protected accessLevelList: AccessLevelList;
    /**
     * Adds a resource of type gateway to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_Gateway.html
     *
     * @param gatewayId - Identifier for the gatewayId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onGateway(gatewayId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type hypervisor to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_Hypervisor.html
     *
     * @param hypervisorId - Identifier for the hypervisorId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onHypervisor(hypervisorId: string, account?: string, partition?: string): this;
    /**
     * Adds a resource of type virtualmachine to the statement
     *
     * https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_VirtualMachine.html
     *
     * @param virtualmachineId - Identifier for the virtualmachineId.
     * @param account - Account of the resource; defaults to empty string: all accounts.
     * @param partition - Partition of the AWS account [aws, aws-cn, aws-us-gov]; defaults to `aws`, unless using the CDK, where the default is the current Stack's partition.
     *
     * Possible conditions:
     * - .ifAwsResourceTag()
     */
    onVirtualmachine(virtualmachineId: string, account?: string, partition?: string): this;
}
